/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.AbstractMap;
import java.util.Map;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.util.Unsupported;

class EntryImpl<K, V>
implements ImmutableMap.ImmutableEntry<K, V>,
Comparable<Map.Entry<K, V>> {
    private final Map.Entry<K, V> target;

    static <K, V> EntryImpl<K, V> newInstance(K key, V value) {
        return EntryImpl.newInstance(new AbstractMap.SimpleEntry<K, V>(key, value));
    }

    static <K, V> EntryImpl<K, V> newInstance(Map.Entry<K, V> target) {
        return new EntryImpl<K, V>(target);
    }

    private EntryImpl(Map.Entry<K, V> target) {
        this.target = target;
    }

    @Override
    public int compareTo(Map.Entry<K, V> o) {
        Comparable key = (Comparable)this.getKey();
        int diff = key.compareTo(o.getKey());
        if (diff == 0) {
            Comparable value = (Comparable)this.getValue();
            diff = value.compareTo(o.getValue());
        }
        return diff;
    }

    @Override
    public boolean equals(Object obj) {
        return this.target.equals(obj);
    }

    @Override
    public K getKey() {
        return this.target.getKey();
    }

    @Override
    public V getValue() {
        return this.target.getValue();
    }

    @Override
    public int hashCode() {
        return this.target.hashCode();
    }

    @Override
    public V setValue(V value) throws UnsupportedOperationException {
        Unsupported.unsupported();
        return null;
    }

    public String toString() {
        return this.target.toString();
    }
}

