/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.identifiers;

import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.common.util.PrimitiveTypes;

public abstract class NumericIdentifiers {
    public static final Class<BigInteger> NUMERIC_IDENTIFIER_TYPE = BigInteger.class;

    public static Number identifier(ResultSet rs, String columnName) throws SQLException {
        return NumericIdentifiers.identifier(rs.getBigDecimal(columnName));
    }

    public static Number identifier(Number value) {
        return PrimitiveTypes.valueOf(value, NUMERIC_IDENTIFIER_TYPE);
    }

    public static Number valueOf(String text) {
        return PrimitiveTypes.valueOf(text, NUMERIC_IDENTIFIER_TYPE);
    }

    public static String string(Number value) {
        if (value == null) {
            return null;
        }
        Number id = NumericIdentifiers.identifier(value);
        return id.toString();
    }
}

