/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.dbtools.common.graph.Edge;
import oracle.dbtools.common.graph.Vertex;

class VertexImpl<V, E>
implements Vertex<V, E> {
    private final ArrayList<Edge<V, E>> edges = new ArrayList();
    private final V value;

    VertexImpl(V value) {
        this(value, Collections.emptyList());
    }

    VertexImpl(V value, Collection<Edge<V, E>> edges) {
        this.value = value;
        this.edges.addAll(edges);
    }

    @Override
    public Collection<Edge<V, E>> edges() {
        return this.edges;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return !(this.value == null ? other.value() != null : !this.value.equals(other.value()));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value);
        return builder.toString();
    }

    @Override
    public V value() {
        return this.value;
    }

    void add(Edge<V, E> edge) {
        if (!this.edges.contains(edge)) {
            this.edges.add(edge);
        }
    }
}

