/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.util.ArrayList;
import oracle.dbtools.common.builder.BuilderBase;
import oracle.dbtools.common.builder.Version;
import oracle.dbtools.common.di.Dependency;
import oracle.dbtools.common.di.DependencyArc;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Iterables;

class TypeDependencies {
    private final Iterable<DependencyArc> arcs;
    private final Class<?> type;

    TypeDependencies(Class<?> type, Iterable<DependencyArc> arcs) {
        this.type = type;
        this.arcs = arcs;
    }

    public Iterable<DependencyArc> arcs() {
        return this.arcs;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("TypeDependencies [type=");
        builder2.append(this.type);
        builder2.append(", arcs=");
        builder2.append(this.arcs);
        builder2.append("]");
        return builder2.toString();
    }

    Class<?> type() {
        return this.type;
    }

    static Builder builder(Class<?> type) {
        return new Builder(type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arcs == null ? 0 : this.arcs.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeDependencies other = (TypeDependencies)obj;
        if (this.arcs == null ? other.arcs != null : !Iterables.equals(this.arcs, other.arcs)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    private static class BuilderState {
        private final AssociativeArrays.Builder<Dependency, DependencyArc> targets = AssociativeArrays.builder();
        private final Class<?> type;

        BuilderState(Class<?> type, Iterable<DependencyArc> existing) {
            this.type = type;
            for (DependencyArc arc : existing) {
                this.targets.add((Object)arc.dependency(), (Object)arc);
            }
        }

        public void add(Dependency dependency, Class<?> implementation) {
            DependencyArc arc = this.targets.get(dependency);
            if (arc == null) {
                arc = new DependencyArc(dependency, implementation);
                this.targets.add((Object)dependency, (Object)arc);
            } else {
                arc.add(implementation);
            }
        }
    }

    static class Builder
    extends BuilderBase<TypeDependencies, BuilderState> {
        protected Builder(Class<?> type) {
            this(new TypeDependencies(type, Iterables.empty()));
        }

        protected Builder(TypeDependencies existing) {
            super(existing);
        }

        public Class<?> type() {
            return ((BuilderState)this.state()).type;
        }

        @Override
        protected BuilderState existingState(TypeDependencies instance) {
            return new BuilderState(instance.type, instance.arcs);
        }

        @Override
        protected TypeDependencies newInstance(BuilderState state, Version version) {
            ArrayList<DependencyArc> arcs = new ArrayList<DependencyArc>();
            for (DependencyArc arc : AssociativeArrays.values(state.targets.build())) {
                arcs.add(arc);
            }
            return new TypeDependencies(state.type, arcs);
        }

        @Override
        protected BuilderState newState(BuilderState existing) {
            return new BuilderState(existing.type, Iterables.empty());
        }

        Builder add(Dependency dependency, Class<?> provider) {
            ((BuilderState)this.state()).add(dependency, provider);
            this.modified();
            return this;
        }
    }
}

