/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Singleton;
import oracle.dbtools.common.activation.Activatables;
import oracle.dbtools.common.activation.Activator;
import oracle.dbtools.common.di.Factory;
import oracle.dbtools.plugin.api.di.annotations.ApplicationScoped;
import oracle.dbtools.plugin.api.di.annotations.RequestScoped;

class Singletons {
    private final Activatables activatables;
    private final transient Factory factory;
    private final transient Singletons parent;
    private final String scopeName;
    private final ConcurrentMap<Class<?>, Object> singletons;
    private static final Object FAILED_ACTIVATION = "__FA__";

    Singletons(String scopeName, Singletons parent, Activatables activatables, Factory factory) {
        this.scopeName = scopeName;
        this.parent = parent;
        this.activatables = activatables;
        if (factory == null) {
            throw new NullPointerException();
        }
        this.factory = factory;
        this.singletons = new ConcurrentHashMap();
    }

    String scopeName() {
        return this.scopeName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.scopeName + " singletons:\n");
        for (Map.Entry singleton : this.singletons.entrySet()) {
            builder.append(((Class)singleton.getKey()).getName());
            builder.append(": ");
            builder.append(singleton.getValue().getClass().getName());
            builder.append(" #");
            builder.append(System.identityHashCode(singleton.getValue()));
            builder.append("\n");
        }
        return builder.toString();
    }

    Object get(Class<?> type) {
        if (!this.isSingleton(type)) {
            throw new IllegalArgumentException();
        }
        Object instance = this.singletons.get(type);
        if (instance == null) {
            boolean useThisScope;
            boolean bl = useThisScope = this.parent == null || Singletons.perServiceScope(type);
            if (useThisScope) {
                instance = this.factory.newInstance(type);
                if (instance == null) {
                    throw new IllegalStateException(type.toString());
                }
                Activator.ActivationStatus status = this.activatables.activate(instance);
                if (Activator.ActivationStatus.ACTIVATED != status) {
                    instance = FAILED_ACTIVATION;
                }
                this.singletons.putIfAbsent(type, instance);
            } else {
                instance = this.parent.get(type);
            }
        }
        if (FAILED_ACTIVATION == instance) {
            instance = null;
        }
        return instance;
    }

    boolean isSingleton(Class<?> type) {
        return Singletons.hasAnnotation(type, RequestScoped.class) || Singletons.hasAnnotation(type, ApplicationScoped.class) || Singletons.hasAnnotation(type, Singleton.class);
    }

    private static <T extends Annotation> boolean hasAnnotation(Class<?> type, Class<T> annotationType) {
        boolean result = false;
        if (type.getAnnotation(annotationType) == null) {
            for (Annotation annotation : type.getDeclaredAnnotations()) {
                Class<? extends Annotation> annotationClass = annotation.annotationType();
                if (annotationClass.getAnnotation(annotationType) == null) continue;
                result = true;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static boolean perServiceScope(Class<?> type) {
        return !Singletons.hasAnnotation(type, ApplicationScoped.class) && !Singletons.hasAnnotation(type, Singleton.class);
    }
}

