/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import oracle.dbtools.common.di.Dependency;
import oracle.dbtools.common.di.TypeDependencies;
import oracle.dbtools.common.graph.DirectedGraph;
import oracle.dbtools.common.graph.Edge;
import oracle.dbtools.common.graph.Path;
import oracle.dbtools.common.graph.Vertex;
import oracle.dbtools.common.graph.Visitor;
import oracle.dbtools.plugin.api.di.annotations.Provides;

class Descendants
implements Visitor<Class<?>, Dependency> {
    private final Vertex<Class<?>, Dependency> ancestor;
    private final Deque<TypeDependencies> descendants = new ArrayDeque<TypeDependencies>();

    Descendants(DirectedGraph<Class<?>, Dependency> graph, Class<?> type) {
        this.ancestor = graph.vertex(type);
        graph.accept(this, type);
    }

    public Collection<TypeDependencies> arcs() {
        ArrayList<TypeDependencies> values = new ArrayList<TypeDependencies>(this.descendants.size());
        Iterator<TypeDependencies> iter = this.descendants.descendingIterator();
        while (iter.hasNext()) {
            TypeDependencies descendant = iter.next();
            values.add(descendant);
        }
        return values;
    }

    @Override
    public void visit(Vertex<Class<?>, Dependency> vertex) {
        if (!vertex.edges().isEmpty()) {
            TypeDependencies.Builder deps = TypeDependencies.builder(vertex.value());
            for (Edge<Class<?>, Dependency> edge : vertex.edges()) {
                Class<?> impl = edge.destination().value();
                if (this.isExternal(impl)) {
                    impl = null;
                }
                deps.add(edge.value(), impl);
            }
            this.descendants.push((TypeDependencies)deps.build());
        }
    }

    private boolean isExternal(Class<?> impl) {
        Provides provides = impl.getAnnotation(Provides.class);
        return provides == null;
    }

    private boolean hasProviderEdge(Path<Class<?>, Dependency> path) {
        Dependency dependency = path.peek();
        if (dependency == null) {
            return false;
        }
        return Dependency.Kind.USES_VIA_PROVIDER == dependency.kind();
    }
}

