/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DependencyInjectionMessages {
    public static final String PROVIDER_WITH_GENERIC_TYPE_PARAMETER = "PROVIDER_WITH_GENERIC_TYPE_PARAMETER";
    public static final String CYCLIC_DEPENDENCY = "CYCLIC_DEPENDENCY";
    public static final String CLASS_NOT_FOUND = "CLASS_NOT_FOUND";
    public static final String NOT_AN_INSTANCE_OF_TYPE = "NOT_AN_INSTANCE_OF_TYPE";
    public static final String NO_PROVIDES_ANNOTATION = "NO_PROVIDES_ANNOTATION";
    public static final String IO_ERROR = "IO_ERROR";
    public static final String CANNOT_CREATE_DEPENDENCY = "CANNOT_CREATE_DEPENDENCY";
    public static final String NO_PROVIDER_FOUND = "NO_PROVIDER_FOUND";
    public static final String ILLEGAL_ACCESS = "ILLEGAL_ACCESS";
    public static final String PROVIDER_GENERIC_TYPE_PARAMETER = "PROVIDER_GENERIC_TYPE_PARAMETER";
    public static final String TOO_MANY_ANNOTATED_CONSTRUCTORS = "TOO_MANY_ANNOTATED_CONSTRUCTORS";
    public static final String ITERABLE_WITH_GENERIC_TYPE_PARAMETER = "ITERABLE_WITH_GENERIC_TYPE_PARAMETER";
    public static final String INSTANTIATION_ERROR = "INSTANTIATION_ERROR";
    public static final String INVOCATION_ERROR = "INVOCATION_ERROR";
    public static final String NO_PROVIDER_FOUND_FOR_SITE = "NO_PROVIDER_FOUND_FOR_SITE";
    public static final String NO_PROVIDERS_FOUND = "NO_PROVIDERS_FOUND";
    public static final String ILLEGAL_ARGUMENT = "ILLEGAL_ARGUMENT";
    private static final String BUNDLE_NAME = "oracle.dbtools.common.di.DependencyInjectionMessages";
    private static final DependencyInjectionMessages INSTANCE = new DependencyInjectionMessages();
    private final ResourceBundle m_bundle = ResourceBundle.getBundle("oracle.dbtools.common.di.DependencyInjectionMessages", Locale.getDefault(), DependencyInjectionMessages.class.getClassLoader());

    private DependencyInjectionMessages() {
    }

    protected String getStringImpl(String key) {
        try {
            return this.m_bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getString(String key) {
        return INSTANCE.getStringImpl(key);
    }

    public static String get(String key) {
        return DependencyInjectionMessages.getString(key);
    }

    protected String formatImpl(String key, Object ... arguments) {
        try {
            return MessageFormat.format(this.m_bundle.getString(key), arguments);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String format(String key, Object ... arguments) {
        return INSTANCE.formatImpl(key, arguments);
    }

    public final Integer getIntegerImpl(String key) {
        String s = this.getStringImpl(key);
        if (s.length() == 1 && Character.isLetter(s.charAt(0))) {
            return new Integer(s.charAt(0));
        }
        return Integer.valueOf(s);
    }

    public static Integer getInteger(String key) {
        return INSTANCE.getIntegerImpl(key);
    }

    public static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(BUNDLE_NAME, locale == null ? Locale.getDefault() : locale, DependencyInjectionMessages.class.getClassLoader());
    }

    public static ResourceBundle getBundle() {
        return DependencyInjectionMessages.INSTANCE.m_bundle;
    }
}

