/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.config.file;

import java.io.File;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.common.config.ConfigurationEventListener;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.config.ConfigurationsProvider;
import oracle.dbtools.common.config.file.ConfigurationFilesBase;
import oracle.dbtools.common.config.file.ConfigurationFolder;
import oracle.dbtools.common.logging.LegacyLoggingAdaptor;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Ordering;
import oracle.dbtools.plugin.api.conf.Configuration;

public class ConfigurationFiles
implements ConfigurationsProvider {
    private ConfigurationFilesBase target = null;
    private static final ConfigurationFiles _INSTANCE = new ConfigurationFiles();
    private static final Log LOG = Log.get(ConfigurationFiles.class);

    private ConfigurationFiles() {
    }

    @Override
    public void addListener(String name, ConfigurationEventListener listener) {
        this.target().addListener(name, listener);
    }

    @Override
    public Comparator<? super String> comparator() {
        return this.target().comparator();
    }

    @Override
    public boolean exists(String name) {
        return this.target().exists(name);
    }

    @Override
    public Configuration get(Object key) {
        return this.target().get(key);
    }

    @Override
    public Configuration get(String name) {
        return this.target().get(name);
    }

    @Override
    public boolean isEmpty() {
        return this.target().isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.target().iterator();
    }

    @Override
    public Ordering ordering() {
        return this.target().ordering();
    }

    @Override
    public AssociativeArray<String, Configuration> put(AssociativeArray<String, Configuration> values) {
        return this.target().put(values);
    }

    @Override
    public AssociativeArray<String, Configuration> put(String key, Configuration value) {
        return this.target().put(key, value);
    }

    @Override
    public void removeListener(ConfigurationEventListener listener) {
        this.target().removeListener(listener);
    }

    @Override
    public void setup() {
        ConfigurationFolder configurationFolder = ConfigurationFolder.INSTANCE;
        if (!configurationFolder.setup()) {
            throw ConfigurationFiles.notInitialized();
        }
        this.target = new ConfigurationFilesBase(new LegacyLoggingAdaptor(LOG), configurationFolder.getFolder());
    }

    @Override
    public int size() {
        return this.target().size();
    }

    @Override
    public void teardown() {
        if (this.target != null) {
            this.target().teardown();
        }
    }

    @Override
    public void update(Configurations newConfiguration) {
        this.target().update(newConfiguration);
    }

    private ConfigurationFilesBase target() {
        if (this.target == null) {
            throw ConfigurationFiles.notInitialized();
        }
        return this.target;
    }

    public static boolean isConfigured(File folder) {
        File conf;
        File defaults;
        if (folder.exists() && (defaults = Files.file(folder, "defaults.xml")).exists() && (conf = Files.file(folder, "conf")).exists()) {
            return !NullOrEmpty.nullOrEmpty(conf.listFiles(ConfigurationFilesBase.IS_CONFIGURATION_FILE));
        }
        return false;
    }

    public static boolean isMigrateV2(File folder) {
        File conf;
        File defaults;
        if (folder.exists() && (defaults = Files.file(folder, "defaults.xml")).exists() && (conf = Files.file(folder, "conf")).exists()) {
            File[] fl;
            for (File f : fl = conf.listFiles(ConfigurationFilesBase.IS_CONFIGURATION_FILE)) {
                if (!f.getAbsolutePath().endsWith("_pu.xml")) continue;
                return false;
            }
        }
        return true;
    }

    private static IllegalStateException notInitialized() {
        return new IllegalStateException("Not yet initialised");
    }

    public static InputStream shippedDefaultsContents() {
        return ConfigurationFilesBase.shippedDefaultsContents();
    }

    public static ConfigurationsProvider instance() {
        return _INSTANCE;
    }
}

