/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.app;

import java.io.IOException;
import java.io.StringReader;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
public class Version {
    public static final Version INSTANCE = new Version();
    public static final String PRODUCT_ABBREVIATION = "ords";
    public static final String PRODUCT_NAME = "Oracle REST Data Services";
    private static final String BUNDLE_NAME = "oracle.dbtools.common.VersionNumber";
    private static final String SERVER_HEADER = "Oracle REST Data Services".replace(' ', '-');
    private static final ResourceBundle VERSION_NUMBER = Version.resourceBundle();
    private static final String VERSION_NUMBER_PROP = "VersionNumber";

    @Inject
    private Version() {
    }

    public String getProductAbbreviation() {
        return PRODUCT_ABBREVIATION;
    }

    public String getProductName() {
        return PRODUCT_NAME;
    }

    public String getVersion() {
        return VERSION_NUMBER.getString(VERSION_NUMBER_PROP);
    }

    public void setServerHeader(HttpServletResponse response) {
        response.setHeader("Server", SERVER_HEADER + this.getVersion());
    }

    private static ResourceBundle resourceBundle() {
        try {
            return ResourceBundle.getBundle(BUNDLE_NAME);
        }
        catch (MissingResourceException e) {
            try {
                return new PropertyResourceBundle(new StringReader("VersionNumber=1.0.0.100.01.01"));
            }
            catch (IOException ioe) {
                throw UnrecoverableException.unrecoverable(ioe);
            }
        }
    }
}

