/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.app;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Locale;
import oracle.dbtools.common.app.ApplicationLifeCycle;
import oracle.dbtools.common.di.DependencyConstraints;
import oracle.dbtools.common.di.Services;
import oracle.dbtools.common.locale.LocalePreference;
import oracle.dbtools.common.util.Iterables;

public class ApplicationContext
implements Closeable {
    private final File configurationFolder;
    private final Services services;
    public static final String APPLICATION_CONTEXT = ApplicationContext.class.getName();
    static final DependencyConstraints NAMED_CONFIGURATION_FOLDER = (DependencyConstraints)DependencyConstraints.builder().named("conf-folder").build();
    private static final DependencyConstraints NAMED_STDOUT = (DependencyConstraints)DependencyConstraints.builder().named("stdout").build();
    private static final DependencyConstraints NAMED_STDERR = (DependencyConstraints)DependencyConstraints.builder().named("stderr").build();

    public ApplicationContext(File configurationFolder, Appendable stdout, Appendable stderr, Services.Builder services) {
        services.add(File.class, configurationFolder, NAMED_CONFIGURATION_FOLDER);
        services.add(Appendable.class, stdout, NAMED_STDOUT);
        services.add(Appendable.class, stderr, NAMED_STDERR);
        services.add(Locale.class, Locale.getDefault(), DependencyConstraints.NO_CONSTRAINTS);
        services.add(oracle.dbtools.plugin.api.i18n.LocalePreference.class, LocalePreference.DEFAULT, DependencyConstraints.NO_CONSTRAINTS);
        this.services = services.build("Application Scope");
        Iterable<ApplicationLifeCycle> hasLifeCycles = this.services.acquireAll(ApplicationLifeCycle.class, DependencyConstraints.NO_CONSTRAINTS);
        for (ApplicationLifeCycle hasLifeCycle : hasLifeCycles) {
            hasLifeCycle.startup(this);
        }
        this.configurationFolder = configurationFolder;
    }

    @Override
    public void close() throws IOException {
        ArrayList all = new ArrayList();
        Iterable<ApplicationLifeCycle> hasLifeCycles = this.services.acquireAll(ApplicationLifeCycle.class, DependencyConstraints.NO_CONSTRAINTS);
        Iterables.add(all, hasLifeCycles);
        ListIterator iter = all.listIterator(all.size());
        while (iter.hasPrevious()) {
            ApplicationLifeCycle hasLifeCycle = (ApplicationLifeCycle)iter.previous();
            hasLifeCycle.shutdown(this);
        }
        this.services.close();
    }

    public File configurationFolder() {
        return this.configurationFolder;
    }

    public Services services() {
        return this.services;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ApplicationContext [configurationFolder=");
        builder.append(this.configurationFolder);
        builder.append(", services=");
        builder.append(this.services);
        builder.append("]");
        return builder.toString();
    }

    public static Services.Builder loadServices(ClassLoader classLoader) {
        Services.Builder services = Services.builder();
        services.load(classLoader);
        return services;
    }
}

