/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.activation;

import java.io.Closeable;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import oracle.dbtools.common.activation.Activatable;
import oracle.dbtools.common.activation.Activator;
import oracle.dbtools.plugin.api.logging.Log;

public class Activatables
implements Closeable {
    private final Map<Object, Activator> activators = new IdentityHashMap<Object, Activator>();
    private final Log log;

    public Activatables(Log log) {
        this.log = log;
    }

    public Activator.ActivationStatus activate(Object instance) {
        if (instance instanceof Activatable) {
            Activator activator = this.activators.get(instance);
            if (activator == null) {
                activator = new Activator(this.log, instance);
            }
            return activator.activate();
        }
        return Activator.ActivationStatus.ACTIVATED;
    }

    @Override
    public void close() throws IOException {
        for (Activator activator : this.activators.values()) {
            activator.deactivate();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("activated:\n");
        for (Activator activator : this.activators.values()) {
            if (!activator.isActive()) continue;
            builder.append(activator.target().getClass().getName());
            builder.append(" ");
            builder.append(System.identityHashCode(activator.target()));
            builder.append("\n");
        }
        return builder.toString();
    }
}

