/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.ServiceUnavailableException;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS7;
import oracle.security.crypto.cert.X509;
import oracle.security.misc.Checksum;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CrlHelper;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.internal.OraclePKIX509CertHelper;
import oracle.security.pki.internal.OraclePKIX509CertReqHelper;
import oracle.security.pki.textui.a;

public class OraclePKIGenFunc {
    private static BufferedReader b = new BufferedReader(new InputStreamReader(System.in));
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    public static final int RETRY_COUNT = 2;
    public static final int MAX_VALIDITY = 182500;

    public static char[] getPassword(String string, boolean bl, String string2) {
        String string3 = null;
        if (string != null) {
            if (bl) {
                try {
                    string3 = OraclePKIGenFunc.a(string);
                }
                catch (IOException iOException) {
                    return null;
                }
            } else {
                string3 = string;
            }
            return string3.toCharArray();
        }
        return OraclePKIGenFunc.getPassword(string2);
    }

    public static char[] getPassword(String string) {
        char[] cArray = null;
        try {
            System.out.print(a.getString(string) + "  ");
            cArray = OraclePKIGenFunc.a();
        }
        catch (IOException iOException) {
            System.out.print(a.getString("UNKNOWN_ERROR") + iOException);
            return null;
        }
        return cArray;
    }

    public static char[] getCreatePassword(String string, boolean bl) {
        String string2 = null;
        if (string != null) {
            if (bl) {
                try {
                    string2 = OraclePKIGenFunc.a(string);
                }
                catch (IOException iOException) {
                    return null;
                }
            } else {
                string2 = string;
            }
            return string2.toCharArray();
        }
        return OraclePKIGenFunc.getCreatePassword();
    }

    public static char[] getCreatePassword() {
        return OraclePKIGenFunc.a("ENTER_PASSWORD", "ENTER_PASSWORD_AGAIN", "PKI-01003", true);
    }

    public static char[] getSecret() {
        return OraclePKIGenFunc.a("ENTER_SECRET", "ENTER_SECRET_AGAIN", "PKI-03003", false);
    }

    private static char[] a(String string, String string2, String string3) {
        return OraclePKIGenFunc.a(string, string2, string3, true);
    }

    private static char[] a(String string, String string2, String string3, boolean bl) {
        int n2 = 0;
        while (true) {
            if (n2 >= 2) {
                System.exit(1);
            }
            char[] cArray = OraclePKIGenFunc.getPassword(string);
            if (bl && !OracleWallet.isValidPassword(cArray)) {
                System.out.println(a.getString("PKI-01002"));
                ++n2;
                continue;
            }
            char[] cArray2 = OraclePKIGenFunc.getPassword(string2);
            boolean bl2 = cArray.length == cArray2.length;
            for (int i2 = 0; i2 < cArray.length && bl2; ++i2) {
                bl2 = cArray[i2] == cArray2[i2];
            }
            if (bl2) {
                return cArray;
            }
            System.out.println(a.getString(string3));
        }
    }

    private static char[] a() throws IOException {
        Console console = System.console();
        if (console != null) {
            return console.readPassword();
        }
        char[] cArray = new char[1024];
        a a2 = new a();
        a2.start();
        String string = b.readLine();
        a2.interrupt();
        try {
            a2.join();
            cArray = string.toCharArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println();
        return cArray;
    }

    public static OracleWallet openAWallet(String string, String string2, boolean bl) throws IOException {
        OracleWallet oracleWallet = new OracleWallet();
        String string3 = null;
        if (string2 != null) {
            string3 = bl ? OraclePKIGenFunc.a(string2) : string2;
            oracleWallet.open(string, string3.toCharArray());
            return oracleWallet;
        }
        try {
            oracleWallet.open(string, null);
            return oracleWallet;
        }
        catch (IOException iOException) {
            oracleWallet.open(string, OraclePKIGenFunc.getPassword("WALLET_PASSWORD_PROMPT"));
            return oracleWallet;
        }
    }

    private static String a(String string) throws IOException {
        String string2 = null;
        try {
            byte[] byArray = OraclePKIGenFunc.b(string);
            byte[] byArray2 = Checksum.SHA((byte[])byArray, null);
            string2 = new String(byArray2);
            return string2;
        }
        catch (Exception exception) {
            System.out.println("Deobfuscation exception: " + exception.toString());
            throw new IOException("deobfuscation error");
        }
    }

    private static byte[] b(String string) {
        if (string == null) {
            return new byte[0];
        }
        int n2 = string.length();
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2 / 2; ++i2) {
            byArray[i2] = (byte)(OraclePKIGenFunc.a(cArray[2 * i2]) << 4 & 0xF0 | OraclePKIGenFunc.a(cArray[2 * i2 + 1]) & 0xF);
        }
        return byArray;
    }

    private static byte a(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return (byte)((byte)c2 - 48);
        }
        if ('a' <= c2 && c2 <= 'f') {
            return (byte)((byte)c2 - 97 + 10);
        }
        if ('A' <= c2 && c2 <= 'F') {
            return (byte)((byte)c2 - 65 + 10);
        }
        return -1;
    }

    public static CRL readCRLAt(String string) throws IOException, ServiceUnavailableException {
        try {
            return new CRL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new CRL(new File(string));
            }
            catch (IOException iOException) {
                return OraclePKIX509CrlHelper.readB64CRLFrom(new FileReader(string));
            }
        }
        catch (IOException iOException) {
            if (iOException.toString().indexOf("javax.naming.ServiceUnavailableException") != -1) {
                throw new ServiceUnavailableException(iOException.toString());
            }
            return OraclePKIX509CrlHelper.readB64CRLFrom(new InputStreamReader(new URL(string).openStream()));
        }
    }

    public static CertificateRequest readCertRequestAt(String string) throws IOException {
        try {
            return new CertificateRequest(new URL(string).openStream());
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new CertificateRequest(new FileInputStream(string));
            }
            catch (IOException iOException) {
                return OraclePKIX509CertReqHelper.readB64CertReqFrom(new FileReader(string));
            }
        }
        catch (IOException iOException) {
            return OraclePKIX509CertReqHelper.readB64CertReqFrom(new InputStreamReader(new URL(string).openStream()));
        }
    }

    public static OraclePKIX509CertImpl[] readCertsAt(String string) throws IOException {
        Vector vector = null;
        try {
            OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(new URL(string)));
            return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
        }
        catch (MalformedURLException malformedURLException) {
            try {
                OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(new File(string)));
                return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
            }
            catch (IOException iOException) {
                try {
                    OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(OraclePKIX509CertHelper.readB64X509CertFrom(new FileReader(string)));
                    return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
                }
                catch (IOException iOException2) {
                    try {
                        vector = new PKCS7(new FileInputStream(string)).getCertificates();
                    }
                    catch (IOException iOException3) {
                        vector = OraclePKIX509CertHelper.readB64X509PKCS7From(new FileReader(string));
                    }
                }
            }
        }
        catch (IOException iOException) {
            try {
                OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(OraclePKIX509CertHelper.readB64X509CertFrom(new InputStreamReader(new URL(string).openStream())));
                return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
            }
            catch (IOException iOException4) {
                try {
                    vector = new PKCS7(new URL(string).openStream()).getCertificates();
                }
                catch (IOException iOException5) {
                    vector = OraclePKIX509CertHelper.readB64X509PKCS7From(new InputStreamReader(new URL(string).openStream()));
                }
            }
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = new OraclePKIX509CertImpl[vector.size()];
        for (int i2 = 0; i2 < oraclePKIX509CertImplArray.length; ++i2) {
            oraclePKIX509CertImplArray[i2] = new OraclePKIX509CertImpl((X509)vector.elementAt(i2));
        }
        return oraclePKIX509CertImplArray;
    }

    public static OraclePKIX509CertImpl[] readCertsAt(InputStream inputStream) throws IOException {
        Vector vector = null;
        try {
            OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(inputStream));
            return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
        }
        catch (ASN1FormatException aSN1FormatException) {
            try {
                inputStream.reset();
                OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(OraclePKIX509CertHelper.readB64X509CertFrom(new InputStreamReader(inputStream)));
                return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
            }
            catch (IOException iOException) {
                try {
                    inputStream.reset();
                    vector = new PKCS7(inputStream).getCertificates();
                }
                catch (IOException iOException2) {
                    try {
                        inputStream.reset();
                        vector = OraclePKIX509CertHelper.readB64X509PKCS7From(new InputStreamReader(inputStream));
                    }
                    catch (IOException iOException3) {
                        throw new IOException(a.getString("PKI-04001"));
                    }
                }
                OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = new OraclePKIX509CertImpl[vector.size()];
                for (int i2 = 0; i2 < oraclePKIX509CertImplArray.length; ++i2) {
                    oraclePKIX509CertImplArray[i2] = new OraclePKIX509CertImpl((X509)vector.elementAt(i2));
                }
                return oraclePKIX509CertImplArray;
            }
        }
    }

    public static BigInteger getSerialNum(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            BigInteger bigInteger = new BigInteger(string2);
            return bigInteger;
        }
        catch (Exception exception) {
            System.out.println("Exception in getSerialNum : " + exception);
            return null;
        }
    }

    public static void updateSerialNum(String string, BigInteger bigInteger) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            String string2 = bigInteger.toString();
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Exception in updateSerialNum : " + exception);
        }
    }
}

