/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ldap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Security;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.security.pki.OraclePKIProvider;

public class LdapSSLSocketFactory
extends SocketFactory {
    public static final String WALLET_LOCATION = "oracle.ldap.wltloc";
    public static final String WALLET_PASSWORD = "oracle.ldap.wltpass";
    public static final String CONTEXT_TYPE = "SSL";
    public static final String SECURE_RANDOM_CLASS = "java.security.SecureRandom";
    public static final String GET_INSTANCE_FUNCTION = "getInstance";
    public static final String GET_SOCKET_FACTORY_FUNCTION = "getSocketFactory";
    public static final String INIT_FUNCTION = "init";
    public static final String GET_TRUST_MANAGERS_FUNCTION = "getTrustManagers";
    public static final String GET_KEY_MANAGERS_FUNCTION = "getKeyManagers";
    public static final String SYSPROP_JAVA_VENDOR = "java.vendor";
    public static final String SYSPROP_KEY_MANAGER_FACTORY_ALGORITHM = "ssl.KeyManagerFactory.algorithm";
    public static final String SYSPROP_TRUST_MANAGER_FACTORY_ALGORITHM = "ssl.TrustManagerFactory.algorithm";
    public static final String PROPERTY_TRUST_MANAGER_PROVIDER = "DEFAULT_TRUST_MANAGER_PROVIDER";
    public static final String PROPERTY_KEY_MANAGER_PROVIDER = "DEFAULT_KEY_MANAGER_PROVIDER";
    public static final String ORACLE_JAVA_VENDOR_NAME = "oracle";
    public static final String SUN_JAVA_VENDOR_NAME = "sun";
    public static final String SUN_DEFAULT_TRUST_MANAGER_PROVIDER = "SunX509";
    public static final String SUN_DEFAULT_KEY_MANAGER_PROVIDER = "SunX509";
    public static final String SSL_CONTEXT_CLASS = "javax.net.ssl.SSLContext";
    public static final String TRUST_MANAGER_FACTORY_CLASS = "javax.net.ssl.TrustManagerFactory";
    public static final String TRUST_MANAGER_CLASS = "javax.net.ssl.TrustManager";
    public static final String TRUST_MANAGER_CLASS_ARRAY = "[Ljavax.net.ssl.TrustManager;";
    public static final String KEY_MANAGER_FACTORY_CLASS = "javax.net.ssl.KeyManagerFactory";
    public static final String KEY_MANAGER_CLASS = "javax.net.ssl.KeyManager";
    public static final String KEY_MANAGER_CLASS_ARRAY = "[Ljavax.net.ssl.KeyManager;";
    public static final String IBM_JAVA_VENDOR_NAME = "ibm";
    public static final String IBM_DEFAULT_TRUST_MANAGER_PROVIDER = "IbmPKIX";
    public static final String IBM_DEFAULT_KEY_MANAGER_PROVIDER = "IbmX509";
    private ClassLoader c;
    protected static SSLSocketFactory a = null;
    static ResourceBundle b = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    public LdapSSLSocketFactory() {
        this(System.getProperties());
    }

    public LdapSSLSocketFactory(Hashtable hashtable) {
        HashMap hashMap = new HashMap();
        String string = System.getProperty(SYSPROP_JAVA_VENDOR);
        this.a(string, hashMap);
        this.a(hashtable, hashMap);
    }

    private void a(String string, HashMap hashMap) {
        if (string == null || string.length() == 0) {
            System.out.println("Warning: Cannot fetch JDK vendor from System Property. Trying to load Oracle JDK specific providers.");
            this.a(hashMap);
        } else {
            String string2 = string.toLowerCase();
            if (string2.indexOf(IBM_JAVA_VENDOR_NAME) >= 0) {
                this.b(hashMap);
            } else if (string2.indexOf(SUN_JAVA_VENDOR_NAME) >= 0 || string2.indexOf(ORACLE_JAVA_VENDOR_NAME) >= 0) {
                this.a(hashMap);
            } else {
                System.out.println("Warning: Unsupported JDK vendor: " + string + ". Trying to load Oracle JDK specific providers.");
                this.a(hashMap);
            }
        }
    }

    private void a(HashMap hashMap) {
        hashMap.put(SYSPROP_JAVA_VENDOR, ORACLE_JAVA_VENDOR_NAME);
        String string = null;
        string = Security.getProperty(SYSPROP_TRUST_MANAGER_FACTORY_ALGORITHM);
        if (string == null || string.equals("")) {
            hashMap.put(PROPERTY_TRUST_MANAGER_PROVIDER, "SunX509");
        } else {
            hashMap.put(PROPERTY_TRUST_MANAGER_PROVIDER, string);
        }
        String string2 = null;
        string2 = Security.getProperty(SYSPROP_KEY_MANAGER_FACTORY_ALGORITHM);
        if (string2 == null || string2.equals("")) {
            hashMap.put(PROPERTY_KEY_MANAGER_PROVIDER, "SunX509");
        } else {
            hashMap.put(PROPERTY_KEY_MANAGER_PROVIDER, string2);
        }
    }

    private void b(HashMap hashMap) {
        hashMap.put(SYSPROP_JAVA_VENDOR, IBM_JAVA_VENDOR_NAME);
        String string = null;
        string = Security.getProperty(SYSPROP_TRUST_MANAGER_FACTORY_ALGORITHM);
        if (string == null || string.equals("")) {
            hashMap.put(PROPERTY_TRUST_MANAGER_PROVIDER, IBM_DEFAULT_TRUST_MANAGER_PROVIDER);
        } else {
            hashMap.put(PROPERTY_TRUST_MANAGER_PROVIDER, string);
        }
        String string2 = null;
        string2 = Security.getProperty(SYSPROP_KEY_MANAGER_FACTORY_ALGORITHM);
        if (string2 == null || string2.equals("")) {
            hashMap.put(PROPERTY_KEY_MANAGER_PROVIDER, IBM_DEFAULT_KEY_MANAGER_PROVIDER);
        } else {
            hashMap.put(PROPERTY_KEY_MANAGER_PROVIDER, string2);
        }
    }

    private void a(Hashtable hashtable, HashMap hashMap) {
        try {
            Security.insertProviderAt(new OraclePKIProvider(), 1);
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "OraclePKI");
            String string = (String)hashtable.get(WALLET_PASSWORD);
            String string2 = (String)hashtable.get(WALLET_LOCATION);
            this.c = ClassLoader.getSystemClassLoader();
            if (string == null && string2 == null) {
                a = this.a(SSL_CONTEXT_CLASS, this.c, CONTEXT_TYPE);
            } else {
                File file = new File((String)hashtable.get(WALLET_LOCATION));
                if (!file.exists()) {
                    throw new IOException(b.getString("PKI-02003") + string2);
                }
                FileInputStream fileInputStream = new FileInputStream((String)hashtable.get(WALLET_LOCATION));
                keyStore.load(fileInputStream, string.toCharArray());
                Object object = this.a(TRUST_MANAGER_FACTORY_CLASS, this.c, keyStore, (String)hashMap.get(PROPERTY_TRUST_MANAGER_PROVIDER));
                Object object2 = this.a(this.c, object, TRUST_MANAGER_FACTORY_CLASS);
                Object object3 = this.a(KEY_MANAGER_FACTORY_CLASS, this.c, keyStore, string, (String)hashMap.get(PROPERTY_KEY_MANAGER_PROVIDER));
                Object object4 = this.b(this.c, object3, KEY_MANAGER_FACTORY_CLASS);
                a = this.a(SSL_CONTEXT_CLASS, this.c, CONTEXT_TYPE, object2, object4);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Unable to find class: " + classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            System.out.println("Unable to instantiate class: " + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("Illegal Access Exception: " + illegalAccessException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("Method not Found: " + noSuchMethodException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("Invocation Target Exception: " + invocationTargetException.toString());
        }
        catch (Exception exception) {
            System.out.println("Exception while initialization: " + exception.toString());
        }
    }

    private SSLSocketFactory a(String string, ClassLoader classLoader, String string2) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = classLoader.loadClass(string);
        Method method = clazz.getDeclaredMethod(GET_INSTANCE_FUNCTION, String.class);
        Object object = method.invoke(null, string2);
        Method method2 = clazz.getDeclaredMethod(INIT_FUNCTION, Object.class, Object.class, Object.class);
        method2.invoke(object, null, null, null);
        Method method3 = clazz.getDeclaredMethod(GET_SOCKET_FACTORY_FUNCTION, null);
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)method3.invoke(object, null);
        return sSLSocketFactory;
    }

    private Object a(String string, ClassLoader classLoader, KeyStore keyStore, String string2) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = classLoader.loadClass(string);
        Method method = clazz.getDeclaredMethod(GET_INSTANCE_FUNCTION, String.class);
        Object object = method.invoke(null, string2);
        Method method2 = clazz.getDeclaredMethod(INIT_FUNCTION, KeyStore.class);
        method2.invoke(object, keyStore);
        return object;
    }

    private Object a(ClassLoader classLoader, Object object, String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = classLoader.loadClass(string);
        Method method = clazz.getDeclaredMethod(GET_TRUST_MANAGERS_FUNCTION, null);
        Object object2 = method.invoke(object, null);
        return object2;
    }

    private Object a(String string, ClassLoader classLoader, KeyStore keyStore, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = classLoader.loadClass(string);
        Method method = clazz.getDeclaredMethod(GET_INSTANCE_FUNCTION, String.class);
        Object object = method.invoke(null, string3);
        Method method2 = clazz.getDeclaredMethod(INIT_FUNCTION, KeyStore.class, char[].class);
        method2.invoke(object, keyStore, string2.toCharArray());
        return object;
    }

    private Object b(ClassLoader classLoader, Object object, String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = classLoader.loadClass(string);
        Method method = clazz.getDeclaredMethod(GET_KEY_MANAGERS_FUNCTION, null);
        Object object2 = method.invoke(object, null);
        return object2;
    }

    private SSLSocketFactory a(String string, ClassLoader classLoader, String string2, Object object, Object object2) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = classLoader.loadClass(string);
        Method method = clazz.getDeclaredMethod(GET_INSTANCE_FUNCTION, String.class);
        Object object3 = method.invoke(null, string2);
        Class<?> clazz2 = Class.forName(TRUST_MANAGER_CLASS_ARRAY);
        Class<?> clazz3 = Class.forName(KEY_MANAGER_CLASS_ARRAY);
        Class<?> clazz4 = Class.forName(SECURE_RANDOM_CLASS);
        Method method2 = clazz.getDeclaredMethod(INIT_FUNCTION, clazz3, clazz2, clazz4);
        method2.invoke(object3, object2, object, null);
        Method method3 = clazz.getDeclaredMethod(GET_SOCKET_FACTORY_FUNCTION, new Class[0]);
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)method3.invoke(object3, null);
        return sSLSocketFactory;
    }

    public static SocketFactory getDefault() {
        return new LdapSSLSocketFactory();
    }

    public Socket createSocket(String string, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)a.createSocket(string, n2);
        return this.a(sSLSocket);
    }

    public Socket createSocket(InetAddress inetAddress, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)a.createSocket(inetAddress, n2);
        return this.a(sSLSocket);
    }

    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)a.createSocket(string, n2, inetAddress, n3);
        return this.a(sSLSocket);
    }

    public Socket createSocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)a.createSocket(inetAddress, n2, inetAddress2, n3);
        return this.a(sSLSocket);
    }

    protected SSLSocket a(SSLSocket sSLSocket) throws IOException {
        String[] stringArray = new String[]{"SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};
        sSLSocket.setUseClientMode(true);
        sSLSocket.setEnabledCipherSuites(stringArray);
        sSLSocket.startHandshake();
        return sSLSocket;
    }
}

