/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12KeyBag;
import oracle.security.crypto.cert.PKCS12SecretBag;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.core.DSAPrivateKey;
import oracle.security.crypto.core.ECPrivateKey;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RSA;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIECPrivateKey;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.h;
import oracle.security.pki.l;

class i
extends h {
    final PKCS12Bag a;
    Certificate[] b;
    private CertificateRequest d;
    int c = -1;

    i(PKCS12Bag pKCS12Bag, Vector vector) {
        byte[] byArray;
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            throw new IllegalArgumentException("Incorrect bag type" + pKCS12Bag);
        }
        this.a = null;
        ASN1Object aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
        if (aSN1Object instanceof ASN1OctetString) {
            try {
                byArray = ((ASN1OctetString)aSN1Object).getValue();
                this.d = new CertificateRequest(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byArray = pKCS12Bag.getLocalKeyID();
        this.c = l.k(byArray);
        Vector<OraclePKIX509CertImpl> vector2 = new Vector<OraclePKIX509CertImpl>(vector.size());
        byte[] byArray2 = l.c(l.j(byArray), l.k(byArray));
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i2);
            if (!this.a(pKCS12CertBag.getLocalKeyID(), byArray2)) continue;
            vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
            vector.removeElementAt(i2);
            OraclePKIDebug.a("Found certificate " + pKCS12CertBag.getCert());
            break;
        }
        if (vector2.size() == 0) {
            OraclePKIDebug.a("No certificate found for cert req " + byArray);
            this.b = null;
        } else {
            X509Certificate x509Certificate = (X509Certificate)vector2.lastElement();
            while (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i3);
                    if (!((Object)x509Certificate.getIssuerDN()).equals(pKCS12CertBag.getCert().getSubject())) continue;
                    bl = true;
                    vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
                    x509Certificate = (X509Certificate)vector2.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.a("Cert chain incomplete for key " + this.a);
                break;
            }
            OraclePKIDebug.a("Cert chain determined");
            this.b = new Certificate[vector2.size()];
            this.b = vector2.toArray(this.b);
        }
    }

    i(PKCS12Bag pKCS12Bag, Vector vector, Vector vector2) {
        Object object;
        Object object2;
        PKCS12Bag pKCS12Bag2;
        int n2;
        Object object3;
        if (!(pKCS12Bag instanceof PKCS12KeyBag) && !(pKCS12Bag instanceof PKCS12ShroudedKeyBag)) {
            throw new IllegalArgumentException("Incorrect bag type" + pKCS12Bag);
        }
        this.a = pKCS12Bag;
        byte[] byArray = this.a.getLocalKeyID();
        this.c = l.k(byArray);
        byte[] byArray2 = "abcxyz".getBytes();
        byte[] byArray3 = null;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = BigInteger.TEN;
        RSA rSA = new RSA();
        String string = null;
        String string2 = null;
        PrivateKey privateKey = null;
        PublicKey publicKey = null;
        if (pKCS12Bag instanceof PKCS12KeyBag) {
            privateKey = ((PKCS12KeyBag)pKCS12Bag).getPrivateKey();
        } else if (pKCS12Bag instanceof PKCS12ShroudedKeyBag) {
            privateKey = ((PKCS12ShroudedKeyBag)pKCS12Bag).getPrivateKey();
        }
        string = privateKey.getAlgorithm();
        if (string.equals("RSA")) {
            rSA.setKey((RSAPrivateKey)privateKey);
            bigInteger = rSA.performOp(bigInteger3);
        } else if (string.equals("EC")) {
            try {
                object3 = Signature.getInstance("SHA1/ECDSA");
                ((Signature)object3).initSign(privateKey);
                ((Signature)object3).update(byArray2, 0, byArray2.length);
                byArray3 = ((Signature)object3).sign();
            }
            catch (GeneralSecurityException generalSecurityException) {
                generalSecurityException.printStackTrace();
            }
        }
        object3 = new Vector(vector.size());
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            n2 = 0;
            pKCS12Bag2 = (PKCS12CertBag)vector.elementAt(i2);
            publicKey = ((PKCS12CertBag)pKCS12Bag2).getCert().getPublicKey();
            string2 = publicKey.getAlgorithm();
            if (string.equals(string2)) {
                if (string2.equals("RSA")) {
                    rSA.setKey((RSAPublicKey)publicKey);
                    bigInteger2 = rSA.performOp(bigInteger);
                    if (bigInteger2.equals(bigInteger3)) {
                        n2 = 1;
                    }
                } else if (string2.equals("EC")) {
                    try {
                        object2 = Signature.getInstance("SHA1/ECDSA");
                        ((Signature)object2).initVerify(publicKey);
                        ((Signature)object2).update(byArray2, 0, byArray2.length);
                        n2 = ((Signature)object2).verify(byArray3) ? 1 : 0;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        generalSecurityException.printStackTrace();
                    }
                }
            }
            if (this.a(pKCS12Bag2.getLocalKeyID(), byArray) && n2 != 0) {
                ((Vector)object3).addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)pKCS12Bag2).getCert()));
                vector.removeElementAt(i2);
                OraclePKIDebug.a("Found certificate " + ((PKCS12CertBag)pKCS12Bag2).getCert());
                break;
            }
            if (!l.i(byArray)) {
                if (n2 == 0) continue;
                ((Vector)object3).addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)pKCS12Bag2).getCert()));
                vector.removeElementAt(i2);
                OraclePKIDebug.a("Found certificate " + ((PKCS12CertBag)pKCS12Bag2).getCert());
                break;
            }
            if (l.c(pKCS12Bag2.getLocalKeyID()) || n2 == 0) continue;
            ((Vector)object3).addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)pKCS12Bag2).getCert()));
            vector.removeElementAt(i2);
            OraclePKIDebug.a("Found certificate " + ((PKCS12CertBag)pKCS12Bag2).getCert());
            break;
        }
        byte[] byArray4 = l.d(l.j(byArray), l.k(byArray));
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            pKCS12Bag2 = (PKCS12SecretBag)vector2.elementAt(n2);
            if (!this.a(pKCS12Bag2.getLocalKeyID(), byArray4) || !((object2 = ((PKCS12SecretBag)pKCS12Bag2).getSecretValue()) instanceof ASN1OctetString)) continue;
            try {
                object = ((ASN1OctetString)object2).getValue();
                this.d = new CertificateRequest((byte[])object);
                vector2.removeElementAt(n2);
                OraclePKIDebug.a("Found cert req " + this.d);
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (((Vector)object3).size() == 0) {
            OraclePKIDebug.a("No certificate found for key " + this.a.getLocalKeyID());
            this.b = null;
        } else {
            X509Certificate x509Certificate = (X509Certificate)((Vector)object3).lastElement();
            while (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    object = (PKCS12CertBag)vector.elementAt(i3);
                    if (!((Object)x509Certificate.getIssuerDN()).equals(((PKCS12CertBag)object).getCert().getSubject())) continue;
                    bl = true;
                    ((Vector)object3).addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)object).getCert()));
                    x509Certificate = (X509Certificate)((Vector)object3).lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.a("Cert chain incomplete for key " + this.a);
                break;
            }
            OraclePKIDebug.a("Cert chain determined");
            this.b = new Certificate[((Vector)object3).size()];
            this.b = ((Vector)object3).toArray(this.b);
        }
    }

    String a(byte[] byArray) {
        return new String("personaNum:" + l.j(byArray) + "  componentNum:" + l.k(byArray));
    }

    Key a() {
        PrivateKey privateKey = null;
        if (this.a instanceof PKCS12KeyBag) {
            privateKey = ((PKCS12KeyBag)this.a).getPrivateKey();
        } else if (this.a instanceof PKCS12ShroudedKeyBag) {
            privateKey = ((PKCS12ShroudedKeyBag)this.a).getPrivateKey();
        }
        if (privateKey instanceof RSAPrivateKey) {
            return new OraclePKIRSAPrivateKey((RSAPrivateKey)privateKey, this.d);
        }
        if (privateKey instanceof ECPrivateKey) {
            return new OraclePKIECPrivateKey((ECPrivateKey)privateKey, this.d);
        }
        if (privateKey instanceof DSAPrivateKey) {
            OraclePKIDebug.a("DSA Keys not supported");
            return null;
        }
        if (this.d != null && this.a == null) {
            return new OraclePKIRSAPrivateKey(null, this.d);
        }
        return null;
    }

    Certificate b() {
        if (this.b == null) {
            return null;
        }
        return this.b[0];
    }

    Certificate[] c() {
        if (this.b == null) {
            return null;
        }
        return (Certificate[])this.b.clone();
    }

    boolean e() {
        return true;
    }

    String f() {
        String string = null;
        Certificate certificate = this.b();
        if (certificate instanceof X509Certificate) {
            OraclePKIDebug.a("Certificate for private key is " + certificate);
            X500Name x500Name = new X500Name(((X509Certificate)certificate).getSubjectDN().getName());
            string = "CN=" + x500Name.getCommonName();
            if (x500Name.getCommonName() == null) {
                string = "OU=" + x500Name.getOrgUnitName();
            }
            return string;
        }
        return "";
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null | byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    byte[] h() {
        return this.a.getLocalKeyID();
    }

    int i() {
        return this.c;
    }
}

