/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.pki.OracleCertExtension;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.textui.OraclePKIGenFunc;
import sun.misc.BASE64Encoder;

public class OracleWalletJks
extends OracleWallet {
    private String i = null;
    private byte[] j = null;
    private char[] k = null;
    static ResourceBundle h = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    public OracleWalletJks() {
        this.a();
    }

    public void create(char[] cArray) throws IOException {
        this.a();
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(h.getString("PKI-01002"));
        }
        if (cArray != null) {
            this.k = new char[cArray.length];
            System.arraycopy(cArray, 0, this.k, 0, cArray.length);
        }
        this.j = null;
        KeyStore keyStore = this.getKeyStore();
        try {
            keyStore.load(null, this.k);
            super.a(keyStore);
            this.setKeyStore(keyStore);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Could not create empty jks store.");
            throw (IOException)iOException.initCause(exception);
        }
    }

    public synchronized void open(String string, char[] cArray) throws IOException {
        this.a();
        if (cArray != null) {
            this.k = new char[cArray.length];
            System.arraycopy(cArray, 0, this.k, 0, cArray.length);
        }
        if (string == null) {
            throw new IOException("wrl not specified.");
        }
        KeyStore keyStore = this.getKeyStore();
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            keyStore.load(fileInputStream, this.k);
            this.setKeyStore(keyStore);
        }
        catch (Exception exception) {
            IOException iOException = new IOException(h.getString("PKI-03005"));
            throw (IOException)iOException.initCause(exception);
        }
    }

    public KeyStore getKeyStore() throws IOException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("jks");
            if (this.j != null) {
                keyStore.load(new ByteArrayInputStream(this.j), this.k);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(h.getString("PKI-03005"));
            throw (IOException)iOException.initCause(exception);
        }
        return keyStore;
    }

    public void setKeyStore(KeyStore keyStore) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (keyStore == null) {
            throw new IOException("KeyStore should not be null.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        keyStore.store(byteArrayOutputStream, this.k);
        this.j = byteArrayOutputStream.toByteArray();
    }

    public synchronized void saveAs(String string) throws IOException {
        if (string == null) {
            throw new IOException("wrl not specified.");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(this.j);
    }

    public boolean exists(String string) throws IOException {
        if (string == null) {
            throw new IOException("wrl not specified.");
        }
        File file = new File(string);
        return file.exists();
    }

    public void changePassword(char[] cArray) throws IOException {
        Object object;
        if (cArray == null) {
            throw new IOException("Password cannot be null string.");
        }
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(h.getString("PKI-01002"));
        }
        KeyStore keyStore = this.getKeyStore();
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!keyStore.isKeyEntry((String)object)) continue;
                Key key = keyStore.getKey((String)object, this.k);
                Certificate[] certificateArray = keyStore.getCertificateChain((String)object);
                keyStore.setKeyEntry((String)object, key, cArray, certificateArray);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(exception);
        }
        try {
            this.k = cArray;
            this.setKeyStore(keyStore);
        }
        catch (Exception exception) {
            object = new IOException();
            throw (IOException)((Throwable)object).initCause(exception);
        }
    }

    public InputStream getWalletArray(boolean bl) throws IOException {
        return new ByteArrayInputStream(this.j);
    }

    public byte[] getWalletArrayB(boolean bl) throws IOException {
        return this.j;
    }

    public void setWalletArray(InputStream inputStream, char[] cArray) throws IOException {
        this.a();
        if (inputStream == null) {
            throw new IOException("InputStream is null");
        }
        if (cArray != null) {
            this.k = new char[cArray.length];
            System.arraycopy(cArray, 0, this.k, 0, cArray.length);
        }
        int n2 = inputStream.available();
        this.j = new byte[n2];
        inputStream.read(this.j);
        KeyStore keyStore = this.getKeyStore();
        try {
            keyStore.load(new ByteArrayInputStream(this.j), this.k);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Create jks store failed.");
            throw (IOException)iOException.initCause(exception);
        }
    }

    public void setWalletArray(byte[] byArray, char[] cArray) throws IOException {
        this.setWalletArray(new ByteArrayInputStream(byArray), cArray);
    }

    public void addCertRequest(X500Principal x500Principal, int n2, OracleCertExtension oracleCertExtension, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (n2 != 512 && n2 != 768 && n2 != 1024 && n2 != 2048 && n2 != 4096) {
            throw new IOException(h.getString("PKI-07008"));
        }
        KeyStore keyStore = this.getKeyStore();
        try {
            if (keyStore.containsAlias(string)) {
                throw new IOException(h.getString("PKI-04008") + string);
            }
        }
        catch (KeyStoreException keyStoreException) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(keyStoreException);
        }
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException(noSuchAlgorithmException.getLocalizedMessage());
            throw (IOException)iOException.initCause(noSuchAlgorithmException);
        }
        keyPairGenerator.initialize(n2);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(privateKey.getEncoded());
        RSAPublicKey rSAPublicKey = new RSAPublicKey(publicKey.getEncoded());
        X500Name x500Name = new X500Name(x500Principal.toString());
        X509 x509 = null;
        BigInteger bigInteger = new BigInteger("7");
        int n3 = 3650;
        try {
            x509 = new X509(x500Name, rSAPublicKey, x500Name, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, bigInteger, n3);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509.getEncoded()));
            Certificate[] certificateArray = new Certificate[]{x509Certificate};
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(rSAPrivateKey.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec2 = new PKCS8EncodedKeySpec(rSAPrivateKey.getEncoded());
            PrivateKey privateKey2 = keyFactory.generatePrivate(pKCS8EncodedKeySpec2);
            keyStore.setKeyEntry(string, privateKey2, this.k, certificateArray);
            this.setKeyStore(keyStore);
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(exception);
        }
    }

    public void createSelfSigned(X500Principal x500Principal, int n2, int n3, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        this.a(x500Principal, n2, n3, null, null, bigInteger, oracleCertExtension, string);
    }

    private void a(X500Principal x500Principal, int n2, int n3, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        if (n2 != 512 && n2 != 768 && n2 != 1024 && n2 != 2048 && n2 != 4096) {
            throw new IOException(h.getString("PKI-07008"));
        }
        KeyStore keyStore = this.getKeyStore();
        try {
            if (keyStore.containsAlias(string)) {
                throw new IOException(h.getString("PKI-04008") + string);
            }
        }
        catch (KeyStoreException keyStoreException) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(keyStoreException);
        }
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException(noSuchAlgorithmException.getLocalizedMessage());
            throw (IOException)iOException.initCause(noSuchAlgorithmException);
        }
        keyPairGenerator.initialize(n2);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(privateKey.getEncoded());
        RSAPublicKey rSAPublicKey = new RSAPublicKey(publicKey.getEncoded());
        X500Name x500Name = new X500Name(x500Principal.toString());
        X509 x509 = null;
        try {
            x509 = n3 == 0 ? new X509(x500Name, (oracle.security.crypto.core.PublicKey)rSAPublicKey, x500Name, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, bigInteger, date, date2) : new X509(x500Name, rSAPublicKey, x500Name, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, bigInteger, n3);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509.getEncoded()));
            Certificate[] certificateArray = new Certificate[]{x509Certificate};
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(rSAPrivateKey.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec2 = new PKCS8EncodedKeySpec(rSAPrivateKey.getEncoded());
            PrivateKey privateKey2 = keyFactory.generatePrivate(pKCS8EncodedKeySpec2);
            keyStore.setKeyEntry(string, privateKey2, this.k, certificateArray);
            this.setKeyStore(keyStore);
        }
        catch (Exception exception) {
            IOException iOException = new IOException(h.getString("PKI-03005"));
            throw (IOException)iOException.initCause(exception);
        }
    }

    public String exportCertReqB64(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (string == null) {
            throw new IOException("alias not specified.");
        }
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isKeyEntry(string)) {
            throw new IOException(h.getString("PKI-04017"));
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)x509Certificate.getPublicKey();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, this.k);
        RSAPublicKey rSAPublicKey2 = new RSAPublicKey(rSAPublicKey.getEncoded());
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(privateKey.getEncoded());
        oracle.security.crypto.core.KeyPair keyPair = new oracle.security.crypto.core.KeyPair(rSAPublicKey2, rSAPrivateKey);
        CertificateRequest certificateRequest = new CertificateRequest(new X500Name(((Object)x509Certificate.getSubjectDN()).toString()), keyPair);
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.output(byteArrayOutputStream);
        string2 = "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + bASE64Encoder.encodeBuffer(byteArrayOutputStream.toByteArray()) + "-----END NEW CERTIFICATE REQUEST-----";
        return string2;
    }

    public void importCert(InputStream inputStream, boolean bl, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = this.getKeyStore();
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        if (bl) {
            if (keyStore.containsAlias(string)) {
                throw new IOException("A trusted certificate entry with alias='" + string + "' already exists in keystore.");
            }
            for (int i2 = 0; i2 < oraclePKIX509CertImplArray.length; ++i2) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(oraclePKIX509CertImplArray[i2].getX509().getEncoded()));
                keyStore.setCertificateEntry(string, x509Certificate);
            }
        } else if (oraclePKIX509CertImplArray.length > 1) {
            Object object;
            OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.a(oraclePKIX509CertImplArray);
            Certificate[] certificateArray = new Certificate[oraclePKIX509CertImplArray2.length];
            int n2 = oraclePKIX509CertImplArray2.length - 1;
            int n3 = 0;
            while (n2 > -1) {
                object = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(oraclePKIX509CertImplArray2[n2].getEncoded()));
                certificateArray[n3] = x509Certificate;
                --n2;
                ++n3;
            }
            RSAPrivateCrtKey rSAPrivateCrtKey = null;
            try {
                rSAPrivateCrtKey = (RSAPrivateCrtKey)keyStore.getKey(string, this.k);
            }
            catch (Exception exception) {
                object = new IOException("getKey failed.");
                ((Throwable)object).initCause(exception);
                throw object;
            }
            if (rSAPrivateCrtKey == null) {
                throw new IOException(h.getString("PKI-04009") + string);
            }
            java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)certificateArray[0].getPublicKey();
            if (!rSAPrivateCrtKey.getPublicExponent().equals(rSAPublicKey.getPublicExponent()) || !rSAPrivateCrtKey.getModulus().equals(rSAPublicKey.getModulus())) {
                throw new IOException(h.getString("PKI-04018"));
            }
            keyStore.setKeyEntry(string, rSAPrivateCrtKey, this.k, certificateArray);
        } else {
            try {
                Certificate[] certificateArray;
                if (string == null || !keyStore.isKeyEntry(string)) {
                    throw new IOException("Entry specified by alias is not a key entry");
                }
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)keyStore.getKey(string, this.k);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(oraclePKIX509CertImplArray[0].getEncoded()));
                java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)x509Certificate.getPublicKey();
                if (!rSAPrivateCrtKey.getPublicExponent().equals(rSAPublicKey.getPublicExponent()) || !rSAPrivateCrtKey.getModulus().equals(rSAPublicKey.getModulus())) {
                    throw new IOException(h.getString("PKI-04018"));
                }
                Enumeration<String> enumeration = keyStore.aliases();
                Vector<Certificate> vector = new Vector<Certificate>(keyStore.size());
                while (enumeration.hasMoreElements()) {
                    certificateArray = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry((String)certificateArray)) continue;
                    vector.addElement(keyStore.getCertificate((String)certificateArray));
                }
                certificateArray = this.a(vector, x509Certificate);
                keyStore.setKeyEntry(string, rSAPrivateCrtKey, this.k, certificateArray);
            }
            catch (Exception exception) {
                IOException iOException = new IOException(exception.getLocalizedMessage());
                iOException.initCause(exception);
                throw iOException;
            }
        }
        this.setKeyStore(keyStore);
    }

    X509Certificate[] a(Vector vector, X509Certificate x509Certificate) throws IOException {
        X509Certificate[] x509CertificateArray = null;
        Vector<X509Certificate> vector2 = new Vector<X509Certificate>(vector.size() + 1);
        boolean bl = false;
        vector2.addElement(x509Certificate);
        block0: do {
            bl = false;
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                if (!((Object)((X509Certificate)vector.get(i2)).getSubjectDN()).equals(((X509Certificate)vector2.lastElement()).getIssuerDN())) continue;
                bl = true;
                vector2.addElement((X509Certificate)vector.get(i2));
                vector.remove(i2);
                continue block0;
            }
        } while (bl);
        X509Certificate x509Certificate2 = (X509Certificate)vector2.lastElement();
        if (!x509Certificate2.getSubjectX500Principal().equals(x509Certificate2.getIssuerX500Principal())) {
            throw new IOException("Could not make chain for user cert.");
        }
        x509CertificateArray = new X509Certificate[vector2.size()];
        for (int i3 = 0; i3 < x509CertificateArray.length; ++i3) {
            x509CertificateArray[i3] = (X509Certificate)vector2.get(i3);
        }
        return x509CertificateArray;
    }

    public String exportCertB64(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isKeyEntry(string)) {
            throw new IOException("Entry specified by alias is not a key entry");
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        if (x509Certificate != null) {
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            byte[] byArray = x509Certificate.getEncoded();
            string2 = "-----BEGIN CERTIFICATE-----\n" + bASE64Encoder.encodeBuffer(byArray) + "-----END CERTIFICATE-----";
        }
        return string2;
    }

    public X500Principal[] getCertReqDNs(int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)x500PrincipalArray) || !((Object)(x509Certificate = (X509Certificate)keyStore.getCertificate((String)x500PrincipalArray)).getIssuerDN()).equals(x509Certificate.getSubjectDN())) continue;
            vector.add(new X500Principal(((Object)x509Certificate.getSubjectDN()).toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n3 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n3] = (X500Principal)enumeration2.nextElement();
            ++n3;
        }
        return x500PrincipalArray;
    }

    public int getCertReqCount(int n2, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        throw new IOException("Not implemented.");
    }

    public int getCertReqCount(int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int n3 = 0;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || !((Object)(x509Certificate = (X509Certificate)keyStore.getCertificate(string)).getIssuerDN()).equals(x509Certificate.getSubjectDN())) continue;
            ++n3;
        }
        return n3;
    }

    public String[] getCertReqAliases(int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray) || !((Object)(x509Certificate = (X509Certificate)keyStore.getCertificate((String)stringArray)).getIssuerDN()).equals(x509Certificate.getSubjectDN())) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n3 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n3] = (String)enumeration2.nextElement();
            ++n3;
        }
        return stringArray;
    }

    public ArrayList getCertReqDNalias(int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ArrayList arrayList = new ArrayList();
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) continue;
            arrayList2.add(((Object)x509Certificate.getSubjectDN()).toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public String[] getCertReqInfo(int n2, int n3) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray = new String[4];
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN()) && n3 == n4) {
                stringArray[0] = ((Object)x509Certificate.getSubjectDN()).toString();
                java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)x509Certificate.getPublicKey();
                stringArray[1] = new Integer(rSAPublicKey.getModulus().intValue() * 8).toString();
                stringArray[2] = new String(x509Certificate.getPublicKey().getAlgorithm());
                stringArray[3] = new String(string);
                break;
            }
            ++n4;
        }
        return stringArray;
    }

    public String[] getCertReqInfo(int n2, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray = new String[3];
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isKeyEntry(string)) {
            return stringArray;
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        stringArray[0] = ((Object)x509Certificate.getSubjectDN()).toString();
        java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)x509Certificate.getPublicKey();
        stringArray[1] = new Integer(rSAPublicKey.getModulus().intValue() * 8).toString();
        stringArray[2] = new String(x509Certificate.getPublicKey().getAlgorithm());
        return stringArray;
    }

    public String[] getCertInfo(int n2, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = new String[12];
        Vector vector = new Vector();
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isKeyEntry(string)) {
            return stringArray;
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        X509 x509 = new X509(x509Certificate.getEncoded());
        OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(x509);
        stringArray[0] = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString();
        stringArray[1] = ((Object)oraclePKIX509CertImpl.getIssuerDN()).toString();
        stringArray[2] = Integer.toString(oraclePKIX509CertImpl.getVersion());
        stringArray[3] = oraclePKIX509CertImpl.getSerialNumber().toString(16);
        stringArray[4] = Integer.toString((int)(oraclePKIX509CertImpl.getNotBefore().getTime() / 1000L));
        stringArray[5] = Integer.toString((int)(oraclePKIX509CertImpl.getNotAfter().getTime() / 1000L));
        stringArray[6] = new Integer(((java.security.interfaces.RSAPublicKey)oraclePKIX509CertImpl.getPublicKey()).getModulus().bitLength()).toString();
        stringArray[7] = super.a(oraclePKIX509CertImpl.getKeyUsage());
        stringArray[8] = oraclePKIX509CertImpl.getSigAlgName();
        stringArray[9] = oraclePKIX509CertImpl.getMD5Digest();
        stringArray[10] = oraclePKIX509CertImpl.getSHADigest();
        stringArray[11] = null;
        return stringArray;
    }

    public String[] getTrustpointInfo(int n2, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = new String[12];
        Vector vector = new Vector();
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isCertificateEntry(string)) {
            return stringArray;
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        X509 x509 = new X509(x509Certificate.getEncoded());
        OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(x509);
        stringArray[0] = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString();
        stringArray[1] = ((Object)oraclePKIX509CertImpl.getIssuerDN()).toString();
        stringArray[2] = Integer.toString(oraclePKIX509CertImpl.getVersion());
        stringArray[3] = oraclePKIX509CertImpl.getSerialNumber().toString(16);
        stringArray[4] = Integer.toString((int)(oraclePKIX509CertImpl.getNotBefore().getTime() / 1000L));
        stringArray[5] = Integer.toString((int)(oraclePKIX509CertImpl.getNotAfter().getTime() / 1000L));
        stringArray[6] = new Integer(((java.security.interfaces.RSAPublicKey)oraclePKIX509CertImpl.getPublicKey()).getModulus().bitLength()).toString();
        stringArray[7] = null;
        stringArray[8] = oraclePKIX509CertImpl.getSigAlgName();
        stringArray[9] = oraclePKIX509CertImpl.getMD5Digest();
        stringArray[10] = oraclePKIX509CertImpl.getSHADigest();
        stringArray[11] = null;
        return stringArray;
    }

    public void removeTrustpoint(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isCertificateEntry(string)) {
            throw new IOException("Entry with input alias is not trusted cert.");
        }
        keyStore.deleteEntry(string);
        this.setKeyStore(keyStore);
    }

    public void removeTrustpoints() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string)) continue;
            keyStore.deleteEntry(string);
        }
        this.setKeyStore(keyStore);
    }

    public void deleteCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isKeyEntry(string)) {
            throw new IOException("Entry with input alias is not user cert.");
        }
        keyStore.deleteEntry(string);
        this.setKeyStore(keyStore);
    }

    public void deleteCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isKeyEntry(string)) {
            throw new IOException("Entry with input alias is not user cert.");
        }
        keyStore.deleteEntry(string);
        this.setKeyStore(keyStore);
    }

    public Enumeration listAliases() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = this.getKeyStore();
        return keyStore.aliases();
    }

    public void createSSO() throws IOException {
        throw new IOException();
    }

    public synchronized void saveSSO() throws IOException {
        throw new IOException();
    }

    public void saveLSSO() throws IOException {
        throw new IOException();
    }

    public synchronized OracleSecretStore getSecretStore() throws IOException, OracleSecretStoreException {
        throw new IOException();
    }

    public synchronized void setSecretStore(OracleSecretStore oracleSecretStore) throws IOException, OracleSecretStoreException {
        throw new IOException();
    }

    public boolean isAutoLoginOnly() throws IOException {
        throw new IOException();
    }

    public Enumeration getWalletPersonas() {
        return null;
    }

    public void Pkcs11AddCertReq(String string, String string2, String string3, String string4, int n2, String string5) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, Exception {
        throw new IOException();
    }

    public boolean containsPkcs11Info() throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    public String[] getPkcs11Info() throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    public void addP11CertLbl(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    public void addP11Lib(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    public void addP11TokenLabel(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    public void addP11TokenPwd(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    public X509Certificate getSSLCert(boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        throw new IOException();
    }

    public String getSSLCertAlias(boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        throw new IOException();
    }

    public String trustpointNeededB64(String string, String string2, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    public boolean isTrustedCertUsedInChain(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    private void a() {
        this.k = null;
        this.i = null;
        this.j = null;
    }
}

