/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CrlHelper;
import oracle.security.pki.OraclePKIX509CrlStore;

public class OraclePKIX509CrlFileStore
implements OraclePKIX509CrlStore {
    File a;

    public OraclePKIX509CrlFileStore(File file) throws IOException {
        if (!file.isDirectory() || !file.canRead()) {
            throw new IOException("Can't open crl location");
        }
        this.a = file;
    }

    public CRL getCrlFor(X509Certificate x509Certificate) throws IOException, CertificateException {
        OraclePKIDebug.a("OraclePKIX509CrlFileStore: entry");
        X509 x509 = null;
        x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
        OraclePKIDebug.a("OraclePKIX509CrlFileStore: looking for CRL for " + x509.getIssuer());
        String string = OraclePKIX509CrlFileStore.hashName(x509.getIssuer());
        OraclePKIDebug.a("OraclePKIX509CrlFileStore: looking for file " + string);
        File file = new File(this.a, string);
        try {
            return new CRL(file);
        }
        catch (IOException iOException) {
            return OraclePKIX509CrlHelper.readB64CRLFrom(new FileReader(file));
        }
    }

    public static String hashName(X500Name x500Name) {
        MessageDigest messageDigest;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            x500Name.output(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            return "";
        }
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            OraclePKIDebug.a("OraclePKIX509CrlFileStore: NoSuchAlgorithmException - MD5");
            return "";
        }
        messageDigest.update(byteArrayOutputStream.toByteArray());
        byte[] byArray = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer(9);
        for (int i2 = 3; i2 >= 0; --i2) {
            if (byArray[i2] < 0) {
                stringBuffer.append(Integer.toHexString(256 + byArray[i2]));
                continue;
            }
            if (byArray[i2] < 16) {
                stringBuffer.append("0");
                stringBuffer.append(Integer.toHexString(byArray[i2]));
                continue;
            }
            stringBuffer.append(Integer.toHexString(byArray[i2]));
        }
        stringBuffer.append(".rN");
        return stringBuffer.toString();
    }
}

