/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CRLDistPoint;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.ext.CRLDistPointExtension;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CrlStore;

public class OraclePKIX509CrlDPStore
implements OraclePKIX509CrlStore {
    public CRL getCrlFor(X509Certificate x509Certificate) throws IOException, CertificateException {
        OraclePKIDebug.a("OraclePKIX509CrlDPStore: entry");
        X509 x509 = null;
        x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
        CRLDistPointExtension cRLDistPointExtension = (CRLDistPointExtension)x509.getExtension(PKIX.id_ce_cRLDistributionPoints);
        if (cRLDistPointExtension == null) {
            return null;
        }
        Vector<CRLDistPoint> vector = cRLDistPointExtension.getCRLDistPoints();
        OraclePKIDebug.a("OraclePKIX509CrlDPStore: found " + vector.size() + " Distribution Points");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Vector<GeneralName> vector2 = vector.elementAt(i2).getDistPointName().getFullName();
            for (int i3 = 0; i3 < vector2.size(); ++i3) {
                GeneralName generalName = vector2.elementAt(i3);
                if (generalName.getType() != GeneralName.Type.URI) continue;
                OraclePKIDebug.a("OraclePKIX509CrlDPStore: trying " + ((ASN1String)generalName.getValue()).getValue());
                try {
                    URL uRL = new URL(((ASN1String)generalName.getValue()).getValue());
                    return new CRL(uRL);
                }
                catch (Exception exception) {
                    OraclePKIDebug.a("OraclePKIX509CrlDPStore: " + exception);
                }
            }
        }
        OraclePKIDebug.a("OraclePKIX509CrlDPStore: CRL not found");
        return null;
    }
}

