/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.text.Collator;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.crypto.KeyAgreement;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.PKCS12KeyBag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS12SecretBag;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.RSA;
import oracle.security.crypto.core.RSAKey;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.pki.NZNative;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIECPrivateKey;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.h;
import oracle.security.pki.i;
import oracle.security.pki.j;
import oracle.security.pki.k;
import oracle.security.pki.l;
import oracle.security.pki.n;
import oracle.security.pki.q;
import oracle.security.pki.r;

public class OracleKeyStoreSpi
extends KeyStoreSpi {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private PKCS12 b = null;
    private Hashtable c = new Hashtable();
    private Hashtable d = new Hashtable();
    private String e;
    private String f;
    private String g;
    private String h;
    private static final int[] i = new int[]{1, 2, 840, 113549, 1, 12, 0, 0, 0};
    private static final byte[] j = new byte[]{1, 0, 0, 0};
    private static final String k = "secret";
    private static final int l = 100;
    public static final String p11LibOID = "2.16.840.1.113894.2.99.300.2";
    public static final String p11TokLblOID = "2.16.840.1.113894.2.99.300.3";
    public static final String p11TokPwdOID = "2.16.840.1.113894.2.99.300.4";
    public static final String p11CrtLblOID = "2.16.840.1.113894.2.99.300.5";
    public static final String CREDENTIAL_CONNECT_STRING = "oracle.security.client.connect_string";
    public static final String CREDENTIAL_USERNAME = "oracle.security.client.username";
    public static final String CREDENTIAL_PASSWORD = "oracle.security.client.password";

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.engineContainsAlias(string)) {
            return ((h)this.c.get(string)).a();
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        OraclePKIDebug.a("OracleKeyStoreSpi: getCertificateChain alias \"" + (null == string ? "null" : string) + "\"");
        if (this.engineContainsAlias(string)) {
            return ((h)this.c.get(string)).c();
        }
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        OraclePKIDebug.a("OracleKeyStoreSpi: getCertificate alias \"" + (null == string ? "null" : string) + "\"");
        if (this.engineContainsAlias(string)) {
            return ((h)this.c.get(string)).b();
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        if (this.engineContainsAlias(string)) {
            return ((h)this.c.get(string)).g();
        }
        return null;
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Not Implemented");
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Not Implemented");
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.engineContainsAlias(string) && !((h)this.c.get(string)).d()) {
            throw new KeyStoreException(a.getString("PKI-04013"));
        }
        j j2 = new j(certificate);
        this.c.put(string, j2);
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (!this.engineContainsAlias(string)) {
            throw new KeyStoreException(a.getString("PKI-04014"));
        }
        this.c.remove(string);
    }

    public Enumeration engineAliases() {
        return new Vector(this.c.keySet()).elements();
    }

    public boolean engineContainsAlias(String string) {
        return this.c.containsKey(string);
    }

    public int engineSize() {
        return this.c.size();
    }

    public boolean engineIsKeyEntry(String string) {
        if (this.engineContainsAlias(string)) {
            return ((h)this.c.get(string)).e();
        }
        return false;
    }

    public boolean engineIsCertificateEntry(String string) {
        if (this.engineContainsAlias(string)) {
            return ((h)this.c.get(string)).d();
        }
        return false;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Set set = this.c.entrySet();
        for (Map.Entry entry : set) {
            if (!((h)entry.getValue()).b().equals(certificate)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        PKCS12 pKCS12 = null;
        OraclePKIDebug.a("OracleKeyStoreSpi: Loading wallet from stream");
        AccessController.doPrivileged(new k(this));
        if (inputStream == null) {
            pKCS12 = new PKCS12();
            pKCS12.setPassword(new String(cArray));
        } else {
            FileChannel fileChannel = null;
            FileLock fileLock = null;
            boolean bl = false;
            try {
                try {
                    if (inputStream instanceof FileInputStream) {
                        OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:getting channel..");
                        fileChannel = ((FileInputStream)inputStream).getChannel();
                        OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:locking file (shared)..");
                        fileLock = fileChannel.lock(0L, inputStream.available(), true);
                        OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:locked file.");
                        bl = true;
                    }
                }
                catch (OverlappingFileLockException overlappingFileLockException) {
                    // empty catch block
                }
                pKCS12 = new PKCS12(new String(cArray), inputStream);
            }
            finally {
                if (fileLock != null) {
                    OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:releasing lock..");
                    fileLock.release();
                }
                if (bl && fileChannel != null) {
                    OraclePKIDebug.a("OracleKeyStoreSpi.engineLoad:closing channel..");
                    fileChannel.close();
                }
            }
        }
        boolean bl = false;
        try {
            bl = pKCS12.verify();
        }
        catch (AuthenticationException authenticationException) {
            bl = false;
        }
        if (!bl) {
            throw new IOException(a.getString("PKI-02010"));
        }
        this.a(pKCS12);
        OraclePKIDebug.a("OracleKeyStoreSpi: Keystore Loaded");
    }

    public void printLocalKeyIDs(PKCS12 pKCS12) {
        System.out.println("-------------------");
        PKCS12Safe pKCS12Safe = pKCS12.getAuthSafes().elementAt(0);
        Vector<PKCS12Bag> vector = pKCS12Safe.getBags();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            if (OracleKeyStoreSpi.b(pKCS12Bag)) {
                System.out.println("CertReqBag = " + oracle.security.pki.l.k(byArray));
            }
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.l.b(byArray)) {
                System.out.println("User CertBag = " + oracle.security.pki.l.k(byArray));
            }
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.l.c(pKCS12Bag.getLocalKeyID())) {
                System.out.println("Trusted CertBag = " + oracle.security.pki.l.k(byArray));
            }
            if (OracleKeyStoreSpi.c(pKCS12Bag)) {
                System.out.println("KeyBag = " + oracle.security.pki.l.k(byArray));
            }
            if (!OracleKeyStoreSpi.d(pKCS12Bag)) continue;
            System.out.println("SecretStoreBag = " + oracle.security.pki.l.k(byArray));
        }
    }

    int a() {
        return this.d.size();
    }

    Enumeration b() {
        TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
        treeSet.addAll(this.d.keySet());
        return new Vector<Object>(treeSet).elements();
    }

    Enumeration c() {
        return new Vector(this.d.keySet()).elements();
    }

    public void secretStoreDeleteSecret(String string) throws OracleSecretStoreException {
        if (!this.secretStoreContainsAlias(string)) {
            throw new OracleSecretStoreException("No such alias in secret store");
        }
        this.d.remove(string);
    }

    public void secretStoreSetSecret(String string, char[] cArray) throws OracleSecretStoreException {
        if (this.secretStoreContainsAlias(string)) {
            r r2 = (r)this.d.get(string);
            r2.a(cArray);
        } else {
            r r3 = new r(string, cArray);
            this.d.put(r3.b(), r3);
        }
    }

    public char[] secretStoreGetSecret(String string) throws OracleSecretStoreException {
        if (this.secretStoreContainsAlias(string)) {
            return ((r)this.d.get(string)).a();
        }
        return null;
    }

    public boolean secretStoreContainsAlias(String string) throws OracleSecretStoreException {
        return this.d.containsKey(string);
    }

    public void secretStoreCreateCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        int n2 = 1;
        Enumeration enumeration = new Vector(this.d.values()).elements();
        System.out.print("Create credential ");
        while (enumeration.hasMoreElements()) {
            r r2 = (r)enumeration.nextElement();
            String string = new String(r2.a());
            String string2 = r2.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            throw new OracleSecretStoreException("Credential already exists");
        }
        while (this.secretStoreContainsAlias(CREDENTIAL_CONNECT_STRING + n2)) {
            ++n2;
        }
        System.out.println(CREDENTIAL_CONNECT_STRING + n2);
        this.secretStoreSetSecret(CREDENTIAL_CONNECT_STRING + n2, cArray);
        this.secretStoreSetSecret(CREDENTIAL_USERNAME + n2, cArray2);
        this.secretStoreSetSecret(CREDENTIAL_PASSWORD + n2, cArray3);
    }

    public void secretStoreModifyCredential(char[] cArray, char[] cArray2, char[] cArray3) throws OracleSecretStoreException {
        boolean bl = false;
        Enumeration enumeration = new Vector(this.d.values()).elements();
        System.out.println("Modify credential ");
        while (enumeration.hasMoreElements()) {
            r r2 = (r)enumeration.nextElement();
            String string = new String(r2.a());
            String string2 = r2.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println("Modify " + string3);
            this.secretStoreDeleteSecret(CREDENTIAL_USERNAME + string3);
            this.secretStoreSetSecret(CREDENTIAL_USERNAME + string3, cArray2);
            this.secretStoreDeleteSecret(CREDENTIAL_PASSWORD + string3);
            this.secretStoreSetSecret(CREDENTIAL_PASSWORD + string3, cArray3);
            bl = true;
            break;
        }
        if (!bl) {
            throw new OracleSecretStoreException("Credential does not exists");
        }
    }

    public void secretStoreDeleteCredential(char[] cArray) throws OracleSecretStoreException {
        boolean bl = false;
        Enumeration enumeration = new Vector(this.d.values()).elements();
        System.out.println("Delete credential ");
        while (enumeration.hasMoreElements()) {
            r r2 = (r)enumeration.nextElement();
            String string = new String(r2.a());
            String string2 = r2.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING) || !string.equalsIgnoreCase(new String(cArray))) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println("Delete " + string3);
            this.secretStoreDeleteSecret(string2);
            this.secretStoreDeleteSecret(CREDENTIAL_USERNAME + string3);
            this.secretStoreDeleteSecret(CREDENTIAL_PASSWORD + string3);
            bl = true;
            break;
        }
        if (!bl) {
            throw new OracleSecretStoreException("Credential does not exists");
        }
    }

    public void secretStoreListCredential() throws OracleSecretStoreException {
        Enumeration enumeration = new Vector(this.d.values()).elements();
        System.out.println("List credential (index: connect_string username)");
        while (enumeration.hasMoreElements()) {
            r r2 = (r)enumeration.nextElement();
            String string = new String(r2.a());
            String string2 = r2.b();
            if (!string2.startsWith(CREDENTIAL_CONNECT_STRING)) continue;
            String string3 = string2.substring(CREDENTIAL_CONNECT_STRING.length());
            System.out.println(string3 + ": " + string + " " + new String(this.secretStoreGetSecret(CREDENTIAL_USERNAME + string3)));
        }
    }

    private static boolean a(PKCS12Bag pKCS12Bag) {
        return pKCS12Bag instanceof PKCS12CertBag;
    }

    private static boolean b(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return oracle.security.pki.l.a(pKCS12Bag.getLocalKeyID());
    }

    private static boolean c(PKCS12Bag pKCS12Bag) {
        return pKCS12Bag instanceof PKCS12KeyBag || pKCS12Bag instanceof PKCS12ShroudedKeyBag;
    }

    private static boolean d(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return oracle.security.pki.l.d(pKCS12Bag.getLocalKeyID());
    }

    private static boolean e(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return oracle.security.pki.l.e(pKCS12Bag.getLocalKeyID());
    }

    private static boolean f(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return oracle.security.pki.l.f(pKCS12Bag.getLocalKeyID());
    }

    private static boolean g(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return oracle.security.pki.l.g(pKCS12Bag.getLocalKeyID());
    }

    private static boolean h(PKCS12Bag pKCS12Bag) {
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            return false;
        }
        return oracle.security.pki.l.h(pKCS12Bag.getLocalKeyID());
    }

    private static Vector b(PKCS12 pKCS12) {
        Vector<PKCS12Safe> vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Safe pKCS12Safe = vector.elementAt(i2);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i2);
            Vector<PKCS12Bag> vector3 = pKCS12Safe.getBags();
            for (int i3 = 0; i3 < vector3.size(); ++i3) {
                PKCS12Bag pKCS12Bag = vector3.elementAt(i3);
                if (!OracleKeyStoreSpi.d(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found secret store bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(i3);
                --i3;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    private void c(PKCS12 pKCS12) {
        Vector<PKCS12Safe> vector = pKCS12.getAuthSafes();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Safe pKCS12Safe = vector.elementAt(i2);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i2);
            Vector<PKCS12Bag> vector2 = pKCS12Safe.getBags();
            for (int i3 = 0; i3 < vector2.size(); ++i3) {
                ASN1Object aSN1Object;
                PKCS12Bag pKCS12Bag = vector2.elementAt(i3);
                if (OracleKeyStoreSpi.e(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 lib info");
                    aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
                    this.e = new String(((ASN1OctetString)aSN1Object).getValue());
                    vector2.removeElementAt(i3);
                    --i3;
                }
                if (OracleKeyStoreSpi.f(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 tokenlabel info");
                    aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
                    this.f = new String(((ASN1OctetString)aSN1Object).getValue());
                    vector2.removeElementAt(i3);
                    --i3;
                }
                if (OracleKeyStoreSpi.g(pKCS12Bag)) {
                    OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 tokenlabel info");
                    aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
                    this.g = new String(((ASN1OctetString)aSN1Object).getValue());
                    vector2.removeElementAt(i3);
                    --i3;
                }
                if (!OracleKeyStoreSpi.h(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found bag containing PKCS11 tokenlabel info");
                aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue();
                this.h = new String(((ASN1OctetString)aSN1Object).getValue());
                vector2.removeElementAt(i3);
                --i3;
            }
            pKCS12Safe.setBags(vector2);
        }
    }

    public String getP11Lib() {
        return this.e;
    }

    public String getP11TokenLabel() {
        return this.f;
    }

    public String getP11TokenPassphrase() {
        return this.g;
    }

    public String getP11CertLabel() {
        return this.h;
    }

    byte[] a(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException {
        ASN1Object aSN1Object;
        ASN1Object aSN1Object2;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object2 = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object2).getAuthSafes());
        }
        aSN1Object2 = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object2 = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object2).setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object2 = pKCS12.getAuthSafes().elementAt(0);
        }
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object2).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        boolean bl = false;
        int n2 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            aSN1Object = vector.elementAt(n2);
            if (!OracleKeyStoreSpi.e(aSN1Object)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 lib bag");
            bl = true;
            break;
        }
        if (bl) {
            vector.remove(n2);
        }
        aSN1Object = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11LibOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object2, aSN1ObjectID, aSN1Object);
        pKCS12SecretBag.setLocalKeyID(oracle.security.pki.l.a(0));
        vector.addElement(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 lib bag ");
        ((PKCS12Safe)aSN1Object2).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] b(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException {
        ASN1Object aSN1Object;
        ASN1Object aSN1Object2;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object2 = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object2).getAuthSafes());
        }
        aSN1Object2 = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object2 = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object2).setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object2 = pKCS12.getAuthSafes().elementAt(0);
        }
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object2).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        boolean bl = false;
        int n2 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            aSN1Object = vector.elementAt(n2);
            if (!OracleKeyStoreSpi.f(aSN1Object)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 token label bag");
            bl = true;
            break;
        }
        if (bl) {
            vector.remove(n2);
        }
        aSN1Object = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11TokLblOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object2, aSN1ObjectID, aSN1Object);
        pKCS12SecretBag.setLocalKeyID(oracle.security.pki.l.b(0));
        vector.addElement(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 token label bag ");
        ((PKCS12Safe)aSN1Object2).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] c(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException {
        ASN1Object aSN1Object;
        ASN1Object aSN1Object2;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object2 = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object2).getAuthSafes());
        }
        aSN1Object2 = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object2 = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object2).setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object2 = pKCS12.getAuthSafes().elementAt(0);
        }
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object2).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        boolean bl = false;
        int n2 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            aSN1Object = vector.elementAt(n2);
            if (!OracleKeyStoreSpi.g(aSN1Object)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 token pwd bag");
            bl = true;
            break;
        }
        if (bl) {
            vector.remove(n2);
        }
        aSN1Object = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11TokPwdOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object2, aSN1ObjectID, aSN1Object);
        pKCS12SecretBag.setLocalKeyID(oracle.security.pki.l.c(0));
        vector.addElement(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 token pwd bag ");
        ((PKCS12Safe)aSN1Object2).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] d(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException {
        ASN1Object aSN1Object;
        ASN1Object aSN1Object2;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object2 = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object2).getAuthSafes());
        }
        aSN1Object2 = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object2 = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object2).setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object2 = pKCS12.getAuthSafes().elementAt(0);
        }
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object2).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        boolean bl = false;
        int n2 = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            aSN1Object = vector.elementAt(n2);
            if (!OracleKeyStoreSpi.h(aSN1Object)) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found old pkcs11 cert label bag");
            bl = true;
            break;
        }
        if (bl) {
            vector.remove(n2);
        }
        aSN1Object = new ASN1OctetString(string.getBytes());
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(p11CrtLblOID);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object2, aSN1ObjectID, aSN1Object);
        pKCS12SecretBag.setLocalKeyID(oracle.security.pki.l.d(0));
        vector.addElement(pKCS12SecretBag);
        OraclePKIDebug.a("OracleWallet: added p11 cert label bag ");
        ((PKCS12Safe)aSN1Object2).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static Vector d(PKCS12 pKCS12) {
        Vector<PKCS12Safe> vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Safe pKCS12Safe = vector.elementAt(i2);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i2);
            Vector<PKCS12Bag> vector3 = pKCS12Safe.getBags();
            for (int i3 = 0; i3 < vector3.size(); ++i3) {
                PKCS12Bag pKCS12Bag = vector3.elementAt(i3);
                if (!OracleKeyStoreSpi.c(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found key bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(i3);
                --i3;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    private static Vector e(PKCS12 pKCS12) {
        Vector<PKCS12Safe> vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Safe pKCS12Safe = vector.elementAt(i2);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i2);
            Vector<PKCS12Bag> vector3 = pKCS12Safe.getBags();
            for (int i3 = 0; i3 < vector3.size(); ++i3) {
                PKCS12Bag pKCS12Bag = vector3.elementAt(i3);
                if (!OracleKeyStoreSpi.a(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(i3);
                --i3;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    private static Vector f(PKCS12 pKCS12) {
        Vector<PKCS12Safe> vector = pKCS12.getAuthSafes();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Safe pKCS12Safe = vector.elementAt(i2);
            OraclePKIDebug.a("OracleKeyStoreSpi: Opening safe " + i2);
            Vector<PKCS12Bag> vector3 = pKCS12Safe.getBags();
            for (int i3 = 0; i3 < vector3.size(); ++i3) {
                PKCS12Bag pKCS12Bag = vector3.elementAt(i3);
                if (!OracleKeyStoreSpi.b(pKCS12Bag)) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: found cert req bag");
                vector2.addElement(pKCS12Bag);
                vector3.removeElementAt(i3);
                --i3;
            }
            pKCS12Safe.setBags(vector3);
        }
        return vector2;
    }

    void a(PKCS12 pKCS12) throws NoSuchAlgorithmException, CertificateException, IOException {
        int n2;
        String string;
        PKCS12Bag pKCS12Bag;
        String string2;
        Object object;
        int n3;
        Vector vector = OracleKeyStoreSpi.d(pKCS12);
        Vector vector2 = OracleKeyStoreSpi.e(pKCS12);
        Vector vector3 = OracleKeyStoreSpi.b(pKCS12);
        Vector vector4 = OracleKeyStoreSpi.f(pKCS12);
        this.c(pKCS12);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(vector.size() + vector2.size());
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>(vector3.size());
        for (n3 = 0; n3 < vector.size(); ++n3) {
            OraclePKIDebug.a("Processing identity " + n3);
            object = new i((PKCS12Bag)vector.elementAt(n3), vector2, vector4);
            string2 = null;
            pKCS12Bag = (PKCS12Bag)vector.elementAt(n3);
            string = pKCS12Bag.getFriendlyName();
            if (string != null) {
                string2 = string;
            } else {
                string2 = ((h)object).f();
                n2 = 1;
                while (hashtable.containsKey(string2)) {
                    string2 = string2 + ' ' + Integer.toString(n2);
                    ++n2;
                }
            }
            OraclePKIDebug.a("Storing identity " + n3 + " as " + string2);
            hashtable.put(string2, object);
        }
        for (n3 = 0; n3 < vector4.size(); ++n3) {
            OraclePKIDebug.a("Processing CertReq with no matching pvt key " + n3);
            object = new i((PKCS12Bag)vector4.elementAt(n3), vector2);
            string2 = null;
            pKCS12Bag = (PKCS12Bag)vector4.elementAt(n3);
            string = pKCS12Bag.getFriendlyName();
            if (string != null) {
                string2 = string;
            } else {
                string2 = ((h)object).f();
                n2 = 1;
                while (hashtable.containsKey(string2)) {
                    string2 = string2 + ' ' + Integer.toString(n2);
                    ++n2;
                }
            }
            OraclePKIDebug.a("Storing creq " + n3 + " as " + string2);
            hashtable.put(string2, object);
        }
        for (n3 = 0; n3 < vector2.size(); ++n3) {
            OraclePKIDebug.a("Processing TP " + n3);
            object = new j((PKCS12CertBag)vector2.elementAt(n3));
            string2 = null;
            pKCS12Bag = (PKCS12Bag)vector2.elementAt(n3);
            string = pKCS12Bag.getFriendlyName();
            if (string != null) {
                string2 = string;
            } else {
                string2 = ((h)object).f();
                n2 = 1;
                while (hashtable.containsKey(string2)) {
                    string2 = ((h)object).f() + ' ' + Integer.toString(n2);
                    ++n2;
                }
            }
            OraclePKIDebug.a("Storing TP " + n3 + " as " + string2);
            hashtable.put(string2, object);
        }
        try {
            for (n3 = 0; n3 < vector3.size(); ++n3) {
                OraclePKIDebug.a("OracleKeyStoreSpi: Storing Secret" + n3);
                object = new r((PKCS12SecretBag)vector3.elementAt(n3));
                hashtable2.put(((r)object).b(), object);
            }
        }
        catch (OracleSecretStoreException oracleSecretStoreException) {
            throw new IOException(oracleSecretStoreException.toString());
        }
        this.c = hashtable;
        this.d = hashtable2;
    }

    byte[] a(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        Object object;
        ASN1Object aSN1Object;
        PKCS12 pKCS12 = null;
        pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
            OracleKeyStoreSpi.b(pKCS12);
        }
        aSN1Object = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new secret store");
            aSN1Object = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object).setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object = pKCS12.getAuthSafes().elementAt(0);
        }
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + "bags");
        if (this.d.size() > 0) {
            object = this.d.entrySet();
            Iterator iterator = object.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                r r2 = (r)iterator.next().getValue();
                PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object);
                r2.a(pKCS12SecretBag);
                pKCS12SecretBag.setLocalKeyID(oracle.security.pki.l.a(0, n2));
                vector.insertElementAt(pKCS12SecretBag, 0);
                ++n2;
                OraclePKIDebug.a("OracleWallet: added secret bag");
            }
        }
        ((PKCS12Safe)aSN1Object).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object);
        }
        OraclePKIDebug.a("OracleWallet: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleWallet: wallet size " + pKCS12.length());
        object = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, KeyStore keyStore, char[] cArray, boolean bl) throws IOException, KeyStoreException, CertificateException {
        ASN1Object aSN1Object;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
            OracleKeyStoreSpi.d(pKCS12);
            OracleKeyStoreSpi.e(pKCS12);
            OracleKeyStoreSpi.f(pKCS12);
        }
        aSN1Object = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object = new PKCS12Safe(pKCS12);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object = pKCS12.getAuthSafes().elementAt(0);
        }
        if (bl) {
            ((PKCS12Safe)aSN1Object).setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA1, AlgID.aes256_CBC);
        } else {
            ((PKCS12Safe)aSN1Object).setMode(3);
        }
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        Object object = keyStore.aliases();
        while (object.hasMoreElements()) {
            int n2 = 0;
            String string = object.nextElement();
            if (keyStore.isCertificateEntry(string)) {
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                X509 x509 = x509Certificate instanceof OraclePKIX509CertImpl ? ((OraclePKIX509CertImpl)x509Certificate).getX509() : new X509(x509Certificate.getEncoded());
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, x509);
                pKCS12CertBag.setLocalKeyID(oracle.security.pki.l.b(0, n2));
                vector.insertElementAt(pKCS12CertBag, 0);
                OraclePKIDebug.a("OracleWallet: added cert bag");
                continue;
            }
            if (!keyStore.isKeyEntry(string)) continue;
            throw new IOException("Not Implemented for private keys");
        }
        ((PKCS12Safe)aSN1Object).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object);
        }
        OraclePKIDebug.a("OracleWallet: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleWallet: wallet size " + pKCS12.length());
        object = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, KeyStore keyStore, char[] cArray) throws IOException, KeyStoreException, CertificateException {
        return this.a(inputStream, keyStore, cArray, false);
    }

    static void a(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2) throws IOException {
        OracleKeyStoreSpi.a(inputStream, cArray, outputStream, cArray2, false);
    }

    static void a(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2, boolean bl) throws IOException {
        PKCS12 pKCS12 = new PKCS12(new String(cArray), inputStream);
        boolean bl2 = cArray.length == cArray2.length;
        for (int i2 = 0; bl2 && i2 < cArray.length; ++i2) {
            if (cArray[i2] == cArray2[i2]) continue;
            bl2 = false;
        }
        pKCS12.setPassword(new String(cArray2));
        Vector<PKCS12Safe> vector = pKCS12.getAuthSafes();
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            PKCS12Bag pKCS12Bag;
            boolean bl3 = false;
            Vector<PKCS12Bag> vector2 = vector.elementAt(i3).getBags();
            ASN1OctetString aSN1OctetString = new ASN1OctetString(j);
            for (int i4 = 0; i4 < vector2.size(); ++i4) {
                if (vector2.elementAt(i4) instanceof PKCS12ShroudedKeyBag) {
                    ((PKCS12ShroudedKeyBag)vector2.elementAt(i4)).setPassword(new String(cArray));
                    pKCS12Bag = new PKCS12KeyBag(vector.elementAt(i3), ((PKCS12ShroudedKeyBag)vector2.elementAt(i4)).getPrivateKey());
                    pKCS12Bag.setLocalKeyID(((PKCS12ShroudedKeyBag)vector2.elementAt(i4)).getLocalKeyID());
                    pKCS12Bag.setFriendlyName(((PKCS12ShroudedKeyBag)vector2.elementAt(i4)).getFriendlyName());
                    vector2.removeElementAt(i4);
                    vector2.insertElementAt(pKCS12Bag, i4);
                    continue;
                }
                if (!(vector2.elementAt(i4) instanceof PKCS12SecretBag) || !((PKCS12SecretBag)(pKCS12Bag = (PKCS12SecretBag)vector2.elementAt(i4))).getSecretType().equals(new ASN1ObjectID(i))) continue;
                bl3 = true;
            }
            PKCS12Safe pKCS12Safe = vector.elementAt(i3);
            if (bl) {
                pKCS12Safe.setPBES2Parameters(PBEAlgorithmIdentifier.id_PBES2, AlgID.hmacWithSHA1, AlgID.aes256_CBC);
            }
            if (pKCS12Safe.getPBEOID().equals(PBEAlgorithmIdentifier.id_PBES2) && !bl3) {
                pKCS12Bag = new PKCS12SecretBag(pKCS12Safe, new ASN1ObjectID(i), aSN1OctetString);
                pKCS12Bag.setLocalKeyID(oracle.security.pki.l.a(0, 0, oracle.security.pki.l.a));
                pKCS12Bag.setFriendlyName(k + new Random().nextInt(100));
                vector2.add(pKCS12Bag);
            }
            vector.elementAt(i3).setBags(vector2);
            vector.elementAt(i3).setPassword(new String(cArray2));
        }
        try {
            pKCS12.output(outputStream);
            OraclePKIDebug.a("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.a("Verifying wallet failed" + authenticationException);
            throw new IOException("Could not store wallet " + authenticationException);
        }
    }

    byte[] a(InputStream inputStream, char[] cArray, CertificateRequest certificateRequest, oracle.security.crypto.core.PrivateKey privateKey, String string) throws IOException, KeyStoreException {
        Object object;
        Object object2;
        ASN1Object aSN1Object;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
        }
        aSN1Object = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object).setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object = pKCS12.getAuthSafes().elementAt(0);
        }
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n2 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            boolean bl;
            int n3;
            object2 = vector.elementAt(i2);
            if (OracleKeyStoreSpi.c((PKCS12Bag)object2)) {
                OraclePKIDebug.a("OracleKeyStoreSpi: found key bag");
                if (string != null && ((PKCS12Bag)object2).getFriendlyName().equalsIgnoreCase(string)) {
                    throw new IOException(a.getString("PKI-04008") + string);
                }
                object = ((PKCS12Bag)object2).getLocalKeyID();
                n3 = oracle.security.pki.l.k(object);
                if (n3 == n2) {
                    ++n2;
                } else if (n3 > n2) {
                    n2 = n3 + 1;
                }
            }
            if (!OracleKeyStoreSpi.b((PKCS12Bag)object2) || (bl = this.a(pKCS12, n3 = oracle.security.pki.l.k(object = ((PKCS12Bag)object2).getLocalKeyID())))) continue;
            if (n3 == n2) {
                ++n2;
                continue;
            }
            if (n3 <= n2) continue;
            n2 = n3 + 1;
        }
        if (string == null) {
            string = n2 == 0 ? "orakey" : "orakey" + Integer.toString(n2);
        }
        if (privateKey != null) {
            PKCS12KeyBag pKCS12KeyBag = new PKCS12KeyBag((PKCS12Safe)aSN1Object, privateKey);
            pKCS12KeyBag.setLocalKeyID(oracle.security.pki.l.c(0, n2));
            pKCS12KeyBag.setFriendlyName(string.toLowerCase());
            vector.addElement(pKCS12KeyBag);
            OraclePKIDebug.a("OracleWallet: added key bag " + n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.output(byteArrayOutputStream);
        object2 = byteArrayOutputStream.toByteArray();
        object = new ASN1OctetString((byte[])object2);
        PKCS12SecretBag pKCS12SecretBag = new PKCS12SecretBag((PKCS12Safe)aSN1Object, new ASN1ObjectID("42.134.72.134.247.13.1.10"), (ASN1Object)object);
        pKCS12SecretBag.setLocalKeyID(oracle.security.pki.l.d(0, n2));
        pKCS12SecretBag.setFriendlyName(string.toLowerCase());
        vector.addElement(pKCS12SecretBag);
        OraclePKIDebug.a("OracleKeyStoreSpi: added req bag " + n2);
        ((PKCS12Safe)aSN1Object).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + pKCS12.length());
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream2);
        return byteArrayOutputStream2.toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string) throws IOException, KeyStoreException {
        Object object;
        ASN1Object aSN1Object;
        if (this.b(oraclePKIX509CertImpl)) {
            throw new KeyStoreException(a.getString("PKI-04003"));
        }
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
        }
        aSN1Object = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object).setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object = pKCS12.getAuthSafes().elementAt(0);
        }
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n2 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            object = vector.elementAt(i2);
            if (string != null && ((PKCS12Bag)object).getFriendlyName() != null && ((PKCS12Bag)object).getFriendlyName().equalsIgnoreCase(string)) {
                throw new IOException(a.getString("PKI-04008") + string);
            }
            if (!OracleKeyStoreSpi.a((PKCS12Bag)object) || !oracle.security.pki.l.c(((PKCS12Bag)object).getLocalKeyID())) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
            ++n2;
        }
        PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, oraclePKIX509CertImpl.getX509());
        pKCS12CertBag.setLocalKeyID(oracle.security.pki.l.b(0, n2));
        if (string != null) {
            pKCS12CertBag.setFriendlyName(string.toLowerCase());
        }
        vector.addElement(pKCS12CertBag);
        OraclePKIDebug.a("OracleWallet: added key bag " + n2);
        ((PKCS12Safe)aSN1Object).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + pKCS12.length());
        object = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ASN1Object aSN1Object;
        ASN1Object aSN1Object2;
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object3)) continue;
            object2 = this.engineGetKey((String)object3, null);
            if (object2.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)object2).getCertificateRequest();
            } else {
                if (!object2.getAlgorithm().equals("EC")) continue;
                certificateRequest = ((OraclePKIECPrivateKey)object2).getCertificateRequest();
            }
            if (certificateRequest == null || !x500Name.equals(new X500Name((String)(object = certificateRequest.getSubject().toString())))) continue;
            serializable = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object3);
            if (serializable != null) {
                throw new IOException(a.getString("PKI-04011"));
            }
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveCertReq: No cert request in wallet with matching DN.");
            throw new IOException(a.getString("PKI-04005"));
        }
        object3 = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object3);
        object2 = ((ByteArrayOutputStream)object3).toByteArray();
        object = null;
        serializable = new PKCS12();
        ((PKCS12)serializable).setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object2 = new PKCS12(new String(cArray), inputStream);
            ((PKCS12)serializable).setAuthSafes(((PKCS12)aSN1Object2).getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object2 = ((PKCS12)serializable).getAuthSafes().elementAt(0);
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object2).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            byte[] byArray;
            boolean bl2;
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            if (!OracleKeyStoreSpi.b(pKCS12Bag) || !(bl2 = Arrays.equals((byte[])object2, byArray = ((ASN1OctetString)(aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            object = pKCS12Bag.getLocalKeyID();
            vector.removeElementAt(i2);
            break;
        }
        byte[] byArray = oracle.security.pki.l.c(oracle.security.pki.l.j((byte[])object), oracle.security.pki.l.k((byte[])object));
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            aSN1Object = vector.elementAt(i3);
            if (!OracleKeyStoreSpi.c((PKCS12Bag)aSN1Object) || !this.a(((PKCS12Bag)aSN1Object).getLocalKeyID(), byArray)) continue;
            vector.removeElementAt(i3);
            break;
        }
        ((PKCS12Safe)aSN1Object2).setBags(vector);
        if (vector.size() > 0 && ((PKCS12)serializable).getAuthSafes().size() == 0) {
            ((PKCS12)serializable).addAuthSafe((PKCS12Safe)aSN1Object2);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)serializable).getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + ((PKCS12)serializable).length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((PKCS12)serializable).length());
        ((PKCS12)serializable).output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] e(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ASN1Object aSN1Object;
        ASN1Object aSN1Object2;
        Object object;
        Object object2;
        Object object3;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object3) || !string.equals(object3)) continue;
            object2 = this.engineGetKey((String)object3, null);
            if (object2.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)object2).getCertificateRequest();
            } else {
                if (!object2.getAlgorithm().equals("EC")) continue;
                certificateRequest = ((OraclePKIECPrivateKey)object2).getCertificateRequest();
            }
            if (certificateRequest == null) continue;
            object = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object3);
            if (object != null) {
                throw new IOException(a.getString("PKI-04011"));
            }
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveCertReq: No cert request in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04009") + string);
        }
        object3 = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object3);
        object2 = ((ByteArrayOutputStream)object3).toByteArray();
        object = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object2 = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object2).getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object2 = pKCS12.getAuthSafes().elementAt(0);
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object2).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            byte[] byArray;
            boolean bl2;
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            if (!OracleKeyStoreSpi.b(pKCS12Bag) || !(bl2 = Arrays.equals((byte[])object2, byArray = ((ASN1OctetString)(aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            object = pKCS12Bag.getLocalKeyID();
            vector.removeElementAt(i2);
            break;
        }
        byte[] byArray = oracle.security.pki.l.c(oracle.security.pki.l.j((byte[])object), oracle.security.pki.l.k((byte[])object));
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            aSN1Object = vector.elementAt(i3);
            if (!OracleKeyStoreSpi.c((PKCS12Bag)aSN1Object) || !this.a(((PKCS12Bag)aSN1Object).getLocalKeyID(), byArray)) continue;
            vector.removeElementAt(i3);
            break;
        }
        ((PKCS12Safe)aSN1Object2).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object2);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + pKCS12.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] f(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ASN1Object aSN1Object;
        ASN1Object aSN1Object2;
        Object object;
        Object object2;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object2) || !string.equals(object2)) continue;
            object = (OraclePKIRSAPrivateKey)this.engineGetKey((String)object2, null);
            certificateRequest = ((OraclePKIRSAPrivateKey)object).getCertificateRequest();
            if (!((OraclePKIRSAPrivateKey)object).isPvtKeyPresent()) {
                throw new IOException(a.getString("PKI-04009") + string);
            }
            if (certificateRequest == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemovePrivateKey: No cert request in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04009") + string);
        }
        object2 = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object2);
        object = ((ByteArrayOutputStream)object2).toByteArray();
        byte[] byArray = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object2 = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object2).getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object2 = pKCS12.getAuthSafes().elementAt(0);
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object2).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            byte[] byArray2;
            boolean bl2;
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            if (!OracleKeyStoreSpi.b(pKCS12Bag) || !(bl2 = Arrays.equals((byte[])object, byArray2 = ((ASN1OctetString)(aSN1Object = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            byArray = pKCS12Bag.getLocalKeyID();
            break;
        }
        byte[] byArray3 = oracle.security.pki.l.c(oracle.security.pki.l.j(byArray), oracle.security.pki.l.k(byArray));
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            aSN1Object = vector.elementAt(i3);
            if (!OracleKeyStoreSpi.c((PKCS12Bag)aSN1Object) || !this.a(((PKCS12Bag)aSN1Object).getLocalKeyID(), byArray3)) continue;
            vector.removeElementAt(i3);
            break;
        }
        ((PKCS12Safe)aSN1Object2).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object2);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + pKCS12.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    int g(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ASN1Object aSN1Object;
        Object object;
        Object object2;
        CertificateRequest certificateRequest = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object2) || !string.equals(object2)) continue;
            object = this.engineGetKey((String)object2, null);
            if (object.getAlgorithm().equals("RSA")) {
                certificateRequest = ((OraclePKIRSAPrivateKey)object).getCertificateRequest();
            } else if (object.getAlgorithm().equals("EC")) {
                certificateRequest = ((OraclePKIECPrivateKey)object).getCertificateRequest();
            }
            if (certificateRequest == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalGetCRCompNum: No cert request in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04009") + string);
        }
        object2 = new ByteArrayOutputStream();
        certificateRequest.output((OutputStream)object2);
        object = ((ByteArrayOutputStream)object2).toByteArray();
        byte[] byArray = null;
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object = pKCS12.getAuthSafes().elementAt(0);
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            ASN1Object aSN1Object2;
            byte[] byArray2;
            boolean bl2;
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            if (!OracleKeyStoreSpi.b(pKCS12Bag) || !(bl2 = Arrays.equals((byte[])object, byArray2 = ((ASN1OctetString)(aSN1Object2 = ((PKCS12SecretBag)pKCS12Bag).getSecretValue())).getValue()))) continue;
            byArray = pKCS12Bag.getLocalKeyID();
            return oracle.security.pki.l.k(byArray);
        }
        throw new IOException("Check wallet.");
    }

    byte[] b(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        Object object;
        Object object2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object2)) == null || !x500Name.equals(new X500Name((String)(object = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString())))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveUserCert: No user cert in wallet with matching DN.");
            throw new IOException(a.getString("PKI-04007") + ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString());
        }
        object2 = new PKCS12();
        ((PKCS12)object2).setPassword(new String(cArray));
        if (inputStream != null) {
            object = new PKCS12(new String(cArray), inputStream);
            ((PKCS12)object2).setAuthSafes(((PKCS12)object).getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        object = ((PKCS12)object2).getAuthSafes().elementAt(0);
        Vector<PKCS12Bag> vector = ((PKCS12Safe)object).getBags();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.l.b(pKCS12Bag.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals(x509)) continue;
                vector2.addElement(pKCS12Bag);
                continue;
            }
            vector2.addElement(pKCS12Bag);
        }
        ((PKCS12Safe)object).setBags(vector2);
        if (vector2.size() > 0 && ((PKCS12)object2).getAuthSafes().size() == 0) {
            ((PKCS12)object2).addAuthSafe((PKCS12Safe)object);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object2).getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + ((PKCS12)object2).length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((PKCS12)object2).length());
        ((PKCS12)object2).output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] h(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        ASN1Object aSN1Object;
        Object object;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object)) == null || !string.equals(object)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveUserCert: No user cert in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04010") + string);
        }
        object = new PKCS12();
        ((PKCS12)object).setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            ((PKCS12)object).setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object = ((PKCS12)object).getAuthSafes().elementAt(0);
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object).getBags();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.l.b(pKCS12Bag.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals(x509)) continue;
                vector2.addElement(pKCS12Bag);
                continue;
            }
            vector2.addElement(pKCS12Bag);
        }
        ((PKCS12Safe)aSN1Object).setBags(vector2);
        if (vector2.size() > 0 && ((PKCS12)object).getAuthSafes().size() == 0) {
            ((PKCS12)object).addAuthSafe((PKCS12Safe)aSN1Object);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object).getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + ((PKCS12)object).length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((PKCS12)object).length());
        ((PKCS12)object).output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] b(InputStream inputStream, char[] cArray) throws IOException, KeyStoreException, CertificateEncodingException {
        Serializable serializable;
        Object object;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry((String)object) || (serializable = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object)) == null || !this.a((OraclePKIX509CertImpl)serializable)) continue;
            OraclePKIDebug.a("Trusted cert is used in cert chain.");
            throw new IOException(a.getString("PKI-04015") + " " + ((Object)((OraclePKIX509CertImpl)serializable).getSubjectDN()).toString());
        }
        object = new PKCS12();
        ((PKCS12)object).setPassword(new String(cArray));
        if (inputStream != null) {
            serializable = new PKCS12(new String(cArray), inputStream);
            ((PKCS12)object).setAuthSafes(((PKCS12)serializable).getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        serializable = ((PKCS12)object).getAuthSafes().elementAt(0);
        Vector<PKCS12Bag> vector = ((PKCS12Safe)serializable).getBags();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.l.c(pKCS12Bag.getLocalKeyID())) continue;
            vector2.addElement(pKCS12Bag);
        }
        ((PKCS12Safe)serializable).setBags(vector2);
        if (vector2.size() > 0 && ((PKCS12)object).getAuthSafes().size() == 0) {
            ((PKCS12)object).addAuthSafe((PKCS12Safe)serializable);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object).getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + ((PKCS12)object).length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((PKCS12)object).length());
        ((PKCS12)object).output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    boolean a(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2)) == null || !x500Name.equals(new X500Name(string = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString()))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalIsTrustedCertUsedInChain: No trusted cert in wallet with matching DN.");
            return false;
        }
        return this.a(oraclePKIX509CertImpl);
    }

    boolean a(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry(string2)) continue;
            oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate(string2);
            if (!string.equals(string2) || oraclePKIX509CertImpl == null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalIsTrustedCertUsedInChain: No trusted cert in wallet with matching alias.");
            return false;
        }
        return this.a(oraclePKIX509CertImpl);
    }

    int i(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        ASN1Object aSN1Object;
        Object object;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.engineIsKeyEntry((String)object) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object)) == null || !string.equals(object)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalGetCertCompNum: No user cert in wallet with matching alias.");
            throw new IOException(a.getString("PKI-04010") + string);
        }
        object = new PKCS12();
        ((PKCS12)object).setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            ((PKCS12)object).setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object = ((PKCS12)object).getAuthSafes().elementAt(0);
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object).getBags();
        Vector vector2 = new Vector(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || !oracle.security.pki.l.b(pKCS12Bag.getLocalKeyID())) continue;
            X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
            X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
            if (!x5092.equals(x509)) continue;
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            return oracle.security.pki.l.k(byArray);
        }
        return 0;
    }

    int j(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        ASN1Object aSN1Object;
        Object object;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry((String)object) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object)) == null || !string.equals(object)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalGetTCertCompNum: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        object = new PKCS12();
        ((PKCS12)object).setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            ((PKCS12)object).setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object = ((PKCS12)object).getAuthSafes().elementAt(0);
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object).getBags();
        Vector vector2 = new Vector(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        boolean bl2 = false;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            if (!OracleKeyStoreSpi.a(pKCS12Bag) || !oracle.security.pki.l.c(pKCS12Bag.getLocalKeyID())) continue;
            X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
            X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
            if (!x5092.equals(x509)) continue;
            byte[] byArray = pKCS12Bag.getLocalKeyID();
            return oracle.security.pki.l.k(byArray);
        }
        return 0;
    }

    byte[] c(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        Object object;
        Object object2;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry((String)object2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object2)) == null || !x500Name.equals(new X500Name((String)(object = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString())))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveTrustedCert: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        if (this.a(oraclePKIX509CertImpl)) {
            OraclePKIDebug.a("internalRemoveTrustedCert: Trusted cert is used in cert chain.");
            throw new IOException(a.getString("PKI-04015"));
        }
        object2 = new PKCS12();
        ((PKCS12)object2).setPassword(new String(cArray));
        if (inputStream != null) {
            object = new PKCS12(new String(cArray), inputStream);
            ((PKCS12)object2).setAuthSafes(((PKCS12)object).getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        object = ((PKCS12)object2).getAuthSafes().elementAt(0);
        Vector<PKCS12Bag> vector = ((PKCS12Safe)object).getBags();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n2 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.l.c(pKCS12Bag.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals(x509)) continue;
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)object, x509);
                pKCS12CertBag.setLocalKeyID(oracle.security.pki.l.b(0, n2));
                String string = pKCS12Bag.getFriendlyName();
                if (string != null) {
                    pKCS12CertBag.setFriendlyName(string);
                }
                vector2.addElement(pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                ++n2;
                continue;
            }
            vector2.addElement(pKCS12Bag);
        }
        ((PKCS12Safe)object).setBags(vector2);
        if (vector2.size() > 0 && ((PKCS12)object2).getAuthSafes().size() == 0) {
            ((PKCS12)object2).addAuthSafe((PKCS12Safe)object);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object2).getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + ((PKCS12)object2).length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((PKCS12)object2).length());
        ((PKCS12)object2).output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] k(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        ASN1Object aSN1Object;
        Object object;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        boolean bl = false;
        Enumeration enumeration = this.engineAliases();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.engineIsCertificateEntry((String)object) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)this.engineGetCertificate((String)object)) == null || !string.equals(object)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("internalRemoveTrustedCert: No trusted cert in wallet with matching DN.");
            throw new IOException("No trusted cert in wallet with matching DN.");
        }
        if (this.a(oraclePKIX509CertImpl)) {
            OraclePKIDebug.a("internalRemoveTrustedCert: Trusted cert is used in cert chain.");
            throw new IOException(a.getString("PKI-04015"));
        }
        object = new PKCS12();
        ((PKCS12)object).setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            ((PKCS12)object).setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
        aSN1Object = ((PKCS12)object).getAuthSafes().elementAt(0);
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object).getBags();
        Vector<PKCS12Bag> vector2 = new Vector<PKCS12Bag>(vector.size());
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n2 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            if (OracleKeyStoreSpi.a(pKCS12Bag) && oracle.security.pki.l.c(pKCS12Bag.getLocalKeyID())) {
                X509 x509 = ((PKCS12CertBag)pKCS12Bag).getCert();
                X509 x5092 = new X509(oraclePKIX509CertImpl.getEncoded());
                if (x5092.equals(x509)) continue;
                PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, x509);
                pKCS12CertBag.setLocalKeyID(oracle.security.pki.l.b(0, n2));
                String string2 = pKCS12Bag.getFriendlyName();
                if (string2 != null) {
                    pKCS12CertBag.setFriendlyName(string2);
                }
                vector2.addElement(pKCS12CertBag);
                OraclePKIDebug.a("OracleWallet: added cert bag " + n2);
                ++n2;
                continue;
            }
            vector2.addElement(pKCS12Bag);
        }
        ((PKCS12Safe)aSN1Object).setBags(vector2);
        if (vector2.size() > 0 && ((PKCS12)object).getAuthSafes().size() == 0) {
            ((PKCS12)object).addAuthSafe((PKCS12Safe)aSN1Object);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + ((PKCS12)object).getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + ((PKCS12)object).length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(((PKCS12)object).length());
        ((PKCS12)object).output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] b(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string) throws IOException, KeyStoreException {
        int n2;
        Object object;
        Object object2;
        Object object3;
        ASN1Object aSN1Object;
        ((ByteArrayInputStream)inputStream).mark(((ByteArrayInputStream)inputStream).available());
        byte[] byArray = this.b(inputStream, cArray, oraclePKIX509CertImpl);
        ((ByteArrayInputStream)inputStream).reset();
        if (byArray == null && this.getP11Lib() != null) {
            byArray = this.a(inputStream, cArray, oraclePKIX509CertImpl);
        }
        ((ByteArrayInputStream)inputStream).reset();
        PKCS12 pKCS12 = new PKCS12();
        pKCS12.setPassword(new String(cArray));
        if (inputStream != null) {
            aSN1Object = new PKCS12(new String(cArray), inputStream);
            pKCS12.setAuthSafes(((PKCS12)aSN1Object).getAuthSafes());
        }
        aSN1Object = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            aSN1Object = new PKCS12Safe(pKCS12);
            ((PKCS12Safe)aSN1Object).setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            aSN1Object = pKCS12.getAuthSafes().elementAt(0);
        }
        Vector<PKCS12Bag> vector = ((PKCS12Safe)aSN1Object).getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        int n3 = 0;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            object3 = vector.elementAt(i2);
            if (!OracleKeyStoreSpi.a((PKCS12Bag)object3) || !oracle.security.pki.l.b(((PKCS12Bag)object3).getLocalKeyID())) continue;
            OraclePKIDebug.a("OracleKeyStoreSpi: found cert bag");
            ++n3;
        }
        PKCS12CertBag pKCS12CertBag = new PKCS12CertBag((PKCS12Safe)aSN1Object, oraclePKIX509CertImpl.getX509());
        pKCS12CertBag.setLocalKeyID(byArray);
        object3 = oraclePKIX509CertImpl.getPublicKey().getAlgorithm();
        RSA rSA = new RSA();
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = BigInteger.TEN;
        KeyPair keyPair = null;
        byte[] byArray2 = null;
        if (((String)object3).equals("RSA")) {
            object2 = new RSAPublicKey(oraclePKIX509CertImpl.getPublicKey().getEncoded());
            rSA.setKey((RSAKey)object2);
            bigInteger = rSA.performOp(bigInteger3);
        } else if (((String)object3).equals("EC")) {
            try {
                object2 = KeyPairGenerator.getInstance("ECDH");
                ((KeyPairGenerator)object2).initialize(((ECPublicKey)oraclePKIX509CertImpl.getPublicKey()).getParams());
                keyPair = ((KeyPairGenerator)object2).generateKeyPair();
                object = KeyAgreement.getInstance("ECDH");
                ((KeyAgreement)object).init(keyPair.getPrivate());
                ((KeyAgreement)object).doPhase((ECPublicKey)oraclePKIX509CertImpl.getPublicKey(), true);
                byArray2 = ((KeyAgreement)object).generateSecret();
            }
            catch (GeneralSecurityException generalSecurityException) {
                generalSecurityException.printStackTrace();
            }
        }
        if (string != null) {
            n2 = 0;
            for (int i3 = 0; i3 < vector.size(); ++i3) {
                PKCS12Bag pKCS12Bag = vector.elementAt(i3);
                if (pKCS12Bag.getFriendlyName() == null || !pKCS12Bag.getFriendlyName().equals(string)) continue;
                oracle.security.crypto.core.PrivateKey privateKey = null;
                if (pKCS12Bag instanceof PKCS12KeyBag) {
                    privateKey = ((PKCS12KeyBag)pKCS12Bag).getPrivateKey();
                } else {
                    if (!(pKCS12Bag instanceof PKCS12ShroudedKeyBag)) continue;
                    privateKey = ((PKCS12ShroudedKeyBag)pKCS12Bag).getPrivateKey();
                }
                String string2 = privateKey.getAlgorithm();
                if (!string2.equals(object3)) continue;
                if (string2.equals("RSA")) {
                    rSA.setKey((RSAPrivateKey)privateKey);
                    bigInteger2 = rSA.performOp(bigInteger);
                    if (!bigInteger2.equals(bigInteger3)) continue;
                    n2 = 1;
                    break;
                }
                if (!string2.equals("EC")) continue;
                try {
                    KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
                    keyAgreement.init((ECPrivateKey)((Object)privateKey));
                    keyAgreement.doPhase(keyPair.getPublic(), true);
                    if (!Arrays.equals(byArray2, keyAgreement.generateSecret())) continue;
                    n2 = 1;
                    break;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    // empty catch block
                }
            }
            if (n2 == 0) {
                throw new IOException(a.getString("PKI-04009") + string);
            }
        } else {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                object = vector.elementAt(n2);
                oracle.security.crypto.core.PrivateKey privateKey = null;
                if (object instanceof PKCS12KeyBag) {
                    privateKey = ((PKCS12KeyBag)object).getPrivateKey();
                } else {
                    if (!(object instanceof PKCS12ShroudedKeyBag)) continue;
                    privateKey = ((PKCS12ShroudedKeyBag)object).getPrivateKey();
                }
                String string3 = privateKey.getAlgorithm();
                if (!string3.equals(object3)) continue;
                if (string3.equals("RSA")) {
                    rSA.setKey((RSAPrivateKey)privateKey);
                    bigInteger2 = rSA.performOp(bigInteger);
                    if (!bigInteger2.equals(bigInteger3)) continue;
                    string = ((PKCS12Bag)object).getFriendlyName();
                    break;
                }
                if (!string3.equals("EC")) continue;
                try {
                    KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
                    keyAgreement.init((ECPrivateKey)((Object)privateKey));
                    keyAgreement.doPhase(keyPair.getPublic(), true);
                    if (!Arrays.equals(byArray2, keyAgreement.generateSecret())) continue;
                    string = ((PKCS12Bag)object).getFriendlyName();
                    break;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    // empty catch block
                }
            }
        }
        if (string != null) {
            pKCS12CertBag.setFriendlyName(string.toLowerCase());
        }
        vector.addElement(pKCS12CertBag);
        OraclePKIDebug.a("OracleWallet: added key bag " + n3);
        ((PKCS12Safe)aSN1Object).setBags(vector);
        if (vector.size() > 0 && pKCS12.getAuthSafes().size() == 0) {
            pKCS12.addAuthSafe((PKCS12Safe)aSN1Object);
        }
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet has " + pKCS12.getAuthSafes().size() + " safes");
        OraclePKIDebug.a("OracleKeyStoreSpi: wallet size " + pKCS12.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        byte[] byArray = null;
        int n2 = -1;
        try {
            int n3 = NZNative.Pkcs11HasMatchingPvtKey(this.getP11Lib(), this.getP11TokenLabel(), this.getP11TokenPassphrase(), oraclePKIX509CertImpl.getEncoded());
            if (n3 != 0) {
                OraclePKIDebug.a("OracleKeyStoreSpi: No matching private key for cert in HSM");
                throw new IOException(a.getString("PKI-04006"));
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            IOException iOException = new IOException();
            iOException.initCause(certificateEncodingException);
            throw iOException;
        }
        Set set = this.c.entrySet();
        for (Map.Entry entry : set) {
            if (!((h)entry.getValue() instanceof i)) continue;
            i i2 = (i)entry.getValue();
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)i2.a();
            CertificateRequest certificateRequest = oraclePKIRSAPrivateKey.getCertificateRequest();
            q q2 = (q)oraclePKIX509CertImpl.getPublicKey();
            if (oraclePKIRSAPrivateKey.isPvtKeyPresent() || certificateRequest == null || !this.a(q2, certificateRequest)) continue;
            n2 = ((i)entry.getValue()).i();
            if (((i)entry.getValue()).b() != null) {
                throw new IOException(a.getString("PKI-04004"));
            }
            PKCS12 pKCS12 = new PKCS12(new String(cArray), inputStream);
            Vector vector = OracleKeyStoreSpi.e(pKCS12);
            Vector<OraclePKIX509CertImpl> vector2 = new Vector<OraclePKIX509CertImpl>(vector.size());
            vector2.addElement(oraclePKIX509CertImpl);
            X509Certificate x509Certificate = (X509Certificate)vector2.lastElement();
            while (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i3);
                    if (!((Object)x509Certificate.getIssuerDN()).equals(pKCS12CertBag.getCert().getSubject())) continue;
                    bl = true;
                    vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
                    x509Certificate = (X509Certificate)vector2.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: Cert chain incomplete for cert ");
                throw new IOException(a.getString("PKI-04012"));
            }
            OraclePKIDebug.a("OracleKeyStoreSpi: Cert chain determined");
            break;
        }
        if (n2 == -1) {
            OraclePKIDebug.a("OracleKeyStoreSpi: Could not generate localkeyID");
            throw new IOException("OracleKeyStoreSpi: Could not generate localkeyID");
        }
        byArray = oracle.security.pki.l.e(0, n2);
        return byArray;
    }

    byte[] b(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        byte[] byArray = null;
        Set set = this.c.entrySet();
        for (Map.Entry entry : set) {
            if (!((h)entry.getValue() instanceof i)) continue;
            PrivateKey privateKey = null;
            PublicKey publicKey = null;
            if (oraclePKIX509CertImpl.getPublicKey().getAlgorithm().equals("RSA")) {
                if (((h)entry.getValue()).a() instanceof OraclePKIECPrivateKey) continue;
                privateKey = (OraclePKIRSAPrivateKey)((h)entry.getValue()).a();
                publicKey = (q)oraclePKIX509CertImpl.getPublicKey();
                if (!((OraclePKIRSAPrivateKey)privateKey).isPvtKeyPresent() || !this.a((q)publicKey, (OraclePKIRSAPrivateKey)privateKey)) continue;
                if (((OraclePKIRSAPrivateKey)privateKey).getCertificateRequest() == null) {
                    throw new IOException(a.getString("PKI-04005"));
                }
            } else if (oraclePKIX509CertImpl.getPublicKey().getAlgorithm().equals("EC")) {
                if (((h)entry.getValue()).a() instanceof OraclePKIRSAPrivateKey) continue;
                privateKey = (OraclePKIECPrivateKey)((h)entry.getValue()).a();
                publicKey = (n)oraclePKIX509CertImpl.getPublicKey();
                if (!((OraclePKIECPrivateKey)privateKey).isPvtKeyPresent() || !this.a((n)publicKey, (OraclePKIECPrivateKey)privateKey)) continue;
                if (((OraclePKIECPrivateKey)privateKey).getCertificateRequest() == null) {
                    throw new IOException(a.getString("PKI-04005"));
                }
            }
            byArray = ((i)entry.getValue()).h();
            if (((i)entry.getValue()).b() != null) {
                throw new IOException(a.getString("PKI-04004"));
            }
            PKCS12 pKCS12 = new PKCS12(new String(cArray), inputStream);
            Vector vector = OracleKeyStoreSpi.e(pKCS12);
            Vector<OraclePKIX509CertImpl> vector2 = new Vector<OraclePKIX509CertImpl>(vector.size());
            vector2.addElement(oraclePKIX509CertImpl);
            X509Certificate x509Certificate = (X509Certificate)vector2.lastElement();
            while (!((Object)x509Certificate.getIssuerDN()).equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i2 = 0; i2 < vector.size(); ++i2) {
                    PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i2);
                    if (!((Object)x509Certificate.getIssuerDN()).equals(pKCS12CertBag.getCert().getSubject())) continue;
                    bl = true;
                    vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.getCert()));
                    x509Certificate = (X509Certificate)vector2.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.a("OracleKeyStoreSpi: Cert chain incomplete for cert ");
                throw new IOException(a.getString("PKI-04012"));
            }
            OraclePKIDebug.a("OracleKeyStoreSpi: Cert chain determined");
            break;
        }
        if (byArray == null) {
            OraclePKIDebug.a("OracleKeyStoreSpi: No matching private key for cert in wallet");
            if (this.getP11Lib() == null) {
                throw new IOException(a.getString("PKI-04006"));
            }
        }
        return byArray;
    }

    boolean a(q q2, CertificateRequest certificateRequest) {
        boolean bl = false;
        BigInteger bigInteger = q2.getPublicExponent();
        BigInteger bigInteger2 = q2.getModulus();
        BigInteger bigInteger3 = ((RSAPublicKey)certificateRequest.getPublicKey()).getExponent();
        BigInteger bigInteger4 = ((RSAPublicKey)certificateRequest.getPublicKey()).getModulus();
        if (bigInteger.equals(bigInteger3) && bigInteger2.equals(bigInteger4)) {
            bl = true;
        }
        return bl;
    }

    boolean a(q q2, OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey) {
        boolean bl = false;
        BigInteger bigInteger = oraclePKIRSAPrivateKey.getPublicExponent();
        BigInteger bigInteger2 = oraclePKIRSAPrivateKey.getModulus();
        if (bigInteger.equals(q2.getPublicExponent()) && bigInteger2.equals(q2.getModulus())) {
            bl = true;
        }
        return bl;
    }

    boolean a(n n2, OraclePKIECPrivateKey oraclePKIECPrivateKey) {
        try {
            byte[] byArray = "abcxyz".getBytes();
            Signature signature = Signature.getInstance("SHA1/ECDSA");
            signature.initSign(oraclePKIECPrivateKey);
            signature.update(byArray, 0, byArray.length);
            byte[] byArray2 = signature.sign();
            Signature signature2 = Signature.getInstance("SHA1/ECDSA");
            signature2.initVerify(n2);
            signature2.update(byArray, 0, byArray.length);
            return signature2.verify(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    boolean a(OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        boolean bl = false;
        Set set = this.c.entrySet();
        Iterator iterator = set.iterator();
        block0: while (iterator.hasNext() && !bl) {
            Certificate[] certificateArray;
            Map.Entry entry = iterator.next();
            if (!((h)entry.getValue() instanceof i) || (certificateArray = ((i)entry.getValue()).c()) == null) continue;
            for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                if (!oraclePKIX509CertImpl.equals(certificateArray[i2])) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    boolean b(OraclePKIX509CertImpl oraclePKIX509CertImpl) throws IOException {
        boolean bl = false;
        Set set = this.c.entrySet();
        for (Map.Entry entry : set) {
            Object object;
            Serializable serializable;
            if (!((h)entry.getValue() instanceof j)) continue;
            X509Certificate x509Certificate = (X509Certificate)((h)entry.getValue()).b();
            X509 x509 = null;
            try {
                x509 = new X509(x509Certificate.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                serializable = new IOException("Cert getEncoded failed.");
                ((Throwable)serializable).initCause(certificateEncodingException);
                throw serializable;
            }
            oracle.security.crypto.core.PublicKey publicKey = x509.getPublicKey();
            serializable = oraclePKIX509CertImpl.getPublicKey();
            if (!publicKey.getAlgorithm().equals(serializable.getAlgorithm())) continue;
            if (publicKey.getAlgorithm().equals("EC")) {
                object = ((ECPublicKey)((Object)publicKey)).getW();
                if (!((ECPoint)object).equals(((n)serializable).getW())) continue;
                bl = true;
                break;
            }
            if (!publicKey.getAlgorithm().equals("RSA")) continue;
            object = ((RSAPublicKey)publicKey).getExponent();
            BigInteger bigInteger = ((RSAPublicKey)publicKey).getModulus();
            if (!((BigInteger)object).equals(((q)serializable).getPublicExponent()) || !bigInteger.equals(((q)serializable).getModulus())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null | byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    private boolean a(PKCS12 pKCS12, int n2) throws IOException {
        boolean bl = false;
        PKCS12Safe pKCS12Safe = null;
        if (pKCS12.getAuthSafes().size() == 0) {
            OraclePKIDebug.a("OracleKeyStoreSpi: creating new key store");
            pKCS12Safe = new PKCS12Safe(pKCS12);
            pKCS12Safe.setMode(3);
        } else {
            OraclePKIDebug.a("OracleKeyStoreSpi: using safe 0");
            pKCS12Safe = pKCS12.getAuthSafes().elementAt(0);
        }
        Vector<PKCS12Bag> vector = pKCS12Safe.getBags();
        OraclePKIDebug.a("OracleKeyStoreSpi: safe has " + vector.size() + " bags");
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            byte[] byArray;
            int n3;
            PKCS12Bag pKCS12Bag = vector.elementAt(i2);
            if (!OracleKeyStoreSpi.c(pKCS12Bag) || (n3 = oracle.security.pki.l.k(byArray = pKCS12Bag.getLocalKeyID())) != n2) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

