/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Random;
import oracle.security.pki.BadPaddingException;
import oracle.security.pki.CipherSpi;
import oracle.security.pki.IllegalBlockSizeException;
import oracle.security.pki.NoSuchPaddingException;
import oracle.security.pki.PBEwSHA1aDESedecbc;
import oracle.security.pki.ShortBufferException;
import oracle.security.pki.d;
import oracle.security.pki.e;
import oracle.security.pki.u;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int PRIVATE_KEY = 3;
    public static final int PUBLIC_KEY = 4;
    public static final int SECRET_KEY = 5;
    public static final int UNWRAP_MODE = 6;
    public static final int WRAP_MODE = 7;
    private static final String a = "Oracle";
    private final CipherSpi b;
    private boolean c = false;
    private String d;

    protected Cipher(CipherSpi cipherSpi, String string) {
        this.b = cipherSpi;
        this.d = string;
    }

    public String toString() {
        return "Cipher object:" + this.d;
    }

    public String getAlgorithm() {
        return this.d;
    }

    public String getProvider() {
        return a;
    }

    public static Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            return Cipher.getInstance(string, a);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("Algorithm not found. [Cipher." + string + "]");
        }
    }

    public static Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        CipherSpi cipherSpi = Cipher.a(string);
        if (cipherSpi != null) {
            return new Cipher(cipherSpi, string);
        }
        throw new NoSuchAlgorithmException("Unknown algorithm");
    }

    public final Key unwrap(byte[] byArray, String string, int n2) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        return this.b.a(byArray, string, n2);
    }

    public final byte[] wrap(Key key) throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
        return this.b.a(key);
    }

    public final int getBlockSize() {
        return this.b.b();
    }

    public final int getOutputSize(int n2) throws IllegalStateException {
        if (!this.c) {
            throw new IllegalStateException("Object has not been initialized");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Input size must be >= 0");
        }
        return this.b.a(n2);
    }

    public final byte[] getIV() {
        return this.b.c();
    }

    public final AlgorithmParameters getParameters() {
        return this.b.d();
    }

    public final void init(int n2, Key key) throws InvalidKeyException {
        this.b.a(n2, key, new Random());
        this.c = true;
    }

    public final void init(int n2, Key key, Random random) throws InvalidKeyException {
        this.b.a(n2, key, random);
        this.c = true;
    }

    public final void init(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.b.a(n2, key, algorithmParameterSpec, new Random());
        this.c = true;
    }

    public final void init(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.b.a(n2, key, algorithmParameterSpec, random);
        this.c = true;
    }

    public final void init(int n2, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.b.a(n2, key, algorithmParameters, new Random());
        this.c = true;
    }

    public final void init(int n2, Key key, AlgorithmParameters algorithmParameters, Random random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.b.a(n2, key, algorithmParameters, random);
        this.c = true;
    }

    public final void init(int n2, Certificate certificate) throws InvalidKeyException {
        this.init(n2, certificate, new Random());
        this.c = true;
    }

    public final void init(int n2, Certificate certificate, Random random) throws InvalidKeyException {
        boolean[] blArray;
        if (certificate instanceof X509Certificate && (blArray = ((X509Certificate)certificate).getKeyUsage()) != null) {
            if (blArray[7] && n2 == 2) {
                throw new InvalidKeyException("Certificate key usage is encipherOnly");
            }
            if (blArray[8] && n2 == 1) {
                throw new InvalidKeyException("Certificate key usage is decipherOnly");
            }
        }
        this.b.a(n2, certificate.getPublicKey(), random);
        this.c = true;
    }

    public final byte[] update(byte[] byArray) throws IllegalStateException {
        if (!this.c) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this.b.a(byArray, 0, byArray.length);
    }

    public final byte[] update(byte[] byArray, int n2, int n3) throws IllegalStateException {
        if (!this.c) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this.b.a(byArray, n2, n3);
    }

    public final int update(byte[] byArray, int n2, int n3, byte[] byArray2) throws IllegalStateException, ShortBufferException {
        if (!this.c) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this.b.a(byArray, n2, n3, byArray2, 0);
    }

    public final int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, ShortBufferException {
        if (!this.c) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this.b.a(byArray, n2, n3, byArray2, n4);
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.c) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this.b.b(null, 0, 0);
    }

    public final int doFinal(byte[] byArray, int n2) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (!this.c) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this.b.b(null, 0, 0, byArray, n2);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.c) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this.b.b(byArray, 0, byArray.length);
    }

    public final byte[] doFinal(byte[] byArray, int n2, int n3) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.c) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this.b.b(byArray, n2, n3);
    }

    public final int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.c) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this.b.b(byArray, n2, n3, byArray2, 0);
    }

    public final int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.c) {
            throw new IllegalStateException("Cipher has not been initialized.");
        }
        return this.b.b(byArray, n2, n3, byArray2, n4);
    }

    private static CipherSpi a(String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        CipherSpi cipherSpi = (CipherSpi)Cipher.b(string);
        if (cipherSpi == null) {
            throw new NoSuchAlgorithmException("Only DES, DESede, PBE are supported");
        }
        int n2 = string.indexOf(47);
        int n3 = string.indexOf(47, n2 + 1);
        if (n2 == -1) {
            return cipherSpi;
        }
        if (n3 == -1) {
            throw new NoSuchAlgorithmException(string + "is not supported");
        }
        try {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1, n3);
            String string4 = string.substring(n3 + 1);
            cipherSpi.a(string3);
            cipherSpi.b(string4);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException("Unknown padding from " + string);
        }
        return cipherSpi;
    }

    private static Object b(String string) {
        if (string.startsWith("PBEwSH") || string.startsWith("hash")) {
            return new PBEwSHA1aDESedecbc();
        }
        if (string.startsWith("PBE")) {
            return new u();
        }
        if (string.startsWith("DESede") || string.startsWith("TripleDES") || string.startsWith("3DES")) {
            return new e();
        }
        if (string.startsWith("DES")) {
            return new d();
        }
        return null;
    }
}

