/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.util.List;
import oracle.ideimpl.deferredupdate.Directories;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.BundleDetails;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.deferredupdate.task.TaskStack;
import oracle.ideimpl.deferredupdate.task.TaskUtil;

class UpdateBundlesInfoTask
extends AtomicTask {
    private List<BundleDetails> _bundles;
    private File _bundlesInfoFile;
    private boolean _remove;
    private Directories _directories;
    private TaskStack _tasks;

    UpdateBundlesInfoTask(List<BundleDetails> bundles, boolean remove) {
        this._bundles = bundles;
        this._remove = remove;
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        this._directories = tc.getDirectories();
        this._tasks = new TaskStack();
        if (this._remove) {
            this.removeBundles(tc);
        } else {
            this.addBundles(tc);
        }
    }

    private void addBundles(TaskContext tc) throws TaskFailedException {
        this._bundlesInfoFile = TaskUtil.findCFUBundlesInfoFile(tc);
        if (this._bundlesInfoFile != null) {
            this.appendNewBundles();
        }
    }

    private void removeBundles(TaskContext tc) throws TaskFailedException {
        this._bundlesInfoFile = TaskUtil.findCFUBundlesInfoFile(tc);
        if (this._bundlesInfoFile != null) {
            this.removeOldBundles();
        }
    }

    private void appendNewBundles() throws TaskFailedException {
        List<String> bundlesInfoContent = this.readBundlesInfoFile();
        StringBuilder infoBuffer = new StringBuilder();
        this.removeBundleLines(bundlesInfoContent);
        for (BundleDetails bundleDetails : this._bundles) {
            String oracleHome;
            File configurationFileSource;
            File bundleFile = bundleDetails.getBundleFile();
            String relativePath = this.getRelativePath(bundleFile, configurationFileSource = new File((oracleHome = this._directories.getOracleHome()) + File.separator + "configuration" + File.separator + "bundles.info"));
            if (relativePath == null) continue;
            infoBuffer.setLength(0);
            infoBuffer.append(bundleDetails.getBundleSymbolicName());
            infoBuffer.append(',');
            infoBuffer.append(bundleDetails.getBundleVersion());
            infoBuffer.append(',');
            infoBuffer.append(relativePath);
            infoBuffer.append(",4,false");
            bundlesInfoContent.add(infoBuffer.toString());
        }
        this.writeBundlesInfoFile(bundlesInfoContent);
    }

    private void removeOldBundles() throws TaskFailedException {
        List<String> bundlesInfoContent = this.readBundlesInfoFile();
        if (this.removeBundleLines(bundlesInfoContent)) {
            this.writeBundlesInfoFile(bundlesInfoContent);
        }
    }

    private boolean removeBundleLines(List<String> bundleLines) {
        boolean removedLine = false;
        block0: for (BundleDetails bundleDetails : this._bundles) {
            String lineBegin = bundleDetails.getBundleSymbolicName() + ",";
            for (int x = 0; x < bundleLines.size(); ++x) {
                String line = bundleLines.get(x);
                if (!line.startsWith(lineBegin)) continue;
                bundleLines.remove(x);
                removedLine = true;
                continue block0;
            }
        }
        return removedLine;
    }

    private void writeBundlesInfoFile(List<String> lines) throws TaskFailedException {
        TaskUtil.writeFile(lines, this._bundlesInfoFile);
    }

    private List<String> readBundlesInfoFile() throws TaskFailedException {
        return TaskUtil.readFile(this._bundlesInfoFile);
    }

    private String getRelativePath(File bundleFile, File bundlesInfoFile) {
        StringBuilder buf = new StringBuilder();
        String bundleFilePath = bundleFile.getPath().replace('\\', '/');
        String bundlesInfoFilePath = bundlesInfoFile.getPath().replace('\\', '/');
        String[] bundleFilePathPieces = bundleFilePath.split("/");
        String[] bundlesInfoFilePathPieces = bundlesInfoFilePath.split("/");
        int bundleFileIndex = 0;
        int bundleFileLength = bundleFilePathPieces.length;
        int bundlesInfoFileLength = bundlesInfoFilePathPieces.length;
        for (int bundlesInfoFileIndex = 0; bundleFileIndex < bundleFileLength && bundlesInfoFileIndex < bundlesInfoFileLength; ++bundleFileIndex, ++bundlesInfoFileIndex) {
            if (bundleFilePathPieces[bundleFileIndex].equals(bundlesInfoFilePathPieces[bundlesInfoFileIndex])) continue;
            while (bundlesInfoFileIndex++ < bundlesInfoFileLength - 1) {
                buf.append("../");
            }
            while (bundleFileIndex < bundleFileLength - 1) {
                buf.append(bundleFilePathPieces[bundleFileIndex++]);
                buf.append('/');
            }
            buf.append(bundleFilePathPieces[bundleFileLength - 1]);
            return buf.toString();
        }
        return null;
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._tasks != null) {
            this._tasks.rollbackTasks(tc);
        }
    }
}

