/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate;

import java.io.File;
import java.io.FileReader;
import java.util.LinkedHashMap;
import java.util.List;
import oracle.ideimpl.deferredupdate.AbstractProgressMonitor;
import oracle.ideimpl.deferredupdate.Directories;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.deferredupdate.task.TaskList;
import oracle.ideimpl.deferredupdate.task.TaskUtil;

public class DeferredUpdater {
    private static final String DEFERRED_FILE = "jdeveloper-deferred-updates.txt";
    private LinkedHashMap<String, List<String>> properties;
    private Directories directories;
    private TaskList taskList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update() {
        block12: {
            File updateFile = null;
            try {
                updateFile = this.getDeferredUpdatesFile();
                if (updateFile == null) {
                    boolean bl = false;
                    return bl;
                }
                this.properties = TaskUtil.readProperties(updateFile);
                this.directories = new Directories(this.properties);
                TaskContext tc = new TaskContext(){

                    @Override
                    public Directories getDirectories() {
                        return DeferredUpdater.this.directories;
                    }

                    @Override
                    public boolean confirmOverwrite(File file) {
                        return true;
                    }
                };
                this.taskList = new TaskList(this.properties, tc);
                try {
                    System.out.println(UpdateArb.get("STANDALONE_CONSOLE_MSG"));
                    this.taskList.executeAll(tc, new AbstractProgressMonitor());
                    boolean bl = true;
                    return bl;
                }
                catch (TaskFailedException ex) {
                    try {
                        System.out.println(ex.getMessage());
                        if (ex.getCause() != null) {
                            System.out.println(ex.getCause().getMessage());
                        }
                        System.out.println(UpdateArb.get("INSTALL_FAIL_MESSAGE"));
                        if (updateFile == null) break block12;
                        updateFile.delete();
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                        System.out.println(UpdateArb.get("INSTALL_FAIL_MESSAGE"));
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (updateFile != null) {
                    updateFile.delete();
                }
            }
        }
        return false;
    }

    private String getTempDir() {
        String os = System.getProperty("os.name").toLowerCase();
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null) {
            return null;
        }
        if (os.indexOf("win") < 0) {
            tmpDir = tmpDir + File.separator + System.getProperty("user.name");
        }
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getDeferredUpdatesFile() throws TaskFailedException {
        String baseDir = this.getTempDir();
        if (baseDir == null) {
            return null;
        }
        File file = new File(baseDir, DEFERRED_FILE);
        if (!file.exists()) return null;
        FileReader reader = null;
        StringBuilder buf = new StringBuilder();
        char[] chars = new char[1024];
        try {
            try {
                reader = new FileReader(file);
                while (true) {
                    int len;
                    if ((len = reader.read(chars)) <= 0) {
                        File deferredUpdatesFile = new File(buf.toString());
                        if (!deferredUpdatesFile.exists()) return null;
                        File file2 = deferredUpdatesFile;
                        return file2;
                    }
                    buf.append(chars, 0, len);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                file.delete();
            }
        }
        catch (Exception ex) {
            throw new TaskFailedException(UpdateArb.format("READ_FAILED", file.getPath()));
        }
    }
}

