/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot.api;

import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import oracle.ide.osgi.boot.OracleIdeLauncher;
import oracle.ide.osgi.boot.SplashScreenImpl;
import oracle.ide.osgi.boot.SplashScreenProgressPlugin;

public final class SplashScreen {
    private static SplashScreen _instance = null;
    private static Object _instanceMonitor = new Object();
    private static SplashScreenImpl _splashScreen = null;
    private static JFrame _mainWindow = null;
    private static JFrame _hiddenWindow = null;
    private static boolean _initialized = false;
    private static AtomicBoolean _showing = new AtomicBoolean(false);

    private SplashScreen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SplashScreen createInstance(IHiddenWindowFactory hiddenWindowFactory) {
        Object object = _instanceMonitor;
        synchronized (object) {
            if (_instance != null) {
                throw new IllegalStateException("SplashScreen can only be initialized once.");
            }
            final IHiddenWindowFactory lhiddenWindowFactory = hiddenWindowFactory;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    _hiddenWindow = lhiddenWindowFactory.getHiddenWindow();
                    _splashScreen = new SplashScreenImpl(_hiddenWindow);
                }
            };
            SplashScreenImpl.SynchronizeWithEdt(runnable, "Problem creating splash screen on ETD.");
            _splashScreen.setLocationRelativeTo(null);
            _splashScreen.setWindowHook(true);
            _instance = new SplashScreen();
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SplashScreen getInstance() {
        Object object = _instanceMonitor;
        synchronized (object) {
            return _instance;
        }
    }

    public static JFrame getOwner() {
        JFrame result = null;
        if (_splashScreen != null) {
            result = _splashScreen.getOwner();
        }
        return result;
    }

    public static void setMainWindow(JFrame value) {
        _mainWindow = value;
        if (value != null && _splashScreen != null) {
            value.addWindowListener(new MainWindowListener(value));
        }
    }

    public static JFrame getMainWindow() {
        return _mainWindow;
    }

    public static void setHiddenWindow(JFrame value) {
        _hiddenWindow = value;
    }

    public static void destroyHiddenWindow() {
        if (_hiddenWindow != null) {
            _hiddenWindow.setVisible(false);
            _hiddenWindow.dispose();
            _hiddenWindow = null;
        }
    }

    public void display(boolean value) {
        final SplashScreenImpl splashScreen = this.getSplashScreenImpl();
        if (!_initialized && value) {
            _initialized = true;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (_hiddenWindow == null) {
                        throw new IllegalStateException("Hidden Window is null.");
                    }
                    _hiddenWindow.setVisible(true);
                    splashScreen.setVisible(true);
                    splashScreen.initializePlugins();
                    _showing = new AtomicBoolean(true);
                }
            };
            SplashScreenImpl.SynchronizeWithEdt(runnable, "Problem showing SplashScreen.");
        } else if (splashScreen != null) {
            splashScreen.display(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = _instanceMonitor;
        synchronized (object) {
            if (_splashScreen != null) {
                _splashScreen.display(false);
                _splashScreen.destroy();
                _splashScreen.dispose();
                _splashScreen = null;
                _instance = null;
            }
            _showing = new AtomicBoolean(false);
        }
    }

    public void readySplashScreenForMainWindow() {
        SplashScreenImpl splashScreen = this.getSplashScreenImpl();
        if (splashScreen != null) {
            splashScreen.setWindowHook(false);
        }
    }

    public void updateProgressTitle(String name, String title) {
        SplashScreenImpl.IProgress progress = this.findProgress(name);
        if (progress != null) {
            progress.setTitle(title);
        }
    }

    public void updateProgressDescription(String name, String description, int inc) {
        SplashScreenImpl.IProgress progress = this.findProgress(name);
        if (progress != null) {
            progress.setDescription(description);
            if (progress instanceof SplashScreenImpl.IDeterminateProgress) {
                SplashScreenImpl.IDeterminateProgress determinateProgress = (SplashScreenImpl.IDeterminateProgress)progress;
                determinateProgress.incrementProgress(inc);
            }
        }
    }

    public void updateProgress(String name, int inc) {
        SplashScreenImpl.IProgress progress = this.findProgress(name);
        if (progress != null && progress instanceof SplashScreenImpl.IDeterminateProgress) {
            SplashScreenImpl.IDeterminateProgress determinateProgress = (SplashScreenImpl.IDeterminateProgress)progress;
            determinateProgress.incrementProgress(inc);
        }
    }

    public void allocateIndeterminateProgress(String name, int percentage) {
        SplashScreenImpl.IProgressDialog progress = this.getPlugin();
        if (progress != null) {
            progress.allocateIndeterminateProgress(name, percentage);
        }
    }

    public void allocateDeterminateProgress(String name, int percentage) {
        SplashScreenImpl.IProgressDialog progress = this.getPlugin();
        if (progress != null) {
            progress.allocateDeterminateProgress(name, percentage);
        }
    }

    public void finalizeDeterminateProgress(String name, int count) {
        SplashScreenImpl.IProgressDialog progress = this.getPlugin();
        if (progress != null) {
            progress.finalizeDeterminateProgress(name, count);
        }
    }

    public void finalizeIndeterminateProgress(String name, int count, int timeout) {
        SplashScreenImpl.IProgressDialog progress = this.getPlugin();
        if (progress != null) {
            progress.finalizeIndeterminateProgress(name, count, timeout);
        }
    }

    public void completeProgress(String name) {
        SplashScreenImpl.IProgressDialog progress = this.getPlugin();
        if (progress != null) {
            progress.completeProgress(name);
        }
    }

    public boolean isShowing() {
        return _showing.get();
    }

    private SplashScreenImpl.IProgressDialog getPlugin() {
        SplashScreenImpl.IProgressDialog result = null;
        SplashScreenImpl splashScreen = this.getSplashScreenImpl();
        if (splashScreen != null) {
            SplashScreenImpl.ISplashScreenPlugin plugin = splashScreen.getPlugin();
            if (plugin instanceof SplashScreenImpl.IProgressDialog) {
                result = (SplashScreenImpl.IProgressDialog)((Object)plugin);
            }
            if (result == null) {
                result = SplashScreenProgressPlugin.createInstance(splashScreen);
            }
        }
        return result;
    }

    private SplashScreenImpl.IProgress findProgress(String name) {
        SplashScreenImpl.ISplashScreenPlugin plugin;
        SplashScreenImpl.IProgress result = null;
        SplashScreenImpl splashScreen = this.getSplashScreenImpl();
        if (splashScreen != null && (plugin = splashScreen.getPlugin()) != null && plugin instanceof SplashScreenImpl.IProgressDialog) {
            SplashScreenImpl.IProgressDialog progress = (SplashScreenImpl.IProgressDialog)((Object)plugin);
            result = progress.findProgress(name);
        }
        if (result == null) {
            Logger.getLogger("global").log(Level.WARNING, String.format("Error loading progress \"%s\"", name));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SplashScreenImpl getSplashScreenImpl() {
        SplashScreenImpl result = null;
        Object object = _instanceMonitor;
        synchronized (object) {
            result = _splashScreen;
        }
        return result;
    }

    public static interface IHiddenWindowFactory {
        public JFrame getHiddenWindow();
    }

    private static final class MainWindowListener
    implements WindowListener {
        private JFrame _mainWindow;

        public MainWindowListener(JFrame mainWindow) {
            this._mainWindow = mainWindow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowOpened(WindowEvent e) {
            this._mainWindow.removeWindowListener(this);
            Object object = _instanceMonitor;
            synchronized (object) {
                JFrame owner = _hiddenWindow;
                _hiddenWindow = null;
                owner.setVisible(false);
                SplashScreenImpl.ISplashScreenPlugin plugin = _splashScreen.getPlugin();
                SplashScreenImpl newSplashScreen = new SplashScreenImpl(this._mainWindow);
                Point location = _splashScreen.getLocation();
                newSplashScreen.setLocation(location);
                newSplashScreen.setPlugin(plugin);
                newSplashScreen.display(true);
                OracleIdeLauncher.disposeSplashScreen();
                _splashScreen.destroy();
                _splashScreen.dispose();
                _splashScreen = null;
                owner.dispose();
                owner = null;
                _splashScreen = newSplashScreen;
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

