/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.refactoring.CascadeWorker;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.db.validators.ValidationCancelledException;
import oracle.javatools.db.validators.ValidationContext;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public abstract class DBObjectValidator<T extends DBObject>
extends CascadeWorker<T>
implements oracle.javatools.db.DBObjectValidator<T> {
    private SortedMap<String, Method> m_propMap;

    protected DBObjectValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected void checkInterrupt() throws ValidationCancelledException {
        if (Thread.currentThread().isInterrupted()) {
            throw new ValidationCancelledException();
        }
    }

    protected void logException(DBException dbe, Level level) throws ValidationCancelledException {
        if (dbe instanceof CancelledException) {
            throw new ValidationCancelledException();
        }
        this.getLogger().log(level, dbe.getMessage());
    }

    @Override
    @Deprecated
    public final void validateObject(T object) throws ValidationException {
        this.validateObject(null, object);
    }

    @Override
    @Deprecated
    public final void validateObjectProperty(T object, String property) throws ValidationException {
        this.validateObjectProperty(null, object, property);
    }

    private boolean isTemporaryCopy(T original, T updated) {
        return original != null && TemporaryObjectID.findOriginalObject(updated) == original;
    }

    protected boolean shouldValidateProperty(ValidationContext<? extends T> context, String propertyName) {
        T updated;
        T original = context.getOriginalObject();
        return !this.isTemporaryCopy(original, updated = context.getUpdatedObject()) || !DBUtil.needsBuilding(updated, propertyName);
    }

    @Override
    public void validateObject(T original, T updated) throws ValidationException {
        this.validateObjectProperty(original, updated, null);
    }

    @Override
    @Deprecated
    public void validateObjectProperty(T original, T updated, String property) throws ValidationException {
        this.validateImpl(new ValidationContext<T>(original, updated, ValidationLevel.FULL, property));
    }

    public final void validate(ValidationContext<? extends T> context) throws ValidationException {
        T orig = context.getOriginalObject();
        T update = context.getUpdatedObject();
        String[] properties = context.getProperties();
        if (properties == null) {
            Method m = this.getLegacyMethod("validateObject", DBObject.class, DBObject.class);
            if (m == null) {
                this.validateImpl(context);
            } else {
                this.invokeValidationMethod(m, orig, update);
            }
        } else {
            Method m = this.getLegacyMethod("validateObjectProperty", DBObject.class, DBObject.class, String.class);
            if (m == null) {
                this.validateImpl(context);
            } else {
                for (String prop : properties) {
                    this.invokeValidationMethod(m, orig, update, prop);
                }
            }
        }
    }

    private Method getLegacyMethod(String methodName, Class ... params) {
        Method retval = null;
        try {
            Method m = this.getClass().getMethod(methodName, params);
            if (!DBObjectValidator.class.equals(m.getDeclaringClass())) {
                retval = m;
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Reflection error", e);
        }
        return retval;
    }

    private void validateImpl(ValidationContext<? extends T> context) throws ValidationException {
        Collection<String> propsToValidate;
        ValidationException firstVE = null;
        T original = context.getOriginalObject();
        T updated = context.getUpdatedObject();
        ValidationLevel contextLevel = context.getLevel();
        String[] contextProps = context.getProperties();
        if (contextProps == null) {
            propsToValidate = this.getPropertyMethodMap().keySet();
        } else {
            propsToValidate = new ArrayList();
            Collection<String> valid = this.listAlwaysValidProperties();
            for (String prop : contextProps) {
                if (prop == null || valid.contains(prop)) continue;
                propsToValidate.add(prop);
            }
        }
        HashSet<String> doneProperties = new HashSet<String>();
        HashSet<Method> doneMethods = new HashSet<Method>();
        for (String property : propsToValidate) {
            this.checkInterrupt();
            if (this.shouldValidateProperty(context, property)) {
                PropertyValidator pv;
                Method method = this.findValidationPropertyMethod(property);
                PropertyValidator propertyValidator = pv = method == null ? null : method.getAnnotation(PropertyValidator.class);
                if (pv == null || pv.level() == null || pv.level().ordinal() > context.getLevel().ordinal()) {
                    boolean didSomething = this.validateMissingMethod(context, property);
                    if (didSomething) {
                        doneProperties.add(property);
                        continue;
                    }
                    if (method != null) continue;
                    firstVE = ValidationException.append(firstVE, new MissingValidatorException((DBObject)updated, property));
                    continue;
                }
                if (doneMethods.contains(method)) continue;
                doneMethods.add(method);
                doneProperties.add(property);
                if (pv.path()) {
                    doneProperties.add(Property.stripProperties(Property.createPath(pv.value())));
                } else {
                    for (String prop : pv.value()) {
                        doneProperties.add(prop);
                    }
                }
                try {
                    if (method.getParameterTypes().length == 1) {
                        this.invokeValidationMethod(method, context);
                        continue;
                    }
                    this.invokeValidationMethod(method, original, updated);
                }
                catch (ValidationException ve) {
                    if (ve.getPropertyName() == null) {
                        ve.setPropertyName(property);
                    }
                    firstVE = ValidationException.append(firstVE, ve);
                }
                continue;
            }
            this.getLogger().log(Level.FINE, "Skipping validation for {0} on {1}", new String[]{property, updated.getName()});
        }
        if (contextProps == null) {
            Map<String, Object> props = this.isTemporaryCopy(original, updated) ? DBUtil.getFrozenProperties(updated) : updated.getProperties();
            for (Map.Entry<String, Object> propEntry : props.entrySet()) {
                this.checkInterrupt();
                String propName = propEntry.getKey();
                if (doneProperties.contains(propName)) continue;
                Object value = propEntry.getValue();
                try {
                    if (value instanceof DBObject[]) {
                        this.validateOwnedObjects(contextLevel, (DBObject[])value);
                        continue;
                    }
                    if (!(value instanceof DBObject)) continue;
                    this.validateOwnedObjects(contextLevel, (DBObject)value);
                }
                catch (MissingValidatorException mve) {
                    this.getLogger().fine(mve.getMessage());
                }
                catch (ValidationException ve) {
                    if (ve.getPropertyName() == null) {
                        ve.setPropertyName(propName);
                    }
                    firstVE = ValidationException.append(firstVE, ve);
                }
            }
        }
        if (firstVE != null) {
            throw firstVE;
        }
    }

    private boolean validateMissingMethod(ValidationContext<? extends T> context, String property) throws ValidationException {
        String remainingPropPath;
        boolean retval = false;
        T original = context.getOriginalObject();
        T updated = context.getUpdatedObject();
        PropertyHelper propHelper = new PropertyHelper();
        String[] chunks = Property.getProperties(property);
        String pathToObject = chunks[0];
        if (chunks.length > 1) {
            String[] chunksAfter = new String[chunks.length - 1];
            System.arraycopy(chunks, 1, chunksAfter, 0, chunksAfter.length);
            remainingPropPath = Property.createPath(chunksAfter);
        } else {
            remainingPropPath = null;
        }
        Object origValue = original == null ? null : propHelper.getPropertyValue(updated, pathToObject);
        Object updValue = propHelper.getPropertyValue(updated, pathToObject);
        if (updValue == null && (remainingPropPath != null || this.isChildObjectProperty((DBObject)updated, pathToObject))) {
            retval = true;
            this.validateMissingPath(original, updated, property);
        } else if (updValue instanceof DBObject) {
            DBObject child = (DBObject)updValue;
            if (child.getParent() == updated) {
                try {
                    retval = true;
                    this.validateChild((DBObject)origValue, (DBObject)updValue, context.getLevel(), remainingPropPath);
                }
                catch (MissingValidatorException mve) {
                    retval = false;
                }
            }
        } else if (remainingPropPath == null && updValue instanceof DBObject[]) {
            retval = true;
            this.validateOwnedObjects(context.getLevel(), (DBObject[])updValue);
        }
        return retval;
    }

    private boolean isChildObjectProperty(DBObject obj, String prop) {
        PropertyInfo info;
        boolean retval = false;
        DBObjectProvider pro = this.getProvider();
        if (pro != null && (info = this.getProvider().getPropertyManager().findPropertyInfo(obj.getClass(), prop)) != null) {
            retval = DBObject.class.isAssignableFrom(DBUtil.decodeArrayClass(info.getPropertyClass()));
        }
        return retval;
    }

    protected void validateMissingPath(T original, T updated, String property) throws ValidationException {
    }

    protected Collection<String> listAlwaysValidProperties() {
        return new TreeSet<String>();
    }

    private void invokeValidationMethod(Method m, Object ... params) throws ValidationException {
        try {
            m.invoke((Object)this, params);
        }
        catch (IllegalArgumentException e) {
            this.processPropException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof ValidationException) {
                throw (ValidationException)t;
            }
            this.processPropException(t == null ? e : t);
        }
        catch (IllegalAccessException e) {
            this.processPropException(e);
        }
    }

    private void processPropException(Throwable t) {
        this.getLogger().log(Level.SEVERE, "Error calling property validation", t);
    }

    private Method findValidationPropertyMethod(String property) {
        Method retval = null;
        if (ModelUtil.hasLength((String)property)) {
            retval = this.getPropertyMethodMap().get(property);
        }
        return retval;
    }

    private synchronized Map<String, Method> getPropertyMethodMap() {
        if (this.m_propMap == null) {
            this.m_propMap = new TreeMap<String, Method>();
            for (Class<?> c = this.getClass(); c != null; c = c.getSuperclass()) {
                this.populateMethodMap(c);
                if (c == DBObjectValidator.class) break;
            }
        }
        return this.m_propMap;
    }

    private void populateMethodMap(Class<?> clz) {
        for (Method m : clz.getDeclaredMethods()) {
            PropertyValidator v = m.getAnnotation(PropertyValidator.class);
            if (v == null) continue;
            if (!Modifier.isPublic(m.getModifiers())) {
                this.logMethodError(m, "@PropertyValidator methods must be public");
                continue;
            }
            String[] props = v.path() ? new String[]{Property.createPath(v.value())} : v.value();
            for (String prop : props) {
                if (!ModelUtil.hasLength((String)prop)) {
                    this.logMethodError(m, "@PropertyValidator for method " + clz.getName() + "." + m.getName() + " is missing a property name");
                    continue;
                }
                if (this.m_propMap.containsKey(prop)) continue;
                this.m_propMap.put(prop, m);
            }
        }
    }

    private void logMethodError(Method m, String message) {
        this.getLogger().log(Level.SEVERE, m.getName(), new IllegalStateException(message));
    }

    @PropertyValidator(value={"type"})
    public final void validateType(T original, T updated) throws ValidationException {
        if (original != null && ModelUtil.areDifferent((Object)original.getType(), (Object)updated.getType())) {
            throw new ValidationException((DBObject)updated, APIBundle.get("DBOV_NO_TYPE_CHANGE"));
        }
    }

    @PropertyValidator(value={"name"})
    @PropertyDependency(value={"schema"})
    public final void validateName(T original, T updated) throws ValidationException {
        this.validateName(updated);
        if (original == null) {
            this.validateNameInUse(updated);
        } else if (!this.getProvider().getDescriptor().areNamesEqual((DBObject)original, (DBObject)updated)) {
            if (this.canRename()) {
                this.validateNameInUse(updated);
            } else {
                throw new ValidationException((DBObject)updated, APIBundle.get("DBOV_NO_RENAME"));
            }
        }
    }

    protected final boolean isChildOfPendingObject(DBObject obj) {
        boolean childOfPendingObject = false;
        DBObject so = obj;
        while (so.getParent() != null) {
            so = so.getParent();
            childOfPendingObject = true;
        }
        if (so instanceof SchemaObject && !this.isPendingObject((SchemaObject)so)) {
            childOfPendingObject = false;
        }
        return childOfPendingObject;
    }

    protected final boolean isPendingObject(SchemaObject obj) {
        return TemplateExpander.isPendingObject(obj);
    }

    protected void validateName(T obj) throws InvalidNameException {
        String name = obj.getName();
        if (!ModelUtil.hasLength((String)name) && !this.canHaveEmptyName()) {
            throw new InvalidNameException((DBObject)obj, APIBundle.get("DBOV_NO_NAME"));
        }
        DBObjectProvider pro = this.getProvider();
        if (pro != null && ModelUtil.hasLength((String)name)) {
            try {
                String extName = pro.getExternalName(name);
                this.validateName(obj.getType(), extName);
            }
            catch (InvalidNameException ine) {
                String reason = ine.getMessage();
                throw new InvalidNameException((DBObject)obj, APIBundle.format("DBOV_INVALID_NAME", name, reason));
            }
        }
    }

    public void validateName(String type, String externalName) throws InvalidNameException {
        DBObjectProvider pro = this.getProvider();
        if (pro != null) {
            pro.getDescriptor().validateName(type, externalName);
        }
    }

    protected final void validateNonNullableProperty(DBObject original, DBObject updated, String propName) throws ValidationException {
        if (original != null && this.getProvider() instanceof Database) {
            Object oldValue = original.getProperty(propName);
            Object newValue = updated.getProperty(propName);
            if (oldValue != null && newValue == null) {
                throw new ValidationException(updated, APIBundle.format("INVALID_NULL_VALUE", DisplayNames.getPropertyDisplayName(propName)));
            }
        }
    }

    protected boolean canHaveEmptyName() {
        return false;
    }

    protected boolean canRename() {
        return true;
    }

    protected void validateNameInUse(T object) throws NameInUseException {
        this.validateNameInUse(object, this.getNamespaceType());
    }

    protected final void validateNameInUse(T object, NamespaceType nsType) throws NameInUseException {
        String parProp;
        Object propValue;
        Schema schema = DBUtil.getSchema(object);
        String name = object.getName();
        DBObjectProvider pro = this.getProvider();
        DBObject parent = object.getParent();
        if (parent != null && nsType.compareTo(NamespaceType.TYPE_PARENT) >= 0 && (propValue = parent.getProperty(parProp = DBUtil.getParentProperty(object))) instanceof DBObject[]) {
            for (DBObject other : (DBObject[])propValue) {
                if (other == object || !pro.getDescriptor().areNamesEqual(name, other.getName(), object.getType(), false)) continue;
                throw new NameInUseException((DBObject)object, other);
            }
        }
        if (!(nsType.compareTo(NamespaceType.TYPE) < 0 || parent != null && this.isChildOfPendingObject((DBObject)object))) {
            pro.validateUniqueName((DBObject)object, schema);
        }
    }

    @Deprecated
    protected T findExistingObject(T object) throws ValidationException {
        DBObjectID id = object.getID();
        DBObject existing = null;
        if (id != null) {
            try {
                existing = id instanceof TemporaryObjectID ? TemporaryObjectID.findOriginalObject((TemporaryObjectID)id) : id.resolveID();
            }
            catch (CancelledException ce) {
                throw new ValidationCancelledException();
            }
            catch (DBException dbe) {
                throw new ValidationException((DBObject)object, dbe.getMessage());
            }
            if (existing != null && ModelUtil.areDifferent((Object)existing.getType(), (Object)object.getType())) {
                throw new ValidationException((DBObject)object, APIBundle.format("DBOV_OBJ_ID_ERR", object.getName()));
            }
        }
        if (existing == null && object instanceof SystemObject && (id == null || id instanceof TemporaryObjectID)) {
            try {
                existing = DBUtil.getProviderDefinition((SystemObject)object, this.getProvider());
            }
            catch (DBException dbe) {
                this.logException(dbe, Level.WARNING);
            }
        }
        return (T)existing;
    }

    public NamespaceType getNamespaceType() {
        return this.canHaveEmptyName() ? NamespaceType.NONE : NamespaceType.TYPE;
    }

    public boolean initializeWithDefaultName() {
        return !this.canHaveEmptyName();
    }

    @Deprecated
    protected boolean enforceChildNameUniqueInSchema(DBObject child) {
        return false;
    }

    @PropertyValidator(value={"Comment"}, level=ValidationLevel.FULL)
    public void validateComment(T original, T update) throws ValidationException {
        String comment = (String)update.getProperty("Comment");
        if (comment != null) {
            DatabaseDescriptor dd = this.getProvider().getDescriptor();
            try {
                dd.validateEncoding(comment, "Comment");
            }
            catch (ValidationException ve) {
                throw new ValidationException((DBObject)update, ve.getMessage());
            }
        }
    }

    public Collection<String[]> getDependencies(String path) {
        PropertyDependency pd;
        ArrayList<String[]> retval = null;
        Method m = this.findValidationPropertyMethod(path);
        if (m != null && (pd = m.getAnnotation(PropertyDependency.class)) != null) {
            for (String prop : pd.value()) {
                if (retval == null) {
                    retval = new ArrayList<String[]>();
                }
                retval.add(new String[]{prop});
            }
        }
        return retval == null ? Collections.emptyList() : retval;
    }

    @Deprecated
    protected final void validateOwnedObjects(DBObject ... children) throws ValidationException {
        this.validateOwnedObjects(ValidationLevel.FULL, children);
    }

    protected final void validateOwnedObjects(ValidationLevel level, DBObject ... children) throws ValidationException {
        if (children != null) {
            ValidationException ex = null;
            for (DBObject kid : children) {
                if (kid == null) continue;
                DBObject orig = null;
                DBObjectID id = kid.getID();
                if (id instanceof TemporaryObjectID) {
                    orig = TemporaryObjectID.findOriginalObject((TemporaryObjectID)id);
                }
                try {
                    this.validateChild(orig, kid, level, new String[0]);
                }
                catch (ValidationException ve) {
                    ex = DBException.append(ex, ve);
                }
            }
            if (ex != null) {
                throw ex;
            }
        }
    }

    private void validateChild(DBObject orig, DBObject kid, ValidationLevel level, String ... props) throws ValidationException {
        DBObjectProvider pro = this.getProvider();
        if (!(pro instanceof AbstractDBObjectProvider)) {
            throw new MissingValidatorException(kid);
        }
        ValidationContext<DBObject> context = new ValidationContext<DBObject>(orig, kid, level, props);
        ((AbstractDBObjectProvider)pro).validate(context);
    }

    @Deprecated
    public static void validateUniqueNames(DBObject[] objs) throws ValidationException {
    }

    public static enum NamespaceType {
        NONE,
        TYPE_PARENT,
        TYPE,
        SCHEMA;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface PropertyDependency {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface PropertyValidator {
        public String[] value();

        public boolean path() default false;

        public ValidationLevel level() default ValidationLevel.SIMPLE;
    }
}

