/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Arrays;
import oracle.javatools.db.property.After;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.HierarchicalQueryObject;
import oracle.javatools.db.sql.ModelObject;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SetOperator;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

public class SQLQuery
extends AbstractSQLFragment {
    public static final String TYPE = "SQLQuery";
    public static final String SQL_TEMPLATE = "SELECT \n    \nFROM \n    \n";

    public SQLQuery() {
        this(null);
    }

    public SQLQuery(String queryText) {
        this.setQueryString(queryText);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Transient
    public boolean isDeclarative() {
        return (Boolean)this.getProperty("declarative", false);
    }

    @Transient
    public void setDeclarative(boolean declarative) {
        this.setProperty("declarative", declarative);
    }

    @TextProperty(multiLine=true)
    public String getQueryString() {
        String query = (String)this.getProperty("queryString");
        if (!ModelUtil.hasLength((String)query) && this.isDeclarative()) {
            query = this.constructQueryText();
        }
        return query;
    }

    @After
    public void setQueryString(String query) {
        if (ModelUtil.areDifferent((Object)query, (Object)this.getProperty("queryString"))) {
            this.setProperty("queryString", query);
            if (query != null) {
                this.setDeclarative(false);
            }
        }
    }

    protected void clearQueryString() {
        if (!AbstractSQLQueryBuilder.isBuilding(this)) {
            this.setDeclarative(true);
            this.setQueryString(null);
        }
    }

    @Derived(value="queryString")
    public SelectObject[] getSelectObjects() {
        return this.getChildSupport("selectObjects").getChildArray(SelectObject.class);
    }

    @Transient
    public void setSelectObjects(SelectObject[] selects) {
        this.clearQueryString();
        this.getChildSupport("selectObjects").setChildArray(selects);
    }

    public void addSelectObject(SelectObject s) {
        this.clearQueryString();
        this.getChildSupport("selectObjects").addChild(s);
    }

    public void addSelectObject(int index, SelectObject s) {
        this.clearQueryString();
        this.getChildSupport("selectObjects").addChild(index, s);
    }

    public boolean removeSelectObject(SelectObject s) {
        if (this.getChildSupport("selectObjects").removeChild(s)) {
            this.clearQueryString();
            return true;
        }
        return false;
    }

    public void moveSelectObject(SelectObject s, int newIndex) {
        if (this.getChildSupport("selectObjects").moveChild(s, newIndex)) {
            this.clearQueryString();
        }
    }

    public int indexOf(SelectObject s) {
        return this.getChildSupport("selectObjects").indexOfChild(s);
    }

    @Derived(value="queryString")
    public FromObject[] getFromObjects() {
        return this.getChildSupport("fromObjects").getChildArray(FromObject.class);
    }

    @Transient
    public void setFromObjects(FromObject[] froms) {
        this.clearQueryString();
        this.getChildSupport("fromObjects").setChildArray(froms);
    }

    public void addFromObject(FromObject f) {
        this.clearQueryString();
        this.getChildSupport("fromObjects").addChild(f);
    }

    public void addFromObject(int index, FromObject f) {
        this.clearQueryString();
        this.getChildSupport("fromObjects").addChild(index, f);
    }

    public boolean removeFromObject(FromObject f) {
        if (this.getChildSupport("fromObjects").removeChild(f)) {
            this.clearQueryString();
            return true;
        }
        return false;
    }

    public void moveFromObject(FromObject f, int newIndex) {
        if (this.getChildSupport("fromObjects").moveChild(f, newIndex)) {
            this.clearQueryString();
        }
    }

    public int indexOf(FromObject f) {
        return this.getChildSupport("fromObjects").indexOfChild(f);
    }

    @Derived(value="queryString")
    public OrderByObject[] getOrderByObjects() {
        return this.getChildSupport("orderByObjects").getChildArray(OrderByObject.class);
    }

    @Transient
    public void setOrderByObjects(OrderByObject[] orderBys) {
        this.clearQueryString();
        this.getChildSupport("orderByObjects").setChildArray(orderBys);
    }

    public void addOrderByObject(OrderByObject o) {
        this.clearQueryString();
        this.getChildSupport("orderByObjects").addChild(o);
    }

    public void addOrderByObject(int index, OrderByObject o) {
        this.clearQueryString();
        this.getChildSupport("orderByObjects").addChild(index, o);
    }

    public boolean removeOrderByObject(OrderByObject o) {
        if (this.getChildSupport("orderByObjects").removeChild(o)) {
            this.clearQueryString();
            return true;
        }
        return false;
    }

    public void moveOrderByObject(OrderByObject o, int newIndex) {
        if (this.getChildSupport("orderByObjects").moveChild(o, newIndex)) {
            this.clearQueryString();
        }
    }

    public int indexOf(OrderByObject o) {
        return this.getChildSupport("orderByObjects").indexOfChild(o);
    }

    @Transient
    public void setWhereObject(WhereObject where) {
        this.clearQueryString();
        this.setProperty("whereObject", where);
    }

    @Derived(value="queryString")
    public WhereObject getWhereObject() {
        return (WhereObject)this.getProperty("whereObject");
    }

    @Transient
    public void setSetOperator(SetOperator setOperator) {
        this.clearQueryString();
        this.setProperty("setOperator", setOperator);
    }

    @Derived(value="queryString")
    public SetOperator getSetOperator() {
        return (SetOperator)this.getProperty("setOperator");
    }

    @Transient
    public void setHierarchicalQueryObject(HierarchicalQueryObject connectby) {
        this.clearQueryString();
        this.setProperty("hierarchicalQueryObject", connectby);
    }

    @Derived(value="queryString")
    public HierarchicalQueryObject getHierarchicalQueryObject() {
        return (HierarchicalQueryObject)this.getProperty("hierarchicalQueryObject");
    }

    @Transient
    public void setGroupByObject(GroupByObject groupby) {
        this.clearQueryString();
        this.setProperty("groupByObject", groupby);
    }

    @Derived(value="queryString")
    public GroupByObject getGroupByObject() {
        return (GroupByObject)this.getProperty("groupByObject");
    }

    @Transient
    public void setModelObject(ModelObject model) {
        this.clearQueryString();
        this.setProperty("modelObject", model);
    }

    @Derived(value="queryString")
    public ModelObject getModelObject() {
        return (ModelObject)this.getProperty("modelObject");
    }

    @Transient
    public void setDistinct(boolean isDistinct) {
        this.setProperty("distinct", isDistinct);
    }

    @Derived(value="queryString")
    public boolean isDistinct() {
        return (Boolean)this.getProperty("distinct", false);
    }

    @Transient
    public void setOrderSiblings(boolean orderSiblings) {
        this.clearQueryString();
        this.setProperty("orderSiblings", orderSiblings);
    }

    @Derived(value="queryString")
    public boolean isOrderSiblings() {
        return (Boolean)this.getProperty("orderSiblings", false);
    }

    @Transient
    public void setDistinctSource(String distinctSource) {
        this.setProperty("distinctSource", distinctSource);
    }

    @Derived(value="queryString")
    public String getDistinctSource() {
        return (String)this.getProperty("distinctSource");
    }

    @Override
    public String getSQLText() {
        return this.getQueryString();
    }

    private void terminatePreviousLine(StringBuilder sql) {
        int len = sql.length();
        if (len > 0 && !"\n".equals(Character.valueOf(sql.charAt(len - 1)))) {
            sql.append(" ").append("\n");
        }
    }

    private String constructQueryText() {
        StringBuilder sql = new StringBuilder();
        SetOperator setOperator = this.getSetOperator();
        if (setOperator == null) {
            ModelObject model;
            GroupByObject groupby;
            HierarchicalQueryObject connectBy;
            this.appendSelectSQL(sql);
            this.appendFromSQL(sql);
            WhereObject where = this.getWhereObject();
            if (where != null) {
                this.terminatePreviousLine(sql);
                sql.append("WHERE").append(" ").append("\n");
                sql.append("    ").append(where.getSQLText());
            }
            if ((connectBy = this.getHierarchicalQueryObject()) != null) {
                this.terminatePreviousLine(sql);
                sql.append(connectBy.getSQLText());
            }
            if ((groupby = this.getGroupByObject()) != null) {
                this.terminatePreviousLine(sql);
                sql.append(groupby.getSQLText());
            }
            if ((model = this.getModelObject()) != null) {
                this.terminatePreviousLine(sql);
                sql.append(model.getSQLText());
            }
        } else {
            sql.append(setOperator.getSQLText());
        }
        OrderByObject[] obos = this.getOrderByObjects();
        if (obos != null && obos.length > 0) {
            this.terminatePreviousLine(sql);
            sql.append(this.isOrderSiblings() ? ORDERSIBLINGSBY : ORDERBY).append(" ").append("\n");
            this.appendToBuffer(sql, Arrays.asList(obos), "    ");
        }
        return sql.toString();
    }

    protected void appendSelectSQL(StringBuilder sql) {
        if (this.isWith()) {
            FromObject with = this.getFromObjects()[0];
            sql.append(with.getSQLText());
        }
        sql.append("SELECT").append(" ");
        String distinct = this.getDistinctSource();
        if (ModelUtil.hasLength((String)distinct)) {
            sql.append(distinct).append(" ");
        }
        sql.append("\n");
        SelectObject[] selects = this.getSelectObjects();
        if (selects.length > 0) {
            this.appendToBuffer(sql, Arrays.asList(selects), "    ");
            sql.append(" ");
        } else {
            sql.append("    ");
        }
        sql.append("\n");
    }

    protected void appendFromSQL(StringBuilder sql) {
        FromObject[] froms = this.getFromObjects();
        sql.append("FROM");
        int firstFrom = 0;
        if (this.isWith()) {
            firstFrom = 1;
        }
        if (froms.length > 0) {
            for (int i = firstFrom; i < froms.length; ++i) {
                sql.append(" ").append("\n");
                sql.append("    ");
                sql.append(froms[i].getSQLText());
                if (i >= froms.length - 1) continue;
                sql.append(",");
            }
        } else {
            sql.append(" ").append("\n");
            sql.append("    ").append("\n");
        }
    }

    private boolean isWith() {
        boolean retval = false;
        FromObject[] froms = this.getFromObjects();
        if (froms != null && froms.length > 0) {
            retval = froms[0].isWith();
        }
        return retval;
    }
}

