/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.InvalidSQLException;

public class SQLParseException
extends InvalidSQLException {
    protected final String NEWLINE = "\n";
    protected final String SPACE = " ";
    protected final String INDICATOR = APIBundle.get("SQL_PARSE_ERROR_INDICATOR");
    private String m_message;
    private ParseError[] m_errors;

    public SQLParseException(ParseError[] errors) {
        this(errors, null);
    }

    public SQLParseException(ParseError[] errors, String query) {
        super(query, (String)null);
        this.m_errors = errors;
    }

    private String createMessage(String frag, int offsetModifier) {
        String retval = null;
        if (this.m_errors != null && this.m_errors.length > 0) {
            StringBuilder messages = new StringBuilder();
            messages.append(APIBundle.get("SQL_PARSE_ERR"));
            for (int i = 0; i < this.m_errors.length; ++i) {
                String query;
                String message;
                int offset = this.m_errors[i].getOffset();
                messages.append("\n");
                if (frag == null || offsetModifier == 0) {
                    message = this.m_errors[i].getMessage();
                    query = this.getSQL();
                } else {
                    String expected = this.m_errors[i].getSuggestions();
                    message = APIBundle.format("SQL_FRAGMENT_ERR", offset -= offsetModifier, expected);
                    query = frag;
                }
                if (query != null) {
                    int endOfLine;
                    boolean offsetInvalid;
                    messages.append(APIBundle.format("SQL_PARSE_ERROR_DESC", message));
                    messages.append("\n");
                    StringBuilder sb = new StringBuilder(query);
                    boolean bl = offsetInvalid = offset >= query.length();
                    if (offsetInvalid) {
                        sb.append(this.INDICATOR);
                    } else {
                        sb.insert(offset, this.INDICATOR);
                    }
                    int realOffset = offsetInvalid ? query.length() - 1 : offset;
                    int startOfLine = query.lastIndexOf("\n", realOffset);
                    if (startOfLine < 0) {
                        startOfLine = 0;
                    }
                    if ((endOfLine = query.indexOf("\n", realOffset)) < 0) {
                        endOfLine = query.length();
                    }
                    messages.append(sb.substring(startOfLine, endOfLine += this.INDICATOR.length()).trim());
                    continue;
                }
                messages.append(message);
            }
            retval = messages.toString();
        }
        return retval;
    }

    public String getFragmentMessage(String fragment, int offset) {
        String retval = this.createMessage(fragment, offset);
        return retval;
    }

    @Override
    public String getMessage() {
        if (this.m_message == null) {
            this.m_message = this.createMessage(null, 0);
        }
        return this.m_message;
    }

    @Override
    public Integer getOffset() {
        Integer offset = null;
        if (this.m_errors != null && this.m_errors.length > 0 && this.m_errors[0] != null) {
            offset = this.m_errors[0].getOffset();
        }
        return offset;
    }

    public void adjustOffset(int offsetAjustment) {
        if (this.m_errors != null && this.m_errors.length > 0) {
            for (ParseError pe : this.m_errors) {
                if (pe == null || pe.m_offset < offsetAjustment) continue;
                ParseError parseError = pe;
                parseError.m_offset = parseError.m_offset - offsetAjustment;
            }
        }
    }

    public static class ParseError {
        private int m_offset;
        private final String m_message;
        private final String m_suggestions;

        public ParseError(int offset, String message, String suggestions) {
            this.m_suggestions = suggestions;
            this.m_offset = offset;
            this.m_message = message;
        }

        public ParseError(int offset, String message) {
            this(offset, message, "");
        }

        public int getOffset() {
            return this.m_offset;
        }

        public String getMessage() {
            return this.m_message;
        }

        public String getSuggestions() {
            return this.m_suggestions;
        }
    }
}

