/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractDBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SQLFragmentWithDatatype;
import oracle.javatools.util.ModelUtil;

public class ColumnUsage
extends AbstractDBObjectUsage
implements SQLFragmentWithDatatype {
    private boolean m_alwaysQuote;

    public ColumnUsage() {
        this((DBObjectID)null, (FromObject)null);
    }

    public ColumnUsage(DBObjectID colID) {
        this(colID, (FromObject)null);
    }

    public ColumnUsage(DBObjectID colID, FromObject from) {
        super(colID, from != null ? from.getID() : null);
        this.setOuterJoin(false);
    }

    @Deprecated
    public void setColumnID(DBObjectID colID) {
        if (colID != null) {
            this.setObjectID(colID);
        }
    }

    public String[] getAttributes() {
        return this.getChildSupport("attributes").getChildArray(String.class);
    }

    public void setAttributes(String[] attrs) {
        this.getChildSupport("attributes").setChildArray(attrs);
    }

    public void setOuterJoin(boolean oj) {
        this.setProperty("outerJoin", oj);
    }

    public boolean isOuterJoin() {
        return (Boolean)this.getProperty("outerJoin", false);
    }

    @Override
    public String getSQLText() {
        StringBuilder buff = this.getSQLTextImpl();
        if (this.m_alwaysQuote && !buff.toString().startsWith("\"")) {
            buff = buff.insert(0, "\"");
            buff = buff.append("\"");
        }
        for (String attr : this.getAttributes()) {
            buff.append(".").append(attr);
        }
        if (this.isOuterJoin()) {
            buff.append("(+)");
        }
        return buff.toString();
    }

    @Transient
    public void setAlwaysQuote(boolean boo) {
        this.m_alwaysQuote = boo;
    }

    @Override
    public String getColumnName() {
        DBObjectID objectID = this.getObjectID();
        String retval = null;
        if (objectID instanceof BaseObjectID) {
            DBObject col;
            Relation rel;
            String name = ((BaseObjectID)objectID).getName();
            if (ModelUtil.hasLength((String)name)) {
                retval = this.getExternalName(name, "COLUMN");
            }
            if (!ModelUtil.hasLength((String)retval) && (rel = this.findParent(Relation.class)) != null && DBUtil.getUppermostParent(objectID).equals(rel.getID(), true) && (col = rel.findOwnedObject(objectID)) != null) {
                retval = this.getExternalName(col.getName(), "COLUMN");
            }
        }
        if (retval == null) {
            retval = super.getColumnName();
        }
        return retval;
    }

    @Override
    public DBObjectID getDataTypeID() {
        DBObjectID ret = null;
        DBObjectID objId = this.getObjectID();
        if (objId != null) {
            DataTypeUsage dtu;
            DBObject obj;
            try {
                obj = objId.resolveID();
            }
            catch (DBException e) {
                obj = null;
            }
            if (obj instanceof Column && (dtu = ((Column)obj).getDataTypeUsage()) != null) {
                ret = dtu.getDataTypeID();
            }
        }
        return ret;
    }
}

