/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.sql.BuiltInFunctionArgument;
import oracle.javatools.db.sql.SQLCallable;

public class BuiltInFunction
extends AbstractBuildableObject
implements SQLCallable {
    public static final String TYPE = "BuiltInFunction";
    private int m_minargs;
    private int m_maxargs;
    private String m_signature;
    private String m_fullSignature;

    public BuiltInFunction() {
        this.setAggregate(this.isAggregate());
        this.setParenthesesRequired(this.isParenthesesRequired());
        this.setVariableArgumentList(this.isVariableArgumentList());
        this.setWindow(this.isWindow());
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setDescription(String description) {
        this.setProperty("description", description);
    }

    public String getDescription() {
        return (String)this.getProperty("description");
    }

    public void setAggregate(boolean aggregate) {
        this.setProperty("aggregate", aggregate);
    }

    @Override
    public boolean isAggregate() {
        return (Boolean)this.getProperty("aggregate", false);
    }

    public void setWindow(boolean window) {
        this.setProperty("window", window);
    }

    @Override
    public boolean isWindow() {
        return (Boolean)this.getProperty("window", false);
    }

    @Override
    public boolean isVariableArgumentList() {
        return (Boolean)this.getProperty("variableArgumentList", false);
    }

    public void setVariableArgumentList(boolean vararg) {
        this.setProperty("variableArgumentList", vararg);
    }

    public void setReturnTypeID(DBObjectID returnTypeID) {
        this.setProperty("returnTypeID", returnTypeID);
    }

    @Override
    public DBObjectID getReturnTypeID() {
        return (DBObjectID)this.getProperty("returnTypeID");
    }

    public void setArguments(BuiltInFunctionArgument[] arguments) {
        this.getChildSupport("arguments").setChildArray(arguments);
        this.m_signature = null;
        this.m_minargs = 0;
        this.m_maxargs = 0;
        for (BuiltInFunctionArgument arg : this.getArguments()) {
            if (!arg.isOptional()) {
                ++this.m_minargs;
            }
            ++this.m_maxargs;
        }
    }

    public BuiltInFunctionArgument[] getArguments() {
        return this.getChildSupport("arguments").getChildArray(BuiltInFunctionArgument.class);
    }

    public void setArgumentDefiningReturnType(Integer argNo) {
        this.setProperty("argumentDefiningReturnType", argNo);
    }

    @Override
    public Integer getArgumentDefiningReturnType() {
        return (Integer)this.getProperty("argumentDefiningReturnType");
    }

    public void setParenthesesRequired(boolean parenthesesRequired) {
        this.setProperty("parenthesesRequired", parenthesesRequired);
        this.m_signature = null;
    }

    @Override
    public boolean isParenthesesRequired() {
        return (Boolean)this.getProperty("parenthesesRequired", false);
    }

    public int getMaxArgs() {
        return this.m_maxargs;
    }

    public int getMinArgs() {
        return this.m_minargs;
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    public String getSignature(boolean full) {
        if (this.m_signature == null) {
            StringBuilder sigBuilder = new StringBuilder();
            StringBuilder fullSigBuilder = new StringBuilder();
            sigBuilder.append(this.getName());
            fullSigBuilder.append(this.getName());
            if (this.isParenthesesRequired()) {
                sigBuilder.append("(");
                fullSigBuilder.append("(");
            }
            int argCount = 0;
            for (BuiltInFunctionArgument arg : this.getArguments()) {
                DBObjectID id;
                if (argCount++ > 0) {
                    sigBuilder.append(",");
                    fullSigBuilder.append(",");
                }
                if (arg.isOptional()) {
                    sigBuilder.append("[");
                    fullSigBuilder.append("[");
                }
                if ((id = arg.getDataTypeID()) == null) {
                    fullSigBuilder.append("?");
                } else {
                    fullSigBuilder.append(DBUtil.getDBObjectName(id));
                }
                if (!arg.isOptional()) continue;
                sigBuilder.append("]");
                fullSigBuilder.append("]");
            }
            if (this.isVariableArgumentList()) {
                if (argCount > 0) {
                    sigBuilder.append(",");
                    fullSigBuilder.append(",");
                }
                sigBuilder.append("...");
                fullSigBuilder.append("...");
            }
            if (this.isParenthesesRequired()) {
                sigBuilder.append(")");
                fullSigBuilder.append(")");
            }
            fullSigBuilder.append(":");
            Integer argno = this.getArgumentDefiningReturnType();
            if (argno != null) {
                fullSigBuilder.append(argno);
            } else {
                DBObjectID id = this.getReturnTypeID();
                if (id == null) {
                    fullSigBuilder.append("?");
                } else {
                    fullSigBuilder.append(DBUtil.getDBObjectName(id));
                }
            }
            fullSigBuilder.append("/");
            fullSigBuilder.append(this.isAggregate() ? "Y" : "N");
            fullSigBuilder.append(this.isWindow() ? "Y" : "N");
            this.m_signature = sigBuilder.toString();
            this.m_fullSignature = fullSigBuilder.toString();
        }
        return full ? this.m_fullSignature : this.m_signature;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.m_signature = null;
    }
}

