/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;

public abstract class AbstractSQLFragment
extends AbstractChildBuildableObject
implements SQLFragment {
    protected static final String DEFAULT_SEPARATOR = ", ";
    protected static final SQLFragment[] EMPTY_ARRAY = new SQLFragment[0];
    protected static final String SPACE = " ";
    protected static final String EMPTY = "";
    protected static final String NEWLINE = "\n";
    protected static final String INDENT = "    ";
    protected static final String COMMA = ",";
    private Integer m_startOffset = null;

    protected AbstractSQLFragment() {
    }

    @Override
    public String getType() {
        return "SQLFragment";
    }

    protected String getTextOrNull(SQLFragment frag) {
        return this.getTextOrNull(frag, false);
    }

    protected String getTextOrNull(SQLFragment frag, boolean surroundWithBrackets) {
        String retval = null;
        if (frag != null && (retval = frag.getSQLText()) != null && (surroundWithBrackets || frag instanceof SQLQuery)) {
            retval = this.surroundWithBrackets(retval.trim());
        }
        return retval;
    }

    protected String argsToString(Collection args, boolean commutative, String sep, int start) {
        StringBuilder retval = new StringBuilder();
        if (args != null) {
            boolean testBrackets = !commutative && args.size() > 1 && sep != DEFAULT_SEPARATOR;
            int i = 0;
            Iterator iter = args.iterator();
            while (iter.hasNext()) {
                SQLFragment next = (SQLFragment)iter.next();
                if (i++ < start) continue;
                boolean swb = testBrackets && (next == null || next.getClass().equals(this.getClass()));
                String t = this.getTextOrNull(next, swb);
                retval.append(t);
                if (!iter.hasNext()) continue;
                retval.append(sep);
            }
        }
        return retval.toString();
    }

    protected String surroundWithBrackets(String text) {
        return this.surroundWithBrackets(text, false);
    }

    protected String surroundWithBrackets(String text, boolean force) {
        int lbrac = 40;
        int rbrac = 41;
        boolean needsBrackets = true;
        String testText = text.trim();
        if (!force && testText.length() > 0 && testText.charAt(0) == '(') {
            needsBrackets = false;
            int count = 1;
            for (int i = 1; i < testText.length(); ++i) {
                char c = testText.charAt(i);
                if (c == ')') {
                    --count;
                } else if (c == '(') {
                    ++count;
                }
                if (count > 0 || i >= testText.length() - 1) continue;
                needsBrackets = true;
                break;
            }
            if (count != 0) {
                needsBrackets = true;
            }
        }
        return needsBrackets ? '(' + text + ')' : text;
    }

    protected void appendToBuffer(StringBuilder query, Collection objs, String indent) {
        if (objs != null) {
            Iterator iter = objs.iterator();
            while (iter.hasNext()) {
                SQLFragment s = (SQLFragment)iter.next();
                String text = s.getSQLText();
                if (indent != null) {
                    query.append(indent);
                    text = text.replaceAll(NEWLINE, NEWLINE + indent);
                }
                query.append(text);
                if (!iter.hasNext()) continue;
                query.append(", \n");
            }
        }
    }

    @Override
    public String toString() {
        return this.getSQLText();
    }

    @Override
    @Transient
    public Integer getStartOffset() {
        return (Integer)this.getProperty("startOffset");
    }

    @Transient
    public void setStartOffset(Integer start) {
        this.setProperty("startOffset", start);
    }
}

