/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBLog;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractAliasFragment
extends AbstractSQLFragment
implements AliasFragment {
    protected AbstractAliasFragment() {
    }

    protected AbstractAliasFragment(SQLFragment exp, String alias) {
        this.setExpression(exp);
        this.setAlias(alias);
    }

    @Override
    public String getAlias() {
        return (String)this.getProperty("alias");
    }

    @Override
    public void setAlias(String alias) {
        if (this.canHaveAlias()) {
            this.setProperty("alias", alias);
            this.setName(null);
        } else if (ModelUtil.hasLength((String)alias)) {
            DBLog.logStackTrace(new SQLQueryException(APIBundle.format("SQL_NO_ALIAS", this.getExpression().getSQLText())));
        }
    }

    public boolean canHaveAlias() {
        return true;
    }

    @Override
    public SQLFragment getExpression() {
        return (SQLFragment)this.getProperty("expression");
    }

    @Override
    public void setExpression(SQLFragment expression) {
        this.setProperty("expression", expression);
        if (this.canHaveAlias()) {
            this.setName(null);
        } else {
            this.setAlias(null);
        }
    }

    @Override
    public String getSQLText() {
        SQLFragment expression = this.getExpression();
        String alias = this.getAlias();
        StringBuilder sql = new StringBuilder();
        sql.append(this.getTextOrNull(expression));
        if (ModelUtil.hasLength((String)alias)) {
            if (this.useAsBeforeAlias()) {
                sql.append(" AS");
            }
            sql.append(" ").append(alias);
        }
        return sql.toString();
    }

    protected boolean useAsBeforeAlias() {
        return false;
    }

    @Override
    public String getUsableAlias() {
        String retval = this.getAlias();
        if (retval == null && !(this.getExpression() instanceof JoinObject) && !this.canUseAsAlias(retval = this.getName())) {
            retval = null;
        }
        return retval;
    }

    @Override
    @Transient
    public String getName() {
        String retval = super.getName();
        if (retval == null) {
            String alias = this.getAlias();
            if (ModelUtil.hasLength((String)alias)) {
                retval = alias;
            } else {
                SQLFragment expression = this.getExpression();
                if (expression != null) {
                    retval = expression.getSQLText();
                }
            }
        }
        return retval;
    }

    protected boolean canUseAsAlias(String exp) {
        return exp.indexOf(" ") <= -1;
    }

    @Override
    public String toString() {
        String retval;
        SQLFragment expression = this.getExpression();
        String alias = this.getAlias();
        String string = retval = expression == null ? null : expression.toString();
        if (ModelUtil.hasLength((String)alias)) {
            retval = alias + " " + "(" + retval + ")";
        }
        return retval;
    }
}

