/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.refactoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.util.ModelUtil;

public abstract class CascadeWorker<T extends DBObject> {
    private final DBObjectProvider m_pro;

    public CascadeWorker(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected final Logger getLogger() {
        return DBLog.getLogger(this);
    }

    public CascadeAction cascadeDelete(DBObject removed, T obj) throws DBException {
        if (!(obj instanceof SystemObject)) {
            throw new IllegalStateException("shouldn't cascade directly to child objects");
        }
        return this.cascadeDelete(removed.getID(), (DBObject)obj, obj);
    }

    protected final CascadeAction cascadeDelete(DBObjectID removed, DBObject referer, T obj) throws DBException {
        CascadeAction retval = CascadeAction.NONE;
        Map<PropertyInfo, Object> refs = this.getProvider().getCascadeManager().findPropertyReferences(referer, removed);
        if (refs != null && !refs.isEmpty()) {
            for (PropertyInfo info : refs.keySet()) {
                CancelledException.checkInterrupt();
                CascadeAction infoAction = this.removeReference(removed, referer, info);
                if (infoAction.compareTo(retval) <= 0) continue;
                retval = infoAction;
            }
        }
        for (DBObject kid : referer.getOwnedObjects()) {
            CancelledException.checkInterrupt();
            CascadeAction childAction = this.cascadeDelete(removed, kid, obj);
            if (childAction == CascadeAction.DELETE) {
                referer.removeOwnedObject(kid);
                retval = CascadeAction.UPDATE;
                continue;
            }
            if (childAction != CascadeAction.UPDATE) continue;
            retval = childAction;
        }
        return retval;
    }

    protected CascadeAction removeReference(DBObjectID removed, DBObject referer, PropertyInfo info) throws DBException {
        CascadeAction retval = info.getCascadeAction();
        if (retval.compareTo(CascadeAction.NONE) > 0) {
            DBObjectID[] newVal = null;
            Class<?> clz = info.getPropertyClass();
            if (clz.isArray()) {
                DBObjectID[] val = (DBObjectID[])info.getPropertyValue(referer);
                ArrayList<DBObjectID> list = new ArrayList<DBObjectID>();
                for (DBObjectID valID : val) {
                    if (removed.equals(valID, true)) continue;
                    list.add(valID);
                }
                int size = list.size();
                DBObjectID[] dBObjectIDArray = newVal = size > 0 ? list.toArray(new DBObjectID[size]) : null;
            }
            if (newVal != null || retval != CascadeAction.DELETE) {
                try {
                    info.setPropertyValue(referer, newVal);
                    retval = CascadeAction.UPDATE;
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Couldn't cascade delete", e);
                }
            }
        }
        return retval;
    }

    public CascadeAction cascadeUpdate(Difference objDiff, T obj) throws DBException {
        CascadeAction retval = CascadeAction.NONE;
        if (!objDiff.isSame()) {
            for (Difference difference : objDiff.getChildren()) {
                CascadeAction cascade;
                CancelledException.checkInterrupt();
                if (difference.isSame() || (cascade = this.cascadePropertyChange(objDiff, difference.getPropertyName(), difference.getOriginalObject(), difference.getUpdatedObject(), obj)).compareTo(retval) <= 0) continue;
                retval = cascade;
            }
        }
        return retval;
    }

    protected CascadeAction cascadePropertyChange(Difference objDiff, String propName, Object oldValue, Object newValue, T obj) throws DBException {
        CascadeAction retval = CascadeAction.NONE;
        if ("name".equals(propName) || "schema".equals(propName)) {
            DBObject origObj = (DBObject)objDiff.getOriginalObject();
            DBObject updateObj = (DBObject)objDiff.getUpdatedObject();
            DBObjectID origID = origObj.getID();
            DBObjectID newID = updateObj.getID();
            if (this.replaceReferences((DBObject)obj, origID, origObj.getName(), updateObj.getName(), this.getSchemaName(origObj), this.getSchemaName(updateObj))) {
                retval = CascadeAction.UPDATE;
            }
        }
        return retval;
    }

    private String getSchemaName(DBObject obj) {
        Schema schema = DBUtil.getSchema(obj);
        return schema == null ? null : schema.getName();
    }

    private boolean replaceReferences(DBObject obj, DBObjectID referencedObjectID, String referencedObjectOriginalName, String referencedObjectNewName, String referencedObjectOriginalSchema, String referencedObjectNewSchema) throws DBException {
        boolean retval = false;
        CascadeManager mgr = this.getProvider().getCascadeManager();
        Map<PropertyInfo, Object> propMap = mgr.findPropertyReferences(obj, referencedObjectID);
        if (propMap != null) {
            for (Map.Entry entry : propMap.entrySet()) {
                CancelledException.checkInterrupt();
                PropertyInfo info = (PropertyInfo)entry.getKey();
                String propName = info.getPropertyName();
                Object propValue = entry.getValue();
                boolean changed = false;
                BaseObjectID newValue = null;
                if (propValue instanceof BaseObjectID) {
                    newValue = this.copyAndFixIfNecessary((BaseObjectID)propValue, referencedObjectID.getType(), referencedObjectOriginalName, referencedObjectNewName, referencedObjectOriginalSchema, referencedObjectNewSchema);
                    changed = newValue != null;
                } else if (propValue instanceof DBObjectID[]) {
                    DBObjectID[] idArr = (DBObjectID[])propValue;
                    for (int i = 0; i < idArr.length; ++i) {
                        BaseObjectID newID;
                        DBObjectID item = idArr[i];
                        if (!(item instanceof BaseObjectID) || (newID = this.copyAndFixIfNecessary((BaseObjectID)item, referencedObjectID.getType(), referencedObjectOriginalName, referencedObjectNewName, referencedObjectOriginalSchema, referencedObjectNewSchema)) == null) continue;
                        changed = true;
                        newValue = propValue;
                        idArr[i] = newID;
                    }
                }
                if (!changed) continue;
                obj.setProperty(propName, newValue);
                retval = true;
            }
        }
        for (DBObject kid : obj.getOwnedObjects()) {
            if (!this.replaceReferences(kid, referencedObjectID, referencedObjectOriginalName, referencedObjectNewName, referencedObjectOriginalSchema, referencedObjectNewSchema)) continue;
            retval = true;
        }
        return retval;
    }

    private BaseObjectID copyAndFixIfNecessary(BaseObjectID id, String referencedObjectType, String referencedObjectOriginalName, String referencedObjectNewName, String referencedObjectOriginalSchema, String referencedObjectNewSchema) {
        BaseObjectID newParent;
        BaseObjectID retval = null;
        if (ModelUtil.areEqual((Object)referencedObjectType, (Object)id.getType()) && ModelUtil.areEqual((Object)referencedObjectOriginalName, (Object)id.getName()) && (!Metadata.getInstance().isSchemaObject(referencedObjectType) || ModelUtil.areEqual((Object)referencedObjectOriginalSchema, (Object)id.getSchemaName()))) {
            retval = (BaseObjectID)id.copyTo(null);
            retval.setName(referencedObjectNewName);
            retval.setSchemaName(referencedObjectNewSchema);
        } else if ("DATABASE LINK".equals(referencedObjectType) && ModelUtil.areEqual((Object)referencedObjectOriginalName, (Object)id.getDatabaseName())) {
            retval = (BaseObjectID)id.copyTo(null);
            retval.setDatabaseName(referencedObjectNewName);
        }
        DBObjectID parent = id.getParent();
        if (parent instanceof BaseObjectID && (newParent = this.copyAndFixIfNecessary((BaseObjectID)parent, referencedObjectType, referencedObjectOriginalName, referencedObjectNewName, referencedObjectOriginalSchema, referencedObjectNewSchema)) != null) {
            parent = newParent;
            if (retval == null) {
                retval = (BaseObjectID)id.copyTo(null);
            }
        }
        if (retval != null) {
            retval.setParent(parent);
        }
        return retval;
    }

    public Set<String> getCascadeProperties() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("name");
        retval.add("schema");
        return retval;
    }
}

