/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.DynamicPropertyProvider;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public final class PropertyHelper {
    private Map<Class, Map<String, PropertyDescriptor>> m_propsCache;
    private final DBObjectProvider m_pro;

    public PropertyHelper() {
        this(null);
    }

    public PropertyHelper(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    private Logger getLogger() {
        return DBLog.getLogger(this);
    }

    private Map<Class, Map<String, PropertyDescriptor>> getPropsCache() {
        if (this.m_propsCache == null) {
            this.m_propsCache = new HashMap<Class, Map<String, PropertyDescriptor>>();
        }
        return this.m_propsCache;
    }

    public Object getPropertyValue(Object obj, String propPath) {
        Object retval = null;
        try {
            retval = this.getPropertyValueOrFail(obj, propPath);
        }
        catch (MissingPropertyException mpe) {
            this.getLogger().log(Level.FINE, mpe.getMessage());
        }
        return retval;
    }

    public Object getPropertyValueOrFail(Object obj, String propPath) throws MissingPropertyException {
        return this.getPropertyValueImpl(obj, propPath, null, false);
    }

    private Object getPropertyValueImpl(Object obj, String propPath, Object context, boolean createMissingBeans) throws MissingPropertyException {
        Object value;
        boolean found;
        MissingPropertyException mpe;
        block39: {
            if (propPath == null) {
                throw new MissingPropertyException(obj, "");
            }
            mpe = null;
            if (obj instanceof DBObjectID) {
                if ("name".equals(propPath)) {
                    String name = DBUtil.getDBObjectName((DBObjectID)obj);
                    return ModelUtil.hasLength((String)name) ? name : null;
                }
                if (Property.createPath("schema", "name").equals(propPath)) {
                    String name = DBUtil.getSchemaName((DBObjectID)obj);
                    return ModelUtil.hasLength((String)name) ? name : null;
                }
                try {
                    Object fromObj;
                    DBObject resolved = ((DBObjectID)obj).resolveID();
                    if (resolved != null && (fromObj = this.getPropertyValueImpl(resolved, propPath, null, createMissingBeans)) != null) {
                        return fromObj;
                    }
                }
                catch (MissingPropertyException idMpe) {
                    mpe = idMpe;
                }
                catch (DBException dbe) {
                    this.getLogger().log(Level.FINE, "Error accessing property " + propPath + ": " + dbe.getMessage());
                }
            }
            int index = propPath.indexOf("/");
            String restOfPath = null;
            if (index > -1) {
                restOfPath = propPath.substring(index + 1);
                propPath = propPath.substring(0, index);
            }
            found = false;
            value = null;
            boolean properties = "properties".equals(propPath);
            if (properties && obj instanceof DBObject && restOfPath != null) {
                value = obj;
                found = true;
            } else {
                PropertyDescriptor prop;
                if (obj instanceof Map && ((Map)obj).containsKey(propPath)) {
                    value = ((Map)obj).get(propPath);
                    found = true;
                } else {
                    PropertyInfo info = this.getPropertyInfo(obj, propPath);
                    if (info != null) {
                        found = true;
                        value = info.getPropertyValue(obj);
                        if (value == null && createMissingBeans) {
                            Class<?> propClz = info.getPropertyClass();
                            if (this.m_pro != null && DBObject.class.isAssignableFrom(propClz)) {
                                value = this.m_pro.getObjectFactory().newObject(propClz);
                            } else if (Copyable.class.isAssignableFrom(propClz)) {
                                try {
                                    value = propClz.newInstance();
                                }
                                catch (Exception e) {
                                    this.getLogger().log(Level.FINE, propPath, e);
                                }
                            }
                            if (value != null) {
                                try {
                                    info.setPropertyValue(obj, value);
                                }
                                catch (Exception e) {
                                    this.getLogger().log(Level.FINE, e.getMessage());
                                }
                            }
                        }
                    } else if (obj instanceof DBObject) {
                        value = ((DBObject)obj).getProperty(propPath);
                        boolean bl = found = value != null;
                    }
                }
                if (!found && (prop = this.getProperty(obj, propPath)) != null) {
                    Method m = prop.getReadMethod();
                    try {
                        value = m.invoke(obj, (Object[])null);
                        found = true;
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.SEVERE, "Error accessing property " + propPath, e);
                    }
                }
            }
            if (value != null && restOfPath != null) {
                if (value instanceof Object[]) {
                    Object[] valueA = value;
                    try {
                        Object[] newValue = new Object[valueA.length];
                        for (int i = 0; i < valueA.length; ++i) {
                            newValue[i] = this.getPropertyValueImpl(valueA[i], restOfPath, obj, false);
                        }
                        value = newValue;
                    }
                    catch (MissingPropertyException mpe2) {
                        DBObject foundByName = null;
                        for (int i = 0; i < valueA.length; ++i) {
                            if (!(valueA[i] instanceof DBObject) || !restOfPath.startsWith(((DBObject)valueA[i]).getName() + "/")) continue;
                            foundByName = (DBObject)valueA[i];
                            break;
                        }
                        if (foundByName != null) {
                            value = this.getPropertyValueImpl(foundByName, restOfPath.substring(foundByName.getName().length() + 1), obj, createMissingBeans);
                            break block39;
                        }
                        mpe = mpe2;
                    }
                } else {
                    value = this.getPropertyValueImpl(value, restOfPath, obj, createMissingBeans);
                }
            }
        }
        if (!found) {
            if (mpe == null) {
                if (this.isValidProperty(obj instanceof Map ? context : obj, propPath)) {
                    return null;
                }
                mpe = new MissingPropertyException(obj, propPath);
            }
            throw mpe;
        }
        return value;
    }

    private boolean isValidProperty(Object obj, String propName) {
        PropertyInfo info = null;
        if (obj instanceof Copyable && (info = this.getPropertyInfoImpl(((Copyable)obj).getClass(), propName)) == null && obj instanceof DBObjectID) {
            String type = ((DBObjectID)obj).getType();
            info = this.getPropertyInfoImpl(Metadata.getInstance().getObjectClass(type), propName);
        }
        return info != null;
    }

    private PropertyInfo getPropertyInfo(Object obj, String propName) {
        PropertyInfo retval = null;
        if (obj instanceof Copyable) {
            retval = this.getPropertyInfoImpl(((Copyable)obj).getClass(), propName);
        }
        return retval;
    }

    private PropertyInfo getPropertyInfoImpl(Class<? extends Copyable> clz, String propName) {
        PropertyInfo retval = null;
        if (clz != null) {
            retval = this.m_pro != null && DBObject.class.isAssignableFrom(clz) ? this.m_pro.getPropertyManager().findPropertyInfo(clz, propName) : PropertyHelper.findPropertyInfo(clz, propName, this.m_pro);
        }
        return retval;
    }

    public void setPropertyValue(Object bean, String propPath, Object value) {
        try {
            this.setPropertyValueOrFail(bean, propPath, value);
        }
        catch (MissingPropertyException mpe) {
            this.getLogger().log(Level.FINE, mpe.getMessage());
        }
    }

    public void setPropertyValueOrFail(Object object, String propPath, Object value) throws MissingPropertyException {
        String propName;
        String basePath;
        int index = propPath.lastIndexOf("/");
        if (index > -1) {
            basePath = propPath.substring(0, index);
            propName = propPath.substring(index + 1);
        } else {
            basePath = null;
            propName = propPath;
        }
        Object bean = basePath == null ? object : this.getPropertyValueImpl(object, basePath, null, value != null);
        if (bean != null) {
            if (bean instanceof Map) {
                if (value == null) {
                    ((Map)bean).remove(propName);
                } else {
                    ((Map)bean).put(propName, value);
                }
            } else {
                if (bean instanceof DBObjectID) {
                    try {
                        bean = ((DBObjectID)bean).resolveID();
                    }
                    catch (DBException dbe) {
                        this.getLogger().log(Level.WARNING, "Could not resolve id to set property", dbe);
                    }
                }
                if (bean instanceof DBObject && !"properties".equals(propName)) {
                    PropertyInfo info = this.getPropertyInfo(bean, propName);
                    if (info == null) {
                        throw new MissingPropertyException(bean, propName);
                    }
                    try {
                        info.setPropertyValue(bean, value);
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.SEVERE, "Could not set property value for " + propName, e);
                    }
                } else {
                    PropertyDescriptor prop = this.getProperty(bean, propName);
                    if (prop == null || prop.getWriteMethod() == null) {
                        throw new MissingPropertyException(bean, propName);
                    }
                    Method m = prop.getWriteMethod();
                    try {
                        m.invoke(bean, value);
                    }
                    catch (Exception e) {
                        this.getLogger().log(Level.SEVERE, "Could not set property value for {0}: {1}", new Object[]{propName, e.getMessage()});
                    }
                }
            }
        }
    }

    private PropertyDescriptor getProperty(Object bean, String propName) {
        Map<String, PropertyDescriptor> props = this.getProperties(bean.getClass());
        return props == null ? null : props.get(propName);
    }

    private Map<String, PropertyDescriptor> getProperties(Class beanClass) {
        Map<String, PropertyDescriptor> retval = this.getPropsCache().get(beanClass);
        if (retval == null) {
            retval = new HashMap<String, PropertyDescriptor>();
            try {
                BeanInfo bi = Introspector.getBeanInfo(beanClass);
                PropertyDescriptor[] props = bi.getPropertyDescriptors();
                for (int i = 0; i < props.length; ++i) {
                    if (props[i].getReadMethod() == null) continue;
                    retval.put(props[i].getName(), props[i]);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, beanClass.getName(), e);
            }
            this.getPropsCache().put(beanClass, retval);
        }
        return retval;
    }

    public Difference getChildDifference(Difference diff, String propPath) throws MissingPropertyException {
        return this.getChildDifference(diff, propPath, false);
    }

    public Difference getChildDifference(Difference diff, String propPath, boolean ignoreSame) throws MissingPropertyException {
        String[] propToks = Property.getProperties(propPath);
        boolean found = false;
        Difference propRs = diff;
        for (String s : propToks) {
            if (!ModelUtil.hasLength((String)s)) {
                throw new IllegalArgumentException("invalid property path " + propPath);
            }
            if ((propRs = this.findChildDifference(propRs, s)) == null) {
                found = false;
                break;
            }
            found = true;
            if (!ignoreSame || !propRs.isSame()) continue;
            propRs = null;
            break;
        }
        if (found) {
            return propRs;
        }
        if (this.isValidProperty(diff.getOriginalObject(), propToks[0])) {
            return null;
        }
        throw new MissingPropertyException(diff.getOriginalObject(), propPath);
    }

    private Difference findChildDifference(Difference diff, String name) {
        Difference propertiesDiff;
        Difference retval = diff.getChildDifference(name);
        if (retval == null && (propertiesDiff = diff.getChildDifference("properties")) != null) {
            retval = this.findChildDifference(propertiesDiff, name);
        }
        return retval;
    }

    public static PropertyInfo findPropertyInfo(String type, String propPath, Class<? extends DBObjectProvider> proClz) {
        Class<? extends DBObject> clz = Metadata.getInstance().getObjectClass(type);
        return clz == null ? null : PropertyHelper.findPropertyInfo(clz, propPath, proClz);
    }

    public static PropertyInfo findPropertyInfo(Class clz, String propPath, Class<? extends DBObjectProvider> proClz) {
        return PropertyHelper.findPropertyInfoImpl(clz, propPath, null, proClz);
    }

    public static PropertyInfo findPropertyInfo(Class clz, String propPath, DBObjectProvider pro) {
        return PropertyHelper.findPropertyInfoImpl(clz, propPath, pro, pro == null ? null : pro.getClass());
    }

    private static PropertyInfo findPropertyInfoImpl(Class objectClz, String propPath, DBObjectProvider pro, Class<? extends DBObjectProvider> proClz) {
        String rest;
        String prop;
        PropertyInfo retval = null;
        if (propPath.contains("/")) {
            int cut = propPath.indexOf("/");
            prop = propPath.substring(0, cut);
            rest = propPath.substring(cut + 1);
        } else {
            prop = propPath;
            rest = null;
        }
        retval = Metadata.getInstance().getSupportedProperty((Class<? extends Copyable>)objectClz, prop, proClz);
        if (retval != null && ModelUtil.hasLength(rest)) {
            DynamicPropertyProvider dpp;
            Class<?> propClz = retval.getPropertyClass();
            if (Map.class.isAssignableFrom(propClz)) {
                propClz = objectClz;
            } else if (propClz.isArray()) {
                propClz = propClz.getComponentType();
            }
            PropertyInfo parent = retval;
            retval = PropertyHelper.findPropertyInfoImpl(propClz, rest, pro, proClz);
            if (retval == null && pro != null && (dpp = parent.getDynamicPropertyProvider()) != null) {
                retval = dpp.getPropertyInfo(objectClz, rest, pro);
            }
        }
        return retval;
    }
}

