/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public abstract class DerivedPropertyBuilder<T extends AbstractBuildableObject>
extends AbstractDBObjectBuilder<T> {
    private final Map<String, Tuple<Object, DBException>> m_lastErrors = new HashMap<String, Tuple<Object, DBException>>();
    private DerivedPropertyBuilder<T> m_tempCopySourceBuilder;

    public DerivedPropertyBuilder(AbstractDBObjectProvider pro, String type) {
        super(pro, type);
        if (Metadata.getInstance().getObjectClass(type) == null) {
            throw new IllegalArgumentException(type + "is not a valid DBObject type");
        }
    }

    public boolean isClearDerivedPropertiesRequired(T obj, DBObjectChange change, Collection<String> currentlyBuiltProps) {
        boolean retval = false;
        for (String builtProp : currentlyBuiltProps) {
            if (!this.isBuildableProperty(builtProp)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public Collection<String> clearDerivedProperties(T obj, DBObjectChange change) {
        ArrayList<String> retval = new ArrayList<String>();
        for (String prop : change.getAllChangedProperties()) {
            Collection<String> clearedProps = this.clearDerivedProperties(obj, prop, change);
            if (clearedProps == null) continue;
            retval.addAll(clearedProps);
        }
        return retval;
    }

    public Collection<String> clearDerivedProperties(T obj, String property, DBObjectChange change) {
        ArrayList<String> retval = null;
        this.m_lastErrors.remove(property);
        Collection<String> derivedProps = this.getDerivedProperties(property);
        if (derivedProps != null) {
            retval = new ArrayList<String>();
            Collection<String> allProps = change.getAllChangedProperties();
            for (String derivedProp : derivedProps) {
                if (allProps.contains(derivedProp)) continue;
                retval.add(derivedProp);
                ((AbstractDBObject)obj).setProperty(derivedProp, null);
            }
        }
        return retval;
    }

    @Override
    protected final boolean canBuildComponents() {
        return true;
    }

    @Override
    public final T createObject(String name, Schema schema, DBObjectID id) {
        return null;
    }

    @Override
    public boolean cancelCurrentBuild(T object) {
        boolean retval = super.cancelCurrentBuild(object);
        DerivedPropertyBuilder<T> other = this.m_tempCopySourceBuilder;
        if (retval && other != null) {
            AbstractBuildableObject orig = (AbstractBuildableObject)TemporaryObjectID.findOriginalObject(object);
            other.cancelCurrentBuild(orig == null ? object : orig);
        }
        return retval;
    }

    @Override
    protected void registerObject(T object) throws DBException {
        if (((AbstractDBObject)object).getID() instanceof BaseObjectID) {
            this.getProvider().getObjectFactory().ensureID((DBObject)object, true, false);
            SystemObject sysObj = DBUtil.getSystemObject(object);
            if (sysObj != null) {
                this.getProvider().getCascadeManager().registerObject(sysObj, true);
            }
        } else {
            this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)object);
        }
    }

    protected boolean canCacheBuildFailure(T object, String sourceProp) {
        return true;
    }

    @Override
    protected boolean isBuiltOnFailure(T object, String[] props, DBException dbe) {
        HashSet<String> sourceProps = new HashSet<String>();
        for (String prop : props) {
            String source = this.getDerivedPropertySource(prop);
            if (source == null) continue;
            sourceProps.add(source);
        }
        boolean retval = sourceProps.isEmpty();
        for (String sourceProp : sourceProps) {
            if (this.canCacheBuildFailure(object, sourceProp)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    @Override
    protected boolean fillInObjectComponentImpl(T object, String prop) throws DBException {
        boolean retval;
        String sourceProp = this.getDerivedPropertySource(prop);
        boolean cache = false;
        Object sourceVal = null;
        if (sourceProp != null && this.canCacheBuildFailure(object, prop) && (sourceVal = ((AbstractDBObject)object).getProperty(sourceProp)) != null) {
            cache = true;
            Tuple<Object, DBException> cached = this.m_lastErrors.get(sourceProp);
            if (cached != null && sourceVal.equals(cached.getFirst())) {
                throw (DBException)cached.getSecond();
            }
        }
        try {
            T orig = this.getOriginalObjectForFillInComponentImpl(object, prop, sourceProp);
            if (orig == null) {
                retval = super.fillInObjectComponentImpl(object, prop);
            } else {
                this.derivePropertiesForTempCopy(object, orig, prop);
                retval = true;
            }
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (DBException dbe) {
            if (cache) {
                this.m_lastErrors.put(sourceProp, (Tuple<Object, DBException>)new Tuple(sourceVal, (Object)dbe));
            }
            throw dbe;
        }
        return retval;
    }

    private T getOriginalObjectForFillInComponentImpl(T object, String prop, String sourceProp) {
        AbstractBuildableObject orig;
        AbstractBuildableObject retval = null;
        if (sourceProp != null && (orig = (AbstractBuildableObject)TemporaryObjectID.getOriginalObject(object)) instanceof AbstractBuildableObject) {
            this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder(orig);
            if (this.isSourcePropertyValueEqual(orig, object, sourceProp)) {
                retval = orig;
            }
        }
        return (T)retval;
    }

    protected boolean isSourcePropertyValueEqual(T orig, T object, String sourceProp) {
        boolean retval = false;
        Object origSourcePropValue = ((AbstractDBObject)orig).getProperty(sourceProp);
        Object updSourcePropValue = ((AbstractDBObject)object).getProperty(sourceProp);
        if (!(updSourcePropValue instanceof DBObject) && origSourcePropValue != null && updSourcePropValue != null && ModelUtil.areEqual((Object)origSourcePropValue, (Object)updSourcePropValue)) {
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void derivePropertiesForTempCopy(T object, T orig, String prop) throws DBException {
        TemporaryObjectID.TemporaryIDPolicy tidp = new TemporaryObjectID.TemporaryIDPolicy();
        this.checkInterruptOrCancel(object);
        String[] dprops = this.getBuiltProperties(prop);
        if (dprops != null) {
            try {
                this.m_tempCopySourceBuilder = this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)orig);
                DBUtil.ensureObjectBuilt(orig, dprops);
            }
            finally {
                this.m_tempCopySourceBuilder = null;
            }
            this.checkInterruptOrCancel(object);
            for (String dprop : dprops) {
                Object origVal = ((AbstractDBObject)orig).getProperty(dprop);
                this.checkInterruptOrCancel(object);
                Object newVal = DBUtil.copyPropertyValue(origVal, orig, object, tidp);
                ((AbstractDBObject)object).setProperty(dprop, newVal);
            }
            Map<DBObjectID, DBObjectID> idMap = tidp.getIDMap();
            idMap.putAll(DBUtil.getTemporaryIDMap(DBUtil.getUppermostParent(object)));
            this.replaceReferenceIDs(object, idMap);
        }
    }
}

