/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HiveDatabase;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.sql.AbstractSQLFragment;

public class TblProperty
extends AbstractSQLFragment {
    @PropertyKey(value=TblProperty[].class, childOf={Table.class}, provider=HiveDatabase.class)
    public static final String LIST_PROPERTY = "TBLPROPERTIES";
    public static final String TYPE = "TblProperty";

    public TblProperty() {
    }

    public TblProperty(String name, String propValue) {
        this.setName(name);
        this.setTablePropertyValue(propValue);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getTablePropertyValue() {
        return (String)this.getProperty("tablePropertyValue");
    }

    public void setTablePropertyValue(String propValue) {
        this.setProperty("tablePropertyValue", propValue);
    }

    @Override
    public String getSQLText() {
        StringBuilder retval = new StringBuilder();
        this.appendWithQuotes(retval, this.getName());
        retval.append("=");
        this.appendWithQuotes(retval, this.getTablePropertyValue());
        return retval.toString();
    }

    private void appendWithQuotes(StringBuilder buff, String str) {
        String quot = "'";
        buff.append("'");
        if (str != null) {
            buff.append(String.valueOf(str).replace("'", "\\'"));
        }
        buff.append("'");
    }

    public static final void setTblProperty(AbstractDBObject obj, String name, String value) {
        AbstractDBObject.ChildSupport kids = TblProperty.getChildSupport(obj, LIST_PROPERTY);
        TblProperty tp = (TblProperty)kids.findChild(name);
        if (tp == null && value != null) {
            kids.addChild(new TblProperty(name, value));
        } else if (value == null) {
            kids.removeChild(tp);
        } else {
            tp.setTablePropertyValue(value);
        }
    }
}

