/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.diff.DBObjectIDComparator;
import oracle.javatools.util.ModelUtil;

public class IDByNameComparator
extends DBObjectIDComparator {
    public IDByNameComparator() {
        super(false);
    }

    @Override
    public int compare(DBObjectID id1, DBObjectID id2) {
        int retval;
        if (id1 instanceof ReferenceID && id2 instanceof ReferenceID) {
            retval = id1.toString().compareTo(id2.toString());
        } else {
            String s1 = this.getName(id1);
            String s2 = this.getName(id2);
            retval = ModelUtil.hasLength((String)s1) && ModelUtil.hasLength((String)s2) ? s1.compareTo(s2) : super.compare(id1, id2);
        }
        return retval;
    }

    private String getName(DBObjectID id) {
        String retval = null;
        if (id instanceof BaseObjectID) {
            retval = ((BaseObjectID)id).getName();
        }
        if (id != null && !ModelUtil.hasLength((String)retval)) {
            try {
                DBObject obj = id.resolveID();
                if (obj != null) {
                    retval = obj.getName();
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return retval;
    }
}

