/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.util.ModelUtil;

class DDLStatementWrapper
extends StatementWrapper {
    private final DDL m_ddl;
    private ExceptionHandler m_handler;

    public DDLStatementWrapper(Database db, DDL<? extends DDLType> ddl) {
        super(db, true, (String[])null);
        Collection<String> ddls = ddl.getStatements();
        this.setStatement(ddls.toArray(new String[ddl.size()]));
        this.m_ddl = ddl;
    }

    @Override
    protected Statement createStatment() throws SQLException {
        Statement stmt = super.createStatment();
        try {
            stmt.setEscapeProcessing(false);
        }
        catch (SQLException sqe) {
            DBLog.getLogger(this).fine("setEscapeProcessing: " + sqe.getMessage());
        }
        return stmt;
    }

    public void setExceptionHandler(ExceptionHandler handler) {
        this.m_handler = handler;
    }

    @Override
    public boolean execute() throws DBException {
        if (this.m_ddl == null || this.m_ddl.size() == 0) {
            return false;
        }
        return this.doExecute(new StatementWrapper.ExecutionRunnable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Boolean runImpl() throws DBException {
                retval = false;
                var2_2 = DDLStatementWrapper.access$000(DDLStatementWrapper.this);
                synchronized (var2_2) {
                    DDLStatementWrapper.access$100(DDLStatementWrapper.this, true);
                    try {
                        retval = true;
                        stmts = DDLStatementWrapper.access$200(DDLStatementWrapper.this).getStatementsForExecution();
                        var4_4 = stmts.values().iterator();
                        block7: while (true) {
                            if (var4_4.hasNext() == false) return retval;
                            swos = var4_4.next();
                            if (swos == null) continue;
                            var6_6 = swos.iterator();
                            while (true) {
                                if (var6_6.hasNext()) ** break;
                                continue block7;
                                swo = var6_6.next();
                                s = swo.getStatement();
                                if (!ModelUtil.hasLength((String)s)) continue;
                                try {
                                    retval = DDLStatementWrapper.access$300(DDLStatementWrapper.this, s) != false || retval != false;
                                }
                                catch (SQLException sqe) {
                                    if (DDLStatementWrapper.access$400(DDLStatementWrapper.this)) continue;
                                    dbe = DDLStatementWrapper.access$500(DDLStatementWrapper.this, swo.getObject(), s, sqe);
                                    if (DDLStatementWrapper.access$600(DDLStatementWrapper.this) == null) throw dbe;
                                    DDLStatementWrapper.access$600(DDLStatementWrapper.this).handleException(dbe);
                                }
                            }
                            break;
                        }
                    }
                    finally {
                        DDLStatementWrapper.this.close();
                        DDLStatementWrapper.access$700(DDLStatementWrapper.this, false);
                    }
                }
            }
        });
    }

    static /* synthetic */ Connection access$000(DDLStatementWrapper x0) {
        return x0.getConnection();
    }

    static /* synthetic */ void access$100(DDLStatementWrapper x0, boolean x1) {
        x0.setExecuting(x1);
    }

    static /* synthetic */ DDL access$200(DDLStatementWrapper x0) {
        return x0.m_ddl;
    }

    static /* synthetic */ boolean access$300(DDLStatementWrapper x0, String x1) throws SQLException {
        return x0.executeImpl(x1);
    }

    static /* synthetic */ boolean access$400(DDLStatementWrapper x0) {
        return x0.isIgnoreErrors();
    }

    static /* synthetic */ DBSQLException access$500(DDLStatementWrapper x0, DBObject x1, String x2, SQLException x3) {
        return x0.createDBSQLException(x1, x2, x3);
    }

    static /* synthetic */ ExceptionHandler access$600(DDLStatementWrapper x0) {
        return x0.m_handler;
    }

    static /* synthetic */ void access$700(DDLStatementWrapper x0, boolean x1) {
        x0.setExecuting(x1);
    }

    public static abstract class ExceptionHandler {
        public abstract void handleException(DBSQLException var1) throws DBException;
    }
}

