/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.DefaultTokenGenerator;
import oracle.javatools.db.ddl.TokenDDLGenerator;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public abstract class BundleDDLGenerator<T extends DDLType>
extends TokenDDLGenerator<T> {
    private final List<DDLList> m_bundles = new ArrayList<DDLList>();

    @Deprecated
    public BundleDDLGenerator(DBObjectProvider pro, String ... resourceNames) {
        this(pro.getClass(), pro, resourceNames);
    }

    public BundleDDLGenerator(Class<? extends Database> databaseClass, DBObjectProvider pro, String ... resourceNames) {
        super(databaseClass, pro);
        this.addResourceNames(resourceNames);
    }

    protected void addResourceNames(String ... resourceNames) {
        if (resourceNames != null) {
            for (String name : resourceNames) {
                if (!ModelUtil.hasLength((String)name)) continue;
                PropertiesDDLList file = new PropertiesDDLList(name);
                this.m_bundles.add(0, file);
            }
            this.registerBundleTokens();
        }
    }

    protected void addBundles(ResourceBundle ... bundles) {
        if (bundles != null) {
            for (ResourceBundle bundle : bundles) {
                if (bundle == null) continue;
                BundleDDLList file = new BundleDDLList(bundle);
                this.m_bundles.add(0, file);
            }
            this.registerBundleTokens();
        }
    }

    protected final String findResource(String key) {
        MissingResourceException mre = null;
        if (this.m_bundles != null) {
            for (int i = 0; i < this.m_bundles.size() - 1; ++i) {
                DDLList list = this.m_bundles.get(i);
                try {
                    return list.getString(key);
                }
                catch (MissingResourceException e) {
                    mre = e;
                    continue;
                }
            }
        }
        if (mre == null) {
            mre = new MissingResourceException("no resource found for " + key, null, key);
        }
        throw mre;
    }

    protected final void registerBundleTokens() {
        if (this.m_bundles.isEmpty()) {
            this.getLogger().fine(this.getClass().getSimpleName() + ": no registered resource bundles");
        } else {
            HashSet<String> tokens = new HashSet<String>();
            for (DDLList list : this.m_bundles) {
                Enumeration<String> keys = list.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (tokens.contains(key)) continue;
                    this.registerBundleEntry(key, list.getString(key));
                    tokens.add(key);
                }
            }
        }
    }

    protected void registerBundleEntry(String key, String code) {
        String[] toks = key.split("\\.");
        if (key.startsWith("GLOBAL")) {
            if (toks.length > 1) {
                if (ModelUtil.hasLength((String)code)) {
                    this.registerTokenGenerator(key.substring(7), new DefaultTokenGenerator(code));
                }
            } else {
                this.getLogger().log(Level.WARNING, "GLOBAL keyword found with no following .tokenName: " + key);
            }
        } else if (toks.length == 3) {
            this.registerDDLFromBundle(toks, key, code);
        } else if (toks.length == 4) {
            try {
                Integer.parseInt(toks[3]);
                this.registerDDLFromBundle(toks, key, code);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log(Level.WARNING, "fourth component not an int for: " + key);
            }
        }
    }

    private void registerDDLFromBundle(String[] toks, String key, String code) {
        if (!ModelUtil.hasLength((String)code)) {
            return;
        }
        String type = toks[0];
        String action = toks[1];
        String ddlTypeString = toks[2];
        if (!ModelUtil.hasLength((String)type)) {
            this.getLogger().severe("invalid bundle key (missing type): " + key);
        } else {
            if (Metadata.getInstance().getObjectClass(type) == null) {
                this.getLogger().warning("unknown object type for: " + key);
            }
            DDLType ddlType = null;
            try {
                ddlType = (DDLType)this.getDDLType(ddlTypeString);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "invalid bundle key (invalid ddltype): " + key, e);
            }
            if (ddlType == null) {
                this.getLogger().severe("invalid bundle key (no ddltype): " + key);
            } else if (action.equals("CREATE")) {
                this.registerCreateDDL(type, code, ddlType);
            } else if (action.equals("ALTER")) {
                this.registerAlterDDL(type, code, ddlType);
            } else if (action.equals("DROP")) {
                this.registerDropDDL(type, code, ddlType);
            } else if (action.equals("UNDELETE")) {
                this.registerUndeleteDDL(type, code, ddlType);
            } else {
                this.getLogger().severe("invalid bundle key (unknown action): " + key);
            }
        }
    }

    protected abstract T getDDLType(String var1);

    protected final void registerBundleCreateDDL(String type, String resName, T ddlType) {
        this.registerCreateDDL(type, this.findResource(resName), (DDLType)ddlType);
    }

    protected final void registerBundleDropDDL(String type, String resName, T ddlType) {
        this.registerDropDDL(type, this.findResource(resName), (DDLType)ddlType);
    }

    protected final void registerBundleUndeleteDDL(String type, String resName, T ddlType) {
        this.registerUndeleteDDL(type, this.findResource(resName), (DDLType)ddlType);
    }

    protected final void registerBundleAlterDDL(String type, String resName, T ddlType) {
        this.registerAlterDDL(type, this.findResource(resName), (DDLType)ddlType);
    }

    private class BundleDDLList
    implements DDLList {
        private ResourceBundle m_bundle;

        public BundleDDLList(ResourceBundle bundle) {
            this.m_bundle = bundle;
        }

        @Override
        public String getString(String key) {
            return this.m_bundle.getString(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.m_bundle.getKeys();
        }
    }

    private class PropertiesDDLList
    implements DDLList {
        private String m_name;
        private final Properties m_props = new Properties();

        public PropertiesDDLList(String resource) {
            this.m_name = resource;
            this.load();
        }

        private void load() {
            block6: {
                this.m_props.clear();
                try {
                    InputStream is = BundleDDLGenerator.this.getClass().getResourceAsStream(this.m_name);
                    if (is == null) {
                        BundleDDLGenerator.this.getLogger().log(Level.WARNING, "Error: resource " + this.m_name + " not found for ddl generation.");
                        break block6;
                    }
                    try {
                        this.m_props.load(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (Exception e) {
                    BundleDDLGenerator.this.getLogger().log(Level.WARNING, "Error opening resource " + this.m_name + " for ddl generator: " + e.getMessage());
                }
            }
        }

        @Override
        public String getString(String key) {
            if (this.m_props.containsKey(key)) {
                return this.m_props.getProperty(key);
            }
            throw new MissingResourceException("No such resource in bundle.", this.m_name, key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.m_props.propertyNames();
        }
    }

    private static interface DDLList {
        public String getString(String var1);

        public Enumeration<String> getKeys();
    }
}

