/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.ValidationException;

public class NameInUseException
extends ValidationException {
    private String m_name;
    private String m_existingName;
    private String m_existingType;
    private String m_message;

    public NameInUseException(DBObject obj) {
        this(obj, obj.getName(), null, null);
    }

    public NameInUseException(Collection<? extends DBObject> objs) {
        super(NameInUseException.firstObj(objs), (String)null);
        this.m_message = NameInUseException.getMessage(objs);
    }

    @Deprecated
    public NameInUseException(String name) {
        this((DBObject)null, name, null, null);
    }

    @Deprecated
    public NameInUseException(String name, String existingName, String existingType) {
        this((DBObject)null, name, existingName, existingType);
    }

    public NameInUseException(DBObject object, String existingName, String existingType) {
        this(object, object == null ? existingName : object.getName(), existingName, existingType);
    }

    public NameInUseException(DBObject object, DBObject existing) {
        this(object, object == null ? existing.getName() : object.getName(), DBUtil.getFullyQualifiedName(existing, false), existing.getType());
        this.setRelatedObjects(existing);
    }

    private NameInUseException(DBObject object, String name, String existingName, String existingType) {
        super(object, (String)null);
        this.m_existingType = existingType;
        this.m_existingName = existingName;
        this.m_name = name;
    }

    @Deprecated
    public NameInUseException(String name, String userName, String userType, String subUserType) {
        this((DBObject)null, name, userName, userType);
    }

    public String getName() {
        return this.m_name;
    }

    public String getExistingName() {
        return this.m_existingName;
    }

    public String getExistingType() {
        return this.m_existingType;
    }

    @Deprecated
    public String getUserName() {
        return this.m_existingName;
    }

    @Deprecated
    public String getUserType() {
        return this.m_existingType;
    }

    @Deprecated
    public String getSubUserType() {
        return null;
    }

    @Override
    public String getMessage() {
        if (this.m_message == null) {
            String existingType;
            String existingName;
            DBObject exObj = this.getObject();
            DBObject[] related = this.getRelatedObjects();
            if (related != null && related.length > 0 && related[0] != null) {
                DBObject relatedPar;
                boolean qual = false;
                if (related[0] instanceof ChildDBObject && exObj != null && (relatedPar = related[0].getParent()) != null && !DBUtil.areNamesAndTypesEqual(relatedPar, exObj.getParent())) {
                    qual = true;
                }
                existingName = qual ? DBUtil.getFullyQualifiedName(related[0], false) : related[0].getName();
                existingType = related[0].getType();
            } else {
                existingName = this.m_existingName;
                existingType = this.m_existingType;
            }
            this.m_message = existingName != null && (!existingName.equals(this.m_name) || exObj == null || !exObj.getType().equals(this.m_existingType)) ? APIBundle.format("DBOV_NAME_EXISTS2", this.m_name, existingType == null ? "" : DisplayNames.getTypeDisplayName(existingType), existingName) : APIBundle.format("DBOV_NAME_EXISTS", this.m_name);
        }
        return this.m_message;
    }

    private static DBObject firstObj(Collection<? extends DBObject> objs) {
        return objs == null || objs.size() == 0 ? null : objs.iterator().next();
    }

    private static String getMessage(Collection<? extends DBObject> objs) {
        StringBuilder buff = new StringBuilder();
        if (objs != null) {
            for (DBObject dBObject : objs) {
                if (dBObject == null) continue;
                if (buff.length() > 0) {
                    buff.append(", ");
                }
                buff.append(dBObject.getName());
            }
        }
        return buff.length() > 0 ? APIBundle.format("DBOV_NAMES_EXIST", buff.toString()) : APIBundle.format("DBOV_NAME_EXISTS", "");
    }
}

