/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.util.ModelUtil;

public class DBObjectProviderID {
    private final String m_type;
    private final Object m_identifier;

    public DBObjectProviderID(String type, Object identifier) {
        this.m_type = type;
        this.m_identifier = identifier;
    }

    public DBObjectProviderID(DBObjectProvider pro) {
        this(pro.getProviderType(), pro.getProviderIdentifier());
    }

    public String getType() {
        return this.m_type;
    }

    public Object getIdentifier() {
        return this.m_identifier;
    }

    public boolean isValid() {
        return this.m_identifier != null && DBObjectProviderFactory.getCreator(this.m_type) != null;
    }

    public DBObjectProvider resolveID() throws DBException {
        return DBObjectProviderFactory.findOrCreateProvider(this);
    }

    public boolean equals(Object other) {
        return other instanceof DBObjectProviderID && ModelUtil.areEqual((Object)this.m_type, (Object)((DBObjectProviderID)other).m_type) && ModelUtil.areEqual((Object)this.m_identifier, (Object)((DBObjectProviderID)other).m_identifier);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.m_type + ":" + this.m_identifier;
    }
}

