/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Relation;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.SQLFragment;

public class CheckConstraint
extends Constraint {
    public static final String CONSTRAINT_TYPE = "CheckConstraint";
    private transient boolean m_expressionBuilt = false;

    public CheckConstraint(String name, Relation relation) {
        super(name, relation);
    }

    public CheckConstraint() {
    }

    @Override
    public String getConstraintType() {
        return CONSTRAINT_TYPE;
    }

    @TextProperty(multiLine=true)
    public String getCheckCondition() {
        SQLFragment frag;
        String retval = (String)this.getProperty("checkCondition");
        if (retval == null && (frag = (SQLFragment)this.getPropertySupport().get("checkConditionFragment")) != null) {
            retval = frag.getSQLText();
        }
        return retval;
    }

    public void setCheckCondition(String condition) {
        this.setProperty("checkCondition", condition);
    }

    @Derived(value="checkCondition")
    public SQLFragment getCheckConditionFragment() {
        return (SQLFragment)this.getProperty("checkConditionFragment");
    }

    @Transient
    public void setCheckConditionFragment(SQLFragment condition) {
        this.setProperty("checkConditionFragment", condition);
    }

    @Override
    public DBObject findOwnedObject(DBObjectID id, boolean strict) {
        return this.findOwnedObject(id, strict, true);
    }

    @Override
    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        ((CheckConstraint)copy).m_expressionBuilt = this.m_expressionBuilt;
    }
}

