/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.json.common.LobInputStream;
import oracle.json.logging.OracleLog;
import oracle.json.util.ByteArray;
import oracle.json.util.ComponentTime;
import oracle.json.util.LimitedInputStream;
import oracle.soda.OracleBatchException;
import oracle.soda.OracleDocument;
import oracle.soda.OracleException;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.OracleCollectionImpl;
import oracle.soda.rdbms.impl.OracleDatabaseImpl;
import oracle.soda.rdbms.impl.OracleDocumentFragmentImpl;
import oracle.soda.rdbms.impl.OracleDocumentImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.sql.Datum;

public class TableCollectionImpl
extends OracleCollectionImpl {
    private static final int MAX_RANGE_TRANSFER = 0x100000;
    private static final int MIN_RANGE_TRANSFER = 4096;
    private static final int BATCH_MAX_SIZE = 100;
    private static final int SEQUENCE_BATCH_SIZE = 10;
    private final long[] seqCache = new long[10];
    private int seqCachePos = 10;

    TableCollectionImpl(OracleDatabaseImpl oracleDatabaseImpl, String string) {
        super(oracleDatabaseImpl, string);
    }

    TableCollectionImpl(OracleDatabaseImpl oracleDatabaseImpl, String string, CollectionDescriptor collectionDescriptor) {
        super(oracleDatabaseImpl, string, collectionDescriptor);
    }

    private String buildSelectForUpsert() {
        this.sb.setLength(0);
        boolean bl = false;
        if (this.options.creationColumnName != null) {
            this.sb.append("select to_char(\"");
            this.sb.append(this.options.creationColumnName);
            this.sb.append('\"');
            OracleDatabaseImpl.addTimestampSelectFormat(this.sb);
            bl = true;
        }
        if (this.returnVersion()) {
            if (bl) {
                this.sb.append(", \"");
            } else {
                this.sb.append("select \"");
            }
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\"");
        }
        this.addFrom(this.sb);
        return this.sb.toString();
    }

    boolean returnVersion() {
        return this.options.versionColumnName != null && (this.options.versioningMethod == 0 || this.options.versioningMethod == 2);
    }

    private String buildQuery() {
        this.sb.setLength(0);
        this.sb.append("select ");
        switch (this.options.keyDataType) {
            case 3: {
                this.sb.append("to_char(\"");
                this.sb.append(this.options.keyColumnName);
                this.sb.append("\")");
                break;
            }
            case 4: {
                this.sb.append("rawtohex(\"");
                this.sb.append(this.options.keyColumnName);
                this.sb.append("\")");
                break;
            }
            case 1: 
            case 2: {
                this.sb.append("\"");
                this.sb.append(this.options.keyColumnName);
                this.sb.append("\"");
            }
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.doctypeColumnName);
            this.sb.append("\"");
        }
        this.sb.append(",\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\"");
        if (this.options.timestampColumnName != null) {
            this.sb.append(",to_char(\"");
            this.sb.append(this.options.timestampColumnName);
            this.sb.append('\"');
            OracleDatabaseImpl.addTimestampSelectFormat(this.sb);
        }
        if (this.options.creationColumnName != null) {
            this.sb.append(",to_char(\"");
            this.sb.append(this.options.creationColumnName);
            this.sb.append('\"');
            OracleDatabaseImpl.addTimestampSelectFormat(this.sb);
        }
        if (this.options.versionColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\"");
        }
        this.addFrom(this.sb);
        this.addWhereKey(this.sb, false);
        return this.sb.toString();
    }

    private void addFrom(StringBuilder stringBuilder) {
        stringBuilder.append(" from \"");
        stringBuilder.append(this.options.dbObjectName);
        stringBuilder.append("\"");
    }

    private boolean returnInsertedTime() {
        return this.options.timestampColumnName != null || this.options.creationColumnName != null;
    }

    private boolean returnInsertedKey() {
        return this.options.keyAssignmentMethod == 3 || this.options.keySequenceName != null;
    }

    private boolean returnInsertedVersion() {
        return this.options.versionColumnName != null && this.options.versioningMethod == 0;
    }

    private boolean insertHasReturnClause(boolean bl) {
        return !bl && (this.returnInsertedKey() || this.returnInsertedTime() || this.returnInsertedVersion());
    }

    static void addInto(StringBuilder stringBuilder, int n) {
        if (n > 0) {
            stringBuilder.append(" into ?");
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(", ?");
            }
        }
    }

    static void addComma(StringBuilder stringBuilder, int n) {
        if (n > 0) {
            stringBuilder.append(", ");
        }
    }

    private String buildInsert(boolean bl) {
        this.sb.setLength(0);
        this.sb.append("insert into ");
        this.appendTable(this.sb);
        this.sb.append(" (\"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\",\"");
        if (this.options.doctypeColumnName != null) {
            this.sb.append(this.options.doctypeColumnName);
            this.sb.append("\",\"");
        }
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\"");
        if (this.options.timestampColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.timestampColumnName);
            this.sb.append("\"");
        }
        if (this.options.creationColumnName != null) {
            this.sb.append(",\"");
            this.sb.append(this.options.creationColumnName);
            this.sb.append("\"");
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(",\"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\"");
        }
        this.sb.append(") values (");
        if (this.options.keySequenceName != null && !bl) {
            switch (this.options.keyDataType) {
                case 3: {
                    this.sb.append("\"");
                    this.sb.append(this.options.keySequenceName);
                    this.sb.append("\".NEXTVAL");
                    break;
                }
                case 4: {
                    this.sb.append("hextoraw(substr(to_char(\"");
                    this.sb.append(this.options.keySequenceName);
                    this.sb.append("\".NEXTVAL,'0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'),3))");
                    break;
                }
                default: {
                    this.sb.append("to_char(\"");
                    this.sb.append(this.options.keySequenceName);
                    this.sb.append("\".NEXTVAL)");
                    break;
                }
            }
        } else if (this.options.keyAssignmentMethod == 3 && !bl) {
            switch (this.options.keyDataType) {
                case 3: {
                    this.sb.append("to_number(");
                    this.sb.append("rawtohex(SYS_GUID()),");
                    this.sb.append("'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX')");
                    break;
                }
                case 4: {
                    this.sb.append("SYS_GUID()");
                    break;
                }
                default: {
                    this.sb.append("rawtohex(SYS_GUID())");
                    break;
                }
            }
        } else {
            this.addKey(this.sb);
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(",?");
        }
        this.sb.append(",?");
        if (this.options.timestampColumnName != null) {
            if (bl) {
                OracleDatabaseImpl.addToTimestamp(",", this.sb);
            } else {
                this.sb.append(",sys_extract_utc(SYSTIMESTAMP)");
            }
        }
        if (this.options.creationColumnName != null) {
            if (bl) {
                OracleDatabaseImpl.addToTimestamp(",", this.sb);
            } else {
                this.sb.append(",sys_extract_utc(SYSTIMESTAMP)");
            }
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(",?");
        }
        this.sb.append(")");
        if (this.insertHasReturnClause(bl)) {
            this.sb.append(" returning ");
            int n = 0;
            if (this.returnInsertedKey()) {
                this.sb.append("\"");
                this.sb.append(this.options.keyColumnName);
                this.sb.append("\"");
                ++n;
            }
            if (this.returnInsertedTime()) {
                TableCollectionImpl.addComma(this.sb, n);
                this.sb.append("to_char(\"");
                if (this.options.timestampColumnName != null) {
                    this.sb.append(this.options.timestampColumnName);
                } else {
                    this.sb.append(this.options.creationColumnName);
                }
                this.sb.append('\"');
                OracleDatabaseImpl.addTimestampReturningFormat(this.sb);
                ++n;
            }
            if (this.returnInsertedVersion()) {
                TableCollectionImpl.addComma(this.sb, n);
                this.sb.append("\"");
                this.sb.append(this.options.versionColumnName);
                this.sb.append("\"");
                ++n;
            }
            TableCollectionImpl.addInto(this.sb, n);
        }
        return this.sb.toString();
    }

    private void addWhereKey(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(" where \"");
        stringBuilder.append(this.options.keyColumnName);
        stringBuilder.append(bl ? "\" > " : "\" = ");
        this.addKey(stringBuilder);
    }

    void addKey(StringBuilder stringBuilder) {
        switch (this.options.keyDataType) {
            case 3: {
                stringBuilder.append("to_number(?)");
                break;
            }
            case 4: {
                stringBuilder.append("?");
                break;
            }
            default: {
                stringBuilder.append("?");
            }
        }
    }

    private String buildUpsert() {
        this.sb.setLength(0);
        this.sb.append("merge into ");
        this.appendTable(this.sb);
        this.sb.append(" JSON$TARGET using (select ");
        this.sb.append(" ? \"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\" from SYS.DUAL) JSON$SOURCE");
        this.sb.append(" on (JSON$TARGET.\"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\" = JSON$SOURCE.\"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\")");
        this.sb.append(" when matched then update set JSON$TARGET.\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\" = ?");
        if (this.options.timestampColumnName != null) {
            this.sb.append(", JSON$TARGET.\"");
            this.sb.append(this.options.timestampColumnName);
            OracleDatabaseImpl.addToTimestamp("\" = ", this.sb);
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(", JSON$TARGET.\"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\" = ");
            if (this.options.versioningMethod == 2) {
                this.sb.append("(JSON$TARGET.\"");
                this.sb.append(this.options.versionColumnName);
                this.sb.append("\" + 1)");
            } else {
                this.sb.append("?");
            }
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(", JSON$TARGET.\"");
            this.sb.append(this.options.doctypeColumnName);
            this.sb.append("\" = ?");
        }
        this.sb.append(" when not matched then insert (JSON$TARGET.\"");
        this.sb.append(this.options.keyColumnName);
        this.sb.append("\",JSON$TARGET.\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\"");
        if (this.options.timestampColumnName != null) {
            this.sb.append(",JSON$TARGET.\"");
            this.sb.append(this.options.timestampColumnName);
            this.sb.append("\"");
        }
        if (this.options.creationColumnName != null) {
            this.sb.append(",JSON$TARGET.\"");
            this.sb.append(this.options.creationColumnName);
            this.sb.append("\"");
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(",JSON$TARGET.\"");
            this.sb.append(this.options.versionColumnName);
            this.sb.append("\"");
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(",JSON$TARGET.\"");
            this.sb.append(this.options.doctypeColumnName);
            this.sb.append("\"");
        }
        this.sb.append(") values (?,?");
        if (this.options.timestampColumnName != null) {
            OracleDatabaseImpl.addToTimestamp(",", this.sb);
        }
        if (this.options.creationColumnName != null) {
            OracleDatabaseImpl.addToTimestamp(",", this.sb);
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            this.sb.append(",?");
        }
        if (this.options.doctypeColumnName != null) {
            this.sb.append(",?");
        }
        this.sb.append(")");
        return this.sb.toString();
    }

    void setStreamBind(PreparedStatement preparedStatement, OracleDocument oracleDocument, int n) throws OracleException, SQLException {
        if (this.options.contentDataType != 4) {
            throw SODAUtils.makeException(SODAMessage.EX_UNSUPPORTED_MODE, this.options.uriName, this.options.getContentDataType());
        }
        InputStream inputStream = ((OracleDocumentImpl)oracleDocument).getContentAsStream();
        long l = -1L;
        if (inputStream instanceof LimitedInputStream) {
            try {
                l = inputStream.available();
            }
            catch (IOException iOException) {
                l = -1L;
            }
        }
        if (l == 0L) {
            preparedStatement.setNull(n, -3);
        } else if (l > 0L) {
            preparedStatement.setBlob(n, inputStream, l);
        } else {
            preparedStatement.setBlob(n, inputStream);
        }
    }

    @Override
    public void insert(OracleDocument oracleDocument) throws OracleException {
        this.insertAndGet(oracleDocument);
    }

    @Override
    public OracleDocument insertAndGet(OracleDocument oracleDocument) throws OracleException {
        if (oracleDocument == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "document");
        }
        this.writeCheck("insert");
        if (oracleDocument.getKey() != null && this.options.keyAssignmentMethod != 1) {
            throw SODAUtils.makeException(SODAMessage.EX_INPUT_DOC_HAS_KEY, new Object[0]);
        }
        OraclePreparedStatement oraclePreparedStatement = null;
        ResultSet resultSet = null;
        byte[] byArray = EMPTY_DATA;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = this.internalDriver;
        switch (this.options.keyAssignmentMethod) {
            case 4: {
                if (!bl) break;
                string = Long.toString(this.nextSequenceValue());
                break;
            }
            case 3: {
                if (!bl) break;
                string = this.db.nextGuid();
                if (this.options.keyDataType != 3) break;
                string = this.uidToDecimal(string);
                break;
            }
            case 2: {
                string = this.db.generateKey();
                if (this.options.keyDataType != 3) break;
                string = this.uidToDecimal(string);
                break;
            }
            default: {
                string = this.canonicalKey(oracleDocument.getKey());
            }
        }
        String string4 = this.buildInsert(bl);
        try {
            int n;
            long l;
            this.metrics.startTiming();
            oraclePreparedStatement = (OraclePreparedStatement)this.conn.prepareStatement(string4);
            int n2 = 0;
            if (!this.returnInsertedKey() || bl) {
                this.bindKeyColumn((PreparedStatement)oraclePreparedStatement, ++n2, string);
            }
            n2 = this.bindMediaTypeColumn((PreparedStatement)oraclePreparedStatement, n2, oracleDocument);
            boolean bl2 = true;
            if (!this.payloadBasedVersioning() && this.admin().isHeterogeneous() && ((OracleDocumentImpl)oracleDocument).hasStreamContent()) {
                this.setStreamBind((PreparedStatement)oraclePreparedStatement, oracleDocument, ++n2);
                bl2 = false;
            } else {
                byArray = this.bindPayloadColumn((PreparedStatement)oraclePreparedStatement, ++n2, oracleDocument);
            }
            if (this.returnInsertedTime() && bl) {
                l = this.db.getDatabaseTime();
                string3 = ComponentTime.stampToString(l);
                if (string3.endsWith("Z")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                if (this.options.timestampColumnName != null) {
                    oraclePreparedStatement.setString(++n2, string3);
                }
                if (this.options.creationColumnName != null) {
                    oraclePreparedStatement.setString(++n2, string3);
                }
            }
            if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                switch (this.options.versioningMethod) {
                    case 2: {
                        l = 1L;
                        oraclePreparedStatement.setLong(++n2, l);
                        string2 = Long.toString(l);
                        break;
                    }
                    case 1: {
                        long l2 = this.db.getDatabaseTime();
                        oraclePreparedStatement.setLong(++n2, l2);
                        string2 = Long.toString(l2);
                        break;
                    }
                    case 3: {
                        string2 = this.db.generateKey();
                        oraclePreparedStatement.setString(++n2, string2);
                        break;
                    }
                    default: {
                        if (!bl2) {
                            throw SODAUtils.makeException(SODAMessage.EX_NO_HASH_VERSION, this.options.uriName, this.options.getVersioningMethod());
                        }
                        string2 = this.computeVersion(byArray);
                        oraclePreparedStatement.setString(++n2, string2);
                    }
                }
            }
            if (!bl) {
                if (this.returnInsertedKey()) {
                    oraclePreparedStatement.registerReturnParameter(++n2, 12);
                }
                if (this.returnInsertedTime()) {
                    oraclePreparedStatement.registerReturnParameter(++n2, 12);
                }
                if (this.returnInsertedVersion()) {
                    oraclePreparedStatement.registerReturnParameter(++n2, 12);
                }
            }
            if ((n = oraclePreparedStatement.executeUpdate()) != 1) {
                throw SODAUtils.makeException(SODAMessage.EX_INSERT_FAILED, this.options.uriName);
            }
            if (this.insertHasReturnClause(bl)) {
                resultSet = oraclePreparedStatement.getReturnResultSet();
                if (resultSet.next()) {
                    int n3 = 0;
                    if (this.returnInsertedKey()) {
                        string = resultSet.getString(++n3);
                    }
                    if (this.returnInsertedTime()) {
                        string3 = OracleDatabaseImpl.getTimestamp(resultSet.getString(++n3));
                    }
                    if (this.returnInsertedVersion()) {
                        string2 = resultSet.getString(++n3);
                    }
                } else {
                    SODAUtils.makeException(SODAMessage.EX_INSERT_FAILED, this.options.uriName);
                }
            }
            oraclePreparedStatement.close();
            oraclePreparedStatement = null;
            this.metrics.recordWrites(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string4);
            }
            catch (Throwable throwable) {
                for (String string5 : SODAUtils.closeCursor(oraclePreparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string5);
                }
                throw throwable;
            }
        }
        for (String string6 : SODAUtils.closeCursor((Statement)oraclePreparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string6);
        }
        OracleDocumentImpl oracleDocumentImpl = new OracleDocumentImpl(string, string2, string3);
        oracleDocumentImpl.setCreatedOn(string3);
        String string7 = oracleDocument.getMediaType();
        this.setContentType(string7, oracleDocumentImpl);
        return oracleDocumentImpl;
    }

    @Override
    public void save(OracleDocument oracleDocument) throws OracleException {
        this.saveAndGet(oracleDocument);
    }

    @Override
    public OracleDocument saveAndGet(OracleDocument oracleDocument) throws OracleException {
        this.writeCheck("save");
        if (this.options.keyAssignmentMethod == 1) {
            if (oracleDocument == null) {
                throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "document");
            }
            String string = oracleDocument.getKey();
            return this.upsert(string, oracleDocument);
        }
        return this.insertAndGet(oracleDocument);
    }

    @Override
    public void insert(Iterator<OracleDocument> iterator) throws OracleBatchException {
        this.insertAndGet(iterator);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<OracleDocument> insertAndGet(Iterator<OracleDocument> iterator) throws OracleBatchException {
        int n = 0;
        int n2 = 0;
        if (iterator == null) {
            throw SODAUtils.makeBatchException(SODAMessage.EX_ARG_CANNOT_BE_NULL, n2, "documents");
        }
        if (this.isReadOnly()) {
            if (OracleLog.isLoggingEnabled()) {
                log.warning("Write to " + this.options.uriName + " not allowed");
            }
            throw SODAUtils.makeBatchException(SODAMessage.EX_READ_ONLY, n2, this.options.uriName, "insert");
        }
        if (!iterator.hasNext()) {
            return EMPTY_LIST;
        }
        ArrayList<OracleDocument> arrayList = new ArrayList<OracleDocument>();
        OraclePreparedStatement oraclePreparedStatement = null;
        String string = this.buildInsert(true);
        boolean bl = false;
        try {
            Object object;
            if (this.conn.getAutoCommit()) {
                this.conn.setAutoCommit(false);
                bl = true;
            }
            this.metrics.startTiming();
            oraclePreparedStatement = (OraclePreparedStatement)this.conn.prepareStatement(string);
            long l = this.db.getDatabaseTime();
            String string2 = ComponentTime.stampToString(l);
            if (string2.endsWith("Z")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            while (iterator.hasNext()) {
                Object object2;
                object = iterator.next();
                if (object == null) {
                    object2 = SODAUtils.makeBatchException(SODAMessage.EX_ITERATOR_RETURNED_NULL_ELEMENT, n2, "documents", n2);
                    throw object2;
                }
                if (object.getKey() != null && this.options.keyAssignmentMethod != 1) {
                    object2 = SODAUtils.makeBatchException(SODAMessage.EX_ITERATOR_RETURNED_DOC_WITH_KEY, n2, "documents", n2);
                    throw object2;
                }
                object2 = null;
                String string3 = null;
                switch (this.options.keyAssignmentMethod) {
                    case 4: {
                        object2 = Long.toString(this.nextSequenceValue());
                        break;
                    }
                    case 3: {
                        object2 = this.db.nextGuid();
                        if (this.options.keyDataType != 3) break;
                        object2 = this.uidToDecimal((String)object2);
                        break;
                    }
                    case 2: {
                        object2 = this.db.generateKey();
                        if (this.options.keyDataType != 3) break;
                        object2 = this.uidToDecimal((String)object2);
                        break;
                    }
                    default: {
                        object2 = this.canonicalKey(object.getKey());
                    }
                }
                int n3 = 0;
                this.bindKeyColumn((PreparedStatement)oraclePreparedStatement, ++n3, (String)object2);
                n3 = this.bindMediaTypeColumn((PreparedStatement)oraclePreparedStatement, n3, (OracleDocument)object);
                byte[] byArray = this.bindPayloadColumn((PreparedStatement)oraclePreparedStatement, ++n3, (OracleDocument)object);
                if (this.options.timestampColumnName != null) {
                    oraclePreparedStatement.setString(++n3, string2);
                }
                if (this.options.creationColumnName != null) {
                    oraclePreparedStatement.setString(++n3, string2);
                }
                if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                    switch (this.options.versioningMethod) {
                        case 2: {
                            long l2 = 1L;
                            oraclePreparedStatement.setLong(++n3, l2);
                            string3 = Long.toString(l2);
                            break;
                        }
                        case 1: {
                            oraclePreparedStatement.setLong(++n3, l);
                            string3 = Long.toString(l);
                            break;
                        }
                        case 3: {
                            string3 = this.db.generateKey();
                            oraclePreparedStatement.setString(++n3, string3);
                            break;
                        }
                        default: {
                            string3 = this.computeVersion(byArray);
                            oraclePreparedStatement.setString(++n3, string3);
                        }
                    }
                }
                oraclePreparedStatement.addBatch();
                if (++n2 % 100 == 0) {
                    int[] nArray = oraclePreparedStatement.executeBatch();
                    n += nArray.length;
                }
                OracleDocumentImpl oracleDocumentImpl = new OracleDocumentImpl((String)object2, string3, string2);
                oracleDocumentImpl.setCreatedOn(string2);
                String string4 = object.getMediaType();
                this.setContentType(string4, oracleDocumentImpl);
                arrayList.add(oracleDocumentImpl);
            }
            if (n2 % 100 != 0) {
                object = oraclePreparedStatement.executeBatch();
                n += ((Object)object).length;
            }
            oraclePreparedStatement.close();
            oraclePreparedStatement = null;
            this.metrics.recordWrites(n2, 100);
        }
        catch (OracleException oracleException) {
            try {
                OracleBatchException oracleBatchException = this.convertToOracleBatchException(oracleException, n2, string);
                oracleBatchException.setNextException(this.completeTxnAndRestoreAutoCommit(bl, false));
                throw oracleBatchException;
                catch (SQLException sQLException) {
                    int n4 = 0;
                    n4 = sQLException instanceof BatchUpdateException ? (n += ((BatchUpdateException)sQLException).getUpdateCounts().length) : n2;
                    OracleBatchException oracleBatchException2 = SODAUtils.makeBatchExceptionWithSQLText(sQLException, n4, string);
                    oracleBatchException2.setNextException(this.completeTxnAndRestoreAutoCommit(bl, false));
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(sQLException.toString());
                    }
                    throw oracleBatchException2;
                }
                catch (RuntimeException runtimeException) {
                    this.completeTxnAndRestoreAutoCommit(bl, false);
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(runtimeException.toString());
                    }
                    throw runtimeException;
                }
                catch (Error error) {
                    this.completeTxnAndRestoreAutoCommit(bl, false);
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(error.toString());
                    }
                    throw error;
                }
            }
            catch (Throwable throwable) {
                Iterator<String> iterator2 = SODAUtils.closeCursor(oraclePreparedStatement, null).iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        throw throwable;
                    }
                    String string5 = iterator2.next();
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string5);
                }
            }
        }
        for (String string6 : SODAUtils.closeCursor((Statement)oraclePreparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string6);
        }
        OracleException oracleException = this.completeTxnAndRestoreAutoCommit(bl, true);
        if (oracleException != null) {
            throw new OracleBatchException(oracleException, n2);
        }
        return arrayList;
    }

    private OracleBatchException convertToOracleBatchException(OracleException oracleException, int n, String string) {
        if (oracleException instanceof OracleBatchException) {
            return (OracleBatchException)oracleException;
        }
        OracleBatchException oracleBatchException = null;
        Throwable throwable = oracleException.getCause();
        oracleBatchException = throwable != null && throwable instanceof SQLException ? SODAUtils.makeBatchExceptionWithSQLText(throwable, n, string) : new OracleBatchException(oracleException, n);
        return oracleBatchException;
    }

    private OracleException completeTxnAndRestoreAutoCommit(boolean bl, boolean bl2) {
        OracleException oracleException = null;
        if (bl) {
            try {
                if (!bl2) {
                    this.conn.rollback();
                } else {
                    this.conn.commit();
                }
            }
            catch (SQLException sQLException) {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                oracleException = new OracleException(sQLException);
            }
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                if (oracleException == null) {
                    oracleException = new OracleException(sQLException);
                }
                oracleException.setNextException(new OracleException(sQLException));
            }
        }
        return oracleException;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OracleDocument upsert(String string, OracleDocument oracleDocument) throws OracleException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = this.buildUpsert();
        OracleDocumentImpl oracleDocumentImpl = null;
        string = this.canonicalKey(string);
        boolean bl = false;
        try {
            long l = this.db.getDatabaseTime();
            String string3 = ComponentTime.stampToString(l);
            if (string3.endsWith("Z")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            this.metrics.startTiming();
            if (this.conn.getAutoCommit()) {
                this.conn.setAutoCommit(false);
                bl = true;
            }
            preparedStatement = this.conn.prepareStatement(string2);
            int n = 0;
            this.bindKeyColumn(preparedStatement, ++n, string);
            byte[] byArray = oracleDocument.getContentAsByteArray();
            if (byArray == null) {
                byArray = EMPTY_DATA;
            }
            String string4 = null;
            switch (this.options.contentDataType) {
                case 1: {
                    string4 = TableCollectionImpl.stringFromBytes(byArray);
                    preparedStatement.setString(++n, string4);
                    break;
                }
                case 5: {
                    string4 = TableCollectionImpl.stringFromBytes(byArray);
                    this.setPayloadClob(preparedStatement, ++n, string4);
                    break;
                }
                case 3: {
                    string4 = TableCollectionImpl.stringFromBytes(byArray);
                    preparedStatement.setNString(++n, string4);
                    break;
                }
                case 6: {
                    string4 = TableCollectionImpl.stringFromBytes(byArray);
                    this.setPayloadNclob(preparedStatement, ++n, string4);
                    break;
                }
                case 2: {
                    preparedStatement.setBytes(++n, byArray);
                    break;
                }
                case 4: {
                    ((OraclePreparedStatement)preparedStatement).setBytesForBlob(++n, byArray);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.options.timestampColumnName != null) {
                preparedStatement.setString(++n, string3);
            }
            String string5 = null;
            if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                switch (this.options.versioningMethod) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        preparedStatement.setLong(++n, l);
                        string5 = Long.toString(l);
                        break;
                    }
                    case 3: {
                        string5 = this.db.generateKey();
                        preparedStatement.setString(++n, string5);
                        break;
                    }
                    default: {
                        string5 = this.computeVersion(byArray);
                        preparedStatement.setString(++n, string5);
                    }
                }
            }
            n = this.bindMediaTypeColumn(preparedStatement, n, oracleDocument);
            this.bindKeyColumn(preparedStatement, ++n, string);
            switch (this.options.contentDataType) {
                case 1: {
                    preparedStatement.setString(++n, string4);
                    break;
                }
                case 5: {
                    this.setPayloadClob(preparedStatement, ++n, string4);
                    break;
                }
                case 3: {
                    preparedStatement.setNString(++n, string4);
                    break;
                }
                case 6: {
                    this.setPayloadNclob(preparedStatement, ++n, string4);
                    break;
                }
                case 2: {
                    preparedStatement.setBytes(++n, byArray);
                    break;
                }
                case 4: {
                    ((OraclePreparedStatement)preparedStatement).setBytesForBlob(++n, byArray);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.options.timestampColumnName != null) {
                preparedStatement.setString(++n, string3);
            }
            if (this.options.creationColumnName != null) {
                preparedStatement.setString(++n, string3);
            }
            if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
                switch (this.options.versioningMethod) {
                    case 2: {
                        long l2 = 1L;
                        preparedStatement.setLong(++n, l2);
                        string5 = Long.toString(l2);
                        break;
                    }
                    case 1: {
                        preparedStatement.setLong(++n, l);
                        string5 = Long.toString(l);
                        break;
                    }
                    default: {
                        preparedStatement.setString(++n, string5);
                    }
                }
            }
            this.bindMediaTypeColumn(preparedStatement, n, oracleDocument);
            int n2 = preparedStatement.executeUpdate();
            if (n2 != 1) {
                throw SODAUtils.makeException(SODAMessage.EX_SAVE_FAILED, this.options.uriName);
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
            String string6 = null;
            if (this.options.creationColumnName != null || this.returnVersion()) {
                this.metrics.startTiming();
                preparedStatement = this.conn.prepareStatement(this.buildSelectForUpsert());
                resultSet = preparedStatement.executeQuery();
                n = 0;
                boolean bl2 = resultSet.next();
                if (!bl2) {
                    throw SODAUtils.makeException(SODAMessage.EX_SAVE_FAILED, this.options.uriName);
                }
                if (this.options.creationColumnName != null) {
                    string6 = resultSet.getString(++n);
                }
                if (this.returnVersion()) {
                    string5 = resultSet.getString(++n);
                }
                resultSet.close();
                resultSet = null;
                preparedStatement.close();
                preparedStatement = null;
                this.metrics.recordReads(1, 1);
            }
            oracleDocumentImpl = new OracleDocumentImpl(string, string5, string3);
            oracleDocumentImpl.setCreatedOn(string6);
            String string7 = oracleDocument.getMediaType();
            this.setContentType(string7, oracleDocumentImpl);
        }
        catch (OracleException oracleException) {
            try {
                oracleException.setNextException(this.completeTxnAndRestoreAutoCommit(bl, false));
                throw oracleException;
                catch (SQLException sQLException) {
                    OracleException oracleException2 = SODAUtils.makeExceptionWithSQLText(sQLException, string2);
                    oracleException2.setNextException(this.completeTxnAndRestoreAutoCommit(bl, false));
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(sQLException.toString());
                    }
                    throw oracleException2;
                }
                catch (RuntimeException runtimeException) {
                    this.completeTxnAndRestoreAutoCommit(bl, false);
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(runtimeException.toString());
                    }
                    throw runtimeException;
                }
                catch (Error error) {
                    this.completeTxnAndRestoreAutoCommit(bl, false);
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(error.toString());
                    }
                    throw error;
                }
            }
            catch (Throwable throwable) {
                Iterator<String> iterator = SODAUtils.closeCursor(preparedStatement, resultSet).iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw throwable;
                    }
                    String string8 = iterator.next();
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string8);
                }
            }
        }
        for (String string9 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string9);
        }
        OracleException oracleException = this.completeTxnAndRestoreAutoCommit(bl, true);
        if (oracleException != null) {
            throw oracleException;
        }
        return oracleDocumentImpl;
    }

    @Override
    public OracleDocumentFragmentImpl findFragment(String string, long l, int n) throws OracleException {
        OracleDocumentFragmentImpl oracleDocumentFragmentImpl = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        byte[] byArray = null;
        LobInputStream lobInputStream = null;
        boolean bl = false;
        String string2 = this.buildQuery();
        string = this.canonicalKey(string);
        if (this.admin().isHeterogeneous()) {
            bl = true;
        }
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string2);
            this.bindKeyColumn(preparedStatement, 1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int n2 = 0;
                String string3 = resultSet.getString(++n2);
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                long l2 = -1L;
                if (this.options.doctypeColumnName != null) {
                    if ((string4 = resultSet.getString(++n2)) == null) {
                        bl = false;
                    } else if (string4.equalsIgnoreCase("application/json")) {
                        bl = false;
                    }
                }
                if (bl) {
                    Blob blob;
                    if (this.options.contentDataType != 4) {
                        throw SODAUtils.makeException(SODAMessage.EX_UNSUPPORTED_MODE, this.options.uriName, this.options.getContentDataType());
                    }
                    if ((blob = resultSet.getBlob(++n2)) != null) {
                        l2 = blob.length();
                        if (l2 > 0L) {
                            InputStream inputStream;
                            if (n < 0 || (long)n + l > l2) {
                                n = (int)(l2 - l);
                            }
                            if ((l > 0L || (long)n + l < l2) && n <= 0x100000 && l2 > 4096L && l2 >> 1 > (long)n) {
                                byArray = blob.getBytes(l + 1L, n);
                                bl = false;
                            }
                            if (bl && (inputStream = blob.getBinaryStream()) != null) {
                                lobInputStream = new LobInputStream(blob, inputStream, (int)l2);
                                lobInputStream.setMetrics(this.metrics);
                            }
                        }
                        if (lobInputStream == null && byArray == null) {
                            lobInputStream = new LobInputStream();
                        }
                    }
                } else {
                    byArray = this.readPayloadColumn(resultSet, ++n2);
                }
                if (this.options.timestampColumnName != null) {
                    string5 = resultSet.getString(++n2);
                }
                if (this.options.creationColumnName != null) {
                    string6 = resultSet.getString(++n2);
                }
                if (this.options.versionColumnName != null) {
                    string7 = resultSet.getString(++n2);
                }
                if (lobInputStream != null) {
                    oracleDocumentFragmentImpl = new OracleDocumentFragmentImpl(string3, string7, string5, lobInputStream, string4);
                } else {
                    oracleDocumentFragmentImpl = new OracleDocumentFragmentImpl(string3, string7, string5, byArray);
                    this.setContentType(string4, oracleDocumentFragmentImpl);
                    if (l2 > 0L) {
                        oracleDocumentFragmentImpl.setFragmentInfo(l, l2);
                    }
                }
                if (string6 != null) {
                    oracleDocumentFragmentImpl.setCreatedOn(string6);
                }
            }
            this.metrics.recordReads(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                block32: {
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(sQLException.toString());
                    }
                    try {
                        if (lobInputStream != null) {
                            lobInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!OracleLog.isLoggingEnabled()) break block32;
                        log.severe(iOException.toString());
                    }
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string2);
            }
            catch (Throwable throwable) {
                for (String string8 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string8);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
        return oracleDocumentFragmentImpl;
    }

    private byte[] readPayloadColumn(ResultSet resultSet, int n) throws SQLException {
        byte[] byArray = EMPTY_DATA;
        switch (this.options.contentDataType) {
            case 1: 
            case 5: {
                String string = resultSet.getString(n);
                if (string == null) break;
                byArray = string.getBytes(ByteArray.DEFAULT_CHARSET);
                break;
            }
            case 3: 
            case 6: {
                String string = resultSet.getNString(n);
                if (string == null) break;
                byArray = string.getBytes(ByteArray.DEFAULT_CHARSET);
                break;
            }
            case 2: 
            case 4: {
                byArray = resultSet.getBytes(n);
            }
        }
        return byArray;
    }

    private long nextSequenceValue() throws OracleException {
        if (this.seqCachePos >= this.seqCache.length) {
            this.fetchSequence();
        }
        return this.seqCache[this.seqCachePos++];
    }

    private String buildSequenceFetch() {
        this.sb.setLength(0);
        this.sb.append("declare\n");
        this.sb.append("  type NTAB is table of number index by binary_integer;\n");
        this.sb.append("  N number;\n");
        this.sb.append("  X number;\n");
        this.sb.append("  K ntab;\n");
        this.sb.append("begin\n");
        this.sb.append("  N := ?;\n");
        this.sb.append("  for I in 1..N loop\n");
        this.sb.append("    select \"");
        this.sb.append(this.options.keySequenceName);
        this.sb.append("\".NEXTVAL into X from SYS.DUAL;\n");
        this.sb.append("    K(I) := X;\n");
        this.sb.append("  end loop;\n");
        this.sb.append("  ? := K;\n");
        this.sb.append("end;");
        return this.sb.toString();
    }

    private void fetchSequence() throws OracleException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = this.buildSequenceFetch();
        int n = 10;
        try {
            Object object = null;
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.setInt(1, n);
            oracleCallableStatement.registerIndexTableOutParameter(2, n, 2, 0);
            oracleCallableStatement.execute();
            object = oracleCallableStatement.getOraclePlsqlIndexTable(2);
            n = ((Datum[])object).length;
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    this.seqCache[i] = object[i].longValue();
                }
            }
            this.seqCachePos -= n;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordsSequenceBatchFetches();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string2 : SODAUtils.closeCursor(oracleCallableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string2);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor((Statement)oracleCallableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
    }

    void setContentType(String string, OracleDocumentImpl oracleDocumentImpl) {
        if (string != null || this.options.doctypeColumnName != null) {
            oracleDocumentImpl.setContentType(string);
        }
    }

    int bindMediaTypeColumn(PreparedStatement preparedStatement, int n, OracleDocument oracleDocument) throws SQLException {
        String string = oracleDocument.getMediaType();
        if (this.options.doctypeColumnName != null) {
            if (string != null) {
                preparedStatement.setString(++n, string);
            } else {
                preparedStatement.setNull(++n, 12);
            }
        }
        return n;
    }

    void bindKeyColumn(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        switch (this.options.keyDataType) {
            case 3: {
                preparedStatement.setString(n, string);
                break;
            }
            case 4: {
                preparedStatement.setBytes(n, ByteArray.hexToRaw(string));
                break;
            }
            case 1: {
                preparedStatement.setString(n, string);
                break;
            }
            case 2: {
                preparedStatement.setNString(n, string);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void setPayloadBlob(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        if (this.internalDriver) {
            preparedStatement.setBlob(n, new ByteArrayInputStream(byArray), byArray.length);
        } else {
            preparedStatement.setBytes(n, byArray);
        }
    }

    private void setPayloadClob(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (this.internalDriver) {
            preparedStatement.setClob(n, new StringReader(string));
        } else {
            preparedStatement.setString(n, string);
        }
    }

    private void setPayloadNclob(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (this.internalDriver) {
            preparedStatement.setNClob(n, new StringReader(string));
        } else {
            preparedStatement.setNString(n, string);
        }
    }

    byte[] bindPayloadColumn(PreparedStatement preparedStatement, int n, OracleDocument oracleDocument) throws SQLException, OracleException {
        byte[] byArray = oracleDocument.getContentAsByteArray();
        if (byArray == null) {
            byArray = OracleCollectionImpl.EMPTY_DATA;
        }
        switch (this.options.contentDataType) {
            case 1: {
                String string = TableCollectionImpl.stringFromBytes(byArray);
                preparedStatement.setString(n, string);
                break;
            }
            case 5: {
                String string = TableCollectionImpl.stringFromBytes(byArray);
                this.setPayloadClob(preparedStatement, n, string);
                break;
            }
            case 3: {
                String string = TableCollectionImpl.stringFromBytes(byArray);
                preparedStatement.setNString(n, string);
                break;
            }
            case 6: {
                String string = TableCollectionImpl.stringFromBytes(byArray);
                this.setPayloadNclob(preparedStatement, n, string);
                break;
            }
            case 2: {
                preparedStatement.setBytes(n, byArray);
                break;
            }
            case 4: {
                this.setPayloadBlob(preparedStatement, n, byArray);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return byArray;
    }

    void addFormat(StringBuilder stringBuilder) {
        if (this.options.contentDataType == 4 || this.options.contentDataType == 2) {
            stringBuilder.append(" format json");
        }
    }
}

