/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.soda.OracleBatchException;
import oracle.soda.OracleException;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SQLTextCarrier;

public final class SODAUtils {
    public static OracleException makeException(SODAMessage sODAMessage, Object ... objectArray) {
        return new OracleException(sODAMessage.get(objectArray), sODAMessage.getKey());
    }

    static OracleException makeException(SODAMessage sODAMessage, Throwable throwable, Object ... objectArray) {
        return new OracleException(sODAMessage.get(objectArray), throwable, sODAMessage.getKey());
    }

    static OracleBatchException makeBatchException(SODAMessage sODAMessage, int n, Object ... objectArray) {
        return new OracleBatchException(sODAMessage.get(objectArray), sODAMessage.getKey(), n);
    }

    static OracleException makeExceptionWithSQLText(Throwable throwable, String string) {
        return SODAUtils.makeExceptionWithSQLText(null, throwable, string, new Object[0]);
    }

    static OracleException makeExceptionWithSQLText(SODAMessage sODAMessage, Throwable throwable, String string, Object ... objectArray) {
        class OracleSQLException
        extends OracleException
        implements SQLTextCarrier {
            String sqlText;

            public OracleSQLException(String string, Throwable throwable, int n, String string2) {
                super(string, throwable, n);
                this.sqlText = string2;
            }

            public OracleSQLException(Throwable throwable, String string) {
                super(throwable);
                this.sqlText = string;
            }

            @Override
            public String getSQL() {
                return this.sqlText;
            }
        }
        if (sODAMessage != null) {
            return new OracleSQLException(sODAMessage.get(objectArray), throwable, sODAMessage.getKey(), string);
        }
        return new OracleSQLException(throwable, string);
    }

    static OracleBatchException makeBatchExceptionWithSQLText(Throwable throwable, int n, String string) {
        class OracleBatchSQLException
        extends OracleBatchException
        implements SQLTextCarrier {
            String sqlText;

            public OracleBatchSQLException(Throwable throwable, int n, String string) {
                super(throwable, n);
                this.sqlText = string;
            }

            @Override
            public String getSQL() {
                return this.sqlText;
            }
        }
        return new OracleBatchSQLException(throwable, n, string);
    }

    public static List<String> closeCursor(Statement statement, ResultSet resultSet) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            arrayList.add(sQLException.getMessage());
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            arrayList.add(sQLException.getMessage());
        }
        return arrayList;
    }
}

