/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.json.common.MetricsCollector;
import oracle.json.logging.OracleLog;
import oracle.json.parser.AndORTree;
import oracle.json.parser.Predicate;
import oracle.json.parser.QueryException;
import oracle.json.parser.ValueTypePair;
import oracle.json.util.JsonByteArray;
import oracle.soda.OracleCursor;
import oracle.soda.OracleDocument;
import oracle.soda.OracleException;
import oracle.soda.OracleOperationBuilder;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.Operation;
import oracle.soda.rdbms.impl.OracleCollectionImpl;
import oracle.soda.rdbms.impl.OracleCursorImpl;
import oracle.soda.rdbms.impl.OracleDatabaseImpl;
import oracle.soda.rdbms.impl.OracleDocumentImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.soda.rdbms.impl.TableCollectionImpl;

public class OracleOperationBuilderImpl
implements OracleOperationBuilder {
    private static final int MAX_NUM_OF_KEYS = 1000;
    private static final Logger log = Logger.getLogger(OracleOperationBuilderImpl.class.getName());
    private String key;
    private boolean isStartKey;
    private boolean ascending;
    private boolean startKeyInclusive;
    Set<String> keys;
    private String since;
    private String until;
    private boolean timeRangeInclusive;
    private OracleDocument filterSpec;
    private AndORTree tree;
    private String version;
    private String lastModified;
    private boolean lock;
    private int limit;
    private long skip;
    boolean headerOnly;
    private int firstRows;
    private final OracleCollectionImpl collection;
    private final MetricsCollector metrics;
    private final OracleConnection connection;
    private final CollectionDescriptor options;
    private String computedVersion;
    private static final String NULL = "null";
    private static final boolean PAGINATION_WORKAROUND = Boolean.valueOf(System.getProperty("oracle.soda.rdbms.paginationWorkaround", "true"));
    private boolean return_query = false;
    private JsonByteArray return_sql_json = null;

    OracleOperationBuilderImpl(OracleCollectionImpl oracleCollectionImpl, OracleConnection oracleConnection) {
        this.collection = oracleCollectionImpl;
        this.options = oracleCollectionImpl.getOptions();
        this.connection = oracleConnection;
        this.ascending = true;
        this.startKeyInclusive = true;
        this.timeRangeInclusive = true;
        this.firstRows = -1;
        this.metrics = oracleCollectionImpl.getMetrics();
    }

    public void returnQuery(boolean bl) {
        this.return_query = bl;
        this.return_sql_json = bl ? new JsonByteArray(1000) : null;
    }

    private void beginQueryRecord(String string) {
        this.return_sql_json.appendOpenBrace();
        this.return_sql_json.appendValue("sql");
        this.return_sql_json.appendColon();
        this.return_sql_json.appendValue(string);
    }

    private void recordNamedBind(String string, String string2) {
        this.return_sql_json.appendComma();
        this.return_sql_json.appendValue(string);
        this.return_sql_json.appendColon();
        this.return_sql_json.appendValue(string2);
    }

    private void recordQueryBind(int n, ValueTypePair valueTypePair) {
        this.return_sql_json.appendComma();
        this.return_sql_json.appendValue("B" + Integer.toString(n));
        this.return_sql_json.appendColon();
        switch (valueTypePair.getType()) {
            case 1: {
                this.return_sql_json.append(valueTypePair.getNumberValue().toString());
                break;
            }
            case 2: {
                this.return_sql_json.appendValue(valueTypePair.getStringValue());
                break;
            }
            case 3: {
                this.return_sql_json.append(valueTypePair.getBooleanValue() ? "true" : "false");
                break;
            }
            default: {
                this.return_sql_json.append(NULL);
            }
        }
    }

    private void recordQueryKey(int n, String string) {
        this.return_sql_json.appendComma();
        this.return_sql_json.appendValue("key_" + Integer.toString(n));
        this.return_sql_json.appendColon();
        if (string == null) {
            this.return_sql_json.append(NULL);
        } else {
            this.return_sql_json.appendValue(string);
        }
    }

    @Override
    public OracleOperationBuilder key(String string) throws OracleException {
        this.key = string;
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "key");
        }
        this.maxNumberOfKeysCheck();
        this.keys = null;
        this.isStartKey = false;
        this.ascending = true;
        this.startKeyInclusive = true;
        return this;
    }

    @Override
    public OracleOperationBuilder keys(Set<String> set) throws OracleException {
        if (set == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "keys");
        }
        if (set.isEmpty()) {
            throw SODAUtils.makeException(SODAMessage.EX_SET_IS_EMPTY, "keys");
        }
        if (set.contains(null)) {
            throw SODAUtils.makeException(SODAMessage.EX_SET_CONTAINS_NULL, "keys");
        }
        this.keys = new HashSet<String>(set);
        this.maxNumberOfKeysCheck();
        this.key = null;
        this.isStartKey = false;
        this.ascending = true;
        this.startKeyInclusive = true;
        return this;
    }

    public OracleOperationBuilder startKey(String string, Boolean bl, Boolean bl2) throws OracleException {
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "startKey");
        }
        this.isStartKey = true;
        this.key = string;
        this.ascending = bl != null ? bl : true;
        this.startKeyInclusive = bl2 != null ? bl2 : true;
        this.keys = null;
        return this;
    }

    public OracleOperationBuilder timeRange(String string, String string2, Boolean bl) throws OracleException {
        if (this.options.timestampColumnName == null) {
            throw SODAUtils.makeException(SODAMessage.EX_NO_TIMESTAMP, this.options.uriName);
        }
        if (string == null && string2 == null) {
            throw SODAUtils.makeException(SODAMessage.EX_SINCE_AND_UNTIL_CANNOT_BE_NULL, new Object[0]);
        }
        if (string != null && string.endsWith("Z")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string2 != null && string2.endsWith("Z")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.since = string;
        this.until = string2;
        this.timeRangeInclusive = bl != null ? bl : true;
        this.lastModified = null;
        return this;
    }

    @Override
    public OracleOperationBuilder filter(OracleDocument oracleDocument) throws OracleException {
        if (oracleDocument == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "filterSpec");
        }
        try {
            this.tree = AndORTree.createTree(((OracleDocumentImpl)oracleDocument).getContentAsStream());
            this.tree.generateJsonExists();
        }
        catch (QueryException queryException) {
            if (OracleLog.isLoggingEnabled()) {
                log.warning(queryException.toString());
            }
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_FILTER, queryException, new Object[0]);
        }
        this.filterSpec = oracleDocument;
        this.maxNumberOfKeysCheck();
        return this;
    }

    private void maxNumberOfKeysCheck() throws OracleException {
        int n = 0;
        if (this.filterSpec != null) {
            n += this.tree.getKeys().size();
        }
        if (this.keys != null) {
            n += this.keys.size();
        } else if (this.key != null && !this.isStartKey) {
            ++n;
        }
        if (n > 1000) {
            throw SODAUtils.makeException(SODAMessage.EX_MAX_NUM_OF_KEYS_EXCEEDED, n, 1000);
        }
    }

    @Override
    public OracleOperationBuilder version(String string) throws OracleException {
        if (this.options.versionColumnName == null) {
            throw SODAUtils.makeException(SODAMessage.EX_NO_VERSION, this.options.uriName);
        }
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "version");
        }
        this.version = string;
        return this;
    }

    public OracleOperationBuilder lastModified(String string) throws OracleException {
        if (this.options.timestampColumnName == null) {
            throw SODAUtils.makeException(SODAMessage.EX_NO_TIMESTAMP, this.options.uriName);
        }
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "lastModified");
        }
        if (string.endsWith("Z")) {
            string = string.substring(0, string.length() - 1);
        }
        this.lastModified = string;
        this.since = null;
        this.until = null;
        this.timeRangeInclusive = true;
        return this;
    }

    private ResultSet getResultSet(Operation operation) throws OracleException {
        PreparedStatement preparedStatement = operation.getPreparedStatement();
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
            preparedStatement = null;
        }
        catch (SQLException sQLException) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.toString());
                log.severe(operation.getSqlText());
            }
            throw SODAUtils.makeExceptionWithSQLText(sQLException, operation.getSqlText());
        }
        finally {
            for (String string : SODAUtils.closeCursor(preparedStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string);
            }
        }
        return resultSet;
    }

    @Override
    public OracleCursor getCursor() throws OracleException {
        Operation operation = this.generateOperation(Terminal.GET_CURSOR);
        ResultSet resultSet = this.getResultSet(operation);
        long l = this.metrics.endTiming();
        OracleCursorImpl oracleCursorImpl = new OracleCursorImpl(this.options, this.metrics, operation, resultSet);
        oracleCursorImpl.setElapsedTime(l);
        if (this.return_query) {
            this.return_sql_json.appendCloseBrace();
            oracleCursorImpl.setQuery(this.return_sql_json.toArray());
        }
        return oracleCursorImpl;
    }

    private Operation generateOperation(Terminal terminal) throws OracleException {
        return this.generateOperation(terminal, null);
    }

    private Operation generateOperation(Terminal terminal, OracleDocument oracleDocument) throws OracleException {
        Operation operation;
        StringBuilder stringBuilder = new StringBuilder();
        if (terminal == Terminal.REMOVE) {
            this.return_query = false;
            this.generateRemove(stringBuilder);
        } else if (this.replace(terminal)) {
            this.return_query = false;
            this.generateUpdate(stringBuilder);
        } else {
            if (terminal != Terminal.GET_CURSOR) {
                this.return_query = false;
            }
            if (this.paginationWorkaround(terminal)) {
                this.generatePaginationWorkaround(stringBuilder, terminal);
            } else {
                this.generateSelect(stringBuilder, terminal);
            }
        }
        int n = 0;
        if (this.filterSpec != null) {
            if (this.tree == null) {
                throw new IllegalStateException();
            }
            n = this.getNumberOfFilterSpecKeys();
        }
        this.generateWhere(stringBuilder);
        boolean bl = false;
        if (!this.countOrWrite(terminal)) {
            if (this.hasFilterSpecOrderBy()) {
                this.generateFilterSpecOrderBy(stringBuilder, this.tree);
                bl = true;
            }
            if (!this.paginationWorkaround(terminal)) {
                this.generateOrderBy(stringBuilder, bl);
                this.generateOffsetAndFetchNext(stringBuilder);
            }
        }
        if (this.returningClause(terminal)) {
            this.generateReturning(stringBuilder);
        }
        PreparedStatement preparedStatement = null;
        String string = stringBuilder.toString();
        try {
            boolean bl2;
            Object object;
            if (this.return_query) {
                this.beginQueryRecord(string);
            }
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Query:\n" + string);
            }
            this.metrics.startTiming();
            preparedStatement = this.connection.prepareStatement(string);
            int n2 = 0;
            if (this.replace(terminal)) {
                n2 = this.bindUpdate(preparedStatement, oracleDocument);
            }
            Iterator<String> iterator = null;
            if (this.key != null) {
                object = this.collection.canonicalKey(this.key);
                ((TableCollectionImpl)this.collection).bindKeyColumn(preparedStatement, ++n2, (String)object);
                if (this.return_query) {
                    this.recordNamedBind("key", (String)object);
                }
            } else if (this.keys != null) {
                iterator = this.keys.iterator();
                this.bindKeys(iterator, preparedStatement, this.keys.size(), n2);
                n2 += this.keys.size();
            }
            if (n > 0) {
                object = this.tree.getKeys();
                this.bindKeys(((HashSet)object).iterator(), preparedStatement, ((HashSet)object).size(), n2);
                n2 += ((HashSet)object).size();
            }
            n2 = this.setStartAndEndTime(preparedStatement, n2);
            n2 = this.setVersionAndLastModified(preparedStatement, n2);
            if (this.filterSpec != null) {
                n2 = this.bindJsonExists(preparedStatement, this.tree, n2);
            }
            if (this.returningClause(terminal)) {
                this.bindReturning(preparedStatement, n2);
            }
            boolean bl3 = bl2 = this.key != null && !this.isStartKey;
            if (!this.countOrWrite(terminal) && !bl2) {
                preparedStatement.setFetchSize(1000);
                ((OraclePreparedStatement)preparedStatement).setLobPrefetchSize(65000);
            }
            Operation operation2 = null;
            boolean bl4 = this.filterSpec != null;
            operation2 = new Operation(preparedStatement, string, this.headerOnly, bl4, bl2, this.collection);
            preparedStatement = null;
            operation = operation2;
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string2 : SODAUtils.closeCursor(preparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string2);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
        return operation;
    }

    private int bindJsonExists(PreparedStatement preparedStatement, AndORTree andORTree, int n) throws SQLException {
        int n2 = 0;
        block6: for (ValueTypePair valueTypePair : andORTree.getValueArray()) {
            ++n;
            if (this.return_query) {
                this.recordQueryBind(n2++, valueTypePair);
            }
            switch (valueTypePair.getType()) {
                case 1: {
                    preparedStatement.setBigDecimal(n, valueTypePair.getNumberValue());
                    continue block6;
                }
                case 2: {
                    preparedStatement.setString(n, valueTypePair.getStringValue());
                    continue block6;
                }
                case 3: {
                    preparedStatement.setString(n, String.valueOf(valueTypePair.getBooleanValue()));
                    continue block6;
                }
                case 4: {
                    preparedStatement.setString(n, NULL);
                    continue block6;
                }
            }
            throw new IllegalStateException();
        }
        return n;
    }

    private int setVersionAndLastModified(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.version != null) {
            if (this.return_query) {
                this.recordNamedBind("version", this.version);
            }
            preparedStatement.setString(++n, this.version);
        }
        if (this.lastModified != null) {
            if (this.return_query) {
                this.recordNamedBind("lastModified", this.lastModified);
            }
            preparedStatement.setString(++n, this.lastModified);
        }
        return n;
    }

    private int setStartAndEndTime(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.since != null) {
            if (this.return_query) {
                this.recordNamedBind("since", this.since);
            }
            preparedStatement.setString(++n, this.since);
        }
        if (this.until != null) {
            if (this.return_query) {
                this.recordNamedBind("until", this.until);
            }
            preparedStatement.setString(++n, this.until);
        }
        return n;
    }

    int bindUpdate(PreparedStatement preparedStatement, OracleDocument oracleDocument) throws SQLException, OracleException {
        int n = 0;
        byte[] byArray = OracleCollectionImpl.EMPTY_DATA;
        boolean bl = true;
        if (!this.collection.payloadBasedVersioning() && this.collection.admin().isHeterogeneous() && ((OracleDocumentImpl)oracleDocument).hasStreamContent()) {
            ((TableCollectionImpl)this.collection).setStreamBind(preparedStatement, oracleDocument, ++n);
            bl = false;
        } else {
            byArray = ((TableCollectionImpl)this.collection).bindPayloadColumn(preparedStatement, ++n, oracleDocument);
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            switch (this.options.versioningMethod) {
                case 2: {
                    break;
                }
                case 1: {
                    long l = this.collection.getDatabase().getDatabaseTime();
                    preparedStatement.setLong(++n, l);
                    this.computedVersion = Long.toString(l);
                    break;
                }
                case 3: {
                    this.computedVersion = this.collection.getDatabase().generateKey();
                    preparedStatement.setString(++n, this.computedVersion);
                    break;
                }
                default: {
                    if (!bl) {
                        throw SODAUtils.makeException(SODAMessage.EX_NO_HASH_VERSION, this.options.uriName, this.options.getVersioningMethod());
                    }
                    this.computedVersion = this.collection.computeVersion(byArray);
                    preparedStatement.setString(++n, this.computedVersion);
                }
            }
        }
        n = ((TableCollectionImpl)this.collection).bindMediaTypeColumn(preparedStatement, n, oracleDocument);
        return n;
    }

    void bindReturning(PreparedStatement preparedStatement, int n) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)preparedStatement;
        if (this.options.timestampColumnName != null) {
            oraclePreparedStatement.registerReturnParameter(++n, 12);
        }
        if (this.options.versionColumnName != null && (this.options.versioningMethod == 0 || this.options.versioningMethod == 2)) {
            oraclePreparedStatement.registerReturnParameter(++n, 12);
        }
        if (this.options.creationColumnName != null) {
            oraclePreparedStatement.registerReturnParameter(++n, 12);
        }
    }

    void bindKeys(Iterator<String> iterator, PreparedStatement preparedStatement, int n, int n2) throws SQLException, OracleException {
        String string = null;
        int n3 = n2;
        int n4 = 0;
        while (iterator.hasNext()) {
            string = iterator.next();
            if (this.return_query) {
                this.recordQueryKey(n4++, string);
            }
            ((TableCollectionImpl)this.collection).bindKeyColumn(preparedStatement, ++n3, string);
        }
    }

    private Operation createReplaceStatement(Terminal terminal, OracleDocument oracleDocument) throws OracleException {
        if (this.key == null || this.isStartKey) {
            throw SODAUtils.makeException(SODAMessage.EX_KEY_MUST_BE_SPECIFIED, new Object[0]);
        }
        if (oracleDocument == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "document");
        }
        this.computedVersion = null;
        return this.generateOperation(terminal, oracleDocument);
    }

    @Override
    public OracleDocument replaceOneAndGet(OracleDocument oracleDocument) throws OracleException {
        this.collection.writeCheck("replaceOneAndGet");
        Operation operation = this.createReplaceStatement(Terminal.REPLACE_ONE_AND_GET, oracleDocument);
        PreparedStatement preparedStatement = operation.getPreparedStatement();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)preparedStatement;
        ResultSet resultSet = null;
        String string = null;
        String string2 = null;
        int n = 0;
        OracleDocumentImpl oracleDocumentImpl = null;
        try {
            n = oraclePreparedStatement.executeUpdate();
            if (n == 0) {
                OracleDocument oracleDocument2 = null;
                return oracleDocument2;
            }
            if (this.returningClause(Terminal.REPLACE_ONE_AND_GET) && (this.options.timestampColumnName != null || ((TableCollectionImpl)this.collection).returnVersion() || this.options.creationColumnName != null) && (resultSet = oraclePreparedStatement.getReturnResultSet()).next()) {
                int n2 = 0;
                if (this.options.timestampColumnName != null) {
                    string = OracleDatabaseImpl.getTimestamp(resultSet.getString(++n2));
                }
                if (((TableCollectionImpl)this.collection).returnVersion()) {
                    this.computedVersion = resultSet.getString(++n2);
                }
                if (this.options.creationColumnName != null) {
                    string2 = OracleDatabaseImpl.getTimestamp(resultSet.getString(++n2));
                }
            }
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
            if (n == 1) {
                oracleDocumentImpl = new OracleDocumentImpl(this.collection.canonicalKey(this.key), this.computedVersion, string);
                oracleDocumentImpl.setCreatedOn(string2);
                String string3 = oracleDocument.getMediaType();
                ((TableCollectionImpl)this.collection).setContentType(string3, oracleDocumentImpl);
            }
        }
        catch (SQLException sQLException) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.toString());
            }
            throw SODAUtils.makeExceptionWithSQLText(sQLException, operation.getSqlText());
        }
        finally {
            for (String string4 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string4);
            }
        }
        for (String string5 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string5);
        }
        return oracleDocumentImpl;
    }

    @Override
    public boolean replaceOne(OracleDocument oracleDocument) throws OracleException {
        this.collection.writeCheck("replaceOne");
        Operation operation = this.createReplaceStatement(Terminal.REPLACE_ONE, oracleDocument);
        PreparedStatement preparedStatement = operation.getPreparedStatement();
        boolean bl = false;
        try {
            if (preparedStatement.executeUpdate() == 1) {
                bl = true;
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
        }
        catch (SQLException sQLException) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.toString());
            }
            throw SODAUtils.makeExceptionWithSQLText(sQLException, operation.getSqlText());
        }
        finally {
            for (String string : SODAUtils.closeCursor(preparedStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string);
            }
        }
        return bl;
    }

    @Override
    public int remove() throws OracleException {
        this.collection.writeCheck("remove");
        Operation operation = this.generateOperation(Terminal.REMOVE);
        PreparedStatement preparedStatement = operation.getPreparedStatement();
        int n = 0;
        try {
            n = preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordWrites(1, 1);
        }
        catch (SQLException sQLException) {
            if (OracleLog.isLoggingEnabled()) {
                log.severe(sQLException.toString());
            }
            throw SODAUtils.makeExceptionWithSQLText(sQLException, operation.getSqlText());
        }
        finally {
            for (String string : SODAUtils.closeCursor(preparedStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string);
            }
        }
        return n;
    }

    @Override
    public OracleOperationBuilder limit(int n) throws OracleException {
        if (n < 1) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_MUST_BE_POSITIVE, "limit");
        }
        this.limit = n;
        return this;
    }

    @Override
    public OracleOperationBuilder skip(long l) throws OracleException {
        if (l < 0L) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_MUST_BE_NON_NEGATIVE, "skip");
        }
        this.skip = l;
        return this;
    }

    @Override
    public OracleOperationBuilder headerOnly() {
        this.headerOnly = true;
        return this;
    }

    public OracleOperationBuilder firstRowsHint(int n) {
        if (n >= 0) {
            this.firstRows = n;
        }
        return this;
    }

    public String explainPlan(String string) throws OracleException {
        String string2;
        Operation operation = this.generateOperation(Terminal.EXPLAIN_PLAN);
        ResultSet resultSet = this.getResultSet(operation);
        Statement statement = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            resultSet.close();
            resultSet = null;
            statement = this.connection.createStatement();
            string = string.equalsIgnoreCase("all") ? "all" : (string.equalsIgnoreCase("typical") ? "typical" : "basic");
            resultSet = statement.executeQuery("select plan_table_output from table(dbms_xplan.display('plan_table', null, '" + string + "'))");
            while (resultSet.next()) {
                stringBuilder.append(resultSet.getString(1));
                stringBuilder.append("\n");
            }
            resultSet.close();
            resultSet = null;
            statement.close();
            statement = null;
            string2 = stringBuilder.toString();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, operation.getSqlText());
            }
            catch (Throwable throwable) {
                for (String string3 : SODAUtils.closeCursor(statement, resultSet)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string3);
                }
                throw throwable;
            }
        }
        for (String string4 : SODAUtils.closeCursor(statement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string4);
        }
        return string2;
    }

    @Override
    public long count() throws OracleException {
        Operation operation = this.generateOperation(Terminal.COUNT);
        long l = 0L;
        PreparedStatement preparedStatement = null;
        try {
            this.metrics.startTiming();
            preparedStatement = operation.getPreparedStatement();
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordReads(1, 1);
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, operation.getSqlText());
            }
            catch (Throwable throwable) {
                for (String string : SODAUtils.closeCursor(preparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string);
                }
                throw throwable;
            }
        }
        for (String string : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string);
        }
        return l;
    }

    @Override
    public OracleDocument getOne() throws OracleException {
        Operation operation = this.generateOperation(Terminal.GET_ONE);
        ResultSet resultSet = this.getResultSet(operation);
        long l = this.metrics.endTiming();
        OracleCursorImpl oracleCursorImpl = new OracleCursorImpl(this.options, this.metrics, operation, resultSet);
        oracleCursorImpl.setElapsedTime(l);
        OracleDocument oracleDocument = null;
        if (oracleCursorImpl.hasNext()) {
            oracleDocument = oracleCursorImpl.next();
        }
        try {
            oracleCursorImpl.close();
        }
        catch (IOException iOException) {
            Throwable throwable = iOException.getCause();
            if (throwable instanceof SQLException) {
                throw SODAUtils.makeExceptionWithSQLText((SQLException)throwable, operation.getSqlText());
            }
            throw new IllegalStateException();
        }
        return oracleDocument;
    }

    private void appendColumn(StringBuilder stringBuilder, String string) {
        this.appendAliasedColumn(stringBuilder, string, null);
    }

    private void appendAliasedColumn(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append(".");
        }
        stringBuilder.append("\"");
        stringBuilder.append(string);
        stringBuilder.append("\"");
    }

    private void generateFilterSpecJsonExists(StringBuilder stringBuilder, AndORTree andORTree) {
        stringBuilder.append("JSON_EXISTS(");
        this.appendColumn(stringBuilder, this.options.contentColumnName);
        ((TableCollectionImpl)this.collection).addFormat(stringBuilder);
        stringBuilder.append(",");
        andORTree.appendJsonExists(stringBuilder);
        stringBuilder.append(")");
    }

    private int getNumberOfFilterSpecKeys() {
        int n = 0;
        if (this.filterSpec != null) {
            if (this.tree == null) {
                throw new IllegalStateException();
            }
            HashSet<String> hashSet = this.tree.getKeys();
            if (hashSet != null) {
                n = hashSet.size();
            }
        }
        return n;
    }

    private void generateWhere(StringBuilder stringBuilder) {
        int n;
        boolean bl = false;
        int n2 = this.getNumberOfFilterSpecKeys();
        if (!this.whereClauseRequired()) {
            return;
        }
        stringBuilder.append(" where ");
        if (this.key != null) {
            stringBuilder.append("(");
            this.appendColumn(stringBuilder, this.options.keyColumnName);
            if (!this.isStartKey) {
                stringBuilder.append(" = ");
            } else {
                stringBuilder.append(this.ascending ? " >" : " <");
                stringBuilder.append(this.startKeyInclusive ? "= " : " ");
            }
            ((TableCollectionImpl)this.collection).addKey(stringBuilder);
            bl = true;
        } else if (this.keys != null) {
            stringBuilder.append(" (");
            this.appendColumn(stringBuilder, this.options.keyColumnName);
            stringBuilder.append(" in (");
            n = 0;
            while (n < this.keys.size()) {
                if (++n == this.keys.size()) {
                    stringBuilder.append("?)");
                    continue;
                }
                stringBuilder.append("?,");
            }
            bl = true;
        }
        if (n2 > 0) {
            if (bl) {
                if (this.isStartKey) {
                    stringBuilder.append(" ) and ( ");
                } else {
                    stringBuilder.append(" or ");
                }
            } else {
                stringBuilder.append("( ");
            }
            this.appendColumn(stringBuilder, this.options.keyColumnName);
            stringBuilder.append(" in (");
            n = 0;
            while (n < n2) {
                if (++n == n2) {
                    stringBuilder.append("?)");
                    continue;
                }
                stringBuilder.append("?,");
            }
            this.addCloseParenthesis(stringBuilder);
            bl = true;
        } else if (bl) {
            this.addCloseParenthesis(stringBuilder);
        }
        if (this.since != null || this.until != null) {
            this.addAnd(stringBuilder, bl);
            stringBuilder.append(" ( ");
            this.appendColumn(stringBuilder, this.options.timestampColumnName);
            if (this.since != null) {
                stringBuilder.append(" >");
                if (this.timeRangeInclusive) {
                    stringBuilder.append("=");
                }
                OracleDatabaseImpl.addToTimestamp(" ", stringBuilder);
            }
            if (this.until != null) {
                if (this.since != null) {
                    stringBuilder.append(" and ");
                    this.appendColumn(stringBuilder, this.options.timestampColumnName);
                }
                OracleDatabaseImpl.addToTimestamp(" <= ", stringBuilder);
            }
            this.addCloseParenthesis(stringBuilder);
            bl = true;
        }
        if (this.version != null) {
            this.addAnd(stringBuilder, bl);
            stringBuilder.append(" ( ");
            this.appendColumn(stringBuilder, this.options.versionColumnName);
            stringBuilder.append(" = ");
            switch (this.options.versioningMethod) {
                case 1: 
                case 2: {
                    stringBuilder.append("to_number(?)");
                    break;
                }
                default: {
                    stringBuilder.append("?");
                }
            }
            this.addCloseParenthesis(stringBuilder);
            bl = true;
        }
        if (this.lastModified != null) {
            this.addAnd(stringBuilder, bl);
            stringBuilder.append(" ( ");
            this.appendColumn(stringBuilder, this.options.timestampColumnName);
            OracleDatabaseImpl.addToTimestamp(" = ", stringBuilder);
            this.addCloseParenthesis(stringBuilder);
            bl = true;
        }
        if (this.filterSpec != null && this.tree.hasJsonExists()) {
            this.addAnd(stringBuilder, bl);
            this.generateFilterSpecJsonExists(stringBuilder, this.tree);
        }
    }

    private boolean whereClauseRequired() {
        return this.key != null || this.keys != null || this.since != null || this.until != null || this.version != null || this.lastModified != null || this.filterSpec != null && (this.tree.hasJsonExists() || this.tree.hasKeys());
    }

    private boolean hasFilterSpecOrderBy() {
        return this.filterSpec != null && this.tree.hasOrderBy();
    }

    private boolean countOrWrite(Terminal terminal) {
        return terminal == Terminal.COUNT || terminal == Terminal.REMOVE || this.replace(terminal);
    }

    private boolean returningClause(Terminal terminal) {
        boolean bl = this.collection.internalDriver;
        return terminal == Terminal.REPLACE_ONE_AND_GET && !bl;
    }

    private boolean replace(Terminal terminal) {
        return terminal == Terminal.REPLACE_ONE_AND_GET || terminal == Terminal.REPLACE_ONE;
    }

    private boolean paginationWorkaround(Terminal terminal) {
        return !(!PAGINATION_WORKAROUND || this.skip <= 0L && this.limit <= 0 || terminal != Terminal.GET_CURSOR && terminal != Terminal.GET_ONE && terminal != Terminal.EXPLAIN_PLAN || this.whereClauseRequired() || this.hasFilterSpecOrderBy());
    }

    private void addAnd(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append(" and ");
        }
    }

    private void addCloseParenthesis(StringBuilder stringBuilder) {
        stringBuilder.append(" ) ");
    }

    private void generateFilterSpecOrderBy(StringBuilder stringBuilder, AndORTree andORTree) {
        ArrayList<Predicate> arrayList = andORTree.getOrderByArray();
        Predicate predicate = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray;
            predicate = arrayList.get(i);
            if (i == 0) {
                stringBuilder.append(" order by");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(" JSON_VALUE(");
            this.appendColumn(stringBuilder, this.options.contentColumnName);
            ((TableCollectionImpl)this.collection).addFormat(stringBuilder);
            stringBuilder.append(", '$");
            for (String string : stringArray = predicate.getPathSteps()) {
                if (string.charAt(0) == '[') continue;
                stringBuilder.append(".");
                stringBuilder.append(string);
                stringBuilder.append("[0]");
            }
            stringBuilder.append("')");
            if (predicate.getValue().equals("1")) {
                stringBuilder.append(" asc");
                continue;
            }
            stringBuilder.append(" desc");
        }
    }

    private void generateOrderBy(StringBuilder stringBuilder, boolean bl) {
        if (this.isStartKey && !bl) {
            stringBuilder.append(" order by ");
            this.appendColumn(stringBuilder, this.options.keyColumnName);
            if (!this.ascending) {
                stringBuilder.append(" desc ");
            }
        } else if (!(this.since == null && this.until == null || bl)) {
            stringBuilder.append(" order by ");
            if (this.since != null || this.until != null) {
                this.appendColumn(stringBuilder, this.options.timestampColumnName);
                stringBuilder.append(",");
            }
            this.appendColumn(stringBuilder, this.options.keyColumnName);
        } else if (this.skip > 0L || this.limit > 0) {
            if (!bl) {
                stringBuilder.append(" order by ");
            } else {
                stringBuilder.append(", ");
            }
            this.appendColumn(stringBuilder, this.options.keyColumnName);
        }
    }

    private void generateOffsetAndFetchNext(StringBuilder stringBuilder) {
        if (this.skip > 0L) {
            stringBuilder.append(" offset " + Long.toString(this.skip) + " rows");
        }
        if (this.limit > 0) {
            stringBuilder.append(" fetch next " + Integer.toString(this.limit) + " rows only");
        }
    }

    private void appendTable(StringBuilder stringBuilder) {
        stringBuilder.append("\"");
        if (this.options.dbSchema != null) {
            stringBuilder.append(this.options.dbSchema);
            stringBuilder.append("\".\"");
        }
        stringBuilder.append(this.options.dbObjectName);
        stringBuilder.append("\"");
    }

    private void generatePaginationWorkaround(StringBuilder stringBuilder, Terminal terminal) {
        stringBuilder.setLength(0);
        String string = "TAB_";
        String string2 = "TAB1_";
        String string3 = "TAB2_";
        if (terminal == Terminal.EXPLAIN_PLAN) {
            stringBuilder.append("explain plan for ");
        }
        stringBuilder.append("select ");
        stringBuilder.append(" /*+ LEADING(" + string2 + ") ");
        stringBuilder.append("USE_NL(" + string3 + ") */ ");
        this.appendTableColumns(stringBuilder, string3);
        stringBuilder.append(" from ");
        stringBuilder.append(" ( select /*+ INDEX(");
        stringBuilder.append(string);
        stringBuilder.append(") */ ");
        this.appendAliasedColumn(stringBuilder, this.options.keyColumnName, string);
        stringBuilder.append(" from ");
        this.appendTable(stringBuilder);
        stringBuilder.append(" ");
        stringBuilder.append(string);
        this.generateOffsetAndFetchNext(stringBuilder);
        stringBuilder.append(" ) ");
        stringBuilder.append(string2);
        stringBuilder.append(", ");
        this.appendTable(stringBuilder);
        stringBuilder.append(" ");
        stringBuilder.append(string3);
        stringBuilder.append(" where ");
        stringBuilder.append(string2);
        stringBuilder.append(".rowid = ");
        stringBuilder.append(string3);
        stringBuilder.append(".rowid ");
        stringBuilder.append(" order by ");
        this.appendAliasedColumn(stringBuilder, this.options.keyColumnName, string2);
    }

    private void generateSelect(StringBuilder stringBuilder, Terminal terminal) {
        stringBuilder.setLength(0);
        if (terminal == Terminal.EXPLAIN_PLAN) {
            stringBuilder.append("explain plan for ");
        }
        stringBuilder.append("select ");
        if (this.firstRows >= 0) {
            stringBuilder.append(" /*+ FIRST_ROWS(");
            stringBuilder.append(this.firstRows);
            stringBuilder.append(") */ ");
        }
        if (terminal == Terminal.COUNT) {
            stringBuilder.append(" count(\"");
            stringBuilder.append(this.options.keyColumnName);
            stringBuilder.append("\")");
        } else {
            this.appendTableColumns(stringBuilder, null);
        }
        stringBuilder.append(" from ");
        this.appendTable(stringBuilder);
    }

    private void appendTableColumns(StringBuilder stringBuilder, String string) {
        switch (this.options.keyDataType) {
            case 3: {
                stringBuilder.append("to_char(");
                this.appendAliasedColumn(stringBuilder, this.options.keyColumnName, string);
                stringBuilder.append(")");
                break;
            }
            case 4: {
                stringBuilder.append("rawtohex(");
                this.appendAliasedColumn(stringBuilder, this.options.keyColumnName, string);
                stringBuilder.append(")");
                break;
            }
            case 1: 
            case 2: {
                this.appendAliasedColumn(stringBuilder, this.options.keyColumnName, string);
            }
        }
        if (this.options.doctypeColumnName != null) {
            stringBuilder.append(",");
            this.appendAliasedColumn(stringBuilder, this.options.doctypeColumnName, string);
        }
        if (!this.headerOnly) {
            stringBuilder.append(",");
            this.appendAliasedColumn(stringBuilder, this.options.contentColumnName, string);
        }
        if (this.options.timestampColumnName != null) {
            stringBuilder.append(",to_char(");
            this.appendAliasedColumn(stringBuilder, this.options.timestampColumnName, string);
            OracleDatabaseImpl.addTimestampSelectFormat(stringBuilder);
        }
        if (this.options.creationColumnName != null) {
            stringBuilder.append(",to_char(");
            this.appendAliasedColumn(stringBuilder, this.options.creationColumnName, string);
            OracleDatabaseImpl.addTimestampSelectFormat(stringBuilder);
        }
        if (this.options.versionColumnName != null) {
            stringBuilder.append(",");
            this.appendAliasedColumn(stringBuilder, this.options.versionColumnName, string);
        }
    }

    private void generateUpdate(StringBuilder stringBuilder) {
        stringBuilder.append("update ");
        this.appendTable(stringBuilder);
        stringBuilder.append(" set \"");
        stringBuilder.append(this.options.contentColumnName);
        stringBuilder.append("\" = ?");
        if (this.options.timestampColumnName != null) {
            stringBuilder.append(", \"");
            stringBuilder.append(this.options.timestampColumnName);
            stringBuilder.append("\" = sys_extract_utc(SYSTIMESTAMP)");
        }
        if (this.options.versionColumnName != null && this.options.versioningMethod != 0) {
            stringBuilder.append(", \"");
            stringBuilder.append(this.options.versionColumnName);
            stringBuilder.append("\" = ");
            if (this.options.versioningMethod == 2) {
                stringBuilder.append("(\"");
                stringBuilder.append(this.options.versionColumnName);
                stringBuilder.append("\" + 1)");
            } else {
                stringBuilder.append("?");
            }
        }
        if (this.options.doctypeColumnName != null) {
            stringBuilder.append(", \"");
            stringBuilder.append(this.options.doctypeColumnName);
            stringBuilder.append("\" = ?");
        }
    }

    private void generateReturning(StringBuilder stringBuilder) {
        int n = 0;
        if (this.options.timestampColumnName == null && this.options.creationColumnName == null && !((TableCollectionImpl)this.collection).returnVersion()) {
            return;
        }
        stringBuilder.append(" returning ");
        if (this.options.timestampColumnName != null) {
            stringBuilder.append("to_char(\"");
            stringBuilder.append(this.options.timestampColumnName);
            stringBuilder.append('\"');
            OracleDatabaseImpl.addTimestampReturningFormat(stringBuilder);
            ++n;
        }
        if (((TableCollectionImpl)this.collection).returnVersion()) {
            TableCollectionImpl cfr_ignored_0 = (TableCollectionImpl)this.collection;
            TableCollectionImpl.addComma(stringBuilder, n);
            stringBuilder.append("\"");
            stringBuilder.append(this.options.versionColumnName);
            stringBuilder.append("\"");
            ++n;
        }
        if (this.options.creationColumnName != null) {
            TableCollectionImpl cfr_ignored_1 = (TableCollectionImpl)this.collection;
            TableCollectionImpl.addComma(stringBuilder, n);
            stringBuilder.append("to_char(\"");
            stringBuilder.append(this.options.creationColumnName);
            stringBuilder.append('\"');
            OracleDatabaseImpl.addTimestampReturningFormat(stringBuilder);
            ++n;
        }
        TableCollectionImpl cfr_ignored_2 = (TableCollectionImpl)this.collection;
        TableCollectionImpl.addInto(stringBuilder, n);
    }

    private void generateRemove(StringBuilder stringBuilder) {
        stringBuilder.append("delete from ");
        this.appendTable(stringBuilder);
    }

    private static enum Terminal {
        COUNT,
        GET_ONE,
        GET_CURSOR,
        REMOVE,
        REPLACE_ONE_AND_GET,
        REPLACE_ONE,
        EXPLAIN_PLAN;

    }
}

