/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.json.common.MetricsCollector;
import oracle.json.logging.OracleLog;
import oracle.json.util.ByteArray;
import oracle.json.util.ComponentTime;
import oracle.json.util.HashFuncs;
import oracle.soda.OracleCollection;
import oracle.soda.OracleDatabase;
import oracle.soda.OracleDatabaseAdmin;
import oracle.soda.OracleDocument;
import oracle.soda.OracleException;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.OracleCollectionImpl;
import oracle.soda.rdbms.impl.OracleDocumentImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.soda.rdbms.impl.TableCollectionImpl;
import oracle.soda.rdbms.impl.cache.DescriptorCache;
import oracle.sql.Datum;

public class OracleDatabaseImpl
implements OracleDatabase {
    static ArrayList<String> EMPTY_LIST = new ArrayList();
    private static final String SELECT_GUID = "select SYS_GUID() from SYS.DUAL";
    private static final String SELECT_GUID_BATCH = "declare\n  type VCTAB is table of varchar2(255) index by binary_integer;\n  N number;\n  X varchar2(255);\n  K vctab;\nbegin\n  N := ?;\n  for I in 1..N loop\n    select rawtohex(SYS_GUID()) into X from SYS.DUAL;\n    K(I) := X;\n  end loop;\n  ? := K;\nend;";
    private static final String COLLECTION_CREATION_MODE = "DDL";
    private static final Logger log = Logger.getLogger(OracleDatabaseImpl.class.getName());
    private final OracleConnection conn;
    private final DescriptorCache sharedDescriptorCache;
    private final HashMap<String, CollectionDescriptor> localDescriptorCache;
    private final HashMap<String, OracleCollectionImpl> localCollectionCache;
    private MetricsCollector metrics;
    private boolean metadataTableExists = true;
    private OracleDatabaseAdmin admin;
    static final boolean JDBC_WORKAROUND = false;
    private static final int DESC_LENGTH = 4000;
    private static final int CREATION_TIMESTAMP_LENGTH = 255;
    private static final long TIME_REFRESH_INTERVAL = 100000000L;
    private static String SELECT_DB_TIMESTAMP = "select to_char(sys_extract_utc(SYSTIMESTAMP),'YYYY-MM-DD\"T\"HH24:MI:SS.FF' ) from SYS.DUAL";
    private long currentTimestamp = 0L;
    private long updateNanos = 0L;
    private static final int GUID_BATCH_SIZE = 10;
    private final String[] guidCache = new String[10];
    private int guidCachePos = 10;

    public OracleDatabaseImpl(OracleConnection oracleConnection, DescriptorCache descriptorCache, MetricsCollector metricsCollector, boolean bl) {
        this.conn = oracleConnection;
        this.sharedDescriptorCache = descriptorCache;
        this.metrics = metricsCollector;
        if (bl) {
            this.localDescriptorCache = new HashMap();
            this.localCollectionCache = new HashMap();
        } else {
            this.localDescriptorCache = null;
            this.localCollectionCache = null;
        }
    }

    private CollectionDescriptor putDescriptorIntoCaches(CollectionDescriptor collectionDescriptor) {
        String string = collectionDescriptor.getName();
        if (this.localDescriptorCache != null) {
            this.localDescriptorCache.put(string, collectionDescriptor);
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Put " + string + " descriptor into local cache");
            }
        }
        if (this.sharedDescriptorCache != null) {
            CollectionDescriptor collectionDescriptor2 = this.sharedDescriptorCache.putIfAbsent(collectionDescriptor);
            if (collectionDescriptor2 != null) {
                if (OracleLog.isLoggingEnabled()) {
                    log.fine(string + " descriptor already exists in shared cache");
                }
                if (this.localCollectionCache == null) {
                    return collectionDescriptor2;
                }
            } else if (OracleLog.isLoggingEnabled()) {
                log.fine("Put " + string + " descriptor into shared cache");
            }
        }
        return collectionDescriptor;
    }

    private CollectionDescriptor getDescriptorFromCaches(String string) {
        CollectionDescriptor collectionDescriptor = null;
        if (this.localDescriptorCache != null && (collectionDescriptor = this.localDescriptorCache.get(string)) != null) {
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Got " + string + " descriptor from local cache");
            }
            if (this.sharedDescriptorCache != null && !this.sharedDescriptorCache.containsDescriptor(string)) {
                this.sharedDescriptorCache.putIfAbsent(collectionDescriptor);
            }
        }
        if (collectionDescriptor == null && this.sharedDescriptorCache != null && (collectionDescriptor = this.sharedDescriptorCache.get(string)) != null) {
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Got " + string + " descriptor from shared cache");
            }
            if (this.localDescriptorCache != null) {
                this.localDescriptorCache.put(string, collectionDescriptor);
            }
        }
        if (collectionDescriptor == null && (this.localCollectionCache != null || this.sharedDescriptorCache != null) && OracleLog.isLoggingEnabled()) {
            log.fine("Descriptor not found in caches");
        }
        return collectionDescriptor;
    }

    void setMetricsCollector(MetricsCollector metricsCollector) {
        this.metrics = metricsCollector;
    }

    private ArrayList<CollectionDescriptor> loadCollections(Integer n, int n2) throws OracleException {
        if (!this.metadataTableExists) {
            return null;
        }
        return this.callListCollections(null, n, n2);
    }

    private ArrayList<CollectionDescriptor> loadCollections(Integer n, String string) throws OracleException {
        if (!this.metadataTableExists) {
            return null;
        }
        return this.callListCollections(string, n, 0);
    }

    private OracleCollection createCollection(String string) throws OracleException {
        return this.createCollection(string, (CollectionDescriptor)null);
    }

    private OracleCollection createCollection(String string, CollectionDescriptor collectionDescriptor) throws OracleException {
        return this.createCollection(string, collectionDescriptor, COLLECTION_CREATION_MODE);
    }

    public OracleCollection createCollection(String string, CollectionDescriptor collectionDescriptor, String string2) throws OracleException {
        OracleCollection oracleCollection = this.openCollection(string, collectionDescriptor);
        if (oracleCollection != null) {
            return oracleCollection;
        }
        if (collectionDescriptor == null) {
            collectionDescriptor = CollectionDescriptor.createStandardBuilder().buildDescriptor(string);
        }
        collectionDescriptor = this.callCreatePLSQL(string, collectionDescriptor, string2);
        return this.openCollection(string, collectionDescriptor);
    }

    @Override
    public OracleCollection openCollection(String string) throws OracleException {
        return this.openCollection(string, null);
    }

    private OracleCollection openCollection(String string, CollectionDescriptor collectionDescriptor) throws OracleException {
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "collectionName");
        }
        OracleCollectionImpl oracleCollectionImpl = null;
        if (this.localCollectionCache != null) {
            oracleCollectionImpl = this.localCollectionCache.get(string);
        }
        if (oracleCollectionImpl != null) {
            if (collectionDescriptor != null && !oracleCollectionImpl.matches(collectionDescriptor)) {
                throw SODAUtils.makeException(SODAMessage.EX_MISMATCHED_DESCRIPTORS, new Object[0]);
            }
            return oracleCollectionImpl;
        }
        CollectionDescriptor collectionDescriptor2 = this.getDescriptorFromCaches(string);
        if (collectionDescriptor2 == null) {
            collectionDescriptor2 = this.loadCollection(string);
        }
        boolean bl = false;
        if (collectionDescriptor2 != null) {
            if (collectionDescriptor != null && !collectionDescriptor2.matches(collectionDescriptor)) {
                throw SODAUtils.makeException(SODAMessage.EX_MISMATCHED_DESCRIPTORS, new Object[0]);
            }
            bl = true;
        }
        if (bl) {
            if (collectionDescriptor2.dbObjectType == 2) {
                throw new IllegalStateException();
            }
            oracleCollectionImpl = new TableCollectionImpl(this, string, collectionDescriptor2);
            if (this.localCollectionCache != null) {
                this.localCollectionCache.put(string, oracleCollectionImpl);
            }
        }
        return oracleCollectionImpl;
    }

    private OracleCollection createCollection(String string, OracleDocument oracleDocument) throws OracleException {
        if (oracleDocument == null) {
            return this.createCollection(string);
        }
        CollectionDescriptor collectionDescriptor = this.createCollectionDescriptor(string, oracleDocument);
        return this.createCollection(string, collectionDescriptor);
    }

    private CollectionDescriptor createCollectionDescriptor(String string, OracleDocument oracleDocument) throws OracleException {
        String string2;
        CollectionDescriptor.Builder builder;
        block3: {
            String string3 = oracleDocument.getContentAsString();
            if (string3 == null || string3.isEmpty()) {
                throw SODAUtils.makeException(SODAMessage.EX_METADATA_DOC_HAS_NO_CONTENT, new Object[0]);
            }
            builder = CollectionDescriptor.jsonToBuilder(string3);
            string2 = null;
            try {
                string2 = this.conn.getCurrentSchema();
            }
            catch (SQLException sQLException) {
                if (!OracleLog.isLoggingEnabled()) break block3;
                log.severe(sQLException.getMessage());
            }
        }
        return builder.buildDescriptor(string, string2);
    }

    void dropCollection(String string) throws OracleException {
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "collectionName");
        }
        this.callDropPLSQL(string);
        if (this.sharedDescriptorCache != null) {
            this.sharedDescriptorCache.remove(string);
        }
        if (this.localDescriptorCache != null) {
            this.localDescriptorCache.remove(string);
        }
        if (this.localCollectionCache != null) {
            this.localCollectionCache.remove(string);
        }
    }

    private List<String> getCollectionNames() throws OracleException {
        return this.getCollectionNames(null, 0);
    }

    private List<String> getCollectionNames(int n) throws OracleException {
        return this.getCollectionNames(n, 0);
    }

    private List<String> getCollectionNames(int n, int n2) throws OracleException {
        if (n < 1) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_MUST_BE_POSITIVE, "limit");
        }
        if (n2 < 0) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_MUST_BE_NON_NEGATIVE, "skip");
        }
        return this.getCollectionNames((Integer)n, n2);
    }

    private List<String> getCollectionNames(Integer n, int n2) throws OracleException {
        ArrayList<CollectionDescriptor> arrayList = this.loadCollections(n, n2);
        int n3 = arrayList.size();
        ArrayList<String> arrayList2 = EMPTY_LIST;
        if (n3 > 0) {
            arrayList2 = new ArrayList(n3);
            for (CollectionDescriptor collectionDescriptor : arrayList) {
                arrayList2.add(collectionDescriptor.uriName);
            }
        }
        return arrayList2;
    }

    private List<String> getCollectionNames(int n, String string) throws OracleException {
        if (n < 1) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_MUST_BE_POSITIVE, "limit");
        }
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "startName");
        }
        ArrayList<CollectionDescriptor> arrayList = this.loadCollections((Integer)n, string);
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = EMPTY_LIST;
        if (n2 > 0) {
            arrayList2 = new ArrayList(n2);
            for (CollectionDescriptor collectionDescriptor : arrayList) {
                arrayList2.add(collectionDescriptor.uriName);
            }
        }
        return arrayList2;
    }

    public OracleDocument createDocumentFromStream(InputStream inputStream) {
        return new OracleDocumentImpl(null, null, null, inputStream, null);
    }

    public OracleDocument createDocumentFromStream(String string, InputStream inputStream) {
        return new OracleDocumentImpl(string, null, null, inputStream, null);
    }

    public OracleDocument createDocumentFromStream(String string, InputStream inputStream, String string2) {
        return new OracleDocumentImpl(string, null, null, inputStream, string2);
    }

    @Override
    public OracleDocument createDocumentFromString(String string) {
        return new OracleDocumentImpl(null, string);
    }

    @Override
    public OracleDocument createDocumentFromString(String string, String string2) {
        return new OracleDocumentImpl(string, string2);
    }

    @Override
    public OracleDocument createDocumentFromString(String string, String string2, String string3) {
        return new OracleDocumentImpl(string, null, null, string2, string3);
    }

    @Override
    public OracleDocument createDocumentFromByteArray(byte[] byArray) {
        return new OracleDocumentImpl(null, byArray);
    }

    @Override
    public OracleDocument createDocumentFromByteArray(String string, byte[] byArray) {
        return new OracleDocumentImpl(string, byArray);
    }

    @Override
    public OracleDocument createDocumentFromByteArray(String string, byte[] byArray, String string2) {
        return new OracleDocumentImpl(string, null, null, byArray, string2);
    }

    MetricsCollector getMetrics() {
        return this.metrics;
    }

    public OracleConnection getConnection() {
        return this.conn;
    }

    long getDatabaseTime() throws SQLException {
        long l = System.nanoTime();
        long l2 = this.updateNanos == 0L ? -1L : l - this.updateNanos;
        if (l2 > 100000000L || l2 < 0L) {
            this.refreshDatabaseTime(l);
        } else {
            long l3;
            long l4 = l2 / 1000L;
            if (l4 <= 0L) {
                l4 = 1L;
            }
            if ((l3 = ComponentTime.increment(this.currentTimestamp, l4)) < 0L) {
                this.refreshDatabaseTime(l);
            } else {
                this.currentTimestamp = l3;
            }
        }
        return this.currentTimestamp;
    }

    private void setDatabaseTime(long l, String string) {
        ComponentTime componentTime;
        long l2;
        if (string.length() > 26) {
            string = string.substring(0, 26);
        }
        if ((l2 = (componentTime = new ComponentTime(string)).getValue()) <= this.currentTimestamp) {
            l2 = ComponentTime.plus(this.currentTimestamp, 1L);
        }
        this.updateNanos = l;
        this.currentTimestamp = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDatabaseTime(long l) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = SELECT_DB_TIMESTAMP;
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.setFetchSize(1);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                this.setDatabaseTime(l, resultSet.getString(1));
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordTimestampRead();
        }
        catch (Throwable throwable) {
            for (String string2 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string2);
            }
            throw throwable;
        }
        for (String string3 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
    }

    String nextGuid() throws OracleException {
        if (this.guidCachePos >= this.guidCache.length) {
            this.fetchGuids();
        }
        return this.guidCache[this.guidCachePos++];
    }

    private void fetchGuids() throws OracleException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = SELECT_GUID_BATCH;
        int n = 10;
        try {
            Object object = null;
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.setInt(1, n);
            oracleCallableStatement.registerIndexTableOutParameter(2, n, 12, 255);
            oracleCallableStatement.execute();
            object = oracleCallableStatement.getOraclePlsqlIndexTable(2);
            n = ((Datum[])object).length;
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    this.guidCache[i] = object[i].stringValue();
                }
            }
            this.guidCachePos -= n;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordGUIDS();
        }
        catch (SQLException sQLException) {
            try {
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string2 : SODAUtils.closeCursor(oracleCallableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string2);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor((Statement)oracleCallableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fetchGuid() {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = SELECT_GUID;
        byte[] byArray = null;
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                byArray = resultSet.getBytes(1);
            }
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordGUIDS();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
            }
            catch (Throwable throwable) {
                for (String string2 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string2);
                }
                throw throwable;
            }
            for (String string3 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string3);
            }
        }
        for (String string4 : SODAUtils.closeCursor(preparedStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string4);
        }
        return byArray;
    }

    String generateKey() throws OracleException {
        byte[] byArray;
        block4: {
            byArray = null;
            try {
                byArray = HashFuncs.getRandom();
            }
            catch (Exception exception) {
                if (!OracleLog.isLoggingEnabled()) break block4;
                log.warning(exception.toString());
            }
        }
        if (byArray == null) {
            byArray = this.fetchGuid();
        }
        if (byArray == null) {
            throw SODAUtils.makeException(SODAMessage.EX_UNABLE_TO_CREATE_UUID, new Object[0]);
        }
        return ByteArray.rawToHex(byArray);
    }

    @Override
    public OracleDatabaseAdmin admin() {
        if (this.admin == null) {
            this.admin = new OracleDatabaseAdministrationImpl();
        }
        return this.admin;
    }

    private void callDropPLSQL(String string) throws OracleException {
        OracleCallableStatement oracleCallableStatement = null;
        String string2 = "begin\n DBMS_SODA_ADMIN.DROP_COLLECTION(P_URI_NAME => ?);\nend;";
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string2);
            oracleCallableStatement.setNString(1, string);
            oracleCallableStatement.execute();
            if (OracleLog.isLoggingEnabled()) {
                log.info("Dropped collection " + string);
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordDDL();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                if (sQLException.getErrorCode() == 54) {
                    throw SODAUtils.makeExceptionWithSQLText(SODAMessage.EX_COMMIT_MIGHT_BE_NEEDED, sQLException, string2, new Object[0]);
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string2);
            }
            catch (Throwable throwable) {
                for (String string3 : SODAUtils.closeCursor(oracleCallableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string3);
                }
                throw throwable;
            }
        }
        for (String string4 : SODAUtils.closeCursor((Statement)oracleCallableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string4);
        }
    }

    private CollectionDescriptor callCreatePLSQL(String string, CollectionDescriptor collectionDescriptor, String string2) throws OracleException {
        OracleCallableStatement oracleCallableStatement = null;
        String string3 = "begin\n  DBMS_SODA_ADMIN.CREATE_COLLECTION(\n                   P_URI_NAME    => ?,\n                   P_CREATE_MODE => ?,\n                   P_DESCRIPTOR  => ?,\n                   P_CREATE_TIME => ?);\nend;";
        String string4 = collectionDescriptor.getDescription();
        if (OracleLog.isLoggingEnabled()) {
            log.info("Create collection:\n" + string4);
        }
        CollectionDescriptor collectionDescriptor2 = null;
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string3);
            oracleCallableStatement.setNString(1, string);
            oracleCallableStatement.setString(2, string2);
            oracleCallableStatement.setString(3, string4);
            oracleCallableStatement.registerOutParameter(3, 12, 4000);
            oracleCallableStatement.registerOutParameter(4, 12, 255);
            oracleCallableStatement.execute();
            if (OracleLog.isLoggingEnabled()) {
                log.info("Created collection " + string);
            }
            String string5 = oracleCallableStatement.getString(4);
            string4 = oracleCallableStatement.getString(3);
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordDDL();
            if (string5 != null) {
                CollectionDescriptor.Builder object = CollectionDescriptor.jsonToBuilder(string4);
                collectionDescriptor2 = object.buildDescriptor(string);
            }
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string3);
            }
            catch (Throwable throwable) {
                for (String string5 : SODAUtils.closeCursor(oracleCallableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string5);
                }
                throw throwable;
            }
        }
        for (String string6 : SODAUtils.closeCursor((Statement)oracleCallableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string6);
        }
        return collectionDescriptor2;
    }

    private CollectionDescriptor loadCollection(String string) throws OracleException {
        if (!this.metadataTableExists) {
            return null;
        }
        OracleCallableStatement oracleCallableStatement = null;
        String string2 = "begin\n  DBMS_SODA_ADMIN.DESCRIBE_COLLECTION(\n                   P_URI_NAME   => ?,\n                   P_DESCRIPTOR => ?);\nend;";
        CollectionDescriptor collectionDescriptor = null;
        try {
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string2);
            oracleCallableStatement.setNString(1, string);
            oracleCallableStatement.registerOutParameter(2, 12, 4000);
            oracleCallableStatement.execute();
            String string3 = oracleCallableStatement.getString(2);
            collectionDescriptor = this.getDescriptorFromCaches(string);
            if (collectionDescriptor == null && string3 != null) {
                CollectionDescriptor.Builder object = CollectionDescriptor.jsonToBuilder(string3);
                collectionDescriptor = this.putDescriptorIntoCaches(object.buildDescriptor(string));
            }
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string2);
            }
            catch (Throwable throwable) {
                for (String string3 : SODAUtils.closeCursor(oracleCallableStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string3);
                }
                throw throwable;
            }
        }
        for (String string4 : SODAUtils.closeCursor((Statement)oracleCallableStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string4);
        }
        return collectionDescriptor;
    }

    private ArrayList<CollectionDescriptor> callListCollections(String string, Integer n, int n2) throws OracleException {
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        String string2 = "begin\n  DBMS_SODA_ADMIN.LIST_COLLECTIONS(\n                   P_START_NAME => ?,\n                   P_RESULTS    => ?);\nend;";
        boolean bl = false;
        ArrayList<CollectionDescriptor> arrayList = new ArrayList<CollectionDescriptor>();
        try {
            int n3 = 0;
            this.metrics.startTiming();
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string2);
            if (string == null) {
                oracleCallableStatement.setNull(1, 12);
            } else {
                oracleCallableStatement.setNString(1, string);
            }
            oracleCallableStatement.registerOutParameter(2, -10);
            oracleCallableStatement.execute();
            resultSet = oracleCallableStatement.getCursor(2);
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Loaded collections");
            }
            while (resultSet.next()) {
                String string3 = resultSet.getNString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                CollectionDescriptor collectionDescriptor = this.getDescriptorFromCaches(string3);
                if (collectionDescriptor == null) {
                    CollectionDescriptor.Builder builder = CollectionDescriptor.jsonToBuilder(string4);
                    collectionDescriptor = builder.buildDescriptor(string3);
                    collectionDescriptor = this.putDescriptorIntoCaches(collectionDescriptor);
                }
                if (n3 >= n2 && !bl) {
                    arrayList.add(collectionDescriptor);
                }
                if (n == null || n <= 0 || ++n3 < n2 + n) continue;
                if (n3 > 1000) break;
                bl = true;
            }
            resultSet.close();
            resultSet = null;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            this.metrics.recordCall();
        }
        catch (SQLException sQLException) {
            try {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(sQLException.toString());
                }
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string2);
            }
            catch (Throwable throwable) {
                for (String string6 : SODAUtils.closeCursor(oracleCallableStatement, resultSet)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string6);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor((Statement)oracleCallableStatement, resultSet)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
        return arrayList;
    }

    static void addToTimestamp(String string, StringBuilder stringBuilder) {
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append("to_timestamp(?,'YYYY-MM-DD\"T\"HH24:MI:SS.FF TZH:TZM')");
    }

    private static void addTimestampFormat(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append(",'YYYY-MM-DD\"T\"HH24.MI.SS.FF\"Z\"')");
        } else {
            stringBuilder.append(",'YYYY-MM-DD\"T\"HH24:MI:SS.FF\"Z\"')");
        }
    }

    static void addTimestampReturningFormat(StringBuilder stringBuilder) {
        OracleDatabaseImpl.addTimestampFormat(stringBuilder, false);
    }

    static void addTimestampSelectFormat(StringBuilder stringBuilder) {
        OracleDatabaseImpl.addTimestampFormat(stringBuilder, false);
    }

    static String getTimestamp(String string) {
        return string;
    }

    private class OracleDatabaseAdministrationImpl
    implements OracleDatabaseAdmin {
        private OracleDatabaseAdministrationImpl() {
        }

        @Override
        public OracleCollection createCollection(String string) throws OracleException {
            return OracleDatabaseImpl.this.createCollection(string);
        }

        @Override
        public OracleCollection createCollection(String string, OracleDocument oracleDocument) throws OracleException {
            return OracleDatabaseImpl.this.createCollection(string, oracleDocument);
        }

        @Override
        public List<String> getCollectionNames() throws OracleException {
            return OracleDatabaseImpl.this.getCollectionNames();
        }

        @Override
        public List<String> getCollectionNames(int n) throws OracleException {
            return OracleDatabaseImpl.this.getCollectionNames(n);
        }

        @Override
        public List<String> getCollectionNames(int n, int n2) throws OracleException {
            return OracleDatabaseImpl.this.getCollectionNames(n, n2);
        }

        @Override
        public List<String> getCollectionNames(int n, String string) throws OracleException {
            return OracleDatabaseImpl.this.getCollectionNames(n, string);
        }

        @Override
        public Connection getConnection() {
            return OracleDatabaseImpl.this.getConnection();
        }
    }
}

