/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import java.math.BigDecimal;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.json.common.MetricsCollector;
import oracle.json.logging.OracleLog;
import oracle.json.parser.IndexColumn;
import oracle.json.parser.IndexSpecification;
import oracle.json.parser.JsonPath;
import oracle.json.parser.QueryException;
import oracle.json.util.ByteArray;
import oracle.json.util.HashFuncs;
import oracle.json.util.JsonByteArray;
import oracle.soda.OracleCollection;
import oracle.soda.OracleCollectionAdmin;
import oracle.soda.OracleDocument;
import oracle.soda.OracleException;
import oracle.soda.OracleOperationBuilder;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.OracleDatabaseImpl;
import oracle.soda.rdbms.impl.OracleDocumentFragmentImpl;
import oracle.soda.rdbms.impl.OracleDocumentImpl;
import oracle.soda.rdbms.impl.OracleOperationBuilderImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;

public abstract class OracleCollectionImpl
implements OracleCollection {
    protected static final Logger log = Logger.getLogger(OracleCollectionImpl.class.getName());
    static ArrayList<OracleDocument> EMPTY_LIST = new ArrayList();
    static byte[] EMPTY_DATA = new byte[0];
    protected final String collectionName;
    protected final OracleConnection conn;
    protected final OracleDatabaseImpl db;
    protected final MetricsCollector metrics;
    protected final CollectionDescriptor options;
    private OracleCollectionAdministrationImpl admin;
    protected StringBuilder sb = new StringBuilder(1000);
    private static final int ORA_SQL_OBJECT_EXISTS = 955;
    private static final int ORA_SQL_OBJECT_NOT_EXISTS = 942;
    private static final int ORA_SQL_INDEX_NOT_EXISTS = 1418;
    protected boolean internalDriver = false;

    OracleCollectionImpl(OracleDatabaseImpl oracleDatabaseImpl, String string) {
        this(oracleDatabaseImpl, string, CollectionDescriptor.createDefault(string));
    }

    OracleCollectionImpl(OracleDatabaseImpl oracleDatabaseImpl, String string, CollectionDescriptor collectionDescriptor) {
        this.db = oracleDatabaseImpl;
        this.collectionName = string;
        this.options = collectionDescriptor;
        this.metrics = oracleDatabaseImpl.getMetrics();
        this.conn = oracleDatabaseImpl.getConnection();
        this.setAvoid();
    }

    public void setAvoid() {
        if (System.getProperty("oracle.jserver.version") != null) {
            this.internalDriver = true;
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Avoid returning clauses for internal connections");
            }
        }
    }

    private String getName() {
        return this.collectionName;
    }

    protected boolean isReadOnly() {
        return !this.options.writable;
    }

    private boolean isHeterogeneous() {
        return this.options.doctypeColumnName != null && this.options.contentDataType == 4;
    }

    public boolean hasClientAssignedKeys() {
        return this.options.keyAssignmentMethod == 1;
    }

    public boolean isBinary() {
        return this.options.contentDataType == 4 || this.options.contentDataType == 2;
    }

    public boolean payloadBasedVersioning() {
        return this.options.versioningMethod == 5 || this.options.versioningMethod == 4 || this.options.versioningMethod == 0;
    }

    boolean matches(CollectionDescriptor collectionDescriptor) {
        return this.options.matches(collectionDescriptor);
    }

    private void drop() throws OracleException {
        this.db.dropCollection(this.collectionName);
    }

    void writeCheck(String string) throws OracleException {
        if (this.isReadOnly()) {
            if (OracleLog.isLoggingEnabled()) {
                log.warning("Write to " + this.options.uriName + " not allowed");
            }
            throw SODAUtils.makeException(SODAMessage.EX_READ_ONLY, this.options.uriName, string);
        }
    }

    protected String computeVersion(byte[] byArray) throws OracleException {
        if (byArray == null) {
            byArray = EMPTY_DATA;
        }
        String string = null;
        this.metrics.startTiming();
        switch (this.options.versioningMethod) {
            case 5: {
                try {
                    byte[] byArray2 = HashFuncs.MD5(byArray);
                    if (byArray2 == null) {
                        OracleException oracleException = SODAUtils.makeException(SODAMessage.EX_MD5_NOT_SUPPORTED, new Object[0]);
                        if (OracleLog.isLoggingEnabled()) {
                            log.warning(oracleException.getMessage());
                        }
                        throw oracleException;
                    }
                    string = ByteArray.rawToHex(byArray2);
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    OracleException oracleException = SODAUtils.makeException(SODAMessage.EX_MD5_NOT_SUPPORTED, noSuchAlgorithmException, new Object[0]);
                    if (OracleLog.isLoggingEnabled()) {
                        log.warning(oracleException.getMessage());
                    }
                    throw oracleException;
                }
            }
            case 4: {
                try {
                    byte[] byArray3 = HashFuncs.SHA256(byArray);
                    if (byArray3 == null) {
                        OracleException oracleException = SODAUtils.makeException(SODAMessage.EX_SHA256_NOT_SUPPORTED, new Object[0]);
                        if (OracleLog.isLoggingEnabled()) {
                            log.warning(oracleException.getMessage());
                        }
                        throw oracleException;
                    }
                    string = ByteArray.rawToHex(byArray3);
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    OracleException oracleException = SODAUtils.makeException(SODAMessage.EX_SHA256_NOT_SUPPORTED, noSuchAlgorithmException, new Object[0]);
                    if (OracleLog.isLoggingEnabled()) {
                        log.warning(oracleException.getMessage());
                    }
                    throw oracleException;
                }
            }
        }
        this.metrics.recordChecksum();
        return string;
    }

    protected String uidToDecimal(String string) {
        byte[] byArray = ByteArray.hexToRaw(string);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = new BigDecimal(256L);
        for (int i = 0; i < byArray.length; ++i) {
            bigDecimal = bigDecimal.multiply(bigDecimal2).add(new BigDecimal(byArray[i] & 0xFF));
        }
        return bigDecimal.toPlainString();
    }

    private boolean isInteger(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if ("0123456789".indexOf(cArray[i]) >= 0) continue;
            return false;
        }
        return true;
    }

    private String zeroStrip(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        for (n = 0; n < n2 && string.charAt(n) == '0'; ++n) {
        }
        if (n == 0) {
            return string;
        }
        if (n == n2) {
            return "0";
        }
        return string.substring(n);
    }

    protected String canonicalKey(String string) throws OracleException {
        if (this.options.keyDataType == 3) {
            if (!this.isInteger(string = this.zeroStrip(string))) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_KEY, string, this.options.getKeyDataType());
            }
        } else if (this.options.keyAssignmentMethod == 3 || this.options.keyAssignmentMethod == 2) {
            int n;
            int n2 = string.length();
            if (n2 < (n = 32)) {
                String string2 = "00000000000000000000000000000000";
                string = string2.substring(1, n - n2) + string;
            } else if (n2 > n) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_KEY, string, this.options.getKeyAssignmentMethod());
            }
            if (!ByteArray.isHex(string)) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_KEY, string, this.options.getKeyAssignmentMethod());
            }
        } else if (this.options.keyDataType == 4) {
            if (!ByteArray.isHex(string)) {
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_KEY, string, this.options.getKeyDataType());
            }
        } else if (this.options.keyAssignmentMethod == 4 && !this.isInteger(string = this.zeroStrip(string))) {
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_KEY, string, "INTEGER");
        }
        return string;
    }

    static String stringFromBytes(byte[] byArray, boolean bl) throws OracleException {
        if (byArray == null) {
            return "";
        }
        if (byArray.length == 0) {
            return "";
        }
        Charset charset = JsonByteArray.getJsonCharset(byArray);
        if (!bl) {
            return new String(byArray, charset);
        }
        try {
            return ByteArray.bytesToString(byArray, charset);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new OracleException(characterCodingException);
        }
    }

    static String stringFromBytes(byte[] byArray) throws OracleException {
        return OracleCollectionImpl.stringFromBytes(byArray, false);
    }

    @Override
    public OracleDocument findOne(String string) throws OracleException {
        return this.find().key(string).getOne();
    }

    public abstract OracleDocumentFragmentImpl findFragment(String var1, long var2, int var4) throws OracleException;

    @Override
    public OracleOperationBuilder find() {
        return new OracleOperationBuilderImpl(this, this.conn);
    }

    private void truncate() throws OracleException {
        this.writeCheck("truncate");
        if (this.options.dbObjectType != 0) {
            throw SODAUtils.makeException(SODAMessage.EX_TRUNCATE_NOT_SUPP, this.options.uriName);
        }
        this.sb.setLength(0);
        this.sb.append("truncate table \"");
        this.sb.append(this.options.dbObjectName);
        this.sb.append("\"");
        String string = this.sb.toString();
        PreparedStatement preparedStatement = null;
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string);
            preparedStatement.execute();
            if (OracleLog.isLoggingEnabled()) {
                log.fine("Truncated collection " + this.collectionName);
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordDDL();
        }
        catch (SQLException sQLException) {
            try {
                throw SODAUtils.makeExceptionWithSQLText(sQLException, string);
            }
            catch (Throwable throwable) {
                for (String string2 : SODAUtils.closeCursor(preparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string2);
                }
                throw throwable;
            }
        }
        for (String string3 : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string3);
        }
    }

    public String toString() {
        return this.options.toString();
    }

    @Override
    public OracleCollectionAdmin admin() {
        if (this.admin == null) {
            this.admin = new OracleCollectionAdministrationImpl();
        }
        return this.admin;
    }

    CollectionDescriptor getOptions() {
        return this.options;
    }

    MetricsCollector getMetrics() {
        return this.metrics;
    }

    OracleDatabaseImpl getDatabase() {
        return this.db;
    }

    void appendTable(StringBuilder stringBuilder) {
        stringBuilder.append("\"");
        if (this.options.dbSchema != null) {
            stringBuilder.append(this.options.dbSchema);
            stringBuilder.append("\".\"");
        }
        stringBuilder.append(this.options.dbObjectName);
        stringBuilder.append("\"");
    }

    private void addFormat(StringBuilder stringBuilder) {
        if (this.options.contentDataType == 4 || this.options.contentDataType == 2) {
            stringBuilder.append(" format json");
        }
    }

    private String buildCTXIndexDDL(String string, String string2) throws OracleException {
        this.sb.setLength(0);
        this.sb.append("create index \"");
        this.sb.append(string);
        this.sb.append("\" on ");
        this.appendTable(this.sb);
        this.sb.append(" (\"");
        this.sb.append(this.options.contentColumnName);
        this.sb.append("\") ");
        this.sb.append("indextype is ctxsys.context parameters(");
        this.sb.append("'section group CTXSYS.JSON_SECTION_GROUP ");
        try {
            this.sb.append("lexer ");
            this.sb.append(IndexSpecification.getLexer(string2));
            this.sb.append(" ");
        }
        catch (QueryException queryException) {
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_INDEX_CREATE, queryException, new Object[0]);
        }
        this.sb.append("stoplist CTXSYS.EMPTY_STOPLIST ");
        this.sb.append("sync (on commit) ");
        this.sb.append("memory 100M");
        this.sb.append("') parallel 8");
        return this.sb.toString();
    }

    private String dropIndexDDL(String string) {
        this.sb.setLength(0);
        this.sb.append("drop index \"");
        this.sb.append(string);
        this.sb.append("\"");
        return this.sb.toString();
    }

    private String buildIndexDDL(String string, boolean bl, boolean bl2, JsonPath[] jsonPathArray) throws OracleException {
        this.sb.setLength(0);
        this.sb.append("create ");
        if (bl) {
            this.sb.append("unique ");
        }
        this.sb.append("index \"");
        this.sb.append(string);
        this.sb.append("\" on ");
        this.appendTable(this.sb);
        this.sb.append(" (");
        boolean bl3 = true;
        int n = 0;
        int n2 = 0;
        for (JsonPath jsonPath : jsonPathArray) {
            String string2 = null;
            int n3 = 0;
            int n4 = 0;
            String string3 = null;
            if (jsonPath instanceof IndexColumn) {
                string2 = ((IndexColumn)jsonPath).getSqlTypeName();
                n3 = ((IndexColumn)jsonPath).getSqlType();
                n4 = ((IndexColumn)jsonPath).getMaxLength();
                string3 = ((IndexColumn)jsonPath).getOrder();
            }
            String[] stringArray = jsonPath.getSteps();
            if (bl3) {
                bl3 = false;
            } else {
                this.sb.append(", ");
            }
            boolean bl4 = false;
            if (string2 != null) {
                bl4 = true;
            }
            this.sb.append("JSON_VALUE(\"");
            this.sb.append(this.options.contentColumnName);
            this.sb.append("\"");
            this.addFormat(this.sb);
            this.sb.append(",'$");
            for (String string4 : stringArray) {
                if (string4.charAt(0) == '[') continue;
                this.sb.append(".");
                this.sb.append(string4);
                this.sb.append("[0]");
            }
            this.sb.append("'");
            if (bl4) {
                this.sb.append(" returning ");
                this.sb.append(string2);
                if (n3 == 1) {
                    if (n + 1 > 16) {
                        throw SODAUtils.makeException(SODAMessage.EX_TOO_MANY_COLUMNS, Integer.toString(n));
                    }
                    if (n4 > 0) {
                        this.sb.append("(");
                        this.sb.append(n4);
                        this.sb.append(")");
                        n2 += n4;
                    } else {
                        this.sb.append("(\uffff)");
                        ++n;
                    }
                }
            }
            if (bl2) {
                this.sb.append(" ERROR ON ERROR");
            }
            this.sb.append(") ");
            if (string3 == null) continue;
            this.sb.append(string3);
        }
        this.sb.append(")");
        Object object = this.sb.toString();
        if (n > 0) {
            int n5 = 0;
            if (n2 < 2000) {
                n5 = (2000 - n2) / n;
            }
            if (n5 < 255) {
                n5 = 255;
            }
            if ((n2 += n5 * n2) > 4000 && OracleLog.isLoggingEnabled()) {
                log.warning("Total size of index " + string + " is " + n2);
            }
            object = ((String)object).replaceAll("\uffff", Integer.toString(n5));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(String string, boolean bl, boolean bl2, JsonPath[] jsonPathArray, String string2) throws OracleException {
        PreparedStatement preparedStatement = null;
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "indexName");
        }
        string = CollectionDescriptor.stringToIdentifier(string);
        String string3 = null;
        if (jsonPathArray == null || jsonPathArray.length == 0) {
            if (this.options.contentDataType == 3 || this.options.contentDataType == 6) {
                throw SODAUtils.makeException(SODAMessage.EX_UNSUPPORTED_INDEX_CREATE, this.options.getContentDataType());
            }
            if (this.options.contentLobEncrypt != 0) {
                throw SODAUtils.makeException(SODAMessage.EX_UNSUPPORTED_ENCRYPTED_INDEX_CREATE, new Object[0]);
            }
            if (this.options.keyDataType == 2) {
                throw SODAUtils.makeException(SODAMessage.EX_UNSUPPORTED_INDEX_CREATE2, new Object[0]);
            }
            string3 = this.buildCTXIndexDDL(string, string2);
        } else {
            string3 = this.buildIndexDDL(string, bl, bl2, jsonPathArray);
        }
        try {
            this.metrics.startTiming();
            if (OracleLog.isLoggingEnabled()) {
                log.info("Index DDL: " + string3);
            }
            preparedStatement = this.conn.prepareStatement(string3);
            preparedStatement.execute();
            if (OracleLog.isLoggingEnabled()) {
                log.info("Created index " + string);
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordDDL();
        }
        catch (SQLException sQLException) {
            try {
                if (sQLException.getErrorCode() == 955) {
                    if (OracleLog.isLoggingEnabled()) {
                        log.warning(sQLException.toString());
                    }
                } else {
                    if (OracleLog.isLoggingEnabled()) {
                        log.warning(sQLException.toString());
                    }
                    throw SODAUtils.makeExceptionWithSQLText(sQLException, string3);
                }
            }
            catch (Throwable throwable) {
                for (String string4 : SODAUtils.closeCursor(preparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string4);
                }
                throw throwable;
            }
            for (String string5 : SODAUtils.closeCursor(preparedStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string5);
            }
        }
        for (String string6 : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIndex(String string) throws OracleException {
        PreparedStatement preparedStatement = null;
        if (string == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "indexName");
        }
        string = CollectionDescriptor.stringToIdentifier(string);
        String string2 = this.dropIndexDDL(string);
        try {
            this.metrics.startTiming();
            preparedStatement = this.conn.prepareStatement(string2);
            preparedStatement.execute();
            if (OracleLog.isLoggingEnabled()) {
                log.info("Dropped index " + string);
            }
            preparedStatement.close();
            preparedStatement = null;
            this.metrics.recordDDL();
        }
        catch (SQLException sQLException) {
            try {
                int n = sQLException.getErrorCode();
                if (n == 942 || n == 1418) {
                    if (OracleLog.isLoggingEnabled()) {
                        log.warning(sQLException.toString());
                    }
                } else {
                    if (OracleLog.isLoggingEnabled()) {
                        log.warning(sQLException.toString());
                    }
                    throw SODAUtils.makeExceptionWithSQLText(sQLException, string2);
                }
            }
            catch (Throwable throwable) {
                for (String string3 : SODAUtils.closeCursor(preparedStatement, null)) {
                    if (!OracleLog.isLoggingEnabled()) continue;
                    log.severe(string3);
                }
                throw throwable;
            }
            for (String string4 : SODAUtils.closeCursor(preparedStatement, null)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string4);
            }
        }
        for (String string5 : SODAUtils.closeCursor(preparedStatement, null)) {
            if (!OracleLog.isLoggingEnabled()) continue;
            log.severe(string5);
        }
    }

    public void dropIndex(OracleDocument oracleDocument) throws OracleException {
        String string = null;
        if (oracleDocument == null) {
            throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "indexSpecification");
        }
        IndexSpecification indexSpecification = new IndexSpecification(((OracleDocumentImpl)oracleDocument).getContentAsStream());
        try {
            string = indexSpecification.parse();
        }
        catch (QueryException queryException) {
            if (OracleLog.isLoggingEnabled()) {
                log.warning(queryException.toString());
            }
            throw SODAUtils.makeException(SODAMessage.EX_INVALID_INDEX_DROP, queryException, new Object[0]);
        }
        this.dropIndex(string);
    }

    private class OracleCollectionAdministrationImpl
    implements OracleCollectionAdmin {
        private OracleCollectionAdministrationImpl() {
        }

        @Override
        public String getName() {
            return OracleCollectionImpl.this.getName();
        }

        @Override
        public void drop() throws OracleException {
            OracleCollectionImpl.this.drop();
        }

        @Override
        public void truncate() throws OracleException {
            OracleCollectionImpl.this.truncate();
        }

        @Override
        public boolean isHeterogeneous() {
            return OracleCollectionImpl.this.isHeterogeneous();
        }

        @Override
        public boolean isReadOnly() {
            return OracleCollectionImpl.this.isReadOnly();
        }

        @Override
        public OracleDocument getMetadata() {
            OracleDocumentImpl oracleDocumentImpl = new OracleDocumentImpl(OracleCollectionImpl.this.options.getDescription());
            return oracleDocumentImpl;
        }

        @Override
        public void indexAll(String string) throws OracleException {
            OracleCollectionImpl.this.createIndex(string, false, false, null, null);
        }

        @Override
        public void indexAll(String string, String string2) throws OracleException {
            OracleCollectionImpl.this.createIndex(string, false, false, null, string2);
        }

        @Override
        public void createIndex(OracleDocument oracleDocument) throws OracleException {
            String string = null;
            if (oracleDocument == null) {
                throw SODAUtils.makeException(SODAMessage.EX_ARG_CANNOT_BE_NULL, "indexSpecification");
            }
            IndexSpecification indexSpecification = new IndexSpecification(((OracleDocumentImpl)oracleDocument).getContentAsStream());
            try {
                string = indexSpecification.parse();
            }
            catch (QueryException queryException) {
                if (OracleLog.isLoggingEnabled()) {
                    log.warning(queryException.toString());
                }
                throw SODAUtils.makeException(SODAMessage.EX_INVALID_INDEX_CREATE, queryException, new Object[0]);
            }
            OracleCollectionImpl.this.createIndex(string, indexSpecification.isUnique(), indexSpecification.isSingleton(), indexSpecification.getColumns(), indexSpecification.getLanguage());
        }

        @Override
        public void dropIndex(String string) throws OracleException {
            OracleCollectionImpl.this.dropIndex(string);
        }
    }
}

