/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.json.common.MetricsCollector;
import oracle.soda.OracleClient;
import oracle.soda.OracleDatabase;
import oracle.soda.OracleException;
import oracle.soda.rdbms.OracleRDBMSMetadataBuilder;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.OracleDatabaseImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.soda.rdbms.impl.cache.CacheOfDescriptorCaches;
import oracle.soda.rdbms.impl.cache.DescriptorCache;

public class OracleRDBMSClient
implements OracleClient {
    private CacheOfDescriptorCaches cacheOfDescriptorCaches;
    private boolean localMetadataCache;
    private final MetricsCollector mcollector = new MetricsCollector();

    public OracleRDBMSClient() {
    }

    public OracleRDBMSClient(Properties properties) {
        this();
        if (properties != null) {
            String string = properties.getProperty("oracle.soda.sharedMetadataCache");
            String string2 = properties.getProperty("oracle.soda.localMetadataCache");
            if (string != null && string.equalsIgnoreCase("true")) {
                this.cacheOfDescriptorCaches = new CacheOfDescriptorCaches(100, 100);
            }
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                this.localMetadataCache = true;
            }
        }
    }

    @Override
    public OracleDatabase getDatabase(Connection connection) throws OracleException {
        String string;
        OracleConnection oracleConnection = (OracleConnection)connection;
        try {
            string = oracleConnection.getCurrentSchema();
        }
        catch (SQLException sQLException) {
            throw new OracleException(sQLException);
        }
        if (string == null && this.cacheOfDescriptorCaches != null) {
            throw SODAUtils.makeException(SODAMessage.EX_SCHEMA_NAME_IS_NULL, new Object[0]);
        }
        DescriptorCache descriptorCache = null;
        if (this.cacheOfDescriptorCaches != null) {
            descriptorCache = this.cacheOfDescriptorCaches.putIfAbsentAndGet(string);
        }
        return new OracleDatabaseImpl(oracleConnection, descriptorCache, this.mcollector, this.localMetadataCache);
    }

    public OracleRDBMSMetadataBuilder createMetadataBuilder() {
        return CollectionDescriptor.createStandardBuilder();
    }
}

