/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.util;

import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import oracle.json.util.ByteArray;

public final class UriTools {
    private static final String URI_STEP_ALLOWED = ".-_~+";
    private static final String URI_ARG_ALLOWED = ".-_~*";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char[] hexDigits = "0123456789ABCDEFabcdef".toCharArray();
    private static final char MIN_ALLOWED_CHARVAL = ' ';
    private static final char MAX_ALLOWED_CHARVAL = '\u00ff';

    private UriTools() {
    }

    private static String encode(String string, String string2) {
        int n;
        byte[] byArray = string.getBytes(ByteArray.DEFAULT_CHARSET);
        ByteArray byteArray = new ByteArray(byArray.length);
        byte[] byArray2 = new byte[3];
        byArray2[0] = 37;
        int n2 = 0;
        for (n = 0; n < byArray.length; ++n) {
            int n3 = byArray[n] & 0xFF;
            if (n3 >= 97 && n3 <= 122 || n3 >= 65 && n3 <= 90 || n3 >= 48 && n3 <= 57 || n3 >= 32 && n3 <= 126 && string2.indexOf((char)n3) >= 0) continue;
            if (n > n2) {
                byteArray.append(byArray, n2, n - n2);
            }
            n2 = n + 1;
            byArray2[1] = (byte)hexDigits[n3 >> 4 & 0xF];
            byArray2[2] = (byte)hexDigits[n3 & 0xF];
            byteArray.append(byArray2);
        }
        if (n2 == 0) {
            return string;
        }
        if (n > n2) {
            byteArray.append(byArray, n2, n - n2);
        }
        return byteArray.getString();
    }

    public static String encodePath(String string) {
        return UriTools.encode(string, URI_STEP_ALLOWED);
    }

    public static String encodeArg(String string) {
        return UriTools.encode(string, URI_ARG_ALLOWED);
    }

    private static int digitToNibble(int n) throws CharacterCodingException {
        for (int i = 0; i < hexDigits.length; ++i) {
            if (hexDigits[i] != n) continue;
            if (i >= 16) {
                i -= 6;
            }
            return i;
        }
        throw new CharacterCodingException();
    }

    private static String decode(String string, boolean bl) throws CharacterCodingException {
        int n;
        byte[] byArray = string.getBytes(ByteArray.DEFAULT_CHARSET);
        ByteArray byteArray = new ByteArray(byArray.length);
        byte[] byArray2 = new byte[1];
        int n2 = 0;
        for (n = 0; n < byArray.length; ++n) {
            int n3 = byArray[n] & 0xFF;
            if ((n3 != 43 || !bl) && n3 != 37) continue;
            if (n > n2) {
                byteArray.append(byArray, n2, n - n2);
            }
            ++n;
            if (n3 == 43) {
                byArray2[0] = 32;
            } else {
                if (byArray.length - n < 2) {
                    throw new CharacterCodingException();
                }
                int n4 = UriTools.digitToNibble(byArray[n++] & 0xFF) << 4;
                byArray2[0] = (byte)(n4 |= UriTools.digitToNibble(byArray[n++] & 0xFF));
            }
            byteArray.append(byArray2);
            n2 = n--;
        }
        if (n2 == 0) {
            return string;
        }
        if (n > n2) {
            byteArray.append(byArray, n2, n - n2);
        }
        return ByteArray.bytesToString(byteArray);
    }

    public static String decodePath(String string) throws CharacterCodingException {
        return UriTools.decode(string, false);
    }

    public static String[] parsePath(String string) throws CharacterCodingException {
        return UriTools.parsePath(string, true);
    }

    public static String[] parsePath(String string, boolean bl) throws CharacterCodingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf(47);
        while (n >= 0) {
            int n2 = string.indexOf(47, n + 1);
            String string2 = n2 < 0 ? string.substring(n + 1) : string.substring(n + 1, n2);
            if (bl) {
                string2 = UriTools.decodePath(string2);
            }
            arrayList.add(string2);
            n = n2;
        }
        int n3 = arrayList.size();
        if (n3 == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return arrayList.toArray(new String[n3]);
    }

    public static String makeInitCap(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = stringBuilder.length();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = stringBuilder.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (Character.isLowerCase(c)) {
                    if (bl) {
                        stringBuilder.setCharAt(i, Character.toUpperCase(c));
                    }
                } else if (Character.isUpperCase(c) && !bl) {
                    stringBuilder.setCharAt(i, Character.toLowerCase(c));
                }
                bl = false;
                continue;
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static String sanitizeHeader(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '\u00ff') continue;
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            for (int j = i; j < n; ++j) {
                c = cArray[j];
                if (c >= ' ' && c <= '\u00ff') continue;
                cArray[j] = 191;
            }
            return new String(cArray);
        }
        return string;
    }
}

