/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.util.ArrayList;
import java.util.Formatter;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;

public class PathParser {
    private static final char STEP_SEPARATOR = '.';
    private static final char SEG_DELIMITER = '`';
    private static final char SQL_DELIMITER = '\"';
    private static final char ESCAPE_CHAR = '\\';
    private static final char ARRAY_START = '[';
    private static final char ARRAY_STOP = ']';
    private static final char WILD_STEP = '*';
    private final char[] pathString;
    private static final String ALPHA_NUM_UNDER = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final int IS_DIGIT_POS = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".indexOf(48);

    public PathParser(String string) {
        this.pathString = string.toCharArray();
    }

    private String buildStep(StringBuilder stringBuilder, boolean bl, boolean bl2) {
        String string;
        if (bl && !bl2 && stringBuilder.length() == 2 && stringBuilder.charAt(1) == '*') {
            bl = false;
        }
        if (!bl) {
            string = stringBuilder.substring(1);
        } else {
            stringBuilder.append('\"');
            string = stringBuilder.toString();
        }
        stringBuilder.setLength(1);
        return string;
    }

    private String buildArrayStep(StringBuilder stringBuilder) {
        stringBuilder.append(']');
        String string = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append('\"');
        return string;
    }

    private void throwException(QueryMessage queryMessage, Object ... objectArray) throws QueryException {
        throw new QueryException(queryMessage.get(objectArray));
    }

    private void throwPathException(QueryMessage queryMessage, int n) throws QueryException {
        this.throwException(queryMessage, new String(this.pathString), Integer.toString(n));
    }

    private void throwArrayException(String string) throws QueryException {
        this.throwException(QueryMessage.EX_BAD_ARRAY_SUBSCRIPT, new String(this.pathString), string);
    }

    private void validateArrayStep(String string) throws QueryException {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        for (int i = 1; i < string.length() - 1; ++i) {
            char c = string.charAt(i);
            if (c == '*') {
                if (!bl) {
                    this.throwArrayException(string);
                }
                bl = false;
                bl2 = false;
                continue;
            }
            if (c == ',') {
                if (!bl3) {
                    this.throwArrayException(string);
                }
                bl3 = false;
                bl5 = false;
                bl4 = false;
                bl8 = true;
                continue;
            }
            if ("0123456789".indexOf(c) >= 0) {
                if (!bl2) {
                    this.throwArrayException(string);
                }
                bl = false;
                bl3 = true;
                bl4 = true;
                bl8 = false;
                continue;
            }
            if (" \t\n\r".indexOf(c) >= 0) {
                if (bl6) {
                    this.throwArrayException(string);
                }
                if (bl4) {
                    bl2 = false;
                    bl5 = true;
                    bl3 = true;
                    continue;
                }
                if (!bl7) continue;
                bl2 = true;
                bl7 = false;
                bl8 = true;
                continue;
            }
            if (c == 't') {
                if (!bl5) {
                    this.throwArrayException(string);
                }
                bl6 = true;
                bl3 = false;
                bl4 = false;
                continue;
            }
            if (c == 'o') {
                if (!bl6) {
                    this.throwArrayException(string);
                }
                bl6 = false;
                bl5 = false;
                bl7 = true;
                continue;
            }
            this.throwArrayException(string);
        }
        if (bl) {
            this.throwArrayException(string);
        }
        if (bl6 || bl7 || bl8) {
            this.throwArrayException(string);
        }
    }

    public String[] splitAndSQLEscape() throws QueryException {
        if (this.pathString == null) {
            this.throwException(QueryMessage.EX_EMPTY_PATH, new Object[0]);
        }
        int n = this.pathString.length;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        StringBuilder stringBuilder = new StringBuilder(Math.max(n * 2 + 2, 128));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = false;
        int n2 = 0;
        stringBuilder.append('\"');
        if (n == 0) {
            bl4 = false;
            bl3 = true;
        }
        block10: while (n2 < this.pathString.length) {
            Object object;
            char c = this.pathString[n2];
            switch (c) {
                case '`': {
                    if (bl5 || bl6) {
                        this.throwPathException(QueryMessage.EX_MISSING_STEP_DOT, n2);
                    }
                    if (!bl) {
                        if (stringBuilder.length() > 1) {
                            this.throwPathException(QueryMessage.EX_BAD_BACKQUOTE, n2);
                        }
                        bl = true;
                        ++n2;
                        continue block10;
                    }
                    if (++n2 < this.pathString.length && (c = this.pathString[n2]) == '`') {
                        stringBuilder.append(c);
                        ++n2;
                        bl3 = true;
                        continue block10;
                    }
                    if (stringBuilder.length() == 1) {
                        bl3 = true;
                    }
                    bl = false;
                    bl6 = true;
                    continue block10;
                }
                case ']': {
                    if (bl2) {
                        bl2 = false;
                        object = this.buildArrayStep(stringBuilder);
                        this.validateArrayStep((String)object);
                        arrayList.add((String)object);
                        bl5 = true;
                        ++n2;
                        continue block10;
                    }
                    if (!bl && c == ']') {
                        this.throwPathException(QueryMessage.EX_PATH_SYNTAX_ERROR, n2);
                    }
                }
                case '.': 
                case '[': {
                    if (bl || bl2) break;
                    boolean bl7 = bl2 = c == '[';
                    if (stringBuilder.length() > 1 || bl6) {
                        arrayList.add(this.buildStep(stringBuilder, bl3, bl6));
                    } else if (!bl2) {
                        if (!bl5) {
                            arrayList.add(this.buildStep(stringBuilder, true, bl6));
                        }
                    } else if (!bl4) {
                        arrayList.add(this.buildStep(stringBuilder, true, bl6));
                    }
                    bl6 = false;
                    bl4 = bl2;
                    bl3 = false;
                    bl5 = false;
                    ++n2;
                    if (bl2) {
                        stringBuilder.setLength(0);
                        stringBuilder.append('[');
                        continue block10;
                    }
                    if (n2 < this.pathString.length) continue block10;
                    bl3 = true;
                    continue block10;
                }
            }
            if (bl5 || bl6) {
                this.throwPathException(QueryMessage.EX_MISSING_STEP_DOT, n2);
            }
            bl4 = true;
            if (c == '\'') {
                stringBuilder.append(c);
                stringBuilder.append(c);
                bl3 = true;
            } else if (c == '\"' || c == '\\') {
                bl3 = true;
                stringBuilder.append('\\');
                stringBuilder.append(c);
            } else if (c < ' ') {
                stringBuilder.append('\\');
                switch (c) {
                    case '\n': {
                        stringBuilder.append('n');
                        break;
                    }
                    case '\r': {
                        stringBuilder.append('r');
                        break;
                    }
                    case '\t': {
                        stringBuilder.append('t');
                        break;
                    }
                    default: {
                        object = new Formatter(stringBuilder);
                        ((Formatter)object).format("u%04x", c);
                        ((Formatter)object).close();
                    }
                }
                bl3 = true;
            } else {
                if (!bl3) {
                    int n3 = ALPHA_NUM_UNDER.indexOf(c);
                    if (n3 < 0) {
                        bl3 = true;
                    } else if (stringBuilder.length() == 1 && n3 >= IS_DIGIT_POS) {
                        bl3 = true;
                    }
                }
                stringBuilder.append(c);
            }
            ++n2;
        }
        if (bl2) {
            this.throwException(QueryMessage.EX_UNCLOSED_STEP, "array", new String(this.pathString));
        }
        if (bl) {
            this.throwException(QueryMessage.EX_UNCLOSED_STEP, "quote", new String(this.pathString));
        }
        if (stringBuilder.length() > 1 || !bl4 || bl6) {
            arrayList.add(this.buildStep(stringBuilder, bl3, bl6));
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public static String unescapeStep(String string) {
        if (string == null) {
            return "";
        }
        int n = string.length();
        if (n < 2) {
            return string;
        }
        char[] cArray = string.toCharArray();
        if (cArray[0] != '\"' || cArray[n - 1] != '\"') {
            return string;
        }
        int n2 = 1;
        int n3 = 0;
        block8: while (n2 < n - 1) {
            char c;
            if ((c = cArray[n2++]) == '\\') {
                c = cArray[n2];
                switch (c) {
                    case '\\': {
                        cArray[n3++] = 92;
                        ++n2;
                        continue block8;
                    }
                    case '\"': {
                        cArray[n3++] = 34;
                        ++n2;
                        continue block8;
                    }
                    case 'n': {
                        cArray[n3++] = 10;
                        ++n2;
                        continue block8;
                    }
                    case 'r': {
                        cArray[n3++] = 13;
                        ++n2;
                        continue block8;
                    }
                    case 't': {
                        cArray[n3++] = 9;
                        ++n2;
                        continue block8;
                    }
                    case 'u': {
                        int n4;
                        int n5;
                        String string2 = "0123456789ABCDEFabcdef";
                        int n6 = 0;
                        int n7 = n2;
                        for (n5 = 0; n5 < 4 && ++n7 < n && (n4 = string2.indexOf(cArray[n7])) >= 0; ++n5) {
                            if (n4 >= 16) {
                                n4 -= 6;
                            }
                            n6 = n6 << 4 | n4;
                        }
                        if (n5 == 4) {
                            cArray[n3++] = (char)n6;
                            n2 += n5 + 1;
                            continue block8;
                        }
                    }
                    default: {
                        cArray[n3++] = 92;
                        break;
                    }
                }
                continue;
            }
            if (c == '\'') {
                c = cArray[n2];
                if (c == '\'') {
                    ++n2;
                }
                cArray[n3++] = 39;
                continue;
            }
            cArray[n3++] = c;
        }
        return new String(cArray, 0, n3);
    }
}

