/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import oracle.json.parser.PathParser;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;

public class JsonQueryPath {
    private String[] steps = null;
    private String path = null;
    private boolean arrayEnd = false;
    private boolean arrayBegin = false;

    public JsonQueryPath(String string) throws QueryException {
        if (string != null) {
            this.steps = new PathParser(string).splitAndSQLEscape();
            if (this.steps == null) {
                throw new QueryException(QueryMessage.EX_BAD_PATH.get(string));
            }
            if (this.steps.length == 0) {
                throw new QueryException(QueryMessage.EX_EMPTY_PATH.get(string));
            }
            StringBuilder stringBuilder = new StringBuilder(string.length() + this.steps.length);
            for (int i = 0; i < this.steps.length; ++i) {
                boolean bl = this.arrayEnd = this.steps[i].charAt(0) == '[';
                if (i == 0) {
                    this.arrayBegin = this.arrayEnd;
                } else if (!this.arrayEnd) {
                    stringBuilder.append(".");
                }
                stringBuilder.append(this.steps[i]);
            }
            this.path = stringBuilder.toString();
        }
    }

    public JsonQueryPath() throws QueryException {
        this(null);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        JsonQueryPath jsonQueryPath = (JsonQueryPath)object;
        if (this.path == jsonQueryPath.path) {
            return true;
        }
        if (jsonQueryPath.steps == null || this.steps == null) {
            return false;
        }
        if (jsonQueryPath.steps.length != this.steps.length) {
            return false;
        }
        for (int i = 0; i < this.steps.length; ++i) {
            if (this.steps[i].equals(jsonQueryPath.steps[i])) continue;
            return false;
        }
        return true;
    }

    String toQueryString(boolean bl) {
        if (this.arrayEnd || !bl) {
            if (this.arrayBegin) {
                return this.path;
            }
            return "." + this.path;
        }
        if (this.arrayBegin) {
            return this.path + "[*]";
        }
        return "." + this.path + "[*]";
    }

    public String[] getSteps() {
        return this.steps;
    }

    public int hashCode() {
        if (this.path == null) {
            return 0;
        }
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }
}

