/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import oracle.json.parser.DocumentLoader;
import oracle.json.parser.IndexColumn;
import oracle.json.parser.PathParser;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;

public class IndexSpecification {
    private final InputStream source;
    private boolean is_parsed = false;
    private String idxName = null;
    private String language = null;
    private IndexColumn[] columns = new IndexColumn[0];
    private boolean is_unique = false;
    private boolean is_singleton = false;

    public IndexSpecification(InputStream inputStream) {
        this.source = inputStream;
    }

    private void makeException(QueryMessage queryMessage, Object ... objectArray) throws QueryException {
        QueryException.throwSyntaxException(queryMessage, objectArray);
    }

    private void close(boolean bl) throws QueryException {
        block2: {
            try {
                this.source.close();
            }
            catch (IOException iOException) {
                if (bl) break block2;
                throw new QueryException(QueryMessage.EX_INVALID_INDEX_SPEC.get(new Object[0]), iOException);
            }
        }
    }

    public String parse(boolean bl) throws QueryException {
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            if (this.source == null) {
                this.makeException(QueryMessage.EX_INVALID_INDEX_SPEC, new Object[0]);
            }
            DocumentLoader documentLoader = new DocumentLoader(this.source);
            JsonObject jsonObject = (JsonObject)documentLoader.parse();
            this.close(false);
            ArrayList<IndexColumn> arrayList = new ArrayList<IndexColumn>();
            for (Map.Entry entry : jsonObject.entrySet()) {
                JsonArray jsonArray;
                Iterator iterator;
                String string = (String)entry.getKey();
                JsonValue jsonValue = (JsonValue)entry.getValue();
                JsonValue.ValueType valueType = jsonValue.getValueType();
                if (string.equalsIgnoreCase("name")) {
                    if (valueType != JsonValue.ValueType.STRING) {
                        this.makeException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "index name", "STRING", valueType.toString());
                    }
                    this.idxName = ((JsonString)jsonValue).getString();
                    continue;
                }
                if (string.equalsIgnoreCase("unique")) {
                    if (valueType == JsonValue.ValueType.TRUE) {
                        this.is_unique = true;
                    } else if (valueType == JsonValue.ValueType.FALSE) {
                        this.is_unique = false;
                    } else {
                        this.makeException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "unique", "BOOLEAN", valueType.toString());
                    }
                    bl2 = true;
                    continue;
                }
                if (string.equalsIgnoreCase("singleton")) {
                    if (valueType == JsonValue.ValueType.TRUE) {
                        this.is_singleton = true;
                    } else if (valueType == JsonValue.ValueType.FALSE) {
                        this.is_singleton = false;
                    } else {
                        this.makeException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "singleton", "BOOLEAN", valueType.toString());
                    }
                    bl3 = true;
                    continue;
                }
                if (string.equalsIgnoreCase("language")) {
                    if (valueType != JsonValue.ValueType.STRING) {
                        this.makeException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "language", "STRING", valueType.toString());
                    }
                    this.language = ((JsonString)jsonValue).getString();
                    continue;
                }
                if (!string.equalsIgnoreCase("fields")) continue;
                if (valueType != JsonValue.ValueType.ARRAY) {
                    this.makeException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields", "ARRAY", valueType.toString());
                }
                if (!(iterator = (jsonArray = (JsonArray)jsonValue).iterator()).hasNext()) {
                    this.makeException(QueryMessage.EX_FIELDS_CANNOT_BE_EMPTY, new Object[0]);
                }
                while (iterator.hasNext()) {
                    String[] stringArray;
                    JsonValue jsonValue2 = (JsonValue)iterator.next();
                    if (jsonValue2.getValueType() != JsonValue.ValueType.OBJECT) {
                        this.makeException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "field", "OBJECT", jsonValue2.getValueType().toString());
                    }
                    JsonObject jsonObject2 = (JsonObject)jsonValue2;
                    IndexColumn indexColumn = new IndexColumn();
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    int n = 0;
                    boolean bl4 = false;
                    Object object = jsonObject2.entrySet().iterator();
                    while (object.hasNext()) {
                        stringArray = (String[])object.next();
                        String string5 = (String)stringArray.getKey();
                        JsonValue jsonValue3 = (JsonValue)stringArray.getValue();
                        JsonValue.ValueType valueType2 = jsonValue3.getValueType();
                        if (string5.equalsIgnoreCase("path")) {
                            if (valueType2 != JsonValue.ValueType.STRING) {
                                this.makeException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields.path", "STRING", valueType2.toString());
                            }
                            string2 = ((JsonString)jsonValue3).getString();
                            continue;
                        }
                        if (string5.equalsIgnoreCase("datatype")) {
                            if (valueType2 != JsonValue.ValueType.STRING) {
                                this.makeException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields.datatype", "STRING", valueType2.toString());
                            }
                            string3 = ((JsonString)jsonValue3).getString();
                            continue;
                        }
                        if (string5.equalsIgnoreCase("maxLength")) {
                            JsonNumber jsonNumber;
                            bl4 = true;
                            if (valueType2 != JsonValue.ValueType.NUMBER) {
                                this.makeException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields.maxLength", "NUMBER", valueType2.toString());
                            }
                            if (!(jsonNumber = (JsonNumber)jsonValue3).isIntegral()) {
                                this.makeException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields.maxLength", "integer", "decimal");
                            }
                            n = jsonNumber.intValue();
                            continue;
                        }
                        if (!string5.equalsIgnoreCase("order")) continue;
                        if (valueType2 == JsonValue.ValueType.STRING) {
                            string4 = ((JsonString)jsonValue3).getString();
                            if (string4.equalsIgnoreCase("asc") || string4.equalsIgnoreCase("desc") || string4.equals("1") || string4.equals("-1")) continue;
                            this.makeException(QueryMessage.EX_WRONG_ORDER, string4);
                            continue;
                        }
                        if (valueType2 == JsonValue.ValueType.NUMBER) {
                            string4 = ((JsonNumber)jsonValue3).toString();
                            if (string4.equals("-1") || string4.equals("1")) continue;
                            this.makeException(QueryMessage.EX_WRONG_ORDER, string4);
                            continue;
                        }
                        this.makeException(QueryMessage.EX_INDEX_PROP_WRONG_TYPE, "fields.order", "STRING", valueType2.toString());
                    }
                    if (string2 == null) {
                        this.makeException(QueryMessage.EX_INDEX_PROP_MISSING, "fields.path");
                    }
                    if ((stringArray = ((PathParser)(object = new PathParser(string2))).splitAndSQLEscape()) == null) {
                        this.makeException(QueryMessage.EX_INDEX_ILLEGAL_PATH, string2);
                    }
                    indexColumn.setPath(stringArray);
                    if (string3 != null) {
                        int n2 = indexColumn.setSqlType(string3);
                        if (n2 == 0) {
                            this.makeException(QueryMessage.EX_INVALID_INDEX_DTYPE, string3);
                        } else if (n2 != 1 && bl4) {
                            this.makeException(QueryMessage.EX_LENGTH_NOT_ALLOWED, string2);
                        }
                    }
                    if (n > 0) {
                        indexColumn.setMaxLength(n);
                    } else if (n < 0) {
                        this.makeException(QueryMessage.EX_INVALID_INDEX_DLEN, Integer.toString(n));
                    }
                    indexColumn.setOrder(string4);
                    arrayList.add(indexColumn);
                    indexColumn = null;
                }
            }
            int n = arrayList.size();
            if (n > 0) {
                if (this.language != null) {
                    this.makeException(QueryMessage.EX_LANGUAGE_NOT_EXPECTED, new Object[0]);
                }
                this.columns = new IndexColumn[n];
                this.columns = arrayList.toArray(this.columns);
            } else if (n == 0) {
                if (bl2) {
                    this.makeException(QueryMessage.EX_FIELDS_EXPECTED, "unique");
                } else if (bl3) {
                    this.makeException(QueryMessage.EX_FIELDS_EXPECTED, "singleton");
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new QueryException(QueryMessage.EX_INVALID_INDEX_SPEC.get(new Object[0]), illegalArgumentException);
        }
        catch (JsonParsingException jsonParsingException) {
            throw new QueryException(QueryMessage.EX_INVALID_INDEX_SPEC.get(new Object[0]), (Exception)((Object)jsonParsingException));
        }
        catch (JsonException jsonException) {
            throw new QueryException(QueryMessage.EX_INVALID_INDEX_SPEC.get(new Object[0]), (Exception)((Object)jsonException));
        }
        finally {
            this.close(true);
        }
        if (bl && this.idxName == null) {
            this.makeException(QueryMessage.EX_INDEX_PROP_MISSING, "name");
        }
        this.is_parsed = true;
        return this.idxName;
    }

    public String parse() throws QueryException {
        return this.parse(true);
    }

    public String getName() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.idxName;
    }

    public String getLanguage() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.language;
    }

    public boolean isUnique() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.is_unique;
    }

    public boolean isSingleton() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.is_singleton;
    }

    public IndexColumn[] getColumns() {
        if (!this.is_parsed) {
            throw new IllegalStateException("Not parsed");
        }
        return this.columns;
    }

    public static String getLexer(String string) throws QueryException {
        String string2 = null;
        if (string == null) {
            string2 = "CTXSYS.JSONREST_ENGLISH_LEXER";
        } else if (string.equalsIgnoreCase("english")) {
            string2 = "CTXSYS.JSONREST_ENGLISH_LEXER";
        } else if (string.equalsIgnoreCase("arabic")) {
            string2 = "CTXSYS.JSONREST_ARABIC_LEXER";
        } else if (string.equalsIgnoreCase("nynorsk")) {
            string2 = "CTXSYS.JSONREST_NYNORSK_LEXER";
        } else if (string.equalsIgnoreCase("bokmal")) {
            string2 = "CTXSYS.JSONREST_BOKMAL_LEXER";
        } else if (string.equalsIgnoreCase("persian")) {
            string2 = "CTXSYS.JSONREST_PERSIAN_LEXER";
        } else if (string.equalsIgnoreCase("croatian")) {
            string2 = "CTXSYS.JSONREST_CROATIAN_LEXER";
        } else if (string.equalsIgnoreCase("serbian")) {
            string2 = "CTXSYS.JSONREST_SERBIAN_LEXER";
        } else if (string.equalsIgnoreCase("danish")) {
            string2 = "CTXSYS.JSONREST_DANISH_LEXER";
        } else if (string.equalsIgnoreCase("slovak")) {
            string2 = "CTXSYS.JSONREST_SLOVAK_LEXER";
        } else if (string.equalsIgnoreCase("finnish")) {
            string2 = "CTXSYS.JSONREST_FINNISH_LEXER";
        } else if (string.equalsIgnoreCase("slovenian")) {
            string2 = "CTXSYS.JSONREST_SLOVENIAN_LEXER";
        } else if (string.equalsIgnoreCase("hebrew")) {
            string2 = "CTXSYS.JSONREST_HEBREW_LEXER";
        } else if (string.equalsIgnoreCase("thai")) {
            string2 = "CTXSYS.JSONREST_THAI_LEXER";
        } else if (string.equalsIgnoreCase("catalan")) {
            string2 = "CTXSYS.JSONREST_CATALAN_LEXER";
        } else if (string.equalsIgnoreCase("korean")) {
            string2 = "CTXSYS.JSONREST_KOREAN_LEXER";
        } else if (string.equalsIgnoreCase("czech")) {
            string2 = "CTXSYS.JSONREST_CZECH_LEXER";
        } else if (string.equalsIgnoreCase("polish")) {
            string2 = "CTXSYS.JSONREST_POLISH_LEXER";
        } else if (string.equalsIgnoreCase("dutch")) {
            string2 = "CTXSYS.JSONREST_DUTCH_LEXER";
        } else if (string.equalsIgnoreCase("portuguese")) {
            string2 = "CTXSYS.JSONREST_PORTUGUESE_LEXER";
        } else if (string.equalsIgnoreCase("romanian")) {
            string2 = "CTXSYS.JSONREST_ROMANIAN_LEXER";
        } else if (string.equalsIgnoreCase("french")) {
            string2 = "CTXSYS.JSONREST_FRENCH_LEXER";
        } else if (string.equalsIgnoreCase("russian")) {
            string2 = "CTXSYS.JSONREST_RUSSIAN_LEXER";
        } else if (string.equalsIgnoreCase("german")) {
            string2 = "CTXSYS.JSONREST_GERMAN_LEXER";
        } else if (string.equalsIgnoreCase("simp-chinese")) {
            string2 = "CTXSYS.JSONREST_SCHINESE_LEXER";
        } else if (string.equalsIgnoreCase("trad-chinese")) {
            string2 = "CTXSYS.JSONREST_TCHINESE_LEXER";
        } else if (string.equalsIgnoreCase("greek")) {
            string2 = "CTXSYS.JSONREST_GREEK_LEXER";
        } else if (string.equalsIgnoreCase("spanish")) {
            string2 = "CTXSYS.JSONREST_SPANISH_LEXER";
        } else if (string.equalsIgnoreCase("hungarian")) {
            string2 = "CTXSYS.JSONREST_HUNGARIAN_LEXER";
        } else if (string.equalsIgnoreCase("swedish")) {
            string2 = "CTXSYS.JSONREST_SWEDISH_LEXER";
        } else if (string.equalsIgnoreCase("italian")) {
            string2 = "CTXSYS.JSONREST_ITALIAN_LEXER";
        } else if (string.equalsIgnoreCase("japanese")) {
            string2 = "CTXSYS.JSONREST_JAPANESE_LEXER";
        } else if (string.equalsIgnoreCase("turkish")) {
            string2 = "CTXSYS.JSONREST_TURKISH_LEXER";
        } else {
            QueryException.throwSyntaxException(QueryMessage.EX_INVALID_INDEX_LANG, string);
        }
        return string2;
    }
}

