/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import oracle.json.parser.AndORNode;
import oracle.json.parser.Evaluator;
import oracle.json.parser.FilterLoader;
import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.Predicate;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;
import oracle.json.parser.ValueTypePair;

public class AndORTree {
    private AndORNode root;
    private ArrayList<ValueTypePair> valueArray = new ArrayList();
    private ArrayList<Predicate> orderByArray = new ArrayList();
    private HashSet<String> keysSet = new HashSet();
    private String predChar = "@";
    private StringBuilder jsonExists;
    private int numBinds;

    private AndORTree() {
    }

    public ArrayList<ValueTypePair> getValueArray() {
        return this.valueArray;
    }

    public ArrayList<Predicate> getOrderByArray() {
        return this.orderByArray;
    }

    public HashSet<String> getKeys() {
        return this.keysSet;
    }

    String getPredChar() {
        return this.predChar;
    }

    void addToOrderByArray(Predicate predicate) {
        this.orderByArray.add(predicate);
    }

    void addToKeys(String string) {
        this.keysSet.add(string);
    }

    String getScalarKey(JsonValue jsonValue) throws QueryException {
        JsonValue.ValueType valueType = jsonValue.getValueType();
        if (valueType == JsonValue.ValueType.STRING) {
            return ((JsonString)jsonValue).getString();
        }
        if (valueType == JsonValue.ValueType.NUMBER) {
            return ((JsonNumber)jsonValue).toString();
        }
        QueryException.throwSyntaxException(QueryMessage.EX_NON_SCALAR_KEY, new Object[0]);
        return null;
    }

    boolean isJSONPrimitive(JsonValue jsonValue) {
        JsonValue.ValueType valueType = jsonValue.getValueType();
        return valueType != JsonValue.ValueType.ARRAY && valueType != JsonValue.ValueType.OBJECT;
    }

    boolean isJSONArray(JsonValue jsonValue) {
        return jsonValue.getValueType() == JsonValue.ValueType.ARRAY;
    }

    boolean isJSONObject(JsonValue jsonValue) {
        return jsonValue.getValueType() == JsonValue.ValueType.OBJECT;
    }

    ValueTypePair addToValueArray(JsonValue jsonValue, String string) throws QueryException {
        ValueTypePair valueTypePair = null;
        if (this.isJSONPrimitive(jsonValue)) {
            if (jsonValue.getValueType() == JsonValue.ValueType.NULL) {
                valueTypePair = new ValueTypePair(4);
            } else if (jsonValue.getValueType() == JsonValue.ValueType.TRUE) {
                valueTypePair = new ValueTypePair(true, 3);
            } else if (jsonValue.getValueType() == JsonValue.ValueType.FALSE) {
                valueTypePair = new ValueTypePair(false, 3);
            } else if (jsonValue.getValueType() == JsonValue.ValueType.NUMBER) {
                valueTypePair = new ValueTypePair(((JsonNumber)jsonValue).bigDecimalValue(), 1);
            } else if (jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                valueTypePair = new ValueTypePair(((JsonString)jsonValue).getString(), 2);
            }
        } else {
            QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_SCALAR, string);
        }
        if (valueTypePair != null) {
            this.valueArray.add(valueTypePair);
        }
        return valueTypePair;
    }

    int getNextBind() throws QueryException {
        int n = this.getNumVals();
        if (this.numBinds >= n) {
            QueryException.throwExecutionException(QueryMessage.RR_BIND_MISMATCH, Integer.toString(n), Integer.toString(this.numBinds + 1));
        }
        return this.numBinds++;
    }

    void removeBind(int n) {
        this.valueArray.remove(n);
        --this.numBinds;
    }

    private int getNumVals() {
        if (this.getValueArray() != null) {
            return this.valueArray.size();
        }
        return 0;
    }

    public static AndORTree createTree(InputStream inputStream) throws QueryException {
        FilterLoader filterLoader;
        try {
            filterLoader = new FilterLoader(inputStream);
        }
        catch (JsonException jsonException) {
            throw new QueryException((Exception)((Object)jsonException));
        }
        return AndORTree.createTree(filterLoader);
    }

    private static AndORTree createTree(FilterLoader filterLoader) throws QueryException {
        JsonObject jsonObject;
        try {
            jsonObject = (JsonObject)filterLoader.parse();
        }
        catch (JsonParsingException jsonParsingException) {
            if (jsonParsingException.getMessage().equals("SODA FOR JAVA: ENCOUNTERED MULTIPLE $orderby")) {
                throw QueryException.getSyntaxException(QueryMessage.EX_MULTIPLE_OPS, "$orderby");
            }
            if (jsonParsingException.getMessage().equals("SODA FOR JAVA: ENCOUNTERED MULTIPLE $query")) {
                throw QueryException.getSyntaxException(QueryMessage.EX_MULTIPLE_OPS, "$query");
            }
            throw new QueryException((Exception)((Object)jsonParsingException));
        }
        catch (JsonException jsonException) {
            throw new QueryException((Exception)((Object)jsonException));
        }
        AndORTree andORTree = new AndORTree();
        AndORNode andORNode = new AndORNode(null);
        andORNode.setEval(Evaluator.EvaluatorCode.$and);
        andORNode.setPredicate(new Predicate(new JsonQueryPath(), null));
        andORTree.root = andORNode;
        boolean bl = false;
        boolean bl2 = false;
        if (jsonObject != null) {
            for (Map.Entry entry : jsonObject.entrySet()) {
                String string = (String)entry.getKey();
                if (string.equalsIgnoreCase("$project")) continue;
                if (string.equalsIgnoreCase("$query")) {
                    bl = true;
                    if (bl2) {
                        QueryException.throwSyntaxException(QueryMessage.EX_QUERY_WITH_OTHER_OPS, new Object[0]);
                    }
                    JsonValue jsonValue = (JsonValue)entry.getValue();
                    AndORTree.checkIfValueIsJsonObject(jsonValue, "$query");
                    for (Object object2 : ((JsonObject)jsonValue).entrySet()) {
                        andORNode.addNode(andORTree, (Map.Entry<String, JsonValue>)object2);
                    }
                    continue;
                }
                if (string.equalsIgnoreCase("$orderby")) {
                    Object object;
                    int n;
                    Object object2;
                    AndORTree.checkIfValueIsJsonObject((JsonValue)entry.getValue(), "$orderby");
                    int n2 = filterLoader.getOrderCount();
                    if (n2 <= 0) continue;
                    object2 = new String[n2];
                    int[] nArray = new int[n2];
                    for (n = 0; n < n2; ++n) {
                        int n3;
                        object = filterLoader.getOrderPath(n);
                        String string2 = filterLoader.getOrderDirection(n);
                        if (object == null) break;
                        int n4 = 0;
                        if (string2 != null) {
                            try {
                                n4 = Integer.parseInt(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                QueryException.throwSyntaxException(QueryMessage.EX_BAD_ORDERBY_PATH_VALUE, object, string2);
                            }
                            if (n4 == 0) {
                                QueryException.throwSyntaxException(QueryMessage.EX_BAD_ORDERBY_PATH_VALUE, object, string2);
                            }
                        } else {
                            QueryException.throwSyntaxException(QueryMessage.EX_BAD_ORDERBY_PATH_VALUE2, object);
                        }
                        int n5 = n4 < 0 ? -n4 : n4;
                        for (n3 = 0; n3 < n; ++n3) {
                            int n6 = nArray[n3];
                            if (n6 < 0) {
                                n6 = -n6;
                            }
                            if (n5 < n6) break;
                        }
                        if (n3 < n) {
                            System.arraycopy(object2, n3, object2, n3 + 1, n - n3);
                            System.arraycopy(nArray, n3, nArray, n3 + 1, n - n3);
                        }
                        object2[n3] = object;
                        nArray[n3] = n4;
                    }
                    n2 = n;
                    for (n = 0; n < n2; ++n) {
                        object = new Predicate(new JsonQueryPath(object2[n]), nArray[n] < 0 ? "-1" : "1");
                        andORTree.addToOrderByArray((Predicate)object);
                    }
                    continue;
                }
                bl2 = true;
                if (bl) {
                    QueryException.throwSyntaxException(QueryMessage.EX_QUERY_WITH_OTHER_OPS, new Object[0]);
                }
                andORNode.addNode(andORTree, entry);
            }
        }
        return andORTree;
    }

    private static void checkIfValueIsJsonObject(JsonValue jsonValue, String string) throws QueryException {
        if (!(jsonValue instanceof JsonObject)) {
            QueryException.throwSyntaxException(QueryMessage.EX_BAD_OP_VALUE, string);
        }
    }

    public boolean hasOrderBy() {
        return !this.getOrderByArray().isEmpty();
    }

    public boolean hasKeys() {
        return !this.getKeys().isEmpty();
    }

    public boolean hasJsonExists() {
        if (this.jsonExists == null) {
            throw new IllegalStateException();
        }
        return this.jsonExists.length() > 0;
    }

    public void generateJsonExists() throws QueryException {
        this.jsonExists = this.root.generateJsonExists(this);
    }

    public void appendJsonExists(StringBuilder stringBuilder) {
        if (this.jsonExists == null) {
            throw new IllegalStateException();
        }
        stringBuilder.append("'$?");
        stringBuilder.append((CharSequence)this.jsonExists);
        stringBuilder.append("'");
        int n = this.getNumVals();
        if (n > 0) {
            stringBuilder.append("\npassing ");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(" , ");
                }
                stringBuilder.append(" ? as \"B");
                stringBuilder.append(Integer.toString(i));
                stringBuilder.append("\"");
            }
        }
    }
}

